// MenuSetup.cpp : implementation file
//

#include "stdafx.h"
#include "Analyzer.h"
#include "MenuSetup.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifndef ENGLISH
#define MENU_SAVE "Salvare le modifiche?"
#else
#define MENU_SAVE "Do you wish to save modifications?"
#endif

/////////////////////////////////////////////////////////////////////////////
// CMenuSetup dialog


CMenuSetup::CMenuSetup(CWnd* pParent /*=NULL*/)
	: CDialog(CMenuSetup::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMenuSetup)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	app=(CAnalyzerApp*)AfxGetApp();
	m_IsModified=0;
	curmenu=0;
}


void CMenuSetup::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMenuSetup)
	DDX_Control(pDX, IDC_RADIO1, m_Main);
	DDX_Control(pDX, IDC_RADIO2, m_Txt);
	DDX_Control(pDX, IDC_RADIO3, m_Cap);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMenuSetup, CDialog)
	//{{AFX_MSG_MAP(CMenuSetup)
	ON_BN_CLICKED(IDC_RADIO1, OnRadio1)
	ON_BN_CLICKED(IDC_RADIO2, OnRadio2)
	ON_BN_CLICKED(IDC_RADIO3, OnRadio3)
	ON_BN_CLICKED(IDC_RADIO4, OnRadio4)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMenuSetup message handlers

int CMenuSetup::SaveMenu(FILE* f, int n, CMenu* pTopMenu)
{
	CMenu* pCurMenu = NULL;
	if (pTopMenu==NULL) pTopMenu = AfxGetMainWnd()->GetMenu();
	int iPos;
	CString str;
	for (iPos = 0; iPos<(signed)pTopMenu->GetMenuItemCount(); iPos++)
	{
		for(int i=0;i<n;i++) putc(' ',f);
		CMenu* pMenu = pTopMenu->GetSubMenu(iPos);
		if (pMenu)
		{
			if (pMenu->GetMenuItemCount()) SaveMenu(f,n+1,pMenu);
			pMenu->GetMenuString(iPos,str,MF_BYPOSITION);
			fputs(str,f);
			putc('=',f);
			fprintf(f,"%d\n",pMenu->GetMenuItemID(iPos));
		}
	}
	return 0;
}

BOOL CMenuSetup::PreTranslateMessage(MSG* pMsg) 
{
	if (pMsg->message!=WM_COMMAND)
		return CDialog::PreTranslateMessage(pMsg);
	else 
	{
		if (pMsg->wParam== IDCANCEL) {OnCancel();return TRUE;}
		CMenu* pTopMenu = GetMenu();
		ChangeMenuState(pTopMenu,pMsg->wParam);
		return TRUE;
	}
}

CMenu* CMenuSetup::ChangeMenuState(CMenu * pTopMenu,UINT com)
{
	// Locate the submenu
	CMenu* pCurMenu = NULL;
	int iPos;
	CMenu* pMenu;
	for (iPos = pTopMenu->GetMenuItemCount()-1; iPos >= 0; iPos--)
	{
			if (pMenu = pTopMenu->GetSubMenu(iPos))
			{
				pMenu=ChangeMenuState(pMenu,com);
				if (pMenu) return pMenu;
			}
			else if (com!= -1 && pTopMenu->GetMenuItemID(iPos) == com)
			{
				m_IsModified=TRUE;
				UINT t=pTopMenu->GetMenuState(iPos,MF_BYPOSITION);
				if (t& MF_CHECKED) pTopMenu->CheckMenuItem(iPos, MF_BYPOSITION|MF_UNCHECKED);
					else pTopMenu->CheckMenuItem(iPos, MF_BYPOSITION|MF_CHECKED);
				return pMenu;
			}
			else if (com==-1)
			{
				if (pTopMenu->GetMenuItemID(iPos)== ID_SEPARATOR) continue;
				pTopMenu->CheckMenuItem(iPos, MF_BYPOSITION|MF_CHECKED);
			}
	}
	return NULL;
}

BOOL CMenuSetup::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_MainMenu.LoadMenu(IDR_VOIDMENU);
	m_TxtMenu.LoadMenu(IDR_TXTMENU);
	m_CapMenu.LoadMenu(IDR_CAPMENU);
	m_TblMenu.LoadMenu(IDR_TBLMENU);

	SetMenu (&m_MainMenu);

    m_ToolBar.Create(this);
   	m_ToolBar.LoadToolBar(IDR_MAINFRAME);
    m_ToolBar1.Create(this);
	m_ToolBar1.LoadToolBar(IDB_BITMAP2);
	
	m_ToolBar.GetToolBarCtrl().SetOwner(this);
	m_ToolBar1.GetToolBarCtrl().SetOwner(this);

	m_ToolBar.SetBarStyle(m_ToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
	m_ToolBar1.SetBarStyle(m_ToolBar1.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

	CRect rcClientStart;
	CRect rcClientNow;
	GetClientRect(rcClientStart);
	RepositionBars(AFX_IDW_CONTROLBAR_FIRST, AFX_IDW_CONTROLBAR_LAST, 
				   0, reposQuery, rcClientNow);

	CPoint ptOffset(rcClientNow.left - rcClientStart.left,
					rcClientNow.top - rcClientStart.top); 

	CRect  rcChild;					
	CWnd* pwndChild = GetWindow(GW_CHILD);
	while (pwndChild)
	{                               
		pwndChild->GetWindowRect(rcChild);
		ScreenToClient(rcChild);
		rcChild.OffsetRect(ptOffset);
		pwndChild->MoveWindow(rcChild, FALSE);
		pwndChild = pwndChild->GetNextWindow();
	}

	// Adjust the dialog window dimensions
	CRect rcWindow;
	GetWindowRect(rcWindow);
	rcWindow.right += rcClientStart.Width() - rcClientNow.Width();
	rcWindow.bottom += rcClientStart.Height() - rcClientNow.Height();
	MoveWindow(rcWindow, FALSE);
	
	// And position the control bars
	RepositionBars(AFX_IDW_CONTROLBAR_FIRST, AFX_IDW_CONTROLBAR_LAST, 0);
		
    // Finally, center the dialog on the screen
	CenterWindow();
	InitToolBars();
	m_Main.SetCheck(TRUE);

	UpdateMenu();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CMenuSetup::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo) 
{
	if(nCode == CN_COMMAND)
	{
		if (nID==IDOK) OnOK();
		else if (nID==IDCANCEL) OnCancel();
		else if (nID==IDC_RADIO1) OnRadio1();
		else if (nID==IDC_RADIO2) OnRadio2();
		else if (nID==IDC_RADIO3) OnRadio3();
		else if (nID==IDC_RADIO4) OnRadio4();
		else
		{
			int n=m_ToolBar.CommandToIndex(nID);
			if (n>=0)
			{
				CToolBarCtrl& r=m_ToolBar.GetToolBarCtrl();
				r.CheckButton(nID,!r.IsButtonChecked(nID));
			}
			else
			{
				n=m_ToolBar1.CommandToIndex(nID);
				if (n>=0)
				{
					CToolBarCtrl& r=m_ToolBar1.GetToolBarCtrl();
					r.CheckButton(nID,!r.IsButtonChecked(nID));
				}
			}
			m_IsModified=TRUE;
		}
		return TRUE;
	}
	
	return CDialog::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

void CMenuSetup::InitToolBars()
{
	SetToolBar(m_ToolBar, "FileToolBar");
	SetToolBar(m_ToolBar1, "CapToolBar");
}

CMenu* CMenuSetup::LoadState(CMenu * pTopMenu, const char* section)
{
	// Locate the submenu
	CMenu* pCurMenu = NULL;
	int iPos;
	CMenu* pMenu;
	for (iPos = pTopMenu->GetMenuItemCount()-1; iPos >= 0; iPos--)
	{
			if (pMenu = pTopMenu->GetSubMenu(iPos))
			{
				pMenu=LoadState(pMenu,section);
			}
			else
			{
				CString str;
				str.Format("ID_%d",pTopMenu->GetMenuItemID(iPos));
				UINT t;
				t=app->GetProfileInt(section,str,1);
				if (!t) pTopMenu->CheckMenuItem(iPos, MF_BYPOSITION|MF_UNCHECKED);
			}
	}
	return NULL;
}

CMenu* CMenuSetup::SaveState(CMenu * pTopMenu, const char* section)
{
	CMenu* pCurMenu = NULL;
	int iPos;
	CMenu* pMenu;
	for (iPos = pTopMenu->GetMenuItemCount()-1; iPos >= 0; iPos--)
	{
			if (pMenu = pTopMenu->GetSubMenu(iPos))
			{
				pMenu=SaveState(pMenu,section);
			}
			else
			{
				CString str;
				if (pTopMenu->GetMenuItemID(iPos)== ID_SEPARATOR) continue;
				UINT t=pTopMenu->GetMenuState(iPos,MF_BYPOSITION);
				if ((t&MF_CHECKED)!=MF_CHECKED)
				{
					str.Format("ID_%d",pTopMenu->GetMenuItemID(iPos));
					app->WriteProfileInt(section,str,0);
				}
				else
				{
					str.Format("ID_%d",pTopMenu->GetMenuItemID(iPos));
					app->WriteProfileInt(section,str,1);
				}
			}
	}
	return NULL;
}

void CMenuSetup::OnOK() 
{
	CMenu* pTopMenu = GetMenu();
	if(m_IsModified) 
	{
		SaveCurMenu();
		SaveToolBar(m_ToolBar, "FileToolBar");
		SaveToolBar(m_ToolBar1, "CapToolBar");
	}
	CDialog::OnOK();
}

void CMenuSetup::SetToolBar(CToolBar & ToolBar, const char * section)
{
	CToolBarCtrl &t=ToolBar.GetToolBarCtrl();
	CString str;

	int n=t.GetButtonCount();
	int tb;
	for (int i=0;i<n;i++)
	{
		int nID=ToolBar.GetItemID(i);
		if (nID==ID_SEPARATOR) continue;
		else
		{
			str.Format("ID_%d",nID);
			tb=app->GetProfileInt(section,str,1);
			t.CheckButton(nID,tb);
		}
	}
}

void CMenuSetup::SaveToolBar(CToolBar & ToolBar, const char * section)
{
	CToolBarCtrl &t=ToolBar.GetToolBarCtrl();
	CString str;

	int n=t.GetButtonCount();
	for (int i=0;i<n;i++)
	{
		int nID=ToolBar.GetItemID(i);
		if (nID==ID_SEPARATOR) continue;
		else
		{
			str.Format("ID_%d",nID);
			if (t.IsButtonChecked(nID))
				app->WriteProfileInt(section,str,1);
			else
				app->WriteProfileInt(section,str,0);
		}
	}
}

void CMenuSetup::UpdateMenu()
{
	const char * str;
	if (curmenu==0)
		str="MainMenu";
	else if (curmenu==1)
		str="TxtMenu";
	else if (curmenu==2)
		str="CapMenu";
	else
		str="TblMenu";
	CMenu* pTopMenu = GetMenu();
	ChangeMenuState(pTopMenu,-1);
	LoadState(pTopMenu,str);
}

void CMenuSetup::OnRadio1() 
{
	if (m_IsModified && AfxMessageBox(MENU_SAVE /*Salvare le modifiche?*/, MB_YESNO)==IDYES)
		SaveCurMenu();
	curmenu=0;
	ChangeMenu();
}

void CMenuSetup::OnRadio2() 
{
	if (m_IsModified && AfxMessageBox(MENU_SAVE /*Salvare le modifiche?*/, MB_YESNO)==IDYES)
		SaveCurMenu();
	curmenu=1;
	ChangeMenu();
}

void CMenuSetup::OnRadio3() 
{
	if (m_IsModified && AfxMessageBox(MENU_SAVE /*Salvare le modifiche?*/, MB_YESNO)==IDYES)
		SaveCurMenu();
	curmenu=2;
	ChangeMenu();
}

void CMenuSetup::SaveCurMenu()
{
	if (curmenu==0)
		SaveState(GetMenu(),"MainMenu");
	else if (curmenu==1)
		SaveState(GetMenu(),"TxtMenu");
	else if (curmenu==2)
		SaveState(GetMenu(),"CapMenu");
	else
		SaveState(GetMenu(),"TblMenu");
}


void CMenuSetup::ChangeMenu()
{
	if (curmenu==0) SetMenu(&m_MainMenu);
	else if (curmenu==1) SetMenu(&m_TxtMenu);
	else if (curmenu==2) SetMenu(&m_CapMenu);
	else SetMenu(&m_TblMenu);
	UpdateMenu();
}


void CMenuSetup::OnRadio4() 
{
	if (m_IsModified && AfxMessageBox(MENU_SAVE /*Salvare le modifiche?*/, MB_YESNO)==IDYES)
		SaveCurMenu();
	curmenu=3;
	ChangeMenu();
}
