#include <stdafx.h>
#include "Analyzer.h"
#include "resource.h"
#include "DataDialog.h"
#include <linecoll.h>

extern CAnalyzerApp theApp;
/////////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNCREATE(CMultiView, CEditView)
BEGIN_MESSAGE_MAP(CMultiView, CEditView)
	//{{AFX_MSG_MAP(CMultiView)
	ON_COMMAND(ID_EDIT_REPEAT,OnEditRepeat)
	ON_COMMAND(ID_EDIT_REPLACE,OnEditReplace)
	ON_UPDATE_COMMAND_UI(ID_EDIT_REPLACE,OnUpdateEditReplace)
	ON_COMMAND(IDM_VIEW_FONT,OnViewFont)
	ON_UPDATE_COMMAND_UI(IDM_VIEW_FONT,OnUpdateViewFont)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CUT,OnUpdateEditCut)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE,OnUpdateEditPaste)
	ON_COMMAND(ID_FILE_PRINT, OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, OnFilePrintPreview)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE, OnUpdateFileSave)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CLEAR, OnUpdateEditClear)
	ON_COMMAND(IDM_PRINT_CHAR, OnSelectPrinterFont)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, OnUpdateEditCopy)
	ON_COMMAND(ID_EDIT_CUT, OnEditCut)
	ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	ON_COMMAND(IDM_EDIT_DATA_EXT, OnEditDataExt)
	ON_UPDATE_COMMAND_UI(IDM_EDIT_DATA_EXT, OnUpdateEditDataExt)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CMultiView::CMultiView():CEditView()
    {
       IsTemp=0;
       f=new CFont();
       f->CreatePointFont(((CAnalyzerApp*)AfxGetApp())->DefinedDim,
		   ((CAnalyzerApp*)AfxGetApp())->DefinedFont);
       defFont=new CFont();
       defFont->CreatePointFont(100,"System");
       isDefFont=TRUE;
    }

void CMultiView::OnEditRepeat()
{
    if (rw) CEditView::OnEditRepeat();
}

void CMultiView::OnEditReplace()
{
    if (rw) CEditView::OnEditReplace();
}

int CMultiView::NewFromStrings(CString s)
   {
    CEdit* c=&GetEditCtrl();
    c->SetWindowText(s);
	c->SetReadOnly();
    if (f)
    {
     CWnd::SetFont(f);
     isDefFont=FALSE;
    }
    rw=0;
    SetTemp();
    return 0;
   }


CMultiView::~CMultiView()
    {
       if (f!=NULL) delete f;
       if (defFont!=NULL) delete defFont;
    }

void CMultiView::OnUpdateViewFont(CCmdUI *pCmdUI)
{
    pCmdUI->SetCheck(!isDefFont);
}

void CMultiView::OnViewFont()
{
    if (isDefFont)
     {
        if (f!=NULL)
        {
         CWnd::SetFont(f);
         isDefFont=FALSE;
        }
     } else
     if (defFont!=NULL){
        CWnd::SetFont(defFont);
        isDefFont=TRUE;
     }
}

void CMultiView::OnInitialUpdate()
{
    if (theApp.max==TRUE) {GetParent()->SendMessage(WM_SYSCOMMAND,SC_MAXIMIZE,0);theApp.max=FALSE;}
    CView::OnInitialUpdate();
}


void CMultiView::OnFilePrint() 
{
	CView::OnFilePrint();
}

void CMultiView::OnFilePrintPreview() 
{
	CView::OnFilePrintPreview();
}

void CMultiView::OnUpdateFileSave(CCmdUI* pCmdUI) 
{
 if (rw) pCmdUI->Enable(TRUE);
  else pCmdUI->Enable(FALSE);
}

void CMultiView::OnUpdateEditReplace(CCmdUI* pCmdUI) 
{
 if (rw) pCmdUI->Enable(TRUE);
  else pCmdUI->Enable(FALSE);
}

void CMultiView::OnUpdateEditClear(CCmdUI* pCmdUI) 
{
 if (rw) pCmdUI->Enable(TRUE);
  else pCmdUI->Enable(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
// CMultiView Printing support

#include "pageset.h"

extern CPageSetupDlg dlgPageSetup;

void CMultiView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	CEditView::OnBeginPrinting(pDC, pInfo);

	LPCTSTR pszFileName = GetDocument()->GetPathName();
	BOOL bForceSysTime = _tcschr(pszFileName, '.') == NULL;
	CTime timeSys = CTime::GetCurrentTime();
	CFileStatus status;
	CFile::GetStatus(pszFileName, status);

	if (dlgPageSetup.m_iHeaderTime != 0 || bForceSysTime)
		m_timeHeader = timeSys;
	else
		m_timeHeader = status.m_mtime;

	if (dlgPageSetup.m_iFooterTime != 0 || bForceSysTime)
		m_timeFooter = timeSys;
	else
		m_timeFooter = status.m_mtime;

	if (!pInfo->m_bPreview)
		return;

	CWaitCursor wait;
	pInfo->m_nCurPage = 0xFFFF;
	OnPrepareDC(pDC, pInfo);

	UINT nIndex = LOWORD(GetEditCtrl().GetSel());
	UINT nCurPage = 1;
	while (nCurPage < (UINT)m_aPageStart.GetSize())
	{
		if (nIndex < m_aPageStart[nCurPage])
			break;
		nCurPage++;
	}
	pInfo->m_nCurPage = nCurPage;
	pInfo->SetMaxPage(m_aPageStart.GetSize());
	m_nPreviewPage = nCurPage;
}

void CMultiView::OnPrint(CDC* pDC, CPrintInfo* pInfo)
{
	// get string to show as "filename" in header/footer
	LPCTSTR pszFileName = GetDocument()->GetPathName();
	if (pszFileName[0] == 0)
		pszFileName = GetDocument()->GetTitle();

    CFont* pOldFont = pDC->SelectObject (&m_fontPrint);

	// go thru global CPageSetupDlg to format the header and footer
	CString strHeader;
	dlgPageSetup.FormatHeader(strHeader, m_timeHeader, pszFileName,
		pInfo->m_nCurPage);
	CString strFooter;
	dlgPageSetup.FormatFooter(strFooter, m_timeFooter, pszFileName,
		pInfo->m_nCurPage);
	SIZE size;

	size.cy=dlgPageSetup.m_Top*100;
	pDC->HIMETRICtoDP(&size);
	pInfo->m_rectDraw.top+=size.cy;
	size.cy=dlgPageSetup.m_Bottom*100;
	pDC->HIMETRICtoDP(&size);
	pInfo->m_rectDraw.bottom-=size.cy;
	size.cx=dlgPageSetup.m_Left*100;
	pDC->HIMETRICtoDP(&size);
	pInfo->m_rectDraw.left+=size.cx;
	size.cx=dlgPageSetup.m_Right*100;
	pDC->HIMETRICtoDP(&size);
	pInfo->m_rectDraw.right-=size.cx;

	TEXTMETRIC tm;
	pDC->GetTextMetrics(&tm);
	int cyChar = tm.tmHeight;
	CRect rectPage = pInfo->m_rectDraw;

	// draw and exclude space for header
	if (!strHeader.IsEmpty())
	{
		pDC->TextOut(rectPage.left, rectPage.top, strHeader);
		rectPage.top += cyChar + cyChar / 4;
		pDC->MoveTo(rectPage.left, rectPage.top);
		pDC->LineTo(rectPage.right, rectPage.top);
		rectPage.top += cyChar / 4;
	}

	// allow space for footer
	pInfo->m_rectDraw = rectPage;
	if (!strFooter.IsEmpty())
		pInfo->m_rectDraw.bottom -= cyChar + cyChar/4 + cyChar/4;

	// draw body text
	CEditView::OnPrint(pDC, pInfo);

	// draw footer
	if (!strFooter.IsEmpty())
	{
		rectPage.bottom -= cyChar;
		pDC->TextOut(rectPage.left, rectPage.bottom, strFooter);
		rectPage.bottom -= cyChar / 4;
		pDC->MoveTo(rectPage.left, rectPage.bottom);
		pDC->LineTo(rectPage.right, rectPage.bottom);
		rectPage.bottom -= cyChar / 4;
	}
    pDC->SelectObject (pOldFont);
}

void ScaleLogFont(LPLOGFONT plf, const CDC& dcFrom, const CDC& dcTo);

void CMultiView::OnSelectPrinterFont()
{
	CWaitCursor wait;
	CFont* pFont = GetPrinterFont();
	LOGFONT lf;
	LPLOGFONT plf = NULL;
	if (pFont != NULL)
	{
		pFont->GetObject(sizeof(LOGFONT), &lf);
		plf = &lf;
	}

	// magic to get printer dialog that would be used if we were printing!
	CPrintDialog dlgPrint(FALSE);
	if (!AfxGetApp()->GetPrinterDeviceDefaults(&dlgPrint.m_pd))
	{
		AfxMessageBox("Cannot get printer defaults.");
		return;
	}
	wait.Restore();
	HDC hdcPrint = dlgPrint.CreatePrinterDC();
	if (hdcPrint == NULL)
	{
		AfxMessageBox("Cannot get printer device context.");
		return;
	}

	CDC dcScreen;
	dcScreen.Attach(::GetDC(NULL));
	CDC dcPrint;
	dcPrint.Attach(hdcPrint);

	if (plf != NULL)
	{
		// need to map initial logfont to screen metrics.
		::ScaleLogFont(plf, dcPrint, dcScreen);
	}

	// now bring up the dialog since we know the printer DC
	CFontDialog dlg(plf, CF_PRINTERFONTS, &dcPrint);
	if (dlg.DoModal() == IDOK)
	{
		// map the resulting logfont back to printer metrics.
		lf = dlg.m_lf;
		::ScaleLogFont(&lf, dcScreen, dcPrint);

		SetPrinterFont(NULL);
		m_fontPrint.DeleteObject();
		if (m_fontPrint.CreateFontIndirect(&lf))
		{
			SetPrinterFont(&m_fontPrint);
			m_lfDefPrintFont = lf;

			// notify container that content has changed
			GetDocument()->UpdateAllViews(NULL);
		}
	}
	//NOTE: destructor will call dcPrint.DeleteDC

	::ReleaseDC(NULL, dcScreen.Detach());
}



void CMultiView::OnEditCopy() 
{
  CLogDocument* log=(CLogDocument*)GetDocument();
  if (!log) return;
  if (log->IsKindOf(RUNTIME_CLASS(CLogDocument)))
  {
	if (log->m_ClipTxt) CEditView::OnEditCopy();
	if (log->m_ClipPck) log->EditCopy();
	return;
  }
  CEditView::OnEditCopy();
}

void CMultiView::OnUpdateEditCopy(CCmdUI* pCmdUI) 
{
	BOOL b=FALSE;
	CLogDocument* log=(CLogDocument*)GetDocument();
	if (!log) {pCmdUI->Enable(b); return;}
	if (!log->IsKindOf(RUNTIME_CLASS(CLogDocument)))
	{
	    int s,e;
		GetEditCtrl().GetSel(s,e);
		if (e>s) pCmdUI->Enable(TRUE); 
		else pCmdUI->Enable(FALSE); 
		return;
	}
	b=log->UpdateModificaCopia();
	if (log->m_ClipTxt)
	{
	    int s,e;
		GetEditCtrl().GetSel(s,e);
		if (e>s) b=TRUE; 
	}
	pCmdUI->Enable(b); 
}

void CMultiView::OnUpdateEditCut(CCmdUI *pCmdUI)
{
	BOOL b=FALSE;
	CLogDocument* log=(CLogDocument*)GetDocument();
	if (!log) {pCmdUI->Enable(b); return;}
	if (!log->IsKindOf(RUNTIME_CLASS(CLogDocument)))
	{
	    int s,e;
		GetEditCtrl().GetSel(s,e);
		if (e>s && rw) pCmdUI->Enable(TRUE); 
		else pCmdUI->Enable(FALSE); 
		return;
	}
	b=log->UpdateModificaTaglia();
	pCmdUI->Enable(b); 
}

void CMultiView::OnUpdateEditPaste(CCmdUI *pCmdUI)
{
	BOOL b=FALSE;
	CLogDocument* log=(CLogDocument*)GetDocument();
	if (!log) {pCmdUI->Enable(b); return;}
	if (!log->IsKindOf(RUNTIME_CLASS(CLogDocument)))
	{
		if (rw) pCmdUI->Enable(IsClipboardFormatAvailable(CF_TEXT)); //CEditView::OnUpdateEditPaste(pCmdUI);
		else pCmdUI->Enable(FALSE);
		return;
	}
	b=log->UpdateModificaIncolla();
	pCmdUI->Enable(b); 
}

void CMultiView::OnEditCut() 
{
  CLogDocument* log=(CLogDocument*)GetDocument();
  if (!log || !log->IsKindOf(RUNTIME_CLASS(CLogDocument)))
  {
	  CEditView::OnEditCut();
	  return;
  }
  if (log->m_ClipTxt) CEditView::OnEditCopy();
  if (log->m_ClipPck) log->EditCut();
}

void CMultiView::OnEditPaste() 
{
  CLogDocument* log=(CLogDocument*)GetDocument();
  if (!log || !log->IsKindOf(RUNTIME_CLASS(CLogDocument)))
  {
	  CEditView::OnEditPaste();
	  return;
  }
  if (log->m_ClipPck) log->EditPaste();
}

const char* FindToken(const char* str,const char* token);

void CMultiView::OnEditDataExt() 
{
	CDataDialog dlg;
	if(dlg.DoModal()==IDOK)
	{
		CString str;
		GetEditCtrl().GetWindowText(str);
		LineCollection lc(&str);
		CString string;
		CString t;
		const char* c;
		int i,n=0;
		int ni=dlg.m_Vals.GetSize();
		int v;
		n=lc.GetSize();
		for(int ii=0;ii<n;ii++)
		{
			str=lc.line(ii);
			t=str;
			for(i=0;i<ni;i++)
			{
				c=t;
				//v=dlg.m_Vals[i];
				//c=FindToken(c,dlg.m_Tags[i]);
				//if(c) sscanf(c,"%d",&v);
				v=dlg.FindToken(c,i);
				str.Format("%d ",v);
				string +=str;
			}
			string +="\r\n";
			str="";
		}
		((CAnalyzerApp*)AfxGetApp())->CreateTblDoc("",string);
	}
}

void CMultiView::OnUpdateEditDataExt(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(TRUE);
}
