// MyTableVw.cpp : implementation file
//

#include "stdafx.h"
#include "analyzer.h"
#include "MyTableVw.h"
#include "CsvDoc.h"
#include "messages.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifdef ENGLISH
#define TBL_ST "Start Time"
#define TBL_END "End Time"
#define TBL_DESC "Description"
#define TBL_NUM "Number"
#define PLT_PAUSE "pause -1 \"Press Return to close graphic window\""
#define M_PLTFILES "Plt Files (*.plt)"
#define M_PLTFLT "*.plt"
#define ERR_PLT "Error exporting PLT file"
#define PLT_GEN "Generated files: \r\n"
#else
#define TBL_ST "Inizio"
#define TBL_END "Fine"
#define TBL_NUM "Numero"
#define TBL_DESC "Descrizione"
#define PLT_PAUSE "pause -1 \"Premere Invio per chiudere il grafico\""
#define M_PLTFILES "File plt (*.plt)"
#define M_PLTFLT "*.plt"
#define ERR_PLT "Errore durante l'esportazione del file PLT"
#define PLT_GEN "File Generati: \r\n"
#endif

/////////////////////////////////////////////////////////////////////////////
// CMyTableView

IMPLEMENT_DYNCREATE(CMyTableView, CTableView)

CMyTableView::CMyTableView()
{
	m_Init=0;
	m_SkipRows=0;
	m_N=0;
}

CMyTableView::~CMyTableView()
{
}


BEGIN_MESSAGE_MAP(CMyTableView, CTableView)
	//{{AFX_MSG_MAP(CMyTableView)
	ON_WM_CREATE()
	ON_COMMAND(ID_REMOVE_ROW, OnRemoveRow)
	ON_UPDATE_COMMAND_UI(ID_REMOVE_ROW, OnUpdateRemoveRow)
	ON_COMMAND(ID_REMOVE_COL, OnRemoveCol)
	ON_UPDATE_COMMAND_UI(ID_REMOVE_COL, OnUpdateRemoveCol)
	ON_COMMAND(IDM_TBL_GRAPH, OnTblGraph)
	ON_UPDATE_COMMAND_UI(IDM_TBL_EDIT, OnUpdateTblEdit)
	ON_WM_LBUTTONDBLCLK()
	ON_COMMAND(IDM_TBL_EXPORT, OnTblExport)
	ON_COMMAND(IDM_PRINT_CHAR, OnPrintChar)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyTableView diagnostics

#ifdef _DEBUG
void CMyTableView::AssertValid() const
{
	CTableView::AssertValid();
}

void CMyTableView::Dump(CDumpContext& dc) const
{
	CTableView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMyTableView message handlers

void CMyTableView::Update(int n)
{
	CString s="";
	m_N=n;
	if(m_N<0)m_N=0;
	int i,j;
	int r,c;
	CCsvDocument* pDoc=(CCsvDocument*) GetDocument();
	if(!pDoc || n<0) return;
	LockUpdate();
	if(m_Title=="") m_Title=pDoc->GetTitle();
	CValGroup& ValGroup=pDoc->m_ValGroup[n];
	j=GetColNumber();
	int nnd=0;
	for(i=0;i<j;i++)
		if (!(DeleteColumn(0)))
			nnd++;
	DeleteAllItems( );
	ValGroup.GetSize(r,c); 
	Invalidate();
	if (ValGroup.TimeStamp(0)!=-1)
	{
		m_SkipRows=2;
	    InsertColumn(0,TBL_ST /*Start Time*/, LVCFMT_LEFT,100);
	    InsertColumn(1,TBL_END /*End Time*/, LVCFMT_LEFT,100);
	}
	else
	{
		m_SkipRows=1;
	    InsertColumn(0,TBL_NUM /*Number*/, LVCFMT_LEFT,100);
	    InsertColumn(1,TBL_DESC /*Description*/, LVCFMT_LEFT,100);
	}
	for(i=2;i<=c+1;i++)
	{
		s=ValGroup.GetColName(i-2);
		s.TrimLeft();
	    InsertColumn(i,s, LVCFMT_LEFT,100);
	}
	m_Init=1;
	pDoc->SetTitle(m_Title+ " - "+ ValGroup.GetName());
	int a,b;
	for(i=0;i<r;i++)
	{
		if(m_SkipRows==2)
		{
			a=ValGroup.TimeStamp(i);
			s.Format("%d",a);
			AddItem(i,0,s);
			b=ValGroup.FinTimeStamp(i);
			s.Format("%d",b);
			AddItem(i,1,s);
		}
		else
		{
			s.Format("%d",1+i);
			AddItem(i,0,s);
			s=ValGroup.GetRowName(i);
			AddItem(i,1,s);
		}
		for(j=0;j<c;j++)
		{
			a=ValGroup.At(i,j);
			s.Format("%d",a);
		    AddItem(i,j+2,s);
		}
	}
	SelectItem(0,0);
	UnLockUpdate();
}


int CMyTableView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	lpCreateStruct->style |= LVS_REPORT | LVS_ICON | LVS_SHOWSELALWAYS;
	lpCreateStruct->style &= ~LVS_SINGLESEL;
	if (CTableView::OnCreate(lpCreateStruct) == -1)
		return -1;
    f=new CFont();
    if (f->CreatePointFont(((CAnalyzerApp*)AfxGetApp())->DefinedDim,
		((CAnalyzerApp*)AfxGetApp())->DefinedFont)==0)
     {
       if (!f->CreateStockObject(OEM_FIXED_FONT))
        {delete[]f;f=NULL;}
     }
	if(f) SetFont(f);
	LOGFONT l;
	f->GetLogFont(&l);
	CCsvDocument* pDoc=(CCsvDocument*) GetDocument();
	if(!pDoc) return 0;
	m_Title=pDoc->GetTitle();
    return 0;
}

void CMyTableView::OnRemoveRow() 
{
	int r,c;
	GetSel(r,c);
	CCsvDocument* pDoc=(CCsvDocument*) GetDocument();
	if(!pDoc || r<0) return;
	DeleteRow(r);
	Invalidate();
	pDoc->RemoveRow(r);
}

void CMyTableView::OnUpdateRemoveRow(CCmdUI* pCmdUI) 
{
	int r,c;
	GetSel(r,c);
	pCmdUI->Enable(r>=0 && r<GetRowCount());
}

void CMyTableView::OnRemoveCol() 
{
	int r,c;
	GetSel(r,c);
	CCsvDocument* pDoc=(CCsvDocument*) GetDocument();
	if(!pDoc || c<2) return;
	DeleteColumn(c);
	if(c-2>=0) pDoc->RemoveCol(c-2);
	Update(m_N);
}

void CMyTableView::OnUpdateRemoveCol(CCmdUI* pCmdUI) 
{
	int r,c;
	GetSel(r,c);
	pCmdUI->Enable(c>=2);
}

CString& CMyTableView::ValidateValue(CString & r)
{
	CString str;
	int i=0;
	sscanf(r,"%d",&i);
	str=CTableView::ValidateValue(r);
	int row,col;
	GetSel(row,col);
	CCsvDocument* csv=(CCsvDocument*)GetDocument();
	if(m_SkipRows==1&&col==1) 
	{
		r=str;
		if(csv)
		{
			csv->m_ValGroup[m_N].SetRowName(row,r);
			csv->SetCsvModifiedFlag(TRUE);
		}
		return r;
	}
	sscanf(str,"%d",&i);
	r.Format("%d",i);
	if(csv)
	{
		csv->m_ValGroup[m_N].SetAt(row,col-2,i);
		csv->SetCsvModifiedFlag(TRUE);
	}
	return r;
}

void CMyTableView::OnTblGraph() 
{
	CAnalyzerApp* app=(CAnalyzerApp*)AfxGetApp();
	CCsvDocument* csv=(CCsvDocument*)GetDocument();
	if(!app) return;
	CString fs1,fs2;
	fs2=app->GetTempFile(".dat");
	fs1=app->GetTempFile(".dem");
	if (fs1=="" || fs2=="") return;
	FILE* f1,*f2;
	const char* fc=fs2;
	f1=fopen(fs1,"w");
	f2=fopen(fs2,"w");
	if (f1==NULL) return;
	if (f2==NULL) {fclose(f1);return;}
	GeneratePlt(f1,fc);
	GenerateDat(f2);
	PlotStr* plt;
	plt=new PlotStr;
	plt->f1=f1;
	plt->f2=f2;
	plt->fs1=fs1;
	plt->fs2=fs2;
	plt->cmd=app->m_PlotApp;
	AfxBeginThread(PlotFunction,plt);
}

void CMyTableView::OnUpdateTblEdit(CCmdUI* pCmdUI) 
{
	int  r, c;
	if (m_SkipRows==2) {pCmdUI->Enable(TRUE);return;}
	GetSel(r,c);
	if (c>0) {pCmdUI->Enable(TRUE);return;}
	else {pCmdUI->Enable(FALSE);return;}
}

void CMyTableView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	int  r, c;
	if (m_SkipRows==2) {CTableView::OnLButtonDblClk(nFlags, point);return;}
	GetSel(r,c);
	if (c>0) {CTableView::OnLButtonDblClk(nFlags, point);return;}
	return;
}

void CMyTableView::GetFinStr(FILE* f)
{
	CCsvDocument* csv=(CCsvDocument*)GetDocument();
	if(!csv) return ;
	int r,c;
	csv->m_ValGroup[m_N].GetSize(r,c);
	int i,j;
	for(i=0;i<r;i++)
	{
		fprintf(f,"%d ",i);
		for(j=0;j<c;j++) fprintf(f,"0 ");
		fprintf(f,"\n%d.%d ",i,1);
		for(j=0;j<c;j++) fprintf(f,"0 ");
		fprintf(f,"\n%d.%d ",i,1);
		for(j=0;j<c;j++) 
			fprintf(f,"%d ",csv->m_ValGroup[m_N].At(i,j));
		fprintf(f,"\n%d.%d ",i,9);
		for(j=0;j<c;j++) 
			fprintf(f,"%d ",csv->m_ValGroup[m_N].At(i,j));
		fprintf(f,"\n%d.%d ",i,9);
		for(j=0;j<c;j++) fprintf(f,"0 ");
		fprintf(f,"\n%d ",i+1);
		for(j=0;j<c;j++) fprintf(f,"0 ");
		fprintf(f,"\n");
	}
	return;
}

void CMyTableView::GeneratePlt(FILE * f1, const char * fc)
{
	CCsvDocument* csv=(CCsvDocument*)GetDocument();
	if(!csv) return ;
	fprintf(f1,"set title \"%s\"",(const char*)csv->m_ValGroup[m_N].GetName());
	fputs("\n",f1);
	if(m_SkipRows==2)
	{
		fprintf(f1,"set xlabel \"Time (secs)\"");
		fputs("\n",f1);
	}
	fprintf(f1,"set grid\nshow grid");
	fputs("\n",f1);
	int i,r,c;
	csv->m_ValGroup[m_N].GetSize(r,c);
	if(c>0)
		fprintf(f1,"plot ");
	for(i=0;i<c&&i<15;i++)
	 {
		if (i>0)
			fprintf(f1,", ");
		if(m_SkipRows==2)
			fprintf(f1,"'%s' u %d:%d t \"%s\" w lines",fc,1,3+i,
				(const char*)csv->m_ValGroup[m_N].GetColName(i));
		else
			fprintf(f1,"'%s' u %d:%d t \"%s\" w lines",fc,1,2+i,
				(const char*)csv->m_ValGroup[m_N].GetColName(i));
	 }
	fputs("\n",f1);
	fputs(PLT_PAUSE /*pause -1 \"Premere Invio per chiudere il grafico\"*/,f1);
	fputs("\n",f1);
}

void CMyTableView::GenerateDat(FILE * f2)
{
	CString str;
	if(m_SkipRows==2)
	{
		str=GetAllStr();
		fputs(str,f2);
	}
	else
	{
		GetFinStr(f2);
	}
}

void CMyTableView::OnTblExport() 
{
	int n=m_N;
	CCsvDocument* csv=(CCsvDocument*)GetDocument();
	if(!csv) return;
	CString files;
	int i;
	CString fs1,fs2;
	fs1=ExportDlg();
	if (fs1=="") return;
	for(i=fs1.GetLength()-1;i>=0;i--)
		if (fs1[i]=='.') {fs2=fs1.Left(i);break;}
	if (fs2=="") fs2="data";
	files=fs1+"\r\n";
	FILE* f1,*f2;
	f1=fopen(fs1,"w");
	if (f1==NULL) return;
	CString fc;
	for(i=0;i<csv->m_ValGroup.GetSize();i++)
	{
		fc.Format("%s%d.dat",(const char*)fs2,i+1);
		f2=fopen(fc,"w");
		if (f2==NULL) 
		{
			files="\r\n"+files;
			AfxMessageBox(ERR_PLT /*Error exporting PLT file*/+files);
			fclose(f1);
			return;
		}
		files+=fc+"\r\n";
		csv->Jump(i);
		GeneratePlt(f1,fc);
		GenerateDat(f2);
		fclose(f2);
	}
	fclose(f1);
	csv->Jump(n);
	AfxMessageBox(PLT_GEN /*File Generati: \r\n*/+files);
}

CString CMyTableView::ExportDlg()
{
	CFileDialog dlgFile(FALSE);

	CString title=M_SAVEAS;
	CString fileName;
    UINT nIDSTitle=AFX_IDS_OPENFILE;
    DWORD lFlags=OFN_HIDEREADONLY ;
    BOOL bOpenFileDialog=FALSE;

	dlgFile.m_ofn.Flags |= lFlags;

	CString strFilter=M_PLTFILES;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_PLTFLT);
	strFilter += (TCHAR)'\0';   // last string
	CString strDefault;
	// append the '*.*' all files filter
	CString allFilter;
	VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	strFilter += allFilter;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_ALLFLT);
	strFilter += (TCHAR)'\0';   // last string
	dlgFile.m_ofn.nMaxCustFilter++;

	dlgFile.m_ofn.lpstrFilter = strFilter;
	dlgFile.m_ofn.lpstrTitle = title;
	dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	BOOL bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	fileName.ReleaseBuffer();
    if (bResult)
     {
	  return fileName;
     }
	else return "";
}

/////////////////////////////////////////////////////////////////////////////
// CTableView Printing support

#include "pageset.h"

extern CPageSetupDlg dlgPageSetup;

void CMyTableView::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
	// get string to show as "filename" in header/footer
	LPCTSTR pszFileName = GetDocument()->GetPathName();
    CFont* pOldFont = pDC->SelectObject (&m_fontPrint);

	if (pszFileName[0] == 0)
		pszFileName = GetDocument()->GetTitle();

	// go thru global CPageSetupDlg to format the header and footer
	::dlgPageSetup.FormatHeader(strHeader, m_timeHeader, pszFileName,
		pInfo->m_nCurPage);
	::dlgPageSetup.FormatFooter(strFooter, m_timeFooter, pszFileName,
		pInfo->m_nCurPage);
	RECT RightBorder;
	RightBorder.top=::dlgPageSetup.m_Top;
	RightBorder.bottom=::dlgPageSetup.m_Bottom;
	RightBorder.left=::dlgPageSetup.m_Left;
	RightBorder.right=::dlgPageSetup.m_Right;
	SetBorders(&RightBorder);
	CTableView::OnPrint(pDC, pInfo);
	pDC->SelectObject (pOldFont);
}

void CMyTableView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo) 
{
	CView::OnBeginPrinting(pDC, pInfo);

	LPCTSTR pszFileName = GetDocument()->GetPathName();
	BOOL bForceSysTime = _tcschr(pszFileName, '.') == NULL;
	CTime timeSys = CTime::GetCurrentTime();
	CFileStatus status;
	CFile::GetStatus(pszFileName, status);

	if (::dlgPageSetup.m_iHeaderTime != 0 || bForceSysTime)
		m_timeHeader = timeSys;
	else
		m_timeHeader = status.m_mtime;

	if (::dlgPageSetup.m_iFooterTime != 0 || bForceSysTime)
		m_timeFooter = timeSys;
	else
		m_timeFooter = status.m_mtime;

	if (!pInfo->m_bPreview)
		return;
}

void ScaleLogFont(LPLOGFONT plf, const CDC& dcFrom, const CDC& dcTo);

void CMyTableView::OnPrintChar() 
{
	CWaitCursor wait;
	CFont* pFont = GetPrinterFont();
	LOGFONT lf;
	LPLOGFONT plf = NULL;
	if (pFont != NULL)
	{
		pFont->GetObject(sizeof(LOGFONT), &lf);
		plf = &lf;
	}

	// magic to get printer dialog that would be used if we were printing!
	CPrintDialog dlgPrint(FALSE);
	if (!AfxGetApp()->GetPrinterDeviceDefaults(&dlgPrint.m_pd))
	{
		AfxMessageBox("Cannot get printer defaults.");
		return;
	}
	wait.Restore();
	HDC hdcPrint = dlgPrint.CreatePrinterDC();
	if (hdcPrint == NULL)
	{
		AfxMessageBox("Cannot get printer device context.");
		return;
	}

	CDC dcScreen;
	dcScreen.Attach(::GetDC(NULL));
	CDC dcPrint;
	dcPrint.Attach(hdcPrint);

	if (plf != NULL)
	{
		// need to map initial logfont to screen metrics.
		::ScaleLogFont(plf, dcPrint, dcScreen);
	}

	// now bring up the dialog since we know the printer DC
	CFontDialog dlg(plf, CF_PRINTERFONTS, &dcPrint);
	if (dlg.DoModal() == IDOK)
	{
		// map the resulting logfont back to printer metrics.
		lf = dlg.m_lf;
		::ScaleLogFont(&lf, dcScreen, dcPrint);

		SetPrinterFont(NULL);
		m_fontPrint.DeleteObject();
		if (m_fontPrint.CreateFontIndirect(&lf))
		{
			SetPrinterFont(&m_fontPrint);
			m_lfDefPrintFont = lf;

			// notify container that content has changed
			GetDocument()->UpdateAllViews(NULL);
		}
	}
	//NOTE: destructor will call dcPrint.DeleteDC

	::ReleaseDC(NULL, dcScreen.Detach());

}
