// pageset.cpp : implementation of the CPadView class
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992-1997 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and related
// electronic documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.

#include "stdafx.h"
#include "Analyzer.h"
#include <malloc.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPageSetupDlg dialog

IMPLEMENT_DYNAMIC(CPageSetupDlg, CDialog)

CPageSetupDlg::CPageSetupDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPageSetupDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPageSetupDlg)
	m_iFooterTime = -1;
	m_iHeaderTime = -1;
	m_Left = 0;
	m_Right = 0;
	m_Top = 0;
	m_Bottom = 0;
	//}}AFX_DATA_INIT
}

void CPageSetupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPageSetupDlg)
	DDX_Text(pDX, IDC_FOOTER, m_strFooter);
	DDX_Text(pDX, IDC_HEADER, m_strHeader);
	DDX_Radio(pDX, IDC_FOOTER_FILE, m_iFooterTime);
	DDX_Radio(pDX, IDC_HEADER_FILE, m_iHeaderTime);
	DDX_Text(pDX, IDC_LEFT, m_Left);
	DDV_MinMaxInt(pDX, m_Left, 0, 50);
	DDX_Text(pDX, IDC_RIGHT, m_Right);
	DDV_MinMaxInt(pDX, m_Right, 0, 50);
	DDX_Text(pDX, IDC_TOP, m_Top);
	DDV_MinMaxInt(pDX, m_Top, 0, 50);
	DDX_Text(pDX, IDC_BOTTOM, m_Bottom);
	DDV_MinMaxInt(pDX, m_Bottom, 0, 50);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPageSetupDlg, CDialog)
	//{{AFX_MSG_MAP(CPageSetupDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPageSetup member functions

static void Replace(CString& strModify, LPCTSTR pszWhat, LPCTSTR pszWith)
	// replace pszWhat with pwzWith in string strModify
{
	int i;
	if ((i = strModify.Find(pszWhat)) >= 0)
	{
		strModify = strModify.Left(i) + pszWith +
			strModify.Mid(i+lstrlen(pszWhat));
	}
}

void CPageSetupDlg::FormatFilePage(CString& strFormat,
	LPCTSTR pszFileName, UINT nPage)
{
	TCHAR sz[32];
	wsprintf(sz, _T("%d"), nPage);
	::Replace(strFormat, _T("&p"), sz);
	if (pszFileName == NULL)
	{
		pszFileName = sz;
		sz[0] = 0;
	}
	::Replace(strFormat, _T("&f"), pszFileName);
}

void CPageSetupDlg::FormatHeader(CString& strHeader, CTime& time,
	LPCTSTR pszFileName, UINT nPage)
{
	CString strFormat = m_strHeader;
	FormatFilePage(strFormat, pszFileName, nPage);
#ifdef _UNICODE
	int nLen = strFormat.GetLength();
	char *pszFormat = (char*)_alloca(nLen+1);
	wcstombs(pszFormat, strFormat, nLen+1);
	strHeader = time.Format(pszFormat);
#else
	strHeader = time.Format(strFormat);
#endif
}

void CPageSetupDlg::FormatFooter(CString& strFooter, CTime& time,
	LPCTSTR pszFileName, UINT nPage)
{
	CString strFormat = m_strFooter;
	FormatFilePage(strFormat, pszFileName, nPage);
#ifdef _UNICODE
	int nLen = strFormat.GetLength();
	char *pszFormat = (char*)_alloca(nLen+1);
	wcstombs(pszFormat, strFormat, nLen+1);
	strFooter = time.Format(pszFormat);
#else
	strFooter = time.Format(strFormat);
#endif
}


static TCHAR BASED_CODE szPageSetup[] = _T("PageSetup");
static TCHAR BASED_CODE szHeader[] = _T("Header");
static TCHAR BASED_CODE szFooter[] = _T("Footer");
static TCHAR BASED_CODE szHeaderTime[] = _T("HeaderTime");
static TCHAR BASED_CODE szFooterTime[] = _T("FooterTime");
static TCHAR BASED_CODE szLeft[] = _T("Left");
static TCHAR BASED_CODE szRight[] = _T("Right");
static TCHAR BASED_CODE szTop[] = _T("Top");
static TCHAR BASED_CODE szBottom[] = _T("Bottom");

void CPageSetupDlg::Initialize()
{
	m_strHeader = AfxGetApp()->GetProfileString(szPageSetup, szHeader,
		_T("File: &f"));
	m_strFooter = AfxGetApp()->GetProfileString(szPageSetup, szFooter,
		_T("Page: &p"));
	m_iHeaderTime = AfxGetApp()->GetProfileInt(szPageSetup, szHeaderTime, 0);
	m_iFooterTime = AfxGetApp()->GetProfileInt(szPageSetup, szFooterTime, 0);
	m_strHeaderOld = m_strHeader;
	m_strFooterOld = m_strFooter;
	m_iHeaderTimeOld = m_iHeaderTime;
	m_iFooterTimeOld = m_iFooterTime;
	m_Left = AfxGetApp()->GetProfileInt(szPageSetup, szLeft, 0);
	m_Right = AfxGetApp()->GetProfileInt(szPageSetup, szRight, 0);
	m_Top = AfxGetApp()->GetProfileInt(szPageSetup, szTop, 0);
	m_Bottom = AfxGetApp()->GetProfileInt(szPageSetup, szBottom, 0);
}

void CPageSetupDlg::Terminate()
{
	if (m_strHeader != m_strHeaderOld)
		AfxGetApp()->WriteProfileString(szPageSetup, szHeader, m_strHeader);
	if (m_strFooter != m_strFooterOld)
		AfxGetApp()->WriteProfileString(szPageSetup, szFooter, m_strFooter);
	if (m_iHeaderTime != m_iHeaderTimeOld)
		AfxGetApp()->WriteProfileInt(szPageSetup, szHeaderTime, m_iHeaderTime);
	if (m_iFooterTime != m_iFooterTimeOld)
		AfxGetApp()->WriteProfileInt(szPageSetup, szFooterTime, m_iFooterTime);
	AfxGetApp()->WriteProfileInt(szPageSetup, szLeft, m_Left);
	AfxGetApp()->WriteProfileInt(szPageSetup, szRight, m_Right);
	AfxGetApp()->WriteProfileInt(szPageSetup, szTop, m_Top);
	AfxGetApp()->WriteProfileInt(szPageSetup, szBottom, m_Bottom);
}

/////////////////////////////////////////////////////////////////////////////
// CPageSetupDlg message handlers
