#include <stdafx.h>
#include "Analyzer.h"
#include "resource.h"
#include "messages.h"

IMPLEMENT_DYNCREATE(CPadDoc, CDocument)
BEGIN_MESSAGE_MAP(CPadDoc, CDocument)
	//{{AFX_MSG_MAP(CPadDoc)
	ON_COMMAND(IDM_FILE_SAVEC,OnFileSave)
	ON_COMMAND(ID_FILE_SAVE_AS,OnFileSaveAs)
	ON_COMMAND(IDM_SAVE_QRY, OnSaveQry)
	ON_UPDATE_COMMAND_UI(IDM_SAVE_QRY, OnUpdateSaveQry)
	ON_UPDATE_COMMAND_UI(IDM_FILE_SAVEC, OnUpdateFileSave)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE_AS, OnUpdateFileSaveAs)
	ON_COMMAND(IDM_QRY_SAVE, OnQrySave)
	ON_UPDATE_COMMAND_UI(IDM_QRY_SAVE, OnUpdateQrySave)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE, OnUpdateGenFileSave)
	ON_COMMAND(ID_FILE_SAVE,OnFileSave)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CPadDoc::Serialize(CArchive& ar)
{
    CMultiView* cmv=(CMultiView*)m_viewList.GetHead();
	const CFile* fp = ar.GetFile();
	CFileStatus rStatus;
	if(!fp->GetStatus(rStatus )) AfxMessageBox(E_RDATTR);
	DWORD d=GetFileAttributes(rStatus.m_szFullName);
	if (d&FILE_ATTRIBUTE_READONLY)
	 {
	  cmv->rw=FALSE;
	  cmv->GetEditCtrl().SetReadOnly();
	 }
	 else
	 {
	  cmv->rw=TRUE;
	 }
    (cmv)->SerializeRaw(ar);
}

void CPadDoc::OnFileSave()
{
 CMultiView* cmv=(CMultiView*)m_viewList.GetHead();
 if (cmv->rw)
  {
   if (GetPathName()!="")
	DoFileSave();
   else if (m_IsQry) OnSaveQry(); else OnFileSaveAs();
  } else if (m_IsQry) OnSaveQry(); else OnFileSaveAs();
}

void CPadDoc::OnFileSaveAs()
{
 CMultiView* cmv=(CMultiView*)m_viewList.GetHead();
 if (cmv->rw && GetPathName()!="")
  {
   	if (!DoSave(NULL))
		TRACE0(E_SAVEFAIL);
  }
  else
   {
	CFileDialog dlgFile(FALSE);

	CString title=M_SAVEAS;
	CString fileName;
    UINT nIDSTitle=AFX_IDS_OPENFILE;
    DWORD lFlags=OFN_HIDEREADONLY ;
    BOOL bOpenFileDialog=FALSE;

	dlgFile.m_ofn.Flags |= lFlags;

	CString strFilter=M_TEXTFILES;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_TXTFLT);
	strFilter += (TCHAR)'\0';   // last string
	strFilter += "Files HTML (*.htm)";
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.htm");
	strFilter += (TCHAR)'\0';   // last string
	strFilter += "Files LFF (*.lff)";
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.lff");
	strFilter += (TCHAR)'\0';   // last string
	strFilter += "Files HTML (*.pdf)";
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.pdf");
	strFilter += (TCHAR)'\0';   // last string
	strFilter += "Files HTML (*.dff)";
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.dff");
	strFilter += (TCHAR)'\0';   // last string
	strFilter += "Files HTML (*.iff)";
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.iff");
	strFilter += (TCHAR)'\0';   // last string
	strFilter += "Files HTML (*.mac)";
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.mac");
	strFilter += (TCHAR)'\0';   // last string
	CString strDefault;
	// append the '*.*' all files filter
	CString allFilter;
	VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	strFilter += allFilter;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_ALLFLT);
	strFilter += (TCHAR)'\0';   // last string
	dlgFile.m_ofn.nMaxCustFilter++;

	dlgFile.m_ofn.lpstrFilter = strFilter;
	dlgFile.m_ofn.lpstrTitle = title;
	dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	BOOL bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	fileName.ReleaseBuffer();
    if (bResult)
     {
	  CString F=fileName;
      CFile f(fileName,CFile::modeCreate | CFile::modeWrite);
      CArchive ar( &f, CArchive::store);
      fileName=dlgFile.GetFileExt();
      fileName.MakeUpper();
      if (fileName=="HTM" || fileName=="HTML")
	  {
		  ar.WriteString("<HTML><BODY><PRE>");
		  cmv->SerializeRaw(ar);
		  ar.WriteString("</PRE></BODY></HTML>");
	  }
      else 
	  {
		  cmv->SerializeRaw(ar);
		  SetPathName(F,TRUE);
		  SetModifiedFlag(FALSE);
	  }
      if(!cmv->GetTemp())
        SetTitle(dlgFile.GetFileName());
     }
   }
}

void CPadDoc::OnSaveQry() 
{
	CMultiView* cmv=(CMultiView*)m_viewList.GetHead();
	CFileDialog dlgFile(FALSE);

	CString title=M_SAVEAS;
	CString fileName;
    UINT nIDSTitle=AFX_IDS_OPENFILE;
    DWORD lFlags=OFN_HIDEREADONLY ;
    BOOL bOpenFileDialog=FALSE;

	dlgFile.m_ofn.Flags |= lFlags;

	CString strFilter=M_QRYFILES;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_QRYFLT);
	strFilter += (TCHAR)'\0';   // last string
	CString strDefault;
	// append the '*.*' all files filter
	CString allFilter;
	VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	strFilter += allFilter;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_ALLFLT);
	strFilter += (TCHAR)'\0';   // last string
	dlgFile.m_ofn.nMaxCustFilter++;

	dlgFile.m_ofn.lpstrFilter = strFilter;
	dlgFile.m_ofn.lpstrTitle = title;
	dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	BOOL bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	fileName.ReleaseBuffer();
    if (bResult)
     {
      CFile f(fileName,CFile::modeCreate | CFile::modeWrite);
      CArchive ar( &f, CArchive::store);
      cmv->SerializeRaw(ar);
	  SetPathName(fileName,TRUE);
	  SetModifiedFlag(FALSE);
      if(!cmv->GetTemp())
        SetTitle(dlgFile.GetFileName());
     }
}

void CPadDoc::OnQrySave() 
{
 CMultiView* cmv=(CMultiView*)m_viewList.GetHead();
 if (cmv->rw)
  {
   if (GetPathName()!="")
	DoFileSave();
   else OnSaveQry();
  } else OnSaveQry();
}

void CPadDoc::OnUpdateQrySave(CCmdUI* pCmdUI) 
{
	if (m_IsQry) pCmdUI->Enable(TRUE); else pCmdUI->Enable(FALSE);
}

void CPadDoc::OnUpdateSaveQry(CCmdUI* pCmdUI) 
{
	if (m_IsQry) pCmdUI->Enable(TRUE); else pCmdUI->Enable(FALSE);
}

CPadDoc::CPadDoc()
{
	m_IsQry=FALSE;
	m_IsConf=FALSE;
}

CPadDoc::~CPadDoc()
{
	((CMainFrame*)AfxGetMainWnd())->RefreshMenu();
}

void CPadDoc::OnUpdateFileSave(CCmdUI* pCmdUI) 
{
	if (m_IsQry) pCmdUI->Enable(FALSE); else pCmdUI->Enable(TRUE);
}

void CPadDoc::OnUpdateFileSaveAs(CCmdUI* pCmdUI) 
{
	if (m_IsQry) pCmdUI->Enable(FALSE); else pCmdUI->Enable(TRUE);
}


void CPadDoc::OnUpdateGenFileSave(CCmdUI* pCmdUI) 
{
	if (m_IsQry || m_IsConf) pCmdUI->Enable(FALSE); else pCmdUI->Enable(TRUE);
}

void CPadDoc::SetPathName(LPCTSTR lpszPathName, BOOL bAddToMRU)
{
	// store the path fully qualified
	m_strPathName = lpszPathName;
	ASSERT(!m_strPathName.IsEmpty());       // must be set to something
	m_bEmbedded = FALSE;
	ASSERT_VALID(this);

	// set the document title based on path name
	CString str;
	str=GetTitle();
	if (str="")
	{
		str=lpszPathName;
		int l=str.GetLength();
		for (int i=l-1;i>=0;i--)
			if (str[i]=='\\') {str=str.Mid(i+1);break;}
		SetTitle(str);
	}
}

