// SaveOptions.cpp : implementation file
//

#include "stdafx.h"
#include "Analyzer.h"
#include "SaveOptions.h"
#include "CLogDocument.h"
#include "messages.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSaveOptions dialog


CSaveOptions::CSaveOptions(CWnd* pParent /*=NULL*/)
	: CDialog(CSaveOptions::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSaveOptions)
	//}}AFX_DATA_INIT
	m_pDoc=NULL;
	ValidFilter=TRUE;
	Option=NULL;
}


void CSaveOptions::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSaveOptions)
	DDX_Control(pDX, IDC_EDIT1, m_Filter);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSaveOptions, CDialog)
	//{{AFX_MSG_MAP(CSaveOptions)
	ON_BN_CLICKED(IDC_BUTTON1, OnSetFilter)
	ON_BN_CLICKED(IDC_RADIO03, OnRadio03)
	ON_BN_CLICKED(IDC_RADIO02, OnRadio02)
	ON_BN_CLICKED(IDC_RADIO01, OnRadio01)
	ON_WM_CLOSE()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_ALL, OnAll)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSaveOptions message handlers

#include "filterwiz.h"

void CSaveOptions::OnSetFilter() 
{
	short errors;
	if (Radio3) 
	{
		Radio0->SetCheck(FALSE);
		Radio1->SetCheck(FALSE);
		Radio2->SetCheck(FALSE);
		Radio3->SetCheck(TRUE);
		m_Filter.SetReadOnly(FALSE);
		m_Filter.UpdateWindow();
	}
	if(!m_pDoc) return;
	CString String=m_pDoc->query.ExecuteCommand("getprotos",&errors);
	if(errors!=0) 
	{
	  CFilterWiz sp;
	  LineCollection lc(&String);
	  sp.lc=&lc;
	  m_Filter.GetWindowText(sp.Filter);
	  sp.m_pDoc=m_pDoc;
	  if(sp.DoModal()==IDOK)
	  {
		  if (m_pDoc->OnLogFilter(sp.Filter))
		  {
			  ValidFilter=TRUE;
		  } else 
		  {
			  ValidFilter=FALSE;
			  m_pDoc->OnLogFilter((CString)"TRUE");
		  }
		  m_Filter.SetWindowText(sp.Filter);
	  }
	} else 
		{
		 AfxMessageBox(String);
		}
}

BOOL CSaveOptions::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	Radio1=(CButton*)GetDlgItem(IDC_RADIO01);
	Radio2=(CButton*)GetDlgItem(IDC_RADIO02);
	Radio3=(CButton*)GetDlgItem(IDC_RADIO03);
	Radio0=(CButton*)GetDlgItem(IDC_ALL);
	
	if (Radio0) Radio0->SetCheck(TRUE);
	if (m_pDoc) 
	{
		m_Filter.SetWindowText(Filter);
		CString str=m_pDoc->GetPathName();
	}
		else m_Filter.SetWindowText("TRUE");

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSaveOptions::OnRadio03() 
{
	if (Radio3) 
	{
		m_Filter.SetReadOnly(!Radio3->GetCheck());
	}
}

void CSaveOptions::OnRadio02() 
{
	if(Radio2->GetCheck()) m_Filter.SetReadOnly(TRUE);
}

void CSaveOptions::OnRadio01() 
{
	if(Radio1->GetCheck()) m_Filter.SetReadOnly(TRUE);
}

void CSaveOptions::OnOK(int & Opt)
{
	m_Filter.GetWindowText(Filter);
	if (Radio0 && Radio0->GetCheck()) 
	{
	    ValidFilter=FALSE;
		// Togliere il commento per disabilitare il filtro attuale
		// m_pDoc->OnLogFilter((CString)"TRUE");
		Opt=4;
	}
	else if (Radio1 && Radio1->GetCheck()) Opt=1;
	else if (Radio2 && Radio2->GetCheck()) Opt=2;
	else if (Radio3 && Radio3->GetCheck()) Opt=3;
	else Opt=2;
}

CSaveOptions::~CSaveOptions()
{
}

void CSaveOptions::OnClose() 
{
	if (Option) OnOK(*Option);
	
	CDialog::OnClose();
}

void CSaveOptions::OnDestroy() 
{
	if (Option) OnOK(*Option);
	CDialog::OnDestroy();
}

void CSaveOptions::OnAll() 
{
	if(Radio0->GetCheck()) m_Filter.SetReadOnly(TRUE);
}
