// SaveWnd.cpp : implementation file
//

#include "stdafx.h"
#include "Analyzer.h"
#include "SaveWnd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "SaveOptions.h"

/////////////////////////////////////////////////////////////////////////////
// CSaveWnd

IMPLEMENT_DYNAMIC(CSaveWnd, CFileDialog)

CSaveWnd::CSaveWnd(BOOL bOpenFileDialog, LPCTSTR lpszDefExt, LPCTSTR lpszFileName,
		DWORD dwFlags, LPCTSTR lpszFilter, CWnd* pParentWnd) :
		CFileDialog(bOpenFileDialog, lpszDefExt, lpszFileName, dwFlags, lpszFilter, pParentWnd),
		SaveOptions(NULL)
{
	Option=NULL;
}


BEGIN_MESSAGE_MAP(CSaveWnd, CFileDialog)
	//{{AFX_MSG_MAP(CSaveWnd)
	ON_WM_SHOWWINDOW()
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL CSaveWnd::OnInitDialog() 
{
	CFileDialog::OnInitDialog();

	SaveOptions=new CSaveOptions(GetParent());
	SaveOptions->Create(IDD_SAVE_OPTIONS,GetParent());
	SaveOptions->Option=&Option;
	SaveOptions->m_pDoc=m_pDoc;
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

CSaveWnd::~CSaveWnd()
{
	if (SaveOptions) delete SaveOptions;
}

void CSaveWnd::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CFileDialog::OnShowWindow(bShow, nStatus);
	
	RECT rect,rect2,rect3;
	SaveOptions->GetWindowRect(&rect2);
	GetParent()->GetWindowRect(&rect);
	GetParent()->GetClientRect(&rect3);
	GetParent()->SetWindowPos(NULL,rect.left,rect.top,rect.right-rect.left,
		rect.bottom-rect.top+rect2.bottom-rect2.top,SWP_NOZORDER);
	SaveOptions->SetWindowPos(&wndTop ,
		rect3.left,
		rect3.bottom,
		rect3.left+rect2.right-rect2.left,
		rect3.bottom+rect2.bottom-rect2.top,0);
	SaveOptions->Invalidate();
	SaveOptions->OnOK(Option);
	SaveOptions->ShowWindow(bShow);
}

void CSaveWnd::OnClose() 
{
	SaveOptions->OnOK(Option);
	m_Filter=SaveOptions->Filter;
	CFileDialog::OnClose();
}
