// SelFilter.cpp : implementation file
//

#include "stdafx.h"
#include "Analyzer.h"
#include "SelFilter.h"
#include "FilterWiz.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifndef ENGLISH
#define FLTRS "filters.dat"
#define FLTR_FILE_SEC "DAT"
#define SF_FP "Filtri Predefiniti"
#define SF_VAL "Valore"
#define SF_NEW "Nuovo Filtro"
#define SF_NESS "Nessun Filtro"
#define SF_NULL "Nulla"
#define SF_ERRNULL "Il filtro vuoto non  eliminabile"
#define SF_ERRNOTHING "Selezionare l'elemento da eliminare"
#define SF_ERRNAME "I nomi non possono contenere il simbolo '='"
#define SF_INSNAME "Inserire un nome valido"
#define SF_NE "Nuova Espressione"
#define SF_NP "Nuovi Parametri"
#define SF_SAVE "Si desiderano salvare le modifiche?"
#define SF_AGGERR "Impossibile aggiornare i filtri"
#define SF_TOOEL "Troppi Elementi"
#else
#define FLTRS "filters_e.dat"
#define FLTR_FILE_SEC "DAT_E"
#define SF_FP "Filters"
#define SF_VAL "Value"
#define SF_NEW "New Filter"
#define SF_NESS "No Filter"
#define SF_NULL "Nothing"
#define SF_ERRNULL "Unable to delete empty filter"
#define SF_ERRNOTHING "No selected filter"
#define SF_ERRNAME "Names cannot contain '='"
#define SF_INSNAME "Insert a valid name"
#define SF_NE "New Expression"
#define SF_NP "New Parameters"
#define SF_SAVE "Save Changes?"
#define SF_AGGERR "Unable to update filters"
#define SF_TOOEL "Too many elements"
#endif

/////////////////////////////////////////////////////////////////////////////
// CSelFilter dialog


CSelFilter::CSelFilter(CWnd* pParent /*=NULL*/)
	: CDialog(CSelFilter::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSelFilter)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_FileName="";
	m_nImage=8;
	m_Add="";
	m_AddNull=1;
	m_IsModified=FALSE;
	m_pDoc=NULL;
	m_Type=0;
}


void CSelFilter::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelFilter)
	DDX_Control(pDX, IDC_STATIC2, m_S2); 
	DDX_Control(pDX, IDC_STATIC1, m_S1);
	DDX_Control(pDX, IDC_WIZARD, m_Wizard);
	DDX_Control(pDX, IDC_NOME, m_Name);
	DDX_Control(pDX, IDC_EXP, m_Exp);
	DDX_Control(pDX, IDC_LIST1, m_ListCtrl);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSelFilter, CDialog)
	//{{AFX_MSG_MAP(CSelFilter)
	ON_BN_CLICKED(IDC_REMOVE, OnRemove)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDC_LIST1, OnEndlabeleditList1)
	ON_NOTIFY(LVN_BEGINLABELEDIT, IDC_LIST1, OnBeginlabeleditList1)
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_BN_CLICKED(IDC_WIZARD, OnWizard)
	ON_NOTIFY(NM_CLICK, IDC_LIST1, OnListClick)
	ON_BN_CLICKED(IDCANCEL2, OnCancel)
	ON_BN_CLICKED(IDC_UPDATE, OnUpdate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSelFilter message handlers

void CSelFilter::OnOK() 
{
	int i,n=m_ListCtrl.GetItemCount();
	SaveModufy();
	m_Filter="";
	for(i=0;i<n;i++)
	{
		if (m_ListCtrl.GetItemState(i,LVIS_SELECTED))
		{
			m_Filter=m_ListCtrl.GetItemText(i,1);
			break;
		}
	}
	if (i==0) m_Filter="";
	if (i==n) m_Exp.GetWindowText(m_Filter);
	
	CDialog::OnOK();
}

BOOL CSelFilter::OnInitDialog() 
{
	CDialog::OnInitDialog();

	if(m_C1!="")
		m_ListCtrl.InsertColumn(0,m_C1, LVCFMT_LEFT,200);
	else
		m_ListCtrl.InsertColumn(0,SF_FP /*Filtri Predefiniti*/, LVCFMT_LEFT,200);
	if(m_C2!="")
		m_ListCtrl.InsertColumn(0,m_C2, LVCFMT_LEFT,200);
	else
	    m_ListCtrl.InsertColumn(0,SF_VAL /*Valore*/, LVCFMT_LEFT,200);
	m_ctlImage.Create(IDB_BITMAP3,16,0,RGB(255,0,255));
	m_ListCtrl.SetImageList(&m_ctlImage,LVSIL_SMALL);
	Update();
	if(!m_pDoc) m_Wizard.ShowWindow(SW_HIDE);
	if(m_St1!="") m_S1.SetWindowText(m_St1);
	if(m_St2!="") m_S2.SetWindowText(m_St2);
	if(m_Title!="") this->SetWindowText(m_Title);
	return FALSE;
}

BOOL CSelFilter::Update()
{
        m_ListCtrl.DeleteAllItems();
		FILE* f;
		if (m_FileName=="") 
		{
			CWinApp* pApp = AfxGetApp();   
			m_FileName=pApp->GetProfileString(FLTR_FILE_SEC, "Filters", 
				(((CAnalyzerApp*)AfxGetApp())->Path)+FLTRS);
		}
		f=fopen(m_FileName,"r");
		int c=0;
		if (f)
		{
			char t[500];
			CString tmp;
			while (fgets(t,498,f))
			{
				if (t[strlen(t)-1]=='\n') t[strlen(t)-1]='\0';
				tmp="";
				for (int i=0;i<(signed)strlen(t);i++) 
					if (t[i]=='=') 
					{
						t[i]='\0'; 
						tmp=t;
						tmp.TrimRight();
						strcpy(t,tmp);
						tmp=(t+i+1); 
						tmp.TrimLeft(); 
						tmp.TrimRight(); 
						break;
					}
				if (tmp=="") continue;
				AddItem(c,0,t,m_nImage);
				AddItem(c,1,tmp);
				c++;
			}
			fclose(f);
		}
		if (m_Add!="")
		{
			AddItem(0,0,SF_NEW /*Nuovo Filtro*/,8);
			AddItem(0,1,m_Add);
			m_IsModified=TRUE;
		}
		if(m_AddNull)
		{
			AddItem(0,0,SF_NESS /*Nessun Filtro*/,6);
			AddItem(0,1,SF_NULL /*Nulla*/);
		}
		m_ListCtrl.UpdateWindow();
		m_ListCtrl.SetColumnWidth(0,200);
		m_ListCtrl.SetFocus();
		if (m_Add!="") 
		{
			CEdit* t;
			t=m_ListCtrl.EditLabel(1);
		}
		return TRUE;
}

void CSelFilter::AddItem(int nItem, int nSubItem, LPCTSTR strItem, int nImageIndex)
{
	LV_ITEM lvItem;
	lvItem.mask = LVIF_TEXT;
	lvItem.iItem = nItem;
	lvItem.iSubItem = nSubItem;
	lvItem.pszText = (LPTSTR) strItem;
	if(nImageIndex != -1){
		lvItem.mask |= LVIF_IMAGE;
		lvItem.iImage = nImageIndex;
	}
	if(nSubItem == 0)
		m_ListCtrl.InsertItem(&lvItem);
	else m_ListCtrl.SetItem(&lvItem);
}

void CSelFilter::OnCancel() 
{
	CDialog::OnCancel();	
}


void CSelFilter::OnRemove() 
{
	int i,n=m_ListCtrl.GetItemCount();
	for(i=0;i<n;i++)
	{
		if (m_ListCtrl.GetItemState(i,LVIS_SELECTED))
		{
			if (i!=0 || m_AddNull==0) {m_ListCtrl.DeleteItem(i);m_IsModified=TRUE;}
			else AfxMessageBox(SF_ERRNULL /*Il filtro vuoto non  eliminabile*/);
			return;
		}
	}
	AfxMessageBox(SF_ERRNOTHING /*Selezionare l'elemento da eliminare*/);
}

void CSelFilter::OnEndlabeleditList1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;
	
	CEdit* t=m_ListCtrl.GetEditControl( );
	CString str;
	*pResult = 1;
	if (t) t->GetWindowText(str);
	if (str!=m_Add) m_IsModified=TRUE;
	for(int i=0;i<str.GetLength();i++)
		if (str[i]=='=') 
			{
				AfxMessageBox(SF_ERRNAME /*I nomi non possono contenere il simbolo '='*/);
				t->SetWindowText(m_Add);
				break;
			}
}

void CSelFilter::OnBeginlabeleditList1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;

	pDispInfo->hdr.code=LVN_ENDLABELEDIT;
	if (m_ListCtrl.GetItemState(0,LVIS_SELECTED)) 
		m_ListCtrl.PostMessage(WM_MBUTTONDOWN ,MK_RBUTTON ,0);
	CEdit* t=m_ListCtrl.GetEditControl();
	if (t) t->GetWindowText(m_Add);
	*pResult = 0;
}

void CSelFilter::OnAdd() 
{
	CString str;
	if (m_Nums>0)
	{
		int n=m_ListCtrl.GetItemCount();
		if (n>=m_Nums-1)
			AfxMessageBox(SF_TOOEL /*Troppi Elementi*/);
	}
	m_Name.GetWindowText(str);
	if (str=="") {AfxMessageBox(SF_INSNAME /*Inserire il nome del filtro*/);return;}
	int i;
	if (m_AddNull) i=1; else i=0;
	AddItem(i,0,str,m_nImage);
	m_Exp.GetWindowText(str);
	AddItem(i,1,str);
	m_ListCtrl.SetItemState(i,0xffffffff,LVIS_SELECTED);
	m_IsModified=TRUE;
}

void CSelFilter::OnWizard() 
{
	SaveModufy();
	int OK=0;
	if (m_Type==0)
	{
		if(!m_pDoc) return;
		short errors;
		CString String=m_pDoc->query.ExecuteCommand("getprotos",&errors);
		if(errors!=0) 
		{
			CFilterWiz sp;
			LineCollection lc(&String);
			sp.lc=&lc;
			m_Exp.GetWindowText(sp.Filter);
			sp.m_pDoc=m_pDoc;
			if(sp.DoModal()==IDOK)
			{
				OK=1;
				if (!m_pDoc->OnLogFilter(sp.Filter))
					m_pDoc->OnLogFilter((CString)"TRUE");
				m_Exp.SetWindowText(sp.Filter);
				m_Name.SetWindowText(SF_NE /*Nuova Espressione*/);
			}
		} 
		else 
		{
			AfxMessageBox(String);
		}
	}
	else
	{
		return;
	}
	//if(OK) OnAdd();
}

void CSelFilter::OnListClick(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int i,n=m_ListCtrl.GetItemCount();
	if (pResult) *pResult = 0;
	if (m_AddNull) i=1; else i=0;
	for(;i<n;i++)
	{
		if (m_ListCtrl.GetItemState(i,LVIS_SELECTED))
		{
			m_Name.SetWindowText(m_ListCtrl.GetItemText(i,0));
			m_Exp.SetWindowText(m_ListCtrl.GetItemText(i,1));
			return;
		}
	}
	m_Name.SetWindowText(m_ListCtrl.GetItemText(0,0));
	if(m_AddNull)
	{
		m_Exp.SetWindowText("");
	}
	else
		m_Exp.SetWindowText(m_ListCtrl.GetItemText(0,1));
}

void CSelFilter::SaveModufy()
{
	int i,n=m_ListCtrl.GetItemCount();
	if (m_IsModified && AfxMessageBox(SF_SAVE /*Si desiderano salvare le modifiche?*/,MB_YESNO)==IDYES)
	{
		FILE* f= fopen(m_FileName,"w");
		if (!f) {AfxMessageBox(SF_AGGERR /*Impossibile aggiornare i filtri*/); return;}
		if (m_AddNull) i=1; else i=0;
		for(;i<n;i++)
			fprintf(f,"%s = %s\n",(const char*)m_ListCtrl.GetItemText(i,0),(const char*)m_ListCtrl.GetItemText(i,1));
		fclose(f);
		m_IsModified=FALSE;
	}
}

void CSelFilter::OnUpdate() 
{
	int i,n=m_ListCtrl.GetItemCount();
	if (m_AddNull) i=1; else i=0;
	for(;i<n;i++)
	{
		if (m_ListCtrl.GetItemState(i,LVIS_SELECTED))
		{
			m_ListCtrl.DeleteItem(i);
			break;
		}
	}
	OnAdd();
}
