// SelLFF.cpp : implementation file
//

#include "stdafx.h"
#include "Analyzer.h"
#include "SelLFF.h"
#include "FilterWiz.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifndef ENGLISH
#define FLTRS "extensions.dat"
#define FLTR_FILE_SEC "DAT"
#define SF_FP "Tipo di file"
#define SF_VAL "Estensione"
#define SF_LFF "File di def. associato"
#define SF_NEW "Nuova Associazione"
#define SF_ERRNULL "Il formato ACP non  eliminabile"
#define SF_ERRNOTHING "Selezionare l'elemento da eliminare"
#define SF_ERRNAME "I nomi non possono contenere il simbolo ':'"
#define SF_INSNAME "Inserire il nome dell'associazione, l'estensione ed il file LFF"
#define SF_NE "Nuova Estensione"
#define SF_NP "Nuovi Parametri"
#define SF_SAVE "Si desiderano salvare le modifiche?"
#define SF_AGGERR "Impossibile aggiornare le associazioni"
#define GEN_SF "Selezionare un file di definizione delle catture"
#define GEN_LFF "File LFF (*.lff)"
#define GEN_LFFFLT "*.lff"
#else
#define FLTRS "extensions_e.dat"
#define FLTR_FILE_SEC "DAT_E"
#define SF_FP "File Type"
#define SF_VAL "Extension"
#define SF_LFF "Associated def. file"
#define SF_NEW "New Association"
#define SF_ERRNULL "Unable to delete ACP format"
#define SF_ERRNOTHING "No selected association"
#define SF_ERRNAME "Names cannot contain ':'"
#define SF_INSNAME "Insert association name, file extensions and LFF file name"
#define SF_NE "New Extension"
#define SF_NP "New Parameters"
#define SF_SAVE "Save Changes?"
#define SF_AGGERR "Unable to update associations"
#define GEN_SF "Select a capture definition file"
#define GEN_LFF "Files LFF (*.lff)"
#define GEN_LFFFLT "*.lff"
#endif

/////////////////////////////////////////////////////////////////////////////
// CSelLFF dialog


CSelLFF::CSelLFF(CWnd* pParent /*=NULL*/)
	: CDialog(CSelLFF::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSelLFF)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_FileName="";
	m_Add="";
	m_IsModified=FALSE;
	m_pDoc=NULL;
	m_Type=0;
}


void CSelLFF::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelLFF)
	DDX_Control(pDX, IDC_EDIT1, m_File);
	DDX_Control(pDX, IDC_NOME, m_Name);
	DDX_Control(pDX, IDC_EXP, m_Exp);
	DDX_Control(pDX, IDC_LIST1, m_ListCtrl);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSelLFF, CDialog)
	//{{AFX_MSG_MAP(CSelLFF)
	ON_BN_CLICKED(IDC_REMOVE, OnRemove)
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_BN_CLICKED(IDC_TRY, OnTry)
	ON_NOTIFY(NM_CLICK, IDC_LIST1, OnListClick)
	ON_BN_CLICKED(IDC_UPDATE, OnUpdate)
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	ON_BN_CLICKED(IDCANCEL2, OnCancel)
	ON_BN_CLICKED(IDOK2, OnOK)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSelLFF message handlers

void CSelLFF::OnOK() 
{
	int n=m_ListCtrl.GetItemCount();
	SaveModufy();
	((CAnalyzerApp*)AfxGetApp())->SaveCapFormats();
	CDialog::OnOK();
}

BOOL CSelLFF::OnInitDialog() 
{
	CDialog::OnInitDialog();

    m_ListCtrl.InsertColumn(0,SF_FP, LVCFMT_LEFT,150);
    m_ListCtrl.InsertColumn(1,SF_VAL, LVCFMT_LEFT,50);
    m_ListCtrl.InsertColumn(2,SF_LFF, LVCFMT_LEFT,200);
	m_ctlImage.Create(IDR_BMP_1,16,0,RGB(255,0,255));
	m_ListCtrl.SetImageList(&m_ctlImage,LVSIL_SMALL);
	Update();
	return FALSE;
}

BOOL CSelLFF::Update()
{
        m_ListCtrl.DeleteAllItems();
		CAnalyzerApp* app=(CAnalyzerApp*) AfxGetApp();
		int n=app->CapFormats.GetSize();
		for (int i=0;i<n;i++)
		{
			AddItem(i,0,app->CapFormats[i],3);
			AddItem(i,1,app->CapExts[i]);
			AddItem(i,2,app->CapLFF[i]);
		}
		return TRUE;
}

void CSelLFF::AddItem(int nItem, int nSubItem, LPCTSTR strItem, int nImageIndex)
{
	LV_ITEM lvItem;
	lvItem.mask = LVIF_TEXT;
	lvItem.iItem = nItem;
	lvItem.iSubItem = nSubItem;
	lvItem.pszText = (LPTSTR) strItem;
	if(nImageIndex != -1){
		lvItem.mask |= LVIF_IMAGE;
		lvItem.iImage = nImageIndex;
	}
	if(nSubItem == 0)
		m_ListCtrl.InsertItem(&lvItem);
	else m_ListCtrl.SetItem(&lvItem);
}

void CSelLFF::OnCancel() 
{
	CDialog::OnCancel();	
}


void CSelLFF::OnRemove() 
{
	int i,n=m_ListCtrl.GetItemCount();
	for(i=0;i<n;i++)
	{
		if (m_ListCtrl.GetItemState(i,LVIS_SELECTED))
		{
			if (i!=0) {m_ListCtrl.DeleteItem(i);m_IsModified=TRUE;}
			else AfxMessageBox(SF_ERRNULL );
			return;
		}
	}
	AfxMessageBox(SF_ERRNOTHING /*Selezionare l'elemento da eliminare*/);
}


void CSelLFF::OnAdd() 
{
	CString str;
	m_Name.GetWindowText(str);
	if (str=="") {AfxMessageBox(SF_INSNAME);return;}
	AddItem(1,0,str,3);
	m_Exp.GetWindowText(str);
	if (str=="") {AfxMessageBox(SF_INSNAME);return;}
	AddItem(1,1,str);
	m_File.GetWindowText(str);
	if (str=="") {AfxMessageBox(SF_INSNAME);return;}
	AddItem(1,2,str);
	m_ListCtrl.SetItemState(1,0xffffffff,LVIS_SELECTED);
	m_IsModified=TRUE;
}

void CSelLFF::OnTry() 
{
	CString m_lff;
	m_File.GetWindowText(m_lff);
	((CAnalyzerApp*)AfxGetApp())->SelFLog(m_lff,((CAnalyzerApp*)AfxGetApp())->m_lfo,1);
}

void CSelLFF::OnListClick(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int i,n=m_ListCtrl.GetItemCount();
	if (pResult) *pResult = 0;
	for(i=0;i<n;i++)
	{
		if (m_ListCtrl.GetItemState(i,LVIS_SELECTED))
		{
			m_Name.SetWindowText(m_ListCtrl.GetItemText(i,0));
			m_Exp.SetWindowText(m_ListCtrl.GetItemText(i,1));
			m_File.SetWindowText(m_ListCtrl.GetItemText(i,2));
			return;
		}
	}
}

void CSelLFF::SaveModufy()
{
	int n=m_ListCtrl.GetItemCount();
	if (m_IsModified && AfxMessageBox(SF_SAVE /*Si desiderano salvare le modifiche?*/,MB_YESNO)==IDYES)
	{
		CAnalyzerApp* app=(CAnalyzerApp*) AfxGetApp();
		app->CapFormats.SetSize(n);
		app->CapExts.SetSize(n);
		app->CapLFF.SetSize(n);
		for (int i=0;i<n;i++)
		{
			app->CapFormats[i]=m_ListCtrl.GetItemText(i,0);
			app->CapExts[i]=m_ListCtrl.GetItemText(i,1);
			app->CapLFF[i]=m_ListCtrl.GetItemText(i,2);
		}
		return;
	}
}

void CSelLFF::OnUpdate() 
{
	int i,n=m_ListCtrl.GetItemCount();
	for(i=1;i<n;i++)
	{
		if (m_ListCtrl.GetItemState(i,LVIS_SELECTED))
		{
			m_ListCtrl.DeleteItem(i);
			break;
		}
	}
	OnAdd();
}

void CSelLFF::OnBrowse() 
{
	 CFileDialog dlgFile(TRUE);
	 BOOL bResult;

	 CString title=GEN_SF /*Selezionare il file sorgente*/;
	 CString fileName;
     UINT nIDSTitle=AFX_IDS_OPENFILE;
     DWORD lFlags=OFN_HIDEREADONLY| OFN_FILEMUSTEXIST;
     BOOL bOpenFileDialog=TRUE; 

	 dlgFile.m_ofn.Flags |= lFlags;

	 CString strFilter=GEN_LFF;
	 strFilter += (TCHAR)'\0';   // next string please
	 strFilter += GEN_LFFFLT;
	 strFilter += (TCHAR)'\0';   // last string
	 CString strDefault;
	 // append the '*.*' all files filter
	 CString allFilter;
	 VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	 strFilter += allFilter;
	 strFilter += (TCHAR)'\0';   // next string please
	 strFilter += _T("*.*");
	 strFilter += (TCHAR)'\0';   // last string
	 dlgFile.m_ofn.nMaxCustFilter++;

	 dlgFile.m_ofn.lpstrFilter = strFilter;
	 dlgFile.m_ofn.lpstrTitle = title;
	 dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	 bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	 fileName.ReleaseBuffer();
	 if (!bResult) return;
	 m_File.SetWindowText(fileName);
	 return ;
}

