#ifndef _TBLVW_
#define _TBLVW_

// TableVw.h : interface of the CTableView class
//
// This class provedes a full row selection mode for the report
// mode list view control.
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992-1997 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and related
// electronic documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.
#include <afxcview.h>

class CTableView : public CListView
{
	DECLARE_DYNCREATE(CTableView)

// Construction
public:
	CTableView();

// Attributes
protected:
	virtual CString& ValidateValue(CString& r){return r;}

public:
	CListCtrl& GetListCtrl(){ASSERT(FALSE); return CListView::GetListCtrl();}
	BOOL DeleteAllItems(){return CListView::GetListCtrl().DeleteAllItems();}
	void Invalidate(BOOL bErase = TRUE ){CListView::GetListCtrl().Invalidate(bErase);}
	inline int InsertColumn(int nCol, LPCTSTR lpszColumnHeading, int nFormat = LVCFMT_LEFT,
		int nWidth = 1, int nSubItem = 1);
	void SetFont(CFont* pFont, BOOL bRedraw = TRUE ){CListView::GetListCtrl().SetFont(pFont, bRedraw);}
	BOOL DeleteRow(int r){return CListView::GetListCtrl().DeleteItem(r);}
	BOOL SetFullRowSel(BOOL bFillRowSel);
	int GetRowCount(){return CListView::GetListCtrl().GetItemCount();}
	BOOL RedrawRows( int nFirst, int nLast ){return CListView::GetListCtrl().RedrawItems(nFirst,nLast);}
	virtual void SetStrHeader(CString& str) {m_strHeader="";}
	virtual void SetStrFooter(CString& str) {m_strFooter="";}
	void SetSeparator(const char* s){if(s) m_Separator=s;}
	CFont* GetPrinterFont() {return CFont::FromHandle(m_hPrinterFont);}

	BOOL m_bClientWidthSel;

// Printing...
	virtual void OnPrint(CDC* pDC, CPrintInfo *pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo);

// Overrides
protected:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTableView)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	//}}AFX_VIRTUAL

// Implementation
public:
	void UnLockUpdate();
	BOOL m_EnableUpdate;
	void LockUpdate();
	void SelectItem(int r,int c);
	int DeleteColumn(UINT i);
	int GetLineWidth();
	int GetColNumber();
	CString GetAllStr();
	void GetSel(int&r,int&c);
	void AddItem(int nItem, int nSubItem, LPCTSTR strItem);
	void SetBorders(RECT* r);
	void SetPrinterFont(CFont* pFont){ m_fontPrinter=pFont;
		m_hPrinterFont = (HFONT)pFont->GetSafeHandle();}
	virtual ~CTableView();
#ifdef _DEBUG
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	static LPCTSTR MakeShortString(CDC* pDC, LPCTSTR lpszLong, int nColumnLen, int nOffset);
	void RepaintSelectedItems();
	int m_Row;
	CFont* m_fontPrinter;
	CString m_strHeader;
	CString m_strFooter;

// Implementation - client area width
	int m_cxClient;

// Implementation - state icon width
	int m_cxStateImageOffset;
	afx_msg LRESULT OnSetImageList(WPARAM wParam, LPARAM lParam);

// Implementation - list view colors
	COLORREF m_clrText;
	COLORREF m_clrTextBk;
	COLORREF m_clrBkgnd;
	afx_msg LRESULT OnSetTextColor(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnSetTextBkColor(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnSetBkColor(WPARAM wParam, LPARAM lParam);

// Generated message map functions
protected:
	//{{AFX_MSG(CTableView)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnPaint();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnEditCopy();
	afx_msg void OnUpdateEditCopy(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnKeyDown(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnTblEdit();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnTblCopyAll();
	//}}AFX_MSG
	afx_msg void OnPrintPreview();
	afx_msg void OnUpdateFilePrint(CCmdUI* pCmdUI);
	DECLARE_MESSAGE_MAP()
private:
	int m_XOffset;
	int m_Column;
	void Print(CDC* pDC, CPrintInfo* pInfo, int nLStart, int nLEnd, int cyChar);
	RECT dlgSetupPage;
	CString m_Separator;
	BOOL m_bFocus;
	BOOL m_bFullRowSel;
	HFONT m_hPrinterFont;
};

inline int CTableView::InsertColumn( int nCol, LPCTSTR lpszColumnHeading, int nFormat,
		int nWidth, int nSubItem)
{
	return CListView::GetListCtrl().InsertColumn(nCol,lpszColumnHeading,nFormat,nWidth,nSubItem);
}

/////////////////////////////////////////////////////////////////////////////
#endif