// TblDocument.cpp : implementation file
//

#include "stdafx.h"
#include "analyzer.h"
#include "TblDocument.h"
#include "tblvw.h"
#include "messages.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifndef ITALIANO
#define M_DATFILES "DAT files (*.dat)"
#define M_DATFLT "*.dat"
#else
#define M_DATFILES "File DAT (*.dat)"
#define M_DATFLT "*.dat"
#endif

/////////////////////////////////////////////////////////////////////////////
// CTblDocument

IMPLEMENT_DYNCREATE(CTblDocument, CDocument)

CTblDocument::CTblDocument()
{
	m_Table=NULL;
	m_R=0;
	m_C=0;
	IsInit=0;
    m_IsTblModified=0;
}

BOOL CTblDocument::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;
	return TRUE;
}

CTblDocument::~CTblDocument()
{
	int i;
	if (m_Table)
	{
		for(i=0;i<m_R;i++)
			if (m_Table[i]) delete[]m_Table[i];
		delete[]m_Table;
	}
}


BEGIN_MESSAGE_MAP(CTblDocument, CDocument)
	//{{AFX_MSG_MAP(CTblDocument)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTblDocument diagnostics

#ifdef _DEBUG
void CTblDocument::AssertValid() const
{
	CDocument::AssertValid();
}

void CTblDocument::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CTblDocument serialization

CView* CTblDocument::GetCompatibleView(CRuntimeClass * pViewClass)
{
    CView* pView;
	POSITION pos = GetFirstViewPosition();
	while (pos != NULL)
	{
		pView = GetNextView(pos);
		if (pView->IsKindOf(pViewClass))
		{
			return pView;
		}
	}
    return NULL;
}

void CTblDocument::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		CString str;
		char tstring[20];
		int r,c;
		for(r=0;r<m_R;r++)
		{
			for(c=0;c<m_C;c++)
			{
				sprintf(tstring,"%d ",m_Table[r][c]);
				str+=tstring;
			}
			str+="\r\n";
			ar.WriteString(str);
			str="";
		}
	}
	else
	{
		LineCollection lc(ar,1);
		SetTitle(ar.GetFile()->GetFileName());
		NewFromLC(lc);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CTblDocument commands

int CTblDocument::NewFromLC(LineCollection & lc)
{
	int n=lc.GetSize();
	int r,c,nn;
	CString str;
	m_R=n;
	for(r=0;r<n;r++)
	{
		nn=0;
		str=lc.line(r);
		if (str.GetLength()==0) {m_R--;continue;}
		while (str[str.GetLength()-1]=='\r' || str[str.GetLength()-1]=='\n')
			str=str.Left(str.GetLength()-1);
		if(str[str.GetLength()-1]!=' ') str+=" ";
		for(c=0;c<str.GetLength();c++)
			if (str[c]==' ')
			{
				nn++;
			}
		m_C=max(m_C,nn);
	}
	m_Table=new int*[m_R];
	if(!m_Table) return 1;
	for(r=0;r<m_R;r++)
	{
		m_Table[r]=NULL;
	}
	for(r=0;r<m_R;r++)
	{
		m_Table[r] = new int[m_C];
		if(!m_Table[r]) return 1;
		for(c=0;c<m_C;c++)
			m_Table[r][c]=0;
	}
	int y=0;
	for(r=0;r<n;r++)
	{
		str=lc.line(r);
		if (str.GetLength()==0) {y++;continue;}
		sscanf(((const char*)str),"%d",&(m_Table[r-y][0]));
		nn=1;
		for(c=0;c<str.GetLength();c++)
			if (str[c]==' ') 
			{
				sscanf(((const char*)str)+c+1,"%d",&(m_Table[r-y][nn]));
				nn++;
			}
	}
	CTblView* vw=(CTblView*)GetCompatibleView(RUNTIME_CLASS(CTableView));
	if (!vw) return 1;
	vw->Update();
	IsInit=1;
	return 0;
}

int CTblDocument::Save()
{
	CFileDialog dlgFile(FALSE);

	CString title=M_SAVEAS;
	CString fileName;
    UINT nIDSTitle=AFX_IDS_OPENFILE;
    DWORD lFlags=OFN_HIDEREADONLY ;
    BOOL bOpenFileDialog=FALSE;

	dlgFile.m_ofn.Flags |= lFlags;

	CString strFilter=M_DATFILES;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_DATFLT);
	strFilter += (TCHAR)'\0';   // last string
	CString strDefault;
	// append the '*.*' all files filter
	CString allFilter;
	VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	strFilter += allFilter;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T(M_ALLFLT);
	strFilter += (TCHAR)'\0';   // last string
	dlgFile.m_ofn.nMaxCustFilter++;

	dlgFile.m_ofn.lpstrFilter = strFilter;
	dlgFile.m_ofn.lpstrTitle = title;
	dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	BOOL bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	fileName.ReleaseBuffer();
    if (bResult)
     {
	  CString F=fileName;
      CFile f(fileName,CFile::modeCreate | CFile::modeWrite);
      CArchive ar( &f, CArchive::store);
      fileName=dlgFile.GetFileExt();
      fileName.MakeUpper();
	  Serialize(ar);
	  m_IsTblModified=0;
     }
	else return 1;
	return 0;
}


void CTblDocument::GetSize(int & r, int & c)
{
	r=m_R;
	c=m_C;
}

int CTblDocument::At(int r, int c)
{
	if (r>=m_R || r<0) r=0;
	if (c>=m_C || c<0) r=0;
	return m_Table[r][c];
}

void CTblDocument::SetAt(int r, int c, int v)
{
	if (r>=m_R || r<0) r=0;
	if (c>=m_C || c<0) r=0;
	m_Table[r][c]=v;
}

void CTblDocument::RemoveRow(int nr)
{
	if (nr<0 || nr>=m_R) nr=0;
	int r;
	int* t=m_Table[nr];
	if (t) delete[]t;
	for(r=nr;r<m_R-1;r++)
		m_Table[r]=m_Table[r+1];
	m_Table[m_R-1]=NULL;
	m_R--;
}

void CTblDocument::RemoveCol(int nc)
{
	if (nc<0 || nc>=m_C) nc=0;
	int r,c;
	for(r=0;r<m_R;r++)
	 for(c=nc;c<m_C-1;c++)
		m_Table[r][c]=m_Table[r][c+1];
	m_C--;
}

void CTblDocument::Close()
{
	CView*pView;
	pView = GetCompatibleView(RUNTIME_CLASS(CTblView));
	if (pView) pView->GetParentFrame()->DestroyWindow();
    return;
}
