// ValGroup.cpp: implementation of the CValGroup class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ValGroup.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CValGroup::CValGroup()
{
	m_ValGroupName=NULL;
	m_ColName=NULL;
	m_RowName=NULL;
	m_R=0;
	m_C=0;
	m_TimeStamp=NULL;
	m_Table=NULL;
}

CValGroup::~CValGroup()
{
	if(m_ValGroupName) delete[]m_ValGroupName;
	m_ValGroupName=NULL;
	Empty();
}

int CValGroup::SetSize(int r, int c)
{
	Empty();
	if(r<=0 || c<=0) return 1;
	m_R=r;
	m_C=c;
	m_TimeStamp=new int[r];
	if(!m_TimeStamp) {Empty();return 1;}
	m_FinTimeStamp=new int[r];
	if(!m_FinTimeStamp) {Empty();return 1;}
	m_ColName=new char*[c];
	if(!m_ColName) 
	{
		Empty();
		return 1;
	}
	else 
	 for(int u=0;u<c;u++) 
		m_ColName[u]=NULL;
	m_RowName=new char*[r];
	if(!m_RowName) 
	{
		Empty();
		return 1;
	}
	else 
	 for(int u=0;u<r;u++) 
		m_RowName[u]=NULL;
	m_Table=new int*[r];
	if(!m_Table) 
	{
		Empty();
		return 1;
	}
	int i;
	for(i=0;i<r;i++)
	{
		m_Table[i]=NULL;
	}
	for(i=0;i<r;i++)
	{
		m_Table[i]=new int[c];
		if(!m_Table[i]) 
		{
			Empty();
			return 1;
		}
	}
	for(i=0;i<r;i++)
	{
		m_TimeStamp[i]=-1;
		m_FinTimeStamp[i]=-1;
		for(int j=0;j<c;j++)
			m_Table[i][j]=0;
	}
	return 0;
}

int CValGroup::At(int r, int c)
{
	if(r<0 || r>=m_R) r=0;
	if(c<0 || c>=m_C) c=0;
	return m_Table[r][c];
}

int& CValGroup::TimeStamp(int r)
{
	if(r<0 || r>=m_R) r=0;
	return m_TimeStamp[r];
}

int& CValGroup::FinTimeStamp(int r)
{
	if(r<0 || r>=m_R) r=0;
	return m_FinTimeStamp[r];
}

void CValGroup::Empty()
{
	if(m_TimeStamp) delete[]m_TimeStamp;
	m_TimeStamp=NULL;
	if(m_FinTimeStamp) delete[]m_FinTimeStamp;
	m_FinTimeStamp=NULL;
	if(m_Table) 
	{
		for (int i=0;i<m_R;i++)
			if (m_Table[i]) delete[]m_Table[i];
		delete[]m_Table;
	}
	if(m_ColName) 
	{
		for (int i=0;i<m_C;i++)
			if (m_ColName[i]) delete[]m_ColName[i];
		delete[]m_ColName;
	}
	m_ColName=NULL;
	if(m_RowName) 
	{
		for (int i=0;i<m_R;i++)
			if (m_RowName[i]) delete[]m_RowName[i];
		delete[]m_RowName;
	}
	m_RowName=NULL;
	m_Table=NULL;
	m_R=0;
	m_C=0;
}

void CValGroup::SetName(const char *n)
{
	if (m_ValGroupName) delete[]m_ValGroupName;
	m_ValGroupName=NULL;
	if (!n) return;
	m_ValGroupName=new char[strlen(n)+1];
	if (!m_ValGroupName) return;
	strcpy(m_ValGroupName,n);
}

void CValGroup::SetColName(const char *name,int n)
{
	if (n>=m_C) return;
	if (!m_ColName) return;
	if (m_ColName[n]) delete[]m_ColName[n];
	m_ColName[n]=NULL;
	if (!name) return;
	m_ColName[n]=new char[strlen(name)+1];
	if (!m_ColName[n]) return;
	strcpy(m_ColName[n],name);
}

const char* CValGroup::GetName()
{
	return m_ValGroupName;
}

const char* CValGroup::GetColName(int n)
{
	if (n>=m_C || m_ColName[n]==NULL) return "";
	return m_ColName[n];
}

void CValGroup::SetAt(int r, int c, int v)
{
	if(r<0 || r>=m_R) r=0;
	if(c<0 || c>=m_C) c=0;
	m_Table[r][c]=v;
}

void CValGroup::RemoveRow(int r)
{
	if(r<0 || r>=m_R) r=0;
	int i,j;
	m_R--;
	for(i=r;i<m_R;i++)
	{
		for(j=0;j<m_C;j++)
			m_Table[i][j]=m_Table[i+1][j];
		m_TimeStamp[i]=m_TimeStamp[i+1];
		m_FinTimeStamp[i]=m_FinTimeStamp[i+1];
	}
	delete[] m_Table[m_R];
}

void CValGroup::RemoveCol(int c)
{
	if(c<0 || c>=m_C) c=0;
	int i,j;
	m_C--;
	delete[]m_ColName[c];
	for(i=c;i<m_C;i++)
	{
		for(j=0;j<m_R;j++)
			m_Table[j][i]=m_Table[j][i+1];
		m_ColName[i]=m_ColName[i+1];
	}
	m_ColName[i]=NULL;
}

void CValGroup::SetRowName(int n, const char * name)
{
	if (n>=m_R) return;
	if (!m_RowName) return;
	if (m_RowName[n]) delete[]m_RowName[n];
	m_RowName[n]=NULL;
	if (!name) return;
	m_RowName[n]=new char[strlen(name)+1];
	if (!m_RowName[n]) return;
	strcpy(m_RowName[n],name);
}

CString CValGroup::GetRowName(int r)
{
	if (r>=m_R || m_RowName[r]==NULL) return "";
	return m_RowName[r];
}
