#include <stdafx.h>
#include <CapDll.h>
#include "Analyzer.h"
#include "resource.h"
#include "CAboutDialog.h"
#include "MenuSetup.h"
#include "ConfigDialog.h"
#include "messages.h"
#include "csvdoc.h"

#ifndef ENGLISH
#define MFR_TCPDUMPERR "Operazione Impossibile su questo Sistema Operativo"
#define MFR_TEMP_ERR "Impossibile Creare un file temporaneo"
#define MFR_C1 "Il comando "
#define MFR_C2 "  fallito!"
#define MFR_ERR "Errori riscontrati nella cattura"
#define W95_BUG "Chiudere e rilanciare l'applicazione perch le modifiche abbiano effetto"
#define ERR_FNT "La fonte selezionata verr utilizzata dalla prossima esecuzione"
#define APP_NONAME "Senza Nome"
#else
#define MFR_TCPDUMPERR "Unable to Capture on this operating system"
#define MFR_TEMP_ERR "Unable to create a temporary file"
#define MFR_C1 "Command: "
#define MFR_C2 " failed!"
#define MFR_ERR "Capture Errors"
#define W95_BUG "In Windows '95 you must close and reopen Analyzer to see modifications"
#define ERR_FNT "Selected font will be used from next Analyzer execution"
#define APP_NONAME "Untitled"
#endif

#include "resource.h"

const char* szAnalyzerClass = "AnalyzerWndClass";

IMPLEMENT_DYNCREATE(CMainFrame, CMDIFrameWnd)
BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_APP_ABOUT,OnAppAbout)
	ON_COMMAND(ID_VISUALIZZA_FINESTRA_COMANDI,OnViewCmd)
	ON_UPDATE_COMMAND_UI(ID_VISUALIZZA_FINESTRA_COMANDI,OnUpdateViewCmd)
	ON_UPDATE_COMMAND_UI(IDM_VIEW_TOOLBAR1,OnUpdateViewToolbar1)
	ON_COMMAND_EX(IDM_VIEW_TOOLBAR1,OnViewToolbar1)
	ON_WM_CLOSE()
	ON_COMMAND(IDM_CAPTURE, OnCapture)
	ON_COMMAND(IDM_MENU, OnMenu)
	ON_WM_ACTIVATE()
	ON_COMMAND(IDM_VIEW_EDIT_TOOLBAE, OnViewEditToolbar)
	ON_UPDATE_COMMAND_UI(IDM_VIEW_EDIT_TOOLBAE, OnUpdateViewEditToolbar)
	ON_UPDATE_COMMAND_UI(ID_FILE_CLOSE, OnUpdateFileClose)
	ON_COMMAND(IDM_CONF_ANALIZER, OnConfAnalyzer)
	ON_WM_DESTROY()
	ON_COMMAND(ID_CATTURA_SCEGLIADATTATORE, OnCatturaScegliadattatore)
	ON_COMMAND(ID_SELEZIONE_CARATTERI, OnSelezioneCaratteri)
	ON_WM_INITMENU()
	//}}AFX_MSG_MAP
	ON_WM_MEASUREITEM()
	ON_WM_MENUCHAR()
	ON_WM_INITMENUPOPUP()
	ON_COMMAND(ID_HELP_INDEX, CFrameWnd::OnHelpIndex)
	ON_COMMAND(ID_HELP_USING, CFrameWnd::OnHelpUsing)
	ON_COMMAND(ID_HELP, CFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CFrameWnd::OnHelpIndex)
	ON_COMMAND(ID_APP_EXIT, OnClose)
END_MESSAGE_MAP()

int UpdateFile(CString& f1,CString& f2)
{
	HANDLE h1,h2;
    h1 = CreateFile(f1, GENERIC_READ,
      FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

    if (h1 == INVALID_HANDLE_VALUE) 
	{
      return(0);
    }
    h2 = CreateFile(f2, GENERIC_READ,
      FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

    if (h2 == INVALID_HANDLE_VALUE) 
	{
	  CloseHandle(h1);
      return(0);
    }
	FILETIME ft1,ft2;
	int ret=0;
	GetFileTime(h1,NULL,NULL,&ft1);
	GetFileTime(h2,NULL,NULL,&ft2);
    if (ft1.dwHighDateTime>ft2.dwHighDateTime) ret = 1;
    else if ((ft1.dwHighDateTime==ft2.dwHighDateTime)&&
		(ft1.dwLowDateTime>ft2.dwLowDateTime)) ret = 1;
    CloseHandle(h1);
    CloseHandle(h2);
	return ret;
}

/*UINT buttons[] =
{
	ID_FILE_NEW, ID_CONF_OPEN, ID_FILE_SAVE, ID_SEPARATOR,
	ID_EDIT_FIND, ID_EDIT_REPEAT, ID_SEPARATOR,
	ID_SEPARATOR, ID_EDIT_CUT, ID_EDIT_COPY, ID_EDIT_PASTE,
	ID_SEPARATOR, ID_PAGE_SETUP, ID_FILE_PRINT_PREVIEW, ID_FILE_PRINT,
	ID_SEPARATOR, ID_APP_ABOUT, ID_CONTEXT_HELP
};*/

/*UINT buttons2[] =
{
	IDM_LOG_NEW,IDM_LOG_OPEN,IDM_FILE_SAVE,IDM_CAPTURE ,ID_SEPARATOR,
	IDM_LOG_FIRST,IDM_LOG_PREVF,IDM_LOG_PREV,
	IDM_LOG_NEXT,IDM_LOG_NEXTF,IDM_LOG_LAST,
	ID_SEPARATOR,IDM_LOG_FIND,ID_LOG_FIND_NEXT,
	ID_SEPARATOR,IDM_SELECT_EXP,
	ID_SEPARATOR,IDM_LOG_EXPAND,IDM_LOG_COLLAPSE,
	ID_SEPARATOR,IDM_LOG_QUERY,ID_NAVIGAZIONE_FILTRO, IDM_VIEW_PROTOS,
	ID_SEPARATOR,IDM_REP_OPEN,IDM_REP_CLOSE,IDM_REP_ADD,
	ID_SEPARATOR,ID_CAP_OPEN,ID_CAP_CLOSE,ID_CAP_ADD,
	ID_SEPARATOR,ID_VISUALIZZA_FINESTRA_COMANDI,ID_LOG_MACRO,IDM_TBL_GRAPH
};*/

//int sbuttons2=sizeof(buttons2)/sizeof(UINT);
//int sbuttons=sizeof(buttons)/sizeof(UINT);

static UINT indicators[] =
{
	ID_SEPARATOR, ID_INDICATOR_CAPS, ID_INDICATOR_NUM, ID_INDICATOR_SCRL,IDS_INDICATOR_LIN, IDS_INDICATOR_COL
};

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	m_isCmdVis=FALSE;
    m_ToolBar.Create(this,CBRS_TOP|CBRS_TOOLTIPS|CBRS_FLYBY|WS_VISIBLE);
	m_ToolBar.LoadToolBar(IDR_MAINFRAME);
	//m_ToolBar.SetButtons(buttons, sizeof(buttons)/sizeof(UINT));
	m_ToolBar.EnableDocking(CBRS_ALIGN_TOP|CBRS_ALIGN_BOTTOM);

    m_ToolBar1.Create(this);
	m_ToolBar1.LoadToolBar(IDB_BITMAP2);
	//m_ToolBar1.SetButtons(buttons2, sizeof(buttons2)/sizeof(UINT));
	m_ToolBar1.SetBarStyle(m_ToolBar.GetBarStyle()|CBRS_TOOLTIPS|CBRS_FLYBY);
	m_ToolBar1.EnableDocking(CBRS_ALIGN_TOP|CBRS_ALIGN_BOTTOM);

	m_StatusBar.Create(this);
	m_StatusBar.SetIndicators(indicators, sizeof(indicators)/sizeof(UINT));

	m_StatusBar.SetPaneText(m_StatusBar.CommandToIndex(IDS_INDICATOR_LIN) ,"");
	m_StatusBar.SetPaneText(m_StatusBar.CommandToIndex(IDS_INDICATOR_COL),"");
	windowmenu.LoadMenu(IDR_MAINFRAME);
	m_ToolBar.SetDlgCtrlID(0x1234);
	m_ToolBar1.SetDlgCtrlID(0x4321);
	EnableDocking(CBRS_ALIGN_TOP|CBRS_ALIGN_BOTTOM);
	DockControlBar(&m_ToolBar,AFX_IDW_DOCKBAR_TOP|AFX_IDW_DOCKBAR_LEFT);
	DockControlBar(&m_ToolBar1,AFX_IDW_DOCKBAR_TOP|AFX_IDW_DOCKBAR_RIGHT  );
	IsClosing=FALSE;
	m_cDlg.padre=this;
	m_cDlg.Create(IDD_CMD_DLG);
	m_cDlg.UpdateWindow();
	m_isCmdVis=FALSE;
	int b=CMDIFrameWnd::OnCreate(lpCreateStruct);
	AdjustToolBars();

	CAnalyzerApp* app=(CAnalyzerApp*) AfxGetApp();
	if (app)
	{
		RECT r2;

		r2.left=app->GetProfileInt("MainWin","left",-1);
		r2.right=app->GetProfileInt("MainWin","right",-1);
		r2.bottom=app->GetProfileInt("MainWin","bottom",-1);
		r2.top=app->GetProfileInt("MainWin","top",-1);
		if (r2.left>=0 && r2.right>=0 && r2.bottom>=0 && r2.top>=0)
			SetWindowPos(& wndTop,r2.left,r2.top,r2.right-r2.left,r2.bottom-r2.top,SWP_SHOWWINDOW);

		LoadBarState(app->m_pszProfileName);
	}

	MDISetMenu(&app->m_MainMenu,&windowmenu);
	DrawMenuBar();

	GetDC()->SetBkColor(::GetSysColor(COLOR_APPWORKSPACE));
	return b;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs) 
{
	WNDCLASS wndcls;

	HINSTANCE hInst = AfxGetInstanceHandle();

	BOOL bRes = CMDIFrameWnd::PreCreateWindow(cs);
	// see if the class already exists
	if (!::GetClassInfo(hInst, szAnalyzerClass, &wndcls))
	{
		// get default stuff
		::GetClassInfo(hInst, cs.lpszClass, &wndcls);
		wndcls.style &= ~(CS_HREDRAW|CS_VREDRAW);
		// register a new class
		wndcls.lpszClassName = szAnalyzerClass;
		wndcls.hIcon = ::LoadIcon(hInst, MAKEINTRESOURCE(IDR_MAINFRAME));
		ASSERT(wndcls.hIcon != NULL);
		if (!AfxRegisterClass(&wndcls))
			AfxThrowResourceException();
	}
	cs.lpszClass = szAnalyzerClass;
	return bRes;
}

int CMainFrame::EditToolBar(int ID,int visible)
    {
        return 0;
    }

void CMainFrame::OnViewCmd()
{
	if (m_isCmdVis) {m_cDlg.ShowWindow(SW_HIDE);m_isCmdVis=FALSE;}
	else {m_cDlg.ShowWindow(SW_SHOW);m_isCmdVis=TRUE;}
}

void CMainFrame::OnUpdateViewCmd(CCmdUI *pCmdUI)
{
	BOOL b=FALSE;
	int IsActive;
	if (GetCompatibleDoc(((CAnalyzerApp*)AfxGetApp())->logTreeTemplate,IsActive)) b=TRUE;
	if (GetCompatibleDoc(((CAnalyzerApp*)AfxGetApp())->logTemplate,IsActive)) b=TRUE;
	pCmdUI->Enable(b);
	if (b==FALSE && m_isCmdVis)
	{
		m_cDlg.ShowWindow(SW_HIDE);
		m_isCmdVis=FALSE;
	}
    pCmdUI->SetCheck(m_isCmdVis);
}

void CMainFrame::OnAppAbout()
{
    CAboutDialog about(this);
}

HMENU CMainFrame::GetWindowMenuPopup( HMENU hMenuBar )
{
	int n=GetMenuItemCount(hMenuBar);
	int i,j,m;
	HMENU t;
	UINT Id;
	for(i=n-1;i>=0;i--)
		{
			t=GetSubMenu(hMenuBar,i);
			m=GetMenuItemCount(t);
			for(j=0;j<=m;j++)
			{
				Id=GetMenuItemID(t,j);
				if (Id==ID_WINDOW_ARRANGE ||
					Id==ID_WINDOW_CASCADE ||
					Id==ID_WINDOW_TILE_HORZ ||
					Id==ID_WINDOW_TILE_VERT)
				return t;
			}
		}
		return NULL;
}

void CMainFrame::OnUpdateViewToolbar1(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck((m_ToolBar1.GetStyle() & WS_VISIBLE) != 0);
	return;
}


void CMainFrame::OnViewToolbar1(UINT nID)
{
   ShowControlBar(&m_ToolBar1, (m_ToolBar1.GetStyle() & WS_VISIBLE) == 0, FALSE);
}


void CMainFrame::OnClose()
{
	CLogDocument* log;
	BOOL b;
	do
	{
	  log=(CLogDocument*)GetCompatibleDoc(((CAnalyzerApp*)AfxGetApp())->logTreeTemplate,b);
	  if (log) log->OnClose();
	} while (log);
	do
	{
	  log=(CLogDocument*)GetCompatibleDoc(((CAnalyzerApp*)AfxGetApp())->logTemplate,b);
	  if (log) log->OnClose();
	} while (log);
    IsClosing=TRUE;
	RECT r2;
	GetWindowRect(&r2);

	CAnalyzerApp* app=(CAnalyzerApp*) AfxGetApp();
	if (app)
	{
		app->WriteProfileInt("MainWin","left",r2.left);
		app->WriteProfileInt("MainWin","right",r2.right);
		app->WriteProfileInt("MainWin","bottom",r2.bottom);
		app->WriteProfileInt("MainWin","top",r2.top);

		SaveBarState(app->m_pszProfileName);
	}

    CMDIFrameWnd::OnClose();
}

CDocument* CMainFrame::GetCompatibleDoc(CDocTemplate *pDocT, BOOL & IsActive)
   {
    CDocument* pDoc, *pfDoc, *paDoc;
	BOOL t;
	IsActive=FALSE;
	CMDIChildWnd* child=MDIGetActive(&t);
	if (child) paDoc=child->GetActiveDocument(); else paDoc=NULL;
	pfDoc=NULL;

	ASSERT_VALID(pDocT);
	POSITION pos = pDocT->GetFirstDocPosition();
	while (pos != NULL)
	{
		pDoc = pDocT->GetNextDoc(pos);
		if (pfDoc==NULL) pfDoc=pDoc;
		if (pDoc==paDoc) {IsActive=TRUE;return paDoc;}
	}
    return pfDoc;
   }

extern CAnalyzerApp theApp;

void CMainFrame::OnCapture() 
{
	DWORD dwVersion=GetVersion();
	DWORD dwWindowsMajorVersion =  (DWORD)(LOBYTE(LOWORD(dwVersion)));
	if (dwVersion < 0x80000000)                // Windows NT
		m_Cmd="windump ";
	else if (dwWindowsMajorVersion >= 4)			// Windows '95
		m_Cmd="windump95 ";
	else
		{AfxMessageBox(MFR_TCPDUMPERR /*Operazione Impossibile su questo Sistema Operativo*/); return;}
	theApp.m_CapDll.SetAdapter(Adapter);
	CString m_File;
	if(theApp.m_CapDll.CaptureDialog(Adapter,
		((CAnalyzerApp*)AfxGetApp())->Path,this)==IDOK) 
	{ 
		Adapter=theApp.m_CapDll.GetAdapter();
		int IsTemp=0;
		if (theApp.m_CapDll.GetFileName()) m_File=theApp.m_CapDll.GetFileName();
		 else m_File="";
		if (m_File=="") 
		{
			m_File=theApp.GetTempFile(".acp");
			if (m_File=="") {return;}
			IsTemp=1;
		}
		m_Cmd+="-P -w " + m_File + " ";
		if (Adapter!="") m_Cmd+="-i " + Adapter +" ";
		m_Cmd+=theApp.m_CapDll.GetFilter();
		const char* cmd;
		cmd=theApp.m_CapDll.Capture(m_Cmd,this);
		CAnalyzerApp* app=(CAnalyzerApp*)AfxGetApp();
		if(cmd)
		{
			app->CreateRoDoc(MFR_ERR /*Errori riscontrati nella cattura*/,cmd);
		}
		else
		{
	 	 if (m_File[0]=='"' && m_File[m_File.GetLength()-1]=='"')
			m_File=m_File.Mid(1,m_File.GetLength()-2);
		 CLogDocument* log;
		 log=app->OpenLog(m_File,IsTemp);
		 if (log && IsTemp) 
		 {
			log->SetCapModifiedFlag(TRUE);
			log->m_IsCapTmp=IsTemp;
			CString s;
			if (log->m_IsCapTmp) s=APP_NONAME;
			log->SetTitle(E_LOGTITLE+s);
		 }
		}
		m_Cmd=m_File;
	}
	
}

void SetToolBar(CToolBarEx &ToolBar, UINT id , const char* section)
{
	CToolBarCtrl &t=ToolBar.GetToolBarCtrl();
	CString str;
	int nn;

	ToolBar.LoadToolBar(id);
	nn=t.GetButtonCount();
	CAnalyzerApp* app =(CAnalyzerApp*)AfxGetApp();

	UINT *tb,n;
	tb=new UINT[nn];
	UINT *ti;
	ti=new UINT[nn];
	int j=0,ns=0;
	for (int i=0;i<nn;i++)
	{
		int nID=ToolBar.GetItemID(i);
		if (nID==ID_SEPARATOR) 
		{
			ns++;
			if (j!=0 && tb[j-1]!=ID_SEPARATOR) 
			{
				tb[j]=nID; 
				ti[j]=0; 
				j++;
			} 
			continue;
		}
		else
		{
			str.Format("ID_%d",nID);
			n=app->GetProfileInt(section,str,1);
			if (n) 
			{
				tb[j]=nID;
				ti[j]=i-ns; 
				j++;
			}
		}
	}
	if (j!=0 && tb[j-1]==ID_SEPARATOR) j--;
	ToolBar.SetButtons(tb,j);
	for(i=0;i<j;i++)
	{
		if (tb[i]!=ID_SEPARATOR)
			{ToolBar.SetButtonInfo(i,tb[i],TBBS_BUTTON,ti[i]);}
		else
			{ToolBar.SetButtonInfo(i,0,TBBS_SEPARATOR,0);}
	}
	ToolBar.CalcFixedLayout(TRUE,FALSE);
	CFrameWnd* f=ToolBar.GetDockingFrame();
	if (f) f->RecalcLayout();

	delete[]tb;
	delete[]ti;
}

void CMainFrame::AdjustToolBars()
{
	SetToolBar(m_ToolBar, IDR_MAINFRAME ,"FileToolBar");
	SetToolBar(m_ToolBar1, IDB_BITMAP2 ,"CapToolBar");
}

extern UINT toolbars[];

void CMainFrame::OnMenu() 
{
	CMenuSetup dlg;
	
	int ret=dlg.DoModal();
	OnMenuSilent(ret);
}

void CMainFrame::OnMenuSilent(int ret) 
{
	AdjustToolBars();
	DWORD dwVersion=GetVersion();
	DWORD dwWindowsMajorVersion =  (DWORD)(LOBYTE(LOWORD(dwVersion)));
	AfxGetApp()->DoWaitCursor(1);
	if (dwVersion < 0x80000000)                // Windows NT
	{
	  app->m_MainMenu.DestroyMenu();
	  app->m_TxtMenu.DestroyMenu();
	  app->m_CapMenu.DestroyMenu();
	  app->m_TblMenu.DestroyMenu();
	  app->m_MainMenu.LoadMenu(IDR_VOIDMENU);
	  app->m_TxtMenu.LoadMenu(IDR_TXTMENU);
	  app->m_CapMenu.LoadMenu(IDR_CAPMENU);
	  app->m_TblMenu.LoadMenu(IDR_TBLMENU);
	  app->SetupMenu(&(app->m_TxtMenu),"TxtMenu");
	  app->SetupMenu(&(app->m_TblMenu),"TblMenu");
	  app->SetupMenu(&(app->m_CapMenu),"CapMenu");
	  app->SetupMenu(&(app->m_MainMenu),"MainMenu");
	  app->SetupAppMenu(&(app->m_TxtMenu));
	  app->SetupAppMenu(&(app->m_CapMenu));
	  app->SetupAppMenu(&(app->m_TblMenu));
	  app->SetupAppMenu(&(app->m_MainMenu));
	  app->m_MainMenu.LoadToolbars(toolbars,3);
	  app->m_TxtMenu.LoadToolbars(toolbars,3);
	  app->m_CapMenu.LoadToolbars(toolbars,3);
	  app->m_TblMenu.LoadToolbars(toolbars,3);
	  CDocument* pDoc=GetActiveDocument();
	  if (pDoc==NULL)
		{
			CMDIChildWnd* child=MDIGetActive();
			if (child) pDoc=child->GetActiveDocument(); else pDoc=NULL;
		}
	  if (pDoc==NULL)
		{
			int iMenu = app->m_CapMenu.GetMenuItemCount() - 2;
			CMenu* pMenu;
			if(iMenu >= 0);
				pMenu = app->m_MainMenu.GetSubMenu(iMenu);
			SetMenu(&app->m_MainMenu);
			MDISetMenu(&app->m_MainMenu,pMenu);
		}
	  else if (pDoc->IsKindOf(RUNTIME_CLASS(CLogDocument)))
		{
			int iMenu = app->m_CapMenu.GetMenuItemCount() - 2;
			CMenu* pMenu;
			if(iMenu >= 0);
				pMenu = app->m_CapMenu.GetSubMenu(iMenu);
			MDISetMenu(&(app->m_CapMenu),pMenu);
		}
	  else if (pDoc->IsKindOf(RUNTIME_CLASS(CCsvDocument)))
		{
			int iMenu = app->m_TblMenu.GetMenuItemCount() - 2;
			CMenu* pMenu;
			if(iMenu >= 0);
				pMenu = app->m_TblMenu.GetSubMenu(iMenu);
			MDISetMenu(&(app->m_TblMenu),pMenu);
		}
	  else
		{
			int iMenu = app->m_TxtMenu.GetMenuItemCount() - 2;
			CMenu* pMenu;
			if(iMenu >= 0);
				pMenu = app->m_TxtMenu.GetSubMenu(iMenu);
			MDISetMenu(&(app->m_TxtMenu),pMenu);
		}
	}
	else if (ret==IDOK) AfxMessageBox(W95_BUG /*Chiudere e rilanciare l'applicazione perch le modifiche abbiano effetto*/);
	AfxGetApp()->DoWaitCursor(-1);
	DrawMenuBar();
}

BOOL CMainFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext *)
{
	SetMenu(&app->m_MainMenu);
	MDISetMenu(& app->m_MainMenu,&windowmenu);
	BOOL b=CreateClient(lpcs, GetMenu());
	PostMessage(WM_ACTIVATE,WA_CLICKACTIVE,0);
	GetDC()->SetBkColor(::GetSysColor(COLOR_APPWORKSPACE));
	return b;
}

CMainFrame::CMainFrame() : fltr(NULL),m_Fltr(FALSE)
{
	app=(CAnalyzerApp*) AfxGetApp();
}


void CMainFrame::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized) 
{
	CMDIFrameWnd::OnActivate(nState, pWndOther, bMinimized);
	if (nState!=WA_INACTIVE)
	{
		RefreshMenu();
	}
}

void CMainFrame::OnViewEditToolbar() 
{
   ShowControlBar(&m_ToolBar, (m_ToolBar.GetStyle() & WS_VISIBLE) == 0, FALSE);
}

void CMainFrame::OnUpdateViewEditToolbar(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck((m_ToolBar.GetStyle() & WS_VISIBLE) != 0);
	return;
}


void CMainFrame::OnUpdateFileClose(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(TRUE);
}

void CMainFrame::OnConfAnalyzer() 
{
	CConfigDialog dlg;
	dlg.DoModal();
}

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
	ASSERT(m_hWndMDIClient == NULL || ::IsWindow(m_hWndMDIClient));
}
#endif

void CMainFrame::OnDestroy() 
{
	m_hMenuDefault=::GetMenu(m_hWnd);
	CMDIFrameWnd::OnDestroy();
}

void CMainFrame::OnCatturaScegliadattatore() 
{
	theApp.m_CapDll.ChooseAdapter(Adapter, this);
	Adapter=theApp.m_CapDll.GetAdapter();
}

void CMainFrame::RefreshMenu()
{
	CDocument* pDoc=GetActiveDocument();
	if (pDoc==NULL)
		{
			CMDIChildWnd* child=MDIGetActive();
			if (child) pDoc=child->GetActiveDocument(); else pDoc=NULL;
		}
	if (pDoc==NULL)
		{
			SetMenu(&app->m_MainMenu);
			MDISetMenu(&app->m_MainMenu,&windowmenu);
			DrawMenuBar();
		}
}

void CMainFrame::OnSelezioneCaratteri() 
{
	CFontDialog f;
	CAnalyzerApp* app=(CAnalyzerApp*)AfxGetApp();
	f.m_cf.Flags&=~(CF_EFFECTS|CF_PRINTERFONTS|CF_USESTYLE);
	//f.m_cf.Flags|=CF_NOSTYLESEL;
	if (f.DoModal()==IDOK)
	{
		app->WriteProfileString("Settings","Font",f.GetFaceName());
		app->WriteProfileInt("Settings","FontDim",f.GetSize());
		AfxMessageBox(ERR_FNT /*La fonte selezionata verr utilizzata dalla prossima esecuzione*/);
	}
}

//This handler ensure that the popup menu items are drawn correctly
void CMainFrame::OnMeasureItem(int nIDCtl, LPMEASUREITEMSTRUCT lpMeasureItemStruct) 
{  
	BOOL setflag=FALSE;  
	if(lpMeasureItemStruct->CtlType==ODT_MENU)
	{
		if(IsMenu((HMENU)lpMeasureItemStruct->itemID))
		{
			CMenu* cmenu=CMenu::FromHandle((HMENU)lpMeasureItemStruct->itemID);
			if(theApp.m_MainMenu.IsMenu(cmenu)||
			   theApp.m_TxtMenu.IsMenu(cmenu) ||
			   theApp.m_CapMenu.IsMenu(cmenu) ||
			   theApp.m_TblMenu.IsMenu(cmenu)
			)
			{
				theApp.m_MainMenu.MeasureItem(lpMeasureItemStruct);        
				setflag=TRUE;      
			}
		}  
	}  
	if(!setflag)CMDIFrameWnd::OnMeasureItem(nIDCtl, lpMeasureItemStruct);
}

//This handler ensures that keyboard shortcuts work
LRESULT CMainFrame::OnMenuChar(UINT nChar, UINT nFlags, CMenu* pMenu) 
{
  LRESULT lresult;  
  if(theApp.m_MainMenu.IsMenu(pMenu)||
	   theApp.m_TxtMenu.IsMenu(pMenu) ||
	   theApp.m_CapMenu.IsMenu(pMenu) ||
	   theApp.m_TblMenu.IsMenu(pMenu)
	   )
    lresult=BCMenu::FindKeyboardShortcut(nChar, nFlags, pMenu);  
  else
    lresult=CMDIFrameWnd::OnMenuChar(nChar, nFlags, pMenu);  
  return(lresult);
}

//This handler updates the menus from time to time
void CMainFrame::OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu) 
{  
	CMDIFrameWnd::OnInitMenuPopup(pPopupMenu, nIndex, bSysMenu);  
	if(!bSysMenu)
	{
		if(theApp.m_MainMenu.IsMenu(pPopupMenu)||
		   theApp.m_TxtMenu.IsMenu(pPopupMenu) ||
		   theApp.m_CapMenu.IsMenu(pPopupMenu) ||
		   theApp.m_TblMenu.IsMenu(pPopupMenu)
		   )
			BCMenu::UpdateMenu(pPopupMenu);  
	}
}

void CMainFrame::OnInitMenu(CMenu* pMenu) 
{
	CMDIFrameWnd::OnInitMenu(pMenu);
}
