#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include "my_vector.h"

FILE* fin;

typedef struct
{
	int Secs;
	int uSecs;
	int SA;
	int DA;
	int PT;
	int SP;
	int DP;
#ifdef VIEW_N
	int n;
#endif
} Trace;

vector <Trace> v(100000,100000);

#ifndef ITALIANO
#define ERR_PAR "E' almeno atteso un parametro"
#define ERR_SRC "Impossibile aprire il file sorgente %s\n"
#else 
#define ERR_PAR "You must must specify at least a parameter"
#define ERR_SRC "Unable to open source file %s\n"
#endif

int cmp (const void* a, const void* b);
void PrintFlowsVerb(Trace* vect,int dim,int s);
void PrintFlows(Trace* vect,int dim,int s);

int main(int argc, char**argv)
{
	char c[500];
	if (argc<2) {printf(ERR_PAR /*E' almeno atteso un parametro*/);exit(-1);}
	int i,verb=0;
	int s=INT_MAX;
	if (argc>2)
	{
		for(i=1;i<argc-1;i++)
		{
			if (strcmp(argv[i],"-v")==0) verb=1;
			else if (strncmp(argv[i],"-s:",3)==0)
				sscanf(argv[i],"-s:%d",&s);
		}
	}
	fin=fopen(argv[argc-1],"r");
	if (fin==NULL) {printf(ERR_SRC /*Impossibile aprire il file sorgente %s\n*/,argv[1]);exit(-1);}
	int y=0;
	Trace *t;
	while (fgets(c,498,fin))
	{
		t=&v[y];
		if(sscanf(c,"%d;%d;%d;%d;%d;%d;%d;",&(t->Secs),&(t->uSecs),&(t->SA),
			&(t->DA),&(t->PT),&(t->SP),&(t->DP))==7) y++;
#ifdef VIEW_N
		t->n=y;
#endif
	}
	y--;
	Trace* vect;
	vect=v;
	qsort((void*)vect,y,sizeof(Trace),cmp);
	if (verb)
		PrintFlowsVerb(vect,y,s);
	else 
		PrintFlows(vect,y,s);

	return 0;
}

void PrintFlowsVerb(Trace* vect,int dim,int s)
{
	int y;
	int n=0;
	y=0;
#ifdef VIEW_N
	printf("%d) ",vect[y].n);
#endif
	printf("%3u.%3u.%3u.%3u -> %3u.%3u.%3u.%3u (%d) %d -> %d | %d:%d",
			 (vect[y].SA>>24)&0xff,(vect[y].SA>>16)&0xff,(vect[y].SA>>8)&0xff,(vect[y].SA)&0xff,
			 (vect[y].DA>>24)&0xff,(vect[y].DA>>16)&0xff,(vect[y].DA>>8)&0xff,(vect[y].DA)&0xff,
			 vect[y].PT,vect[y].SP,vect[y].DP,vect[y].Secs,vect[y].uSecs
			);
	for(y=1;y<dim-1;y++)
	{
		if (vect[y].SA!=vect[y-1].SA ||
			 vect[y].DA!=vect[y-1].DA ||
			 vect[y].PT!=vect[y-1].PT ||
			 vect[y].SP!=vect[y-1].SP ||
			 vect[y].DP!=vect[y-1].DP ||
			 vect[y].Secs - vect[y-1].Secs > s
			 )
		{
			printf(" -> %d:%d (%d)\n",vect[y-1].Secs,vect[y-1].uSecs,n+1);
#ifdef VIEW_N
			if (vect[y].n<0) printf("%d\n",y);
			printf("%d) ",vect[y].n);
#endif
		    printf("%3u.%3u.%3u.%3u -> %3u.%3u.%3u.%3u (%d) %d -> %d | %d:%d",
			 (vect[y].SA>>24)&0xff,(vect[y].SA>>16)&0xff,(vect[y].SA>>8)&0xff,(vect[y].SA)&0xff,
			 (vect[y].DA>>24)&0xff,(vect[y].DA>>16)&0xff,(vect[y].DA>>8)&0xff,(vect[y].DA)&0xff,
			 vect[y].PT,vect[y].SP,vect[y].DP,vect[y].Secs,vect[y].uSecs
			);
			n=0;
		}
		else n++;
	}
		if (vect[y].SA!=vect[y-1].SA ||
			 vect[y].DA!=vect[y-1].DA ||
			 vect[y].PT!=vect[y-1].PT ||
			 vect[y].SP!=vect[y-1].SP ||
			 vect[y].DP!=vect[y-1].DP ||
			 vect[y].Secs - vect[y-1].Secs > s
			 )
		{
			printf(" -> %d:%d (%d)\n",vect[y-1].Secs,vect[y-1].uSecs,n+1);
#ifdef VIEW_N
			printf("%d) ",vect[y].n);
#endif
		    printf("%3u.%3u.%3u.%3u -> %3u.%3u.%3u.%3u (%d) %d -> %d | %d:%d -> ...",
			 (vect[y].SA>>24)&0xff,(vect[y].SA>>16)&0xff,(vect[y].SA>>8)&0xff,(vect[y].SA)&0xff,
			 (vect[y].DA>>24)&0xff,(vect[y].DA>>16)&0xff,(vect[y].DA>>8)&0xff,(vect[y].DA)&0xff,
			 vect[y].PT,vect[y].SP,vect[y].DP,vect[y].Secs,vect[y].uSecs
			);
		}
		else
			printf(" -> ...");
}

void PrintFlows(Trace* vect,int dim,int s)
{
	int y;
	int n=0;
	y=0;
#ifdef VIEW_N
	printf("%d;",vect[y].n);
#endif
	printf("%d;%d;%d;%d;%d;%d;%d;",vect[y].SA,vect[y].DA,vect[y].PT,vect[y].SP,vect[y].DP,
		vect[y].Secs,vect[y].uSecs);
	for(y=1;y<dim-1;y++)
	{
		if (vect[y].SA!=vect[y-1].SA ||
			 vect[y].DA!=vect[y-1].DA ||
			 vect[y].PT!=vect[y-1].PT ||
			 vect[y].SP!=vect[y-1].SP ||
			 vect[y].DP!=vect[y-1].DP ||
			 vect[y].Secs - vect[y-1].Secs > s
			 )
		{
			printf("%d;%d;%d;\n",vect[y-1].Secs,vect[y-1].uSecs,n+1);
#ifdef VIEW_N
			if (vect[y].n<0) printf("%d\n",y);
			printf("%d;",vect[y].n);
#endif
			printf("%d;%d;%d;%d;%d;%d;%d;",vect[y].SA,vect[y].DA,vect[y].PT,vect[y].SP,vect[y].DP,
				vect[y].Secs,vect[y].uSecs);
			n=0;
		}
		else n++;
	}
		if (vect[y].SA!=vect[y-1].SA ||
			 vect[y].DA!=vect[y-1].DA ||
			 vect[y].PT!=vect[y-1].PT ||
			 vect[y].SP!=vect[y-1].SP ||
			 vect[y].DP!=vect[y-1].DP ||
			 vect[y].Secs - vect[y-1].Secs > s
			 )
		{
			printf("%d;%d;%d;\n",vect[y-1].Secs,vect[y-1].uSecs,n+1);
#ifdef VIEW_N
			printf("%d;",vect[y].n);
#endif
			printf("%d;%d;%d;%d;%d;%d;%d;%d;%d;%d;\n",
				vect[y].SA,vect[y].DA,vect[y].PT,vect[y].SP,vect[y].DP,
				vect[y].Secs,vect[y].uSecs,
				vect[y].Secs,vect[y].uSecs,1);
		}
		else
			printf("%d;%d;%d;\n",vect[y-1].Secs,vect[y-1].uSecs,n+1);
}

int cmp (const void* a, const void* b)
{
	if (((Trace*)a)->SA<((Trace*)b)->SA) return -1;
	if (((Trace*)a)->SA>((Trace*)b)->SA) return 1;
	if (((Trace*)a)->DA<((Trace*)b)->DA) return -1;
	if (((Trace*)a)->DA>((Trace*)b)->DA) return 1;
	if (((Trace*)a)->PT<((Trace*)b)->PT) return -1;
	if (((Trace*)a)->PT>((Trace*)b)->PT) return 1;
	if (((Trace*)a)->SP<((Trace*)b)->SP) return -1;
	if (((Trace*)a)->SP>((Trace*)b)->SP) return 1;
	if (((Trace*)a)->DP<((Trace*)b)->DP) return -1;
	if (((Trace*)a)->DP>((Trace*)b)->DP) return 1;
	if (((Trace*)a)->Secs<((Trace*)b)->Secs) return -1;
	if (((Trace*)a)->Secs>((Trace*)b)->Secs) return 1;
	if (((Trace*)a)->uSecs<((Trace*)b)->uSecs) return -1;
	if (((Trace*)a)->uSecs>((Trace*)b)->uSecs) return 1;
	return 0;
}
