//***********************************************************************
//
//  HexView.cpp
//
//***********************************************************************

#include <afxwin.h>
#include <afxext.h>
#include "Resource.h"

#include "..\inc\packet32.h"
#include "HexDoc.h"
#include "HexView.h"


#define PRINTMARGIN 2

// -----------------------------------------------
IMPLEMENT_DYNCREATE (CHexView, CScrollView)

BEGIN_MESSAGE_MAP (CHexView, CScrollView)
    ON_WM_CREATE ()
    ON_COMMAND (ID_FILE_PRINT, CScrollView::OnFilePrint)
    ON_COMMAND (ID_FILE_PRINT_DIRECT, CScrollView::OnFilePrint)
    ON_COMMAND (ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)
    ON_COMMAND (IDM_CAPTURE, CHexView::OnCapture)
    ON_COMMAND (IDM_PACKET, CHexView::OnPacket)
    ON_COMMAND (IDM_GETADAPTERSNAME, CHexView::OnGetAdaptersName)
    ON_COMMAND (IDM_SEND_PACKET, CHexView::OnSend)
    ON_COMMAND (IDM_OPENADAPTER1, CHexView::OnOpenAdapter1)
    ON_COMMAND (IDM_OPENADAPTER2, CHexView::OnOpenAdapter2)
    ON_COMMAND (IDM_CLOSEADAPTER, CHexView::OnCloseAdapter)
    ON_COMMAND (IDM_DUMPFILE, CHexView::OnDumpFile)

    ON_COMMAND (IDM_DIRECTED, CHexView::OnDirected)
    ON_COMMAND (IDM_MULTICAST, CHexView::OnMulticast)
    ON_COMMAND (IDM_BROADCAST, CHexView::OnBroadcast)
    ON_COMMAND (IDM_ALLMULTICAST, CHexView::OnAllMulticast)
    ON_COMMAND (IDM_PROMISCUOUS, CHexView::OnPromiscuous)
 
	ON_COMMAND (IDM_NUMBER, CHexView::OnNumber)

END_MESSAGE_MAP ()

// -----------------------------------------------
int CHexView::OnCreate (LPCREATESTRUCT lpcs)
{
    if (CScrollView::OnCreate (lpcs) == -1)
        return -1;

    CClientDC dc (this);
    int nHeight = -((dc.GetDeviceCaps (LOGPIXELSY) * 10) / 72);

    m_screenFont.CreateFont (nHeight, 0, 0, 0, FW_NORMAL, 0, 0, 0,
        DEFAULT_CHARSET, OUT_CHARACTER_PRECIS, CLIP_CHARACTER_PRECIS,
        DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE, "Courier New");

    TEXTMETRIC tm;
    CFont* pOldFont = dc.SelectObject (&m_screenFont);
    dc.GetTextMetrics (&tm);
    m_cyScreen = tm.tmHeight + tm.tmExternalLeading;
    dc.SelectObject (pOldFont);
	Adapter = (GetDocument()->Adapter);
	NPacket = 1;
	AdapterName1[0] = '\0';
	AdapterName2[0] = '\0';
    return 0;
}

// -----------------------------------------------
void CHexView::OnGetAdaptersName()
{
 ULONG NameLength = 128;
 char AdaptersName[128];

	PacketGetAdapterNames(AdaptersName,&NameLength);
	int i;
	for (i=0;AdaptersName[i]!='\0' || AdaptersName[i+1]!='\0';i++)
	{
		AdapterName1[i] = AdaptersName[i];
	}
	AdapterName1[i] = '\0';
	AdapterName1[i+1] = '\0';
	AdapterName1[i+2] = '\0';

	int j;
	for (i+=3,j=0;AdaptersName[i]!='\0' || AdaptersName[i+1]!='\0';i++,j++)
	{
		AdapterName2[j] = AdaptersName[i];
	}
	AdapterName2[j] = '\0';
	AdapterName2[j+1] = '\0';
	AdapterName2[j+2] = '\0';

}
// -----------------------------------------------
void CHexView::OnCloseAdapter()
{

  // Chiudo l'adattatore
	if (Adapter != NULL)
	{
	    PacketCloseAdapter(GetDocument()->Adapter);
		GetDocument()->Adapter = Adapter = NULL;
	}
}

// -----------------------------------------------
void CHexView::OnOpenAdapter1()
{
	if (Adapter == NULL && (AdapterName1[0] != '\0'))
	{
		GetDocument()->BigBuffer = NULL;
		// Apro l'adattatore 
		GetDocument()->Adapter = PacketOpenAdapter(AdapterName1);
		Adapter = GetDocument()->Adapter;
		PacketSetFilter(Adapter,NDIS_PACKET_TYPE_PROMISCUOUS);
	}
}
// -----------------------------------------------
void CHexView::OnOpenAdapter2()
{
	if (Adapter == NULL && AdapterName2[0] != '\0')
	{
		GetDocument()->BigBuffer = NULL;
		// Apro l'adattatore 
		GetDocument()->Adapter = (LPADAPTER)PacketOpenAdapter(AdapterName2);
		Adapter = GetDocument()->Adapter;
		PacketSetFilter(Adapter,NDIS_PACKET_TYPE_PROMISCUOUS);
	}
}

// -----------------------------------------------
void CHexView::OnPacket()
{
	// Leggo il pacchetto
	if (GetDocument()->readPacket() == 0 )
		return;
	OnInitialUpdate();
	Invalidate();
}
// -----------------------------------------------
void CHexView::OnSend()
{
	// Invio il pacchetto
	if (GetDocument()->writePacket())
		AfxMessageBox("Send of packet Completed");
	else
		AfxMessageBox("Error in sending of the packet");
}
// -----------------------------------------------
void CHexView::OnCapture()
{
	// Leggo i pacchetti
	if (GetDocument()->readPackets(NPacket) == 0)
		return;
	OnInitialUpdate();
	Invalidate();
}

// -----------------------------------------------
void CHexView::OnDumpFile()
{
	GetDocument()->DumpPacket();
}

// -----------------------------------------------
	void CHexView::OnDirected()
{
	if (Adapter != NULL)
		PacketSetFilter(Adapter,NDIS_PACKET_TYPE_DIRECTED);
}
// -----------------------------------------------
	void CHexView::OnMulticast()
{
	if (Adapter != NULL)
	    PacketSetFilter(Adapter,NDIS_PACKET_TYPE_MULTICAST);
}
// -----------------------------------------------
	void CHexView::OnBroadcast()
{
	if (Adapter != NULL)
		PacketSetFilter(Adapter,NDIS_PACKET_TYPE_BROADCAST);
}
// -----------------------------------------------
	void CHexView::OnAllMulticast()
{
   	if (Adapter != NULL)
		PacketSetFilter(Adapter,NDIS_PACKET_TYPE_ALL_MULTICAST);
}
// -----------------------------------------------
	void CHexView::OnPromiscuous()
{
	if (Adapter != NULL)
	    PacketSetFilter(Adapter,NDIS_PACKET_TYPE_PROMISCUOUS);
}

// -----------------------------------------------
	void CHexView::OnNumber()
{
	CDialogNumber dlg(this);

	if (dlg.DoModal() == IDOK)
	{
		NPacket = dlg.num;
	}
}
// -----------------------------------------------

void CHexView::OnInitialUpdate ()
{
    UINT nDocLength = GetDocument ()->GetDocumentLength ();
    m_nLinesTotal = (nDocLength + 15) / 16;

    SetScrollSizes (MM_TEXT, CSize (0, m_nLinesTotal * m_cyScreen),
        CSize (0, m_cyScreen * 10), CSize (0, m_cyScreen));
    ScrollToPosition (CPoint (0, 0));

    CScrollView::OnInitialUpdate ();
}

// -----------------------------------------------
void CHexView::OnDraw (CDC* pDC)
{
    if (m_nLinesTotal != 0) {
        CRect rect;
        pDC->GetClipBox (&rect);


        UINT nStart = rect.top / m_cyScreen;
        UINT nEnd = min (m_nLinesTotal - 1,
            (rect.bottom + m_cyScreen - 1) / m_cyScreen);

        CString string;
        CFont* pOldFont = pDC->SelectObject (&m_screenFont);

        for (UINT i=nStart; i<=nEnd; i++) 
		{
            if (FormatLine (i, string) == 100)
			{
				pDC->TextOut (2, (i * m_cyScreen) + 2, string);
				i++;
				pDC->TextOut (2, (i * m_cyScreen) + 2, CString("---------------------------------------------------------------------------------"));
			}
			else
				pDC->TextOut (2, (i * m_cyScreen) + 2, string);
        }
        pDC->SelectObject (pOldFont);
    }
}

// -----------------------------------------------
BOOL CHexView::OnPreparePrinting (CPrintInfo* pInfo)
{
    return DoPreparePrinting (pInfo);
}

// -----------------------------------------------
void CHexView::OnBeginPrinting (CDC* pDC, CPrintInfo* pInfo)
{
    int nHeight = -((pDC->GetDeviceCaps (LOGPIXELSY) * 10) / 72);

    m_printerFont.CreateFont (nHeight, 0, 0, 0, FW_NORMAL, 0, 0, 0,
        DEFAULT_CHARSET, OUT_CHARACTER_PRECIS, CLIP_CHARACTER_PRECIS,
        DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE, "Courier New");

    TEXTMETRIC tm;
    CFont* pOldFont = pDC->SelectObject (&m_printerFont);
    pDC->GetTextMetrics (&tm);
    m_cyPrinter = tm.tmHeight + tm.tmExternalLeading;
    CSize size = pDC->GetTextExtent ("---------1---------2---------" \
        "3---------4---------5---------6---------7---------8-", 81);
    pDC->SelectObject (pOldFont);

    m_nLinesPerPage = (pDC->GetDeviceCaps (VERTRES) -
        (m_cyPrinter * (3 + (2 * PRINTMARGIN)))) / m_cyPrinter;
    UINT nMaxPage = max (1, (m_nLinesTotal + (m_nLinesPerPage - 1)) /
        m_nLinesPerPage);
    pInfo->SetMaxPage (nMaxPage);

    m_cxOffset = (pDC->GetDeviceCaps (HORZRES) - size.cx) / 2;
    m_cxWidth = size.cx;
}

// -----------------------------------------------
void CHexView::OnPrint (CDC* pDC, CPrintInfo* pInfo)
{
    PrintPageHeader (pDC, pInfo->m_nCurPage);
    PrintPage (pDC, pInfo->m_nCurPage);
}

// -----------------------------------------------
void CHexView::OnEndPrinting (CDC* pDC, CPrintInfo* pInfo)
{
    m_printerFont.DeleteObject ();
}

// -----------------------------------------------
int CHexView::FormatLine (UINT nLine, CString& string)
{
 BYTE b[17];
 ::FillMemory (b, 16, 32);
 UINT nCount = GetDocument ()->GetBytes (nLine * 16, 16, b);
 if (nCount == 100)
 {
	 string.Format("%s","---------------------------------------------------------------------------------");
	 return 0;
 } 
 else
 {
    string.Format ("%0.8X    %0.2X %0.2X %0.2X %0.2X %0.2X %0.2X " \
        "%0.2X %0.2X - %0.2X %0.2X %0.2X %0.2X %0.2X %0.2X %0.2X " \
        "%0.2X    ", nLine * 16,
        b[0], b[1],  b[2],  b[3],  b[4],  b[5],  b[6],  b[7],
        b[8], b[9], b[10], b[11], b[12], b[13], b[14], b[15]);

    for (UINT i=0; i<nCount; i++) {
        if (!::IsCharAlphaNumeric (b[i]))
            b[i] = 0x2E;
    }

    b[nCount] = 0;
    string += b;

    if (nCount < 16) {
        UINT pos1 = 59;
        UINT pos2 = 60;
        UINT j = 16 - nCount;

        for (i=0; i<j; i++) {
            string.SetAt (pos1, ' ');
            string.SetAt (pos2, ' ');
            pos1 -= 3;
            pos2 -= 3;
            if (pos1 == 35) {
                string.SetAt (35, ' ');
                string.SetAt (36, ' ');
                pos1 = 33;
                pos2 = 34;
            }
        }
    }
 }
 if (nCount < 16)
	 return 100;
 return 0;
}

// -----------------------------------------------
void CHexView::PrintPageHeader (CDC* pDC, UINT nPageNumber)
{
    CString strHeader = GetDocument ()->GetPathName ();
    if (strHeader.GetLength () > 68)
        strHeader = GetDocument ()->GetTitle ();

    CString strPageNumber;
    strPageNumber.Format ("Page %d", nPageNumber);

    UINT nSpaces = 81 - strPageNumber.GetLength () -
        strHeader.GetLength ();
    for (UINT i=0; i<nSpaces; i++)
        strHeader += ' ';
    strHeader += strPageNumber;

    UINT y = m_cyPrinter * PRINTMARGIN;
    CFont* pOldFont = pDC->SelectObject (&m_printerFont);
    pDC->TextOut (m_cxOffset, y, strHeader);

    y += (m_cyPrinter * 3) / 2;
    pDC->MoveTo (m_cxOffset, y);
    pDC->LineTo (m_cxOffset + m_cxWidth, y);

    pDC->SelectObject (pOldFont);
}

// -----------------------------------------------
void CHexView::PrintPage (CDC* pDC, UINT nPageNumber)
{
    if (m_nLinesTotal != 0) {
        UINT nStart = (nPageNumber - 1) * m_nLinesPerPage;
        UINT nEnd = min (m_nLinesTotal - 1, nStart + m_nLinesPerPage - 1);

        CString string;
        CFont* pOldFont = pDC->SelectObject (&m_printerFont);

        UINT y;
        for (UINT i=nStart; i<=nEnd; i++) {
            FormatLine (i, string);
            y = ((i - nStart) + PRINTMARGIN + 3) * m_cyPrinter;
            pDC->TextOut (m_cxOffset, y, string);
        }
        pDC->SelectObject (pOldFont);
    }
}

//***********************************************************************
BEGIN_MESSAGE_MAP (CDialogNumber, CDialog)
END_MESSAGE_MAP ()


BOOL CDialogNumber::OnInitDialog(UINT n)
{
	char str[10]; 
	_itoa(n,str,10);
	edit1().SetWindowText(str);
	return TRUE;
}
//--------------------------------------------------------------
void CDialogNumber::OnOK()
{
	char str[10]; 
	edit1().GetWindowText(str,10);
	num = atoi(str);
	CDialog::OnOK();
}
//--------------------------------------------------------------
CEdit& CDialogNumber:: edit1 ()
{
	return *(CEdit*) GetDlgItem(IDC_EDIT1);
}

//***********************************************************************
