#ifdef WIN32
#include "../Win32-Include/w32_fzs.h"
#include <stdio.h>
#include <signal.h>

extern int progress;

int wsockinit()
{
	WORD wVersionRequested;
	WSADATA wsaData;
	int err;
	wVersionRequested = MAKEWORD( 1, 1); 
	err = WSAStartup( wVersionRequested, &wsaData );
	if ( err != 0 )
	{
	
	//questa parte serve solo epr il debug epr capire qual e' l'errore riportato dalla WSAStartup
	if (err==WSASYSNOTREADY) 
		printf("\n Indicates that the underlying network subsystem is not ready for network communication. \n");

	if (err==WSAVERNOTSUPPORTED ) 
		printf("\n The version of Windows Sockets support requested is not provided by this particular Windows Sockets implementation. \n");

	if (err==WSAEINPROGRESS ) 
		printf("\n A blocking Windows Sockets 1.1 operation is in progress. \n");

	if (err==WSAEPROCLIM ) 
		printf("\n Limit on the number of tasks supported by the Windows Sockets implementation has been reached. \n");

	if (err==WSAEFAULT ) 
		printf("\n The lpWSAData is not a valid pointer\n");

	/* Tell the user that we couldn't find a usable */
	/* WinSock DLL.                                  */
		return 1;
	}
	return 0;
}

HANDLE hThread;

#ifndef WIN95
static WCHAR *TmpName=NULL;
#endif

DWORD WINAPI MyThread(LPVOID l)
{
	HANDLE in;
	DWORD d;
	char t;
	for(;;)
	{
		in=GetStdHandle(STD_INPUT_HANDLE);
		//_getch();
		ReadFile(in,&t,1,&d,NULL);
		SuspendThread(hThread);
		raise(SIGTERM);
	}
	ExitThread(0);
	return 0;
}

void InitP()
{
	DWORD d;
	DuplicateHandle(GetCurrentProcess(),
							GetCurrentThread(),
							GetCurrentProcess(),
							&hThread,0,FALSE,
							DUPLICATE_SAME_ACCESS);
	CreateThread(NULL,1024,&MyThread,NULL,0,&d);
}

extern char* AdapterName1;

#ifndef WIN95

WCHAR* SChar2WChar(char* nome)
{
	int i;
	TmpName=(WCHAR*) malloc ((strlen(nome)+2)*sizeof(WCHAR));
	for (i=0;i<(signed)strlen(nome)+1; i++)
		TmpName[i]=nome[i];
	TmpName[i]=0;
	return TmpName;
}

void PrintDeviceList(const char* device)
{
	const WCHAR* t;
	int i=0;
	t=(WCHAR*)device;
	while (!(t[i]==0 && t[i+1]==0))
	{
		if (t[i]==0) putchar('\n');
		else putchar(t[i]);
		i++;
	}
	putchar('\n');
}

#else

void PrintDeviceList(const char* device)
{
	const char* t;
	int i=0;
	t=(char*)device;
	while (!(t[i]==0 && t[i+1]==0))
	{
		if (t[i]==0 || t[i]==' ') putchar('\n');
		else putchar(t[i]);
		i++;
	}
	putchar('\n');
}

#endif

void PrintCapBegins (char* program_name, char* device)
{
	int ii,jj;
	char dev[128];

	for(ii=0,jj=0;ii<128;ii++) 
			if (device[ii]=='\0' 
#ifndef WIN95
				&& device[ii+1]=='\0'
#endif
				) break; 
			else if (device[ii]!='\0') {dev[jj]=device[ii];jj++;}
		dev[jj]='\0';
		(void)fprintf(stderr, "%s: listening on %s\n",
		    program_name, dev);
		(void)fflush(stderr);
}
#endif
