


TCPSLICE(1)                                           TCPSLICE(1)


NNAAMMEE
       tcpslice  - extract pieces of and/or glue together tcpdump
       files

SSYYNNOOPPSSIISS
       ttccppsslliiccee [ --ddRRrrtt ] [ --ww _f_i_l_e ]
                [ _s_t_a_r_t_-_t_i_m_e [ _e_n_d_-_t_i_m_e ] ] _f_i_l_e _._._.

DDEESSCCRRIIPPTTIIOONN
       _T_c_p_s_l_i_c_e is a program for extracting portions  of  packet-
       trace  files generated using _t_c_p_d_u_m_p_(_l_)'s --ww flag.  It can
       also be used to glue together several such files, as  dis-
       cussed below.

       The  basic  operation of _t_c_p_s_l_i_c_e is to copy to _s_t_d_o_u_t all
       packets from  its  input  file(s)  whose  timestamps  fall
       within  a  given  range.  The starting and ending times of
       the range may be  specified  on  the  command  line.   All
       ranges  are  inclusive.  The starting time defaults to the
       time of the first packet in the first input file; we  call
       this  the  _f_i_r_s_t  _t_i_m_e_.   The  ending time defaults to ten
       years after the starting time.  Thus, the command _t_c_p_s_l_i_c_e
       _t_r_a_c_e_-_f_i_l_e  simply  copies  _t_r_a_c_e_-_f_i_l_e to _s_t_d_o_u_t (assuming
       the file does not include more than ten  years'  worth  of
       data).

       There are a number of ways to specify times.  The first is
       using Unix timestamps of the form  _s_s_s_s_s_s_s_s_s_._u_u_u_u_u_u  (this
       is the format specified by _t_c_p_d_u_m_p's --tttt flag).  For exam-
       ple,  665544332211009988..77665544  specifies  38  seconds  and  765,400
       microseconds after 8:51PM PDT, Sept. 25, 1990.

       All  examples  in this manual are given for PDT times, but
       when displaying times and interpreting times  symbolically
       as  discussed  below,  _t_c_p_s_l_i_c_e  uses  the local timezone,
       regardless of the timezone in which the _t_c_p_d_u_m_p  file  was
       generated.   The  daylight-savings  setting  used  is that
       which is appropriate for the local timezone at the date in
       question.   For  example,  times  associated  with  summer
       months will usually include daylight-savings effects,  and
       those with winter months will not.

       Times  may  also be specified relative to either the _f_i_r_s_t
       _t_i_m_e (when specifying a starting  time)  or  the  starting
       time  (when  specifying  an  ending  time)  by preceding a
       numeric value in seconds  with  a  `+'.   For  example,  a
       starting  time  of  ++220000  indicates  200 seconds after the
       _f_i_r_s_t _t_i_m_e_, and the two arguments ++220000 ++330000 indicate  from
       200 seconds after the _f_i_r_s_t _t_i_m_e through 500 seconds after
       the _f_i_r_s_t _t_i_m_e_.

       Times may also be specified in terms of years (y),  months
       (m),  days  (d),  hours (h), minutes (m), seconds (s), and
       microseconds(u).   For   example,   the   Unix   timestamp



                         21 December 1996                       1





TCPSLICE(1)                                           TCPSLICE(1)


       654321098.7654  discussed above could also be expressed as
       9900yy99mm2255dd2200hh5511mm3388ss776655440000uu..

       When specifying times using this style,  fields  that  are
       omitted  default  as  follows.   If the omitted field is a
       unit _g_r_e_a_t_e_r than that of the first specified field,  then
       its  value  defaults to the corresponding value taken from
       either _f_i_r_s_t _t_i_m_e (if the starting time  is  being  speci-
       fied)  or  the  starting time (if the ending time is being
       specified).  If the omitted field is a unit _l_e_s_s than that
       of  the  first  specified field, then it defaults to zero.
       For example, suppose that the input file has a _f_i_r_s_t  _t_i_m_e
       of  the  Unix  timestamp mentioned above, i.e., 38 seconds
       and 765,400 microseconds after 8:51PM PDT, Sept. 25, 1990.
       To  specify 9:36PM PDT (exactly) on the same date we could
       use 2211hh3366mm..  To specify a range from  9:36PM  PDT  through
       1:54AM PDT the next day we could use 2211hh3366mm 2266dd11hh5544mm..

       Relative  times  can  also  be  specified  when  using the
       _y_m_d_h_m_s_u format.  Omitted fields then default to 0  if  the
       unit of the field is _g_r_e_a_t_e_r than that of the first speci-
       fied field, and to  the  corresponding  value  taken  from
       either  the _f_i_r_s_t _t_i_m_e or the starting time if the omitted
       field's unit is _l_e_s_s than  that  of  the  first  specified
       field.  Given a _f_i_r_s_t _t_i_m_e of the Unix timestamp mentioned
       above, 2222hh ++11hh1100mm specifies a range from  10:00PM  PDT  on
       that  date through 11:10PM PDT, and ++11hh ++11hh1100mm specifies a
       range  from  38.7654  seconds  after  9:51PM  PDT  through
       38.7654  seconds after 11:01PM PDT.  The first hour of the
       file could be extracted using ++00 ++11hh..

       Note that with the _y_m_d_h_m_s_u format there  is  an  ambiguity
       between  using _m for `month' or for `minute'.  The ambigu-
       ity is resolved as follows: if an _m field is followed by a
       _d  field then it is interpreted as specifying months; oth-
       erwise it specifies minutes.

       If more than one input file  is  specified  then  _t_c_p_s_l_i_c_e
       first  copies  packets  lying  in the given range from the
       first file; it then increases the  starting  time  of  the
       range  to lie just beyond the timestamp of the last packet
       in the first file, repeats the  process  with  the  second
       file,  and so on.  Thus files with interleaved packets are
       _n_o_t merged.  For a given file, only packets that are newer
       than  any in the preceding files will be considered.  This
       mechanism avoids any possibility  of  a  packet  occurring
       more than once in the output.

OOPPTTIIOONNSS
       If any of --RR,, --rr or --tt are specified then _t_c_p_s_l_i_c_e reports
       the timestamps of the first and last packets in each input
       file  and  exits.   Only one of these three options may be
       specified.




                         21 December 1996                       2





TCPSLICE(1)                                           TCPSLICE(1)


       --dd     Dump the start and end times specified by the given
              range and exit.  This option is useful for checking
              that the given range actually specifies  the  times
              you think it does.  If one of --RR,, --rr or --tt has been
              specified then the times are dumped in  the  corre-
              sponding  format;  otherwise,  raw  format ( --RR) is
              used.

       --RR     Dump the timestamps of the first and  last  packets
              in  each input file as raw timestamps (i.e., in the
              form  _s_s_s_s_s_s_s_s_s_._u_u_u_u_u_u).

       --rr     Same as --RR except  the  timestamps  are  dumped  in
              human-readable  format,  similar  to  that  used by
              _d_a_t_e_(_1_).

       --tt     Same as --RR except the timestamps are dumped in _t_c_p_-
              _s_l_i_c_e format, i.e., in the _y_m_d_h_m_s_u format discussed
              above.

       --ww     Direct the output to _f_i_l_e rather than _s_t_d_o_u_t.

SSEEEE AALLSSOO
       tcpdump(l)

AAUUTTHHOORR
       Vern Paxson, of Lawrence Berkeley  Laboratory,  University
       of California, Berkeley, CA.

       The current version is available via anonymous ftp:

              _f_t_p_:_/_/_f_t_p_._e_e_._l_b_l_._g_o_v_/_t_c_p_s_l_i_c_e_._t_a_r_._Z

BBUUGGSS
       Please send bug reports to tcpslice@ee.lbl.gov.

       An input filename that beings with a digit or a `+' can be
       confused with a start/end time.   Such  filenames  can  be
       specified  with  a  leading `./'; for example, specify the
       file `04Jul76.trace' as `./04Jul76.trace'.

       _t_c_p_s_l_i_c_e cannot read its input from _s_t_d_i_n, since  it  uses
       random-access to rummage through its input files.

       _t_c_p_s_l_i_c_e  refuses to write to its output if it is a termi-
       nal (as indicated by _i_s_a_t_t_y_(_3_)).  This is not a bug but  a
       feature,  to  prevent  it from spraying binary data to the
       user's terminal.  Note that this  means  you  must  either
       redirect _s_t_d_o_u_t or specify an output file via --ww.

       _t_c_p_s_l_i_c_e  will not work properly on _t_c_p_d_u_m_p files spanning
       more than one year;  with  files  containing  portions  of
       packets  whose original length was more than 65,535 bytes;
       nor with files containing fewer than three packets.   Such



                         21 December 1996                       3





TCPSLICE(1)                                           TCPSLICE(1)


       files  result  in  the error message: `couldn't find final
       packet in file'.  These problems are due to the interpola-
       tion  scheme used by _t_c_p_s_l_i_c_e to greatly speed up its pro-
       cessing when dealing with large trace  files.   Note  that
       _t_c_p_s_l_i_c_e can efficiently extract slices from the middle of
       trace files of any size, and can also work with  truncated
       trace  files  (i.e.,  the final packet in the file is only
       partially present, typically due to _t_c_p_d_u_m_p being ungrace-
       fully killed).
















































                         21 December 1996                       4


