#include "cconvformat.h"
#include "mystring.h"

#if defined WIN32 
#ifndef _CONSOLE
#include "../win32/stdafx.h"
#endif
#endif

#ifndef ENGLISH
#define ERR_SRC "Errore nel file sorgente."
#define ERR_DST "Errore nel file destinazione."
#define ERR_AUX "Errore nel file ausiliario."
#define ERR_OPEN "Errore di apertura dei file"
#define ERR_END "Conversione terminata."
#define ERR_CONS "Numero di byte consecutivi non corretto"
#define ERR_EXCL "Numero di byte esclusi non corretto"
#define ERR_DATA "Numero di dati da processare non corretto"
#define ERR_EXCL2 "Numero di byte da escludere non corretto"
#define ERR_OPTN "Opzione non supportata"
#define ERR_INF "Problemi nell'apertura del file di ingresso"
#define ERR_EXIST "Il file esiste gi. Si intende sovrascriverlo?"
#define ERR_OUTF "Problemi nell'apertura del file di uscita"
#define ERR_PARS "Errore nei parametri"

#else
#define ERR_SRC "Error in source file."
#define ERR_DST "Errore in destination file."
#define ERR_AUX "Errore in auxiliary file."
#define ERR_OPEN "Error openind files"
#define ERR_END "Conversion finished."
#define ERR_CONS "Wrong consecutive byte number"
#define ERR_EXCL "Wrong excluded byte number"
#define ERR_DATA "Wrong data number"
#define ERR_EXCL2 "Wrong excluded byte number"
#define ERR_OPTN "Optione not supported"
#define ERR_INF "Problems opening input file"
#define ERR_EXIST "File already exists. Do you wish to overwrite it?"
#define ERR_OUTF "Problems opening output file"
#define ERR_PARS "Errors in parameters"
#endif

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif
#ifndef IDYES
#define IDYES 1
#endif
#ifndef IDNO
#define IDNO 2
#endif
#ifndef IDOK
#define IDOK 0
#endif
#ifndef IDCANCEL
#define IDCANCEL -1
#endif

#if defined WIN32 
#ifndef _CONSOLE
#define Say(a) AfxMessageBox(a)
#define Ask(Domanda) AfxMessageBox(Domanda,MB_YESNO|MB_ICONQUESTION)
#else
#define Say(a) fprintf(stderr,"%s\n",a);
inline int Ask(const char* Domanda) 
{
 char t[10];Say(Domanda);fgets(t,5,stdin); 
 if(t[0]=='s' || t[0]=='S') return IDYES;
 return IDNO;
}
#endif
#else
#define Say(a) fprintf(stderr,"%s\n",a);
inline int Ask(const char* Domanda) 
{
 char t[10];Say(Domanda);fgets(t,5,stdin); 
 if(t[0]=='s' || t[0]=='S') return IDYES;
 return IDNO;
}
#endif

CConvFormat::CConvFormat()
    {
        CopyToFile=FALSE;
        ceoln='\n';
        min='0';
        max='9';
        nexcl=4;
        InsTS=FALSE;
        InsLen=FALSE;
        InsTotLen=FALSE;
	    NByteExcl=0;
	    NByteCons=1000;
	    NByteData=200;
		StrAdd.SetSize(0);
		StrIniProd.SetSize(0);
		StrFinProd.SetSize(0);
		filein=fileout=filedisc=NULL;
    }

void CConvFormat::TryOpen()
    {
	if (filein) fclose(filein);
	if (fileout) fclose(fileout);
	if (filedisc) fclose(filedisc);
	filein=fileout=filedisc=NULL;
    if(Source[0]!='\0')
	{
	 filein=fopen(Source,"r");
     if (filein==NULL)
     {
 	  Say(ERR_SRC /*Errore nel file sorgente.*/);
	  return;
	 }
	} 
    if(Dest[0]!='\0')
	{
     fileout=fopen(Dest,"wb");
     if (filein==NULL)
     {
	  Say(ERR_DST /*Errore nel file destinazione.*/);
	  return;
	 }
	}
    if (CopyToFile)
     {
      if(FileName[0]!='\0')
	  {
       filedisc=fopen(FileName,"wb");
       if (filedisc==NULL)
	    Say(ERR_AUX /*Errore nel file ausiliario.*/);
	  }
	 } else filedisc=NULL;
	 OpenFile();
	 if(filein) fclose (filein);
	 if(fileout) fclose (fileout);
	 if (filedisc) fclose (filedisc);
	 filein=NULL;
	 fileout=NULL;
	 filedisc=NULL;
    }

void CConvFormat::OpenFile()
    {
    char c[1000];
    int temp,n_ln=0,i,nbyte;
    vector<int> array,pacchetto;

	if(filein==NULL||fileout==NULL) 
	{Say(ERR_OPEN /*Errore di apertura dei files*/);return;}
    // Inizializzazione
    pacchetto.SetSize(5000);
    nbyte=-NByteExcl;
    // Copia bytes iniziali nel file destinazione
    temp=StrIniProd.GetSize();
    for (i=0;i<temp;i++)
     fputc(StrIniProd[i],fileout);
    // Processa input fino alla fine.
    while (fgets(c,999,filein))
     {
		if(strlen(c)>(unsigned)NByteCons) c[NByteCons]='\0';
        // Vede se  una riga contenente dati da trattare
        if (c[0]<min || c[0]>max)
          {
           // Tratta i dati scartati
           if(filedisc) fputs(c,filedisc);
           n_ln++;
          }
         else
          {
            // Vede se si sta processando un pacchetto nuovo
            if (n_ln)
             {
                  n_ln=0;
                  if(nbyte>0)
                   {
                    SavePacket(pacchetto,nbyte);
                    nbyte=-NByteExcl;
                   }
             }
            int l=strlen(c);
            // Impesisce di processare oltre la fine riga
            for(i=0;i<l;i++)
             if (c[i]==ceoln) c[i]='\0';
            // Riconosce riga
            StrToHex(c+nexcl,array);
            l=array.GetSize();
            if(l>NByteData) {l=NByteData;}
            // Copia la riga nel pacchetto
            int size;
            for (i=0;i<l;i++)
             {
              //fputc(array[i],fileout);
              size=pacchetto.GetSize();
              if (nbyte>=size) pacchetto.SetSize(size+1000);
              if (nbyte+i>=0) pacchetto[nbyte+i]=array[i];
             }
            nbyte+=l;
          }
     }
    if (nbyte>0) SavePacket(pacchetto,nbyte);
    temp=StrFinProd.GetSize();
    for (i=0;i<temp;i++)
     fputc(StrFinProd[i],fileout);
    Say(ERR_END /*Conversione terminata.*/);
   }

vector<int> &CConvFormat::StrToHex(char const * s,vector<int> &dest)
    {
        int i,l=strlen(s),indice=0;
        int t,n=0;

        dest.SetSize(l);
        for (i=0;i<l;i++)
         {
          if ((s[i]>='0' && s[i]<='9') ||
              (s[i]>='a' && s[i]<='f') ||
              (s[i]>='A' && s[i]<='F'))
           continue;
          if (indice!=i)
           {sscanf(s+indice,"%x",&t);
            t &=0xFF;
            dest[n]=t;
            n++;
            }
          indice=i+1;
         }
        if ((indice<i)&&(i!=0))
           {sscanf(s+indice,"%x",&t);
            t &=0xFF;
            dest[n]=t;
            n++;
            }
        dest.SetSize(n);
        return dest;
    }

string &CConvFormat::HexToStr(vector<int>& s,string &d)
    {
        int l=s.GetSize(),y;
        d.Empty();
        char t[20];
        for(int i=0;i<l;i++)
         {
         y=s[i];
         sprintf(t,"%x ",y);
         d+=t;
         }
        return d;
    }

void CConvFormat::SavePacket(vector<int> &pacchetto,int nbyte)
    {
        int temp,i,w=0;
                  // Aggiunge la dimensione (se richiesto)
                  temp=StrAdd.GetSize();
                  int lp= nbyte+temp;
                  // Aggiunge il timestamp (se richiesto)
                  if (InsTS)
                   {
                    fwrite(&w,4,1,fileout);
                    fwrite(&w,4,1,fileout);
                   }
                  if (InsLen)
                   {
                    fwrite(&lp,4,1,fileout);
                   }
                  // Aggiunge la dimensione totale (se richiesto)
                  if (InsTotLen)
                   {
                    fwrite(&lp,4,1,fileout);
                   }
                  // Aggiunge la stringa iniziale per ogni pacchetto
                  for (i=0;i<temp;i++)
                   fputc(StrAdd[i],fileout);
                  // Salva il pacchetto
                  for (i=0;i<lp-temp;i++)
                   fputc(pacchetto[i],fileout);
    }

int CConvFormat::ProcessCommandLine(int argc, char * * argv)
{
	int i,l,ll,sd=0;
	char* c,*t;
	if (filein) fclose(filein);
	if (fileout) fclose(fileout);
	if (filedisc) fclose(filedisc);
	filein=fileout=filedisc=NULL;
	for(i=1;i<argc;i++)
	{
		if(argv[i][0]=='\0') continue;
		if(argv[i][0]=='-')
		{
			t=argv[i]+1;
			l=strlen(t);
			for (ll=0;ll<l;ll++)
				if(t[ll]==':' || t[ll]=='=')
				{strmin(t);t[ll]='\0';c=t+ll+1;break;}
			//elaborazione opzioni
			if(strcmp(t,"h")==0) {help();return IDCANCEL;}
			else if(strcmp(t,"i")==0) {min=c[0];}
			else if(strcmp(t,"f")==0) {max=c[0];}
			else if(strcmp(t,"eoln")==0) {ceoln=c[0];}
			else if(strcmp(t,"nc")==0) 
					{
						ll=sscanf(c,"%d",&NByteCons);
						if(NByteCons<1||NByteCons>1000||ll==0) 
							{
								NByteCons=1000;
								Say(ERR_CONS /*Numero di byte consecutivi non corretto*/);
							}
					}
			else if(strcmp(t,"ne")==0) 
					{
						ll=sscanf(c,"%d",&nexcl);
						if(nexcl<0||nexcl>998||ll==0) 
							{
								nexcl=0;
								Say(ERR_EXCL /*Numero di byte esclusi non corretto*/);
							}
					}
			else if(strcmp(t,"np")==0) 
					{
						ll=sscanf(c,"%d",&NByteData);
						if(NByteData<1||NByteData>200||ll==0) 
							{
								NByteData=200;
								Say(ERR_DATA /*Numero di dati da processare non corretto*/);
							}
					}
			else if(strcmp(t,"be")==0) 
					{
						ll=sscanf(c,"%d",&NByteExcl);
						if(NByteExcl<0||ll==0) 
							{
								NByteExcl=1000;
								Say(ERR_EXCL2 /*Numero di byte da escludere non corretto*/);
							}
					}
			else if(strcmp(t,"stradd")==0) 
					{
						StrToHex(c,StrAdd);
					}
			else if(strcmp(t,"strini")==0) 
					{
						StrToHex(c,StrIniProd);
					}
			else if(strcmp(t,"strfin")==0) 
					{
						StrToHex(c,StrFinProd);
					}
			else if(strcmp(t,"ts")==0) {InsTS=TRUE;}
			else if(strcmp(t,"lp")==0) {InsLen=TRUE;}
			else if(strcmp(t,"lt")==0) {InsTotLen=TRUE;}

			else Say(ERR_OPTN /*Opzione non supportata*/); 
		}
		else
			if(sd==0)
			{
				filein=fopen(argv[i],"r");
				if (filein==NULL) 
				{
					Say(ERR_INF /*Problemi nell'apertura del file di ingresso*/);
					goto problemi;
				}
				else {Source=argv[i];sd++;}
			}
			else if(sd==1)
			{
				fileout=fopen(argv[i],"r");
				if (fileout!=NULL) 
					if(Ask(ERR_EXIST /*Il file esiste gi. Si intende sovrascriverlo?*/)==IDNO) return IDCANCEL;
				fileout=fopen(argv[i],"wb");
				if (fileout==NULL) 
					{Say(ERR_OUTF /*Problemi nell'apertura del file di uscita*/);goto problemi;}
				else {Dest=argv[i];sd++;}
			}
			else if(sd==2)
			{
				filedisc=fopen(argv[i],"r");
				if (filedisc!=NULL) 
					if(Ask(ERR_EXIST /*Il file esiste gi. Si intende sovrascriverlo?*/)==IDNO) return IDCANCEL;
				filedisc=fopen(argv[i],"wb");
				if (filedisc==NULL) 
					{Say(ERR_OUTF /*Problemi nell'apertura del file di uscita*/);goto problemi;}
				else {FileName=argv[i];sd++;}
			}
			else if(sd>=3) {Say(ERR_PARS /*Errore nei parametri*/);goto problemi;}
	}
	if(FileName[0]!='\0') CopyToFile=TRUE;
	if(sd==2) CopyToFile=FALSE;
	return IDOK;
	problemi:
	if(filein) fclose(filein);
	if(fileout) fclose(fileout);
	if(filedisc) fclose(filedisc);
	Source="";
	Dest="";
	FileName="";
	return IDCANCEL;
}

#ifdef WIN32
#ifndef _CONSOLE
#define CRLF "\r\n"
#ifndef ENGLISH
#define PRINTHELP(A) AfxMessageBox(A\
			"Nota: Nella versione con interfaccia grafica le opzioni della\r\n"\
			"linea di comando impostano solamente i parametri.\r\n"\
			"La conversione deve essere comandata esplicitamente.\r\n")
#else
#define PRINTHELP(A) AfxMessageBox(A\
			"Note: In graphic interface command line options set only paramerters\r\n"\
			"Conversion must be explicitly commanded.\r\n")
#endif
#else
#define PRINTHELP(A) printf(A)
#define CRLF "\n"
#endif
#else
#define PRINTHELP(A) printf(A)
#define CRLF "\n"
#endif


void CConvFormat::help()
{
#ifndef ENGLISH
	PRINTHELP(
			"La linea di comando di ConvDump :" 
			CRLF
			"	ConvDump [opzioni] filein fileout [filedisc]"
			CRLF
			"dove:"
			CRLF
			"	filein  il file di dump aperto"
			CRLF
			"	fileout  il file che verr generato"
			CRLF
			"	filedisc  il file che ospiter i dati non interpretati"
			CRLF
			"le opzioni sono tutte nel formato:"
			CRLF
			"	{-}NomeOpzione{:|=}"
			CRLF
			"esse sono:"
			CRLF
			"	-h...........Visualizza questo messaggio."
			CRLF
			"	-i:c.........Imposta il car. minimo iniziante una riga di dati a 'c'"
			CRLF
			"	-f:c.........Imposta il car. massimo iniziante una riga di dati a 'c'"
			CRLF
			"	-eoln:c......Imposta il carattere di fine riga a 'c'"
			CRLF
			"	-nc:n........Imposta il numero di caratteri per riga ad 'n'"
			CRLF
			"	-ne:n........Imposta il numero di caratteri esclusi per riga ad 'n'"
			CRLF
			"	-np:n........Imposta il numero di caratteri processati per riga ad 'n'"
			CRLF
			"	-be:n........Imposta il numero di byte esclusi da quelli processati"
			CRLF
			"	-stradd:s....Imposta la stringa da aggiungere ad 's'"
			CRLF
			"	-strini:s....Imposta la stringa iniziale da aggiungere ad 's'"
			CRLF
			"	-strfin:s....Imposta la stringa finale da aggiungere ad 's'"
			CRLF
			"	-ts..........Aggiunge il timestamp del pacchetto nel file prodotto"
			CRLF
			"	-lp..........Aggiunge la lunghezza del pacchetto nel file prodotto"
			CRLF
			"	-lt..........Aggiunge la lunghezza tot del pacch. nel file prodotto"
			CRLF
			"E' importante che tra il nome dell'opzione ed il suo valore sia presente"
			CRLF
			"il carattere ':' o '='. Non ci devono essere spazi."
			CRLF
			"Le stringhe devono usare un carattere di separazione tra i dati diverso "
			CRLF
			"dallo spazio. I valori di default sono:"
			CRLF
			"filedisc (non considerato) - i='0' - f='9' - eoln='\\n' - nc=1000 - ne=4"
			CRLF
			"lp (non considerato) - lt (non considerato) - id=\"\" -stradd=\"\""
			CRLF
			"strini=\"\" - strfin=\"\" - np=200 - be=0"
			CRLF
			"Esempi:"
			CRLF
			"	ConvDump -h"
			CRLF
			"		Visualizza questa schermata"
			CRLF
			"	ConvDump -f:0 -ne:10 -np:16 samples/bootsect.dmp bootsect.bin"
			CRLF
			"		Genera un bootsector a partire dal suo dump esadecimale."
			CRLF
			);
#else
	PRINTHELP(
			"ConvDump command line is:" 
			CRLF
			"	ConvDump [options] infile outfile [discfile]"
			CRLF
			"where:"
			CRLF
			"	infile is the input dump file"
			CRLF
			"	outfile is the output file"
			CRLF
			"	discfile is the file where not interpreted data will be written"
			CRLF
			"options are in the following format:"
			CRLF
			"	{-}OptionName{:|=}"
			CRLF
			"they are:"
			CRLF
			"	-h...........Shows this message."
			CRLF
			"	-i:c.........Sets minimum character beginning a line to 'c'"
			CRLF
			"	-f:c.........Sets maximum character beginning a line to 'c'"
			CRLF
			"	-eoln:c......Sets end of line character to 'c'"
			CRLF
			"	-nc:n........Sets character number for any line to 'n'"
			CRLF
			"	-ne:n........Sets excluded character number for any line to 'n'"
			CRLF
			"	-np:n........Sets processed character number for any line to 'n'"
			CRLF
			"	-be:n........Sets excluded byne number for any line to 'n'"
			CRLF
			"	-stradd:s....Sets adding string for any packet to 's'"
			CRLF
			"	-strini:s....Sets initial adding string for output file to 's'"
			CRLF
			"	-strfin:s....Sets final adding string for output file to 's'"
			CRLF
			"	-ts..........Adds timestamp to any packet"
			CRLF
			"	-lp..........Adds packet length"
			CRLF
			"	-lt..........Adds total packet length"
			CRLF
			"From option name and option value a character of ':' or '=' must be present."
			CRLF
			"No spaces are allowed."
			CRLF
			"Strings must have a separator character different from space."
			CRLF
			"Default values are:"
			CRLF
			"discdisc (not considered) - i='0' - f='9' - eoln='\\n' - nc=1000 - ne=4"
			CRLF
			"lp (not considered) - lt (not considered) - id=\"\" -stradd=\"\""
			CRLF
			"strini=\"\" - strfin=\"\" - np=200 - be=0"
			CRLF
			"Examples:"
			CRLF
			"	ConvDump -h"
			CRLF
			"		Shows this message"
			CRLF
			"	ConvDump -f:0 -ne:10 -np:16 samples/bootsect.dmp bootsect.bin"
			CRLF
			"		Generate a bootsector from is exadecimal dump."
			CRLF
			);
#endif
}
