//
// ConvDump.cpp
//
// Copyright (c) Viano Piero, 1998. All Rights Reserved.
//

#include "stdafx.h"
#include "ConvDump.h"
#include "maindlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#ifndef ENGLISH
#define SEL_FILE "Selezione file"
#define EXT_FILE "Files Dump (*.dmp)"
#define ALL_FILE "Tutti i file (*.*)"
#else
#define SEL_FILE "File selection"
#define EXT_FILE "Dump files(*.dmp)"
#define ALL_FILE "Any file (*.*)"
#endif

CConvDumpApp theApp;

BOOL CConvDumpApp::InitInstance()
{

#if (_MFC_VER >= 0x0300)
	Enable3dControls();
#else
	EnableVBX();
	SetDialogBkColor();
#endif

	int i,l,n=1;
	l=strlen(m_lpCmdLine);
	for(i=0;i<l;i++)
		if(m_lpCmdLine[i]==' ' || m_lpCmdLine[i]=='\t') n++;
	argv=new char*[n+1];
	if(l==0) {n=1;argc=1;}
	else argc=n+1;
	n=2;
	argv[0]="convdump";
	argv[1]=m_lpCmdLine;
	for(i=0;i<l;i++)
		if(m_lpCmdLine[i]==' ' || m_lpCmdLine[i]=='\t') 
		{
		  argv[n]=m_lpCmdLine+i+1;
		  m_lpCmdLine[i]='\0';
		  n++;
		}
		

	TCHAR dir[MAX_PATH*2];
	i=GetCurrentDirectory(sizeof(dir)/sizeof(TCHAR),dir);
	if (i) 
	{
		dir[i]='\0';
		if (dir[i]!='\\') {dir[i]='\\';dir[i+1]='\0';}
		 else dir [i]='\0';
		//AfxMessageBox(dir);
		Path.Format("%s",dir);
	}
    else Path="";

	m_pMainWnd = new CMainDialog();

	m_pMainWnd->ShowWindow(m_nCmdShow);
	return TRUE;
}

// VBX handling
//{{AFX_VBX_REGISTER_MAP()
//}}AFX_VBX_REGISTER_MAP


CConvDumpApp::~CConvDumpApp()
{
	if(argv) delete []argv;
}

BOOL CConvDumpApp::Browse(CString &FileName)
   {
	CFileDialog dlgFile(TRUE);

	CString title=SEL_FILE /*Selezione file*/;
	CString fileName;
    UINT nIDSTitle=AFX_IDS_OPENFILE;
    DWORD lFlags=OFN_HIDEREADONLY;
    BOOL bOpenFileDialog=TRUE;

	dlgFile.m_ofn.Flags |= lFlags;

	CString strFilter=EXT_FILE /*Files Dump (*.dmp)*/;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.dmp");
	strFilter += (TCHAR)'\0';   // last string
	CString strDefault;
	// append the "*.*" all files filter
	strFilter +=ALL_FILE /*Tutti i file (*.*)*/;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.*");
	strFilter += (TCHAR)'\0';   // last string
	dlgFile.m_ofn.nMaxCustFilter++;

	dlgFile.m_ofn.lpstrFilter = strFilter;
	dlgFile.m_ofn.lpstrTitle = title;
	dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	BOOL bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	fileName.ReleaseBuffer();
    if (bResult)
     {
        FileName=fileName;return TRUE;
     }
    return FALSE;
  }
