// CAdvDialog.cpp : implementation file
//

#include "stdafx.h"
#include "ConvDump.h"

#include "CAdvDialog.h"
#include <stdio.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#ifndef ENGLISH
#define ERR_FILE "Il file specificato non  valido"
#define ST_FILE "Carica Stato"
#define ST1_FILE "Files di Stato (*.cds)"
#define ALL_FILE "Tutti i File (*.*)"
#define SAVE_STATE "Salva Stato"
#define ANY_FILE "Tutti i File (*.*)"
#else
#define ERR_FILE "Invalid file"
#define ST_FILE "Status loading"
#define ST1_FILE "Status Files (*.cds)"
#define ALL_FILE "Any File (*.*)"
#define SAVE_STATE "Status Saving"
#define ANY_FILE "Any File (*.*)"
#endif

/////////////////////////////////////////////////////////////////////////////
// CAdvDialog

BEGIN_MESSAGE_MAP(CAdvDialog, CDialog)
	//{{AFX_MSG_MAP(CAdvDialog)
	ON_BN_CLICKED(IDC_RADIO1,OnClickedRadio1)
	ON_BN_CLICKED(IDC_RADIO2,OnClickedRadio2)
	ON_BN_CLICKED(IDC_BUTTON2,OnClickedButton2)
	ON_BN_CLICKED(IDC_LOADSTATE,OnClickedLoadstate)
	ON_BN_CLICKED(IDC_SAVESTATE,OnClickedSavestate)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP();

CAdvDialog::CAdvDialog(CWnd* pParent)
    : CDialog((unsigned)CAdvDialog::IDD, pParent)
{
    //{{AFX_DATA_INIT(CAdvDialog)
	min		 = "";
	max		 = "";
	nexcl		 = 0;
	ncons		 = 200;
	ceoln		 = "";
	FileName		 = "";
	StrAdd		 = "";
	StrIniProd		 = "";
	StrFinProd		 = "";
	NByteExcl		 = 0;
	NByteCons		 = 0;
	//}}AFX_DATA_INIT
}

void CAdvDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CAdvDialog)
	DDX_Text(pDX, IDC_EDIT1, min);
	DDV_MaxChars(pDX, min, 1);
	DDX_Text(pDX, IDC_EDIT2, max);
	DDV_MaxChars(pDX, max, 1);
	DDX_Text(pDX, IDC_EDIT3, nexcl);
	DDV_MinMaxInt(pDX, nexcl, 0, 998);
	DDX_Text(pDX, IDC_EDIT11, ncons);
	DDV_MinMaxInt(pDX, ncons, 1, 200);
	DDX_Text(pDX, IDC_EDIT4, ceoln);
	DDV_MaxChars(pDX, ceoln, 1);
	DDX_Text(pDX, IDC_EDIT5, FileName);
	DDX_Text(pDX, IDC_EDIT6, StrAdd);
	DDX_Text(pDX, IDC_EDIT7, StrIniProd);
	DDX_Text(pDX, IDC_EDIT8, StrFinProd);
	DDX_Text(pDX, IDC_EDIT9, NByteExcl);
	DDV_MinMaxInt(pDX, NByteExcl, 0, 1000000);
	DDX_Text(pDX, IDC_EDIT12, NByteCons);
	DDV_MinMaxInt(pDX, NByteCons, 1, 1000);
	//}}AFX_DATA_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CAdvDialog message handlers


BOOL CAdvDialog::OnInitDialog()
{
    CDialog::OnInitDialog();

    SaveState = FALSE;
    CButton * b1=(CButton*) GetDlgItem(IDC_RADIO1);
    CButton * b2=(CButton*) GetDlgItem(IDC_RADIO2);
    CButton * b3;
    CEdit * e1=(CEdit *) GetDlgItem(IDC_EDIT5);
    if (ToFile)
     {
        b2->SetCheck(TRUE);
        e1->SetReadOnly(FALSE);
     }
     else
      {
        b1->SetCheck(TRUE);
        e1->SetReadOnly(TRUE);
      }
    b1=(CButton*) GetDlgItem(IDC_CHECK1);
    b2=(CButton*) GetDlgItem(IDC_CHECK2);
    b3=(CButton*) GetDlgItem(IDC_CHECK3);
    if (f->InsLen) b1->SetCheck(TRUE);
    if (f->InsTotLen) b2->SetCheck(TRUE);
    if (f->InsTS) b3->SetCheck(TRUE);
    return TRUE;  // return TRUE unless you set the focus to a control
}


void CAdvDialog::OnOK()
{
    CButton * b2=(CButton*) GetDlgItem(IDC_RADIO2);
    ToFile=b2->GetCheck();
    b2=(CButton*) GetDlgItem(IDC_CHECK1);
    f->InsLen= b2->GetCheck();
    b2=(CButton*) GetDlgItem(IDC_CHECK2);
    f->InsTotLen = b2->GetCheck();
    b2=(CButton*) GetDlgItem(IDC_CHECK3);
    f->InsTS = b2->GetCheck();
    if(ToFile)
    {
     FILE *f;
     CEdit * e1=(CEdit *) GetDlgItem(IDC_EDIT5);
     e1->GetWindowText(FileName);
     f=fopen(FileName,"wb");
     if (f) fclose(f);
      else
      {
        AfxMessageBox(ERR_FILE /*Il file specificato non  valido*/);
        SaveState=FALSE;
        return;
      }
    }
    CDialog::OnOK();
}


void CAdvDialog::OnClickedRadio1()
{
    CButton * b1=(CButton*) GetDlgItem(IDC_RADIO1);
    CEdit * e1=(CEdit *) GetDlgItem(IDC_EDIT5);
    if (b1->GetCheck()) e1->SetReadOnly(TRUE);
     else e1->SetReadOnly(FALSE);
}


void CAdvDialog::OnClickedRadio2()
{
    CButton * b1=(CButton*) GetDlgItem(IDC_RADIO1);
    CEdit * e1=(CEdit *) GetDlgItem(IDC_EDIT5);
    if (b1->GetCheck()) e1->SetReadOnly(TRUE);
     else e1->SetReadOnly(FALSE);
}


void CAdvDialog::OnClickedButton2()
{
    CButton * b1=(CButton*) GetDlgItem(IDC_RADIO1);
    if(b1->GetCheck()) return;
    CEdit * e1=(CEdit *) GetDlgItem(IDC_EDIT5);
    if(((CConvDumpApp*)AfxGetApp())->Browse(FileName))
      e1->SetWindowText(FileName);
}


void CAdvDialog::OnClickedLoadstate()
{
	CFileDialog dlgFile(TRUE);

	CString title=ST_FILE /*Carica Stato*/;
	CString fileName;
    DWORD lFlags=OFN_HIDEREADONLY | OFN_FILEMUSTEXIST;

	dlgFile.m_ofn.Flags |= lFlags;

	CString strFilter=ST1_FILE /*Files di Stato (*.cds)*/;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.cds");
	strFilter += (TCHAR)'\0';   // last string
	strFilter += _T(ALL_FILE /*Tutti i File (*.*)*/);;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.*");
	strFilter += (TCHAR)'\0';   // last string
	dlgFile.m_ofn.nMaxCustFilter++;

	dlgFile.m_ofn.lpstrFilter = strFilter;
	dlgFile.m_ofn.lpstrTitle = title;
	dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	BOOL bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	fileName.ReleaseBuffer();
    if (bResult)
     {
      StateFile=fileName;
      CDialog::EndDialog(IDC_LOADSTATE);
     }
}


void CAdvDialog::OnClickedSavestate()
{
	CFileDialog dlgFile(FALSE);

	CString title=SAVE_STATE /*Salva Stato*/;
	CString fileName;
    DWORD lFlags=OFN_HIDEREADONLY ;//| OFN_FILEMUSTEXIST;
    BOOL bOpenFileDialog=FALSE;

	dlgFile.m_ofn.Flags |= lFlags;

	CString strFilter=ST1_FILE /*Files di Stato (*.cds)*/;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.cds");
	strFilter += (TCHAR)'\0';   // last string
	strFilter += _T(ANY_FILE /*Tutti i File (*.*)*/);;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.*");
	strFilter += (TCHAR)'\0';   // last string
	dlgFile.m_ofn.nMaxCustFilter++;

	dlgFile.m_ofn.lpstrFilter = strFilter;
	dlgFile.m_ofn.lpstrTitle = title;
	dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	BOOL bResult = dlgFile.DoModal() == IDOK ? TRUE : FALSE;
	fileName.ReleaseBuffer();
    if (bResult)
     {
      StateFile = fileName;
      SaveState=TRUE;
      OnOK();
      //CFile f(fileName,CFile::modeCreate | CFile::modeWrite);
      //CArchive ar( &f, CArchive::store);
     }
}

