//
// maindlg.cpp
//
// Copyright (c) Viano Piero, 1998. All Rights Reserved.
//

#include "stdafx.h"
#include "ConvDump.h"
#include "maindlg.h"
#include "aboutdlg.h"
#include "cadvdialog.h"
#include "htmlhelp.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#ifndef ENGLISH
#define ERR_SAVE "Problemi durante il salvataggio"
#define ERR_LOAD "Errore di lettura"
#define ERR_RD "Problemi durante la lettura"
#else
#define ERR_SAVE "Problems while saving"
#define ERR_LOAD "Read Error"
#define ERR_RD "Problems while reading"
#endif

// This is a specially modified modeless dialog box application class

//
// class CMainDialog
//

CMainDialog::CMainDialog(CWnd* pParent /*=NULL*/)

	: CDialog(CMainDialog::IDD, pParent)

{
	//{{AFX_DATA_INIT(CMainDialog)
	//}}AFX_DATA_INIT

	Create(CMainDialog::IDD, pParent);
}

void CMainDialog::PostNcDestroy()
{
	delete this;
}

void CMainDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMainDialog)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMainDialog, CDialog)
	//{{AFX_MSG_MAP(CMainDialog)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_ABOUT, OnClickedAbout)
	ON_BN_CLICKED(IDC_ADVANCED,OnClickedAdvanced)
	ON_BN_CLICKED(IDC_BUTTON1,OnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2,OnClickedButton2)
	ON_BN_CLICKED(IDC_CONVERT,OnClickedConvert)
	ON_BN_CLICKED(IDC_BUTTON3,OnClickedHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//
// CMainDialog commands
//


BOOL CMainDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	HICON i=AfxGetApp()->LoadIcon(IDI_ICON1);
	SetIcon(i, TRUE);

    CString t="default.cds";
	int n=((CConvDumpApp*)AfxGetApp())->argc;
    if(n==1) LoadState (t,FALSE);
	else 
	{
		n=convformat.ProcessCommandLine(
				n,((CConvDumpApp*)AfxGetApp())->argv);
		if(n==IDCANCEL) LoadState (t,FALSE);
		CEdit * e1=(CEdit *) GetDlgItem(IDC_EDIT1);
        e1->SetWindowText(convformat.Source);
        e1=(CEdit *) GetDlgItem(IDC_EDIT2);
        e1->SetWindowText(convformat.Dest);
	}

	return TRUE;
}

void CMainDialog::OnDestroy()
{
	CDialog::OnDestroy();

	::PostQuitMessage(0);
}

void CMainDialog::OnOK()
{
	CDialog::OnOK();

	// Do not delete this call, the app needs to be destroyed
	DestroyWindow();
}

void CMainDialog::OnCancel()
{
	// Do not delete this call, the app needs to be destroyed
	DestroyWindow();
}

void CMainDialog::OnClickedAbout()
{
	CAboutDlg	about;

	about.DoModal();
}

void CMainDialog::OnClickedAdvanced()
{
  CAdvDialog d;
  int h;
  do
  {
   d.f=&convformat;
   d.min=convformat.min;
   d.max=convformat.max;
   d.nexcl=convformat.nexcl;
   d.ncons=convformat.NByteData;
   if (convformat.ceoln!='\r' && convformat.ceoln!='\n')
     d.ceoln=convformat.ceoln;
      else
     d.ceoln="";
   d.FileName=convformat.FileName;
   d.ToFile=convformat.CopyToFile;
   string s;
   convformat.HexToStr(convformat.StrAdd,s);
   d.StrAdd=s;
   convformat.HexToStr(convformat.StrIniProd,s);
   d.StrIniProd=s;
   convformat.HexToStr(convformat.StrFinProd,s);
   d.StrFinProd=s;
   d.NByteExcl=convformat.NByteExcl;
   d.NByteCons=convformat.NByteCons;
   h=d.DoModal();
   if (h==IDOK)
   {
    if (d.min.GetLength()) convformat.min=d.min[0];
     else convformat.min='0';
    if (d.max.GetLength()) convformat.max=d.max[0];
     else convformat.max='9';
    convformat.nexcl=d.nexcl;
    if (d.ceoln.GetLength()) convformat.ceoln=d.ceoln[0];
     else convformat.ceoln='\r';
    convformat.FileName=(const char*)_T((LPCTSTR)d.FileName);
    convformat.CopyToFile=d.ToFile;
    convformat.StrToHex((LPCTSTR)d.StrAdd,convformat.StrAdd);
    convformat.StrToHex((LPCTSTR)d.StrIniProd,convformat.StrIniProd);
    convformat.StrToHex((LPCTSTR)d.StrFinProd,convformat.StrFinProd);
    convformat.NByteExcl=d.NByteExcl;
    convformat.NByteCons=d.NByteCons;
    convformat.NByteData=d.ncons;
    if (d.SaveState)
     {
        SaveState(d.StateFile);
     }
   }
   if (h==IDC_LOADSTATE)
    {
        LoadState(d.StateFile);
    }
  } while (h==IDC_LOADSTATE);
}


void CMainDialog::OnClickedButton1()
{
    CString FileName;
    CEdit * e1=(CEdit *) GetDlgItem(IDC_EDIT1);
    if(((CConvDumpApp*)AfxGetApp())->Browse(FileName))
      e1->SetWindowText(FileName);
}


void CMainDialog::OnClickedButton2()
{
    CString FileName;
    CEdit * e1=(CEdit *) GetDlgItem(IDC_EDIT2);
    if(((CConvDumpApp*)AfxGetApp())->Browse(FileName))
      e1->SetWindowText(FileName);
}


void CMainDialog::OnClickedConvert()
{
	CString s,d;
    CEdit * e1=(CEdit *) GetDlgItem(IDC_EDIT1);
      e1->GetWindowText(s);
	convformat.Source=(LPCTSTR)s;
    e1=(CEdit *) GetDlgItem(IDC_EDIT2);
      e1->GetWindowText(d);
	convformat.Dest=(LPCTSTR)d;
    convformat.TryOpen();
}


void CMainDialog::SaveState(CString &StateFile,BOOL err)
    {
      char t[10];
      CString str;
      try
       {
        CFile f(StateFile,CFile::modeCreate | CFile::modeWrite);
        CArchive ar( &f, CArchive::store);
        CEdit * e1=(CEdit *) GetDlgItem(IDC_EDIT1);
        e1->GetWindowText(str);
		convformat.Source=(LPCTSTR)str;
        ar.WriteString(str+"\r\n");
        e1=(CEdit *) GetDlgItem(IDC_EDIT2);
        e1->GetWindowText(str);
		convformat.Dest=(LPCTSTR)str;
        ar.WriteString(str+"\r\n");
        if (convformat.CopyToFile==TRUE)
          ar.WriteString(convformat.FileName+"\r\n");
         else
          ar.WriteString("\r\n");
        sprintf(t,"%d\r\n",convformat.NByteExcl);
        ar.WriteString(t);
		string st;
		str=convformat.HexToStr(convformat.StrAdd,st);
        ar.WriteString(str+"\r\n");
		str=convformat.HexToStr(convformat.StrIniProd,st);
        ar.WriteString(str+"\r\n");
		str=convformat.HexToStr(convformat.StrFinProd,st);
        ar.WriteString(str+"\r\n");
        if (convformat.ceoln!='\r' && convformat.ceoln!='\n')
          sprintf(t,"%c\r\n",convformat.ceoln);
         else sprintf(t,"\r\n");
        ar.WriteString(t);
        sprintf(t,"%c\r\n",convformat.min);
        ar.WriteString(t);
        sprintf(t,"%c\r\n",convformat.max);
        ar.WriteString(t);
        sprintf(t,"%d\r\n",convformat.nexcl);
        ar.WriteString(t);
        if(convformat.InsTS)
          ar.WriteString("TRUE\r\n");
         else
          ar.WriteString("FALSE\r\n");
        if(convformat.InsLen)
          ar.WriteString("TRUE\r\n");
         else
          ar.WriteString("FALSE\r\n");
        if(convformat.InsTotLen)
          ar.WriteString("TRUE\r\n");
         else
          ar.WriteString("FALSE\r\n");
        sprintf(t,"%d\r\n",convformat.NByteData);
        ar.WriteString(t);
        sprintf(t,"%d\r\n",convformat.NByteCons);
        ar.WriteString(t);
       } catch (CFileException)
          {if(err)AfxMessageBox(ERR_SAVE /*Problemi durante il salvataggio*/);}
    }

void CMainDialog::LoadState(CString &StateFile,BOOL err)
    {
      char const * t;
      CString str;
      try
       {
        FILE* tt=fopen((LPCTSTR)StateFile,"r");
        if(tt==NULL)
         {if (err) AfxMessageBox(ERR_LOAD /*Errore di lettura*/);return;}
          else fclose(tt);
        CFile f(StateFile,CFile::modeRead);
        CArchive ar( &f, CArchive::load);
        CEdit * e1=(CEdit *) GetDlgItem(IDC_EDIT1);
        ar.ReadString(str);
		convformat.Source=(LPCTSTR)str;
        e1->SetWindowText(convformat.Source);
        e1=(CEdit *) GetDlgItem(IDC_EDIT2);
        ar.ReadString(str);
		convformat.Dest=(LPCTSTR)str;
        e1->SetWindowText(str);
        ar.ReadString(str);
		convformat.FileName=(LPCTSTR)str;
        if (str=="") convformat.CopyToFile=FALSE;
         else convformat.CopyToFile=TRUE;
        ar.ReadString(str);
        t=(LPCTSTR) str;
        sscanf(t,"%d",&convformat.NByteExcl);
        ar.ReadString(str);
        convformat.StrToHex((LPCTSTR)str,convformat.StrAdd);
        ar.ReadString(str);
        convformat.StrToHex((LPCTSTR)str,convformat.StrIniProd);
        ar.ReadString(str);
        convformat.StrToHex((LPCTSTR)str,convformat.StrFinProd);
        ar.ReadString(str);
        if (str.GetLength()==0) convformat.ceoln= '\r';
         else convformat.ceoln=str[0];
        ar.ReadString(str);
        t=(LPCTSTR) str;
        sscanf(t,"%c",&convformat.min);
        ar.ReadString(str);
        t=(LPCTSTR) str;
        sscanf(t,"%c",&convformat.max);
        ar.ReadString(str);
        t=(LPCTSTR) str;
        sscanf(t,"%d",&convformat.nexcl);
        ar.ReadString(str);
        if(str=="TRUE")
         convformat.InsTS=TRUE; else convformat.InsTS=FALSE;
        ar.ReadString(str);
        if(str=="TRUE")
         convformat.InsLen=TRUE; else convformat.InsLen=FALSE;
        ar.ReadString(str);
        if(str=="TRUE")
         convformat.InsTotLen=TRUE; else convformat.InsTotLen=FALSE;
        ar.ReadString(str);
        t=(LPCTSTR) str;
        sscanf(t,"%d",&convformat.NByteData);
        ar.ReadString(str);
        t=(LPCTSTR) str;
        sscanf(t,"%d",&convformat.NByteCons);
       } catch (CFileException)
          {if (err) AfxMessageBox(ERR_RD /*Problemi durante la lettura*/);}
    }

void CMainDialog::OnClickedHelp()
{
    /*STARTUPINFO si;
    PROCESS_INFORMATION pip;
    ZeroMemory(&si,sizeof(si));
    si.cb=sizeof(si);
    BOOL b;
    char directory[1000],t1[1000];
    GetWindowsDirectory(t1,1000);
    if(t1[strlen(t1)-1]=='\\') t1[strlen(t1)-1]='\0';
    strcpy(t1+strlen(t1),"\\hh.exe");
	CString *Path=&(((CConvDumpApp*)AfxGetApp())->Path);
	(*Path)="hh" + (*Path);
    b=CreateProcess(t1,(char*)(LPCTSTR)((*Path)+" convdump.chm::/Utility/ConvDump/cdintro.htm"),NULL,NULL,
                    FALSE,0,NULL,
                    directory,&si,&pip);*/
    ::HtmlHelp(this->m_hWnd,(((CConvDumpApp*)AfxGetApp())->Path)+"convdump.chm",0, 0);
}

