#ifndef __PACKET32
#define __PACKET32

#include "ntddpack.h"

#define        DOSNAMEPREFIX   TEXT("Packet_")
#define        MAX_LINK_NAME_LENGTH   64
#define        NMAX_PACKET 65535  

typedef struct _ADAPTER  { 
						   HANDLE hFile;
                           TCHAR  SymbolicLink[MAX_LINK_NAME_LENGTH];
						 }  ADAPTER, *LPADAPTER;

typedef struct _PACKET {  
						 // HANDLE       hEvent;
                          OVERLAPPED   OverLapped;
                          PVOID        Buffer;
                          UINT         Length;
                          PVOID        Next;
						  UINT         ulBytesReceived;
						  BOOLEAN      bIoComplete;
						}  PACKET, *LPPACKET;

#ifdef __cplusplus
extern "C" {
#endif

LPADAPTER PacketOpenAdapter(LPTSTR AdapterName);
BOOLEAN PacketSendPacket(LPADAPTER AdapterObject,LPPACKET pPacket,BOOLEAN Sync);
LPPACKET PacketAllocatePacket(void);
LPPACKET PacketAllocateNPacket(UINT n);
VOID PacketInitPacket(LPPACKET lpPacket,PVOID  Buffer,UINT  Length);
VOID PacketFreePacket(LPPACKET lpPacket);
BOOLEAN PacketResetAdapter(LPADAPTER AdapterObject);
BOOLEAN PacketWaitPacket(LPADAPTER AdapterObject,LPPACKET lpPacket);
BOOLEAN PacketReceiveNPacket(LPADAPTER AdapterObject,LPPACKET headLPacket,UINT n,UINT length,BYTE* buffer,BOOLEAN Sync);
BOOLEAN PacketReceivePacket(LPADAPTER AdapterObject,LPPACKET lpPacket,BOOLEAN Sync);
VOID PacketCloseAdapter(LPADAPTER lpAdapter);
BOOLEAN PacketSetFilter(LPADAPTER AdapterObject,ULONG Filter);
ULONG PacketGetAdapterNames(PTSTR pStr,PULONG  BufferSize);
BOOLEAN PacketRequest(LPADAPTER  AdapterObject,BOOLEAN Set,PPACKET_OID_DATA  OidData);
VOID PacketSetNextPacket(LPPACKET lpPacket, LPPACKET next);
VOID PacketSetLengthBuffer(LPPACKET lpPacket, UINT dim);
VOID PacketSetLengthPacket(LPPACKET lpPacket, UINT numBytes);
LPPACKET PacketGetNextPacket(LPPACKET lpPacket);

#ifdef __cplusplus
}
#endif 

#endif //__PACKET32
