/*
 * Copyright (c) 1996, 1997
 *	Piero Viano.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifndef lint
static const char rcsid[] =
    "@(#) $Header: pcap-win32.c,v 1.0 98/08/15 22:39:37 leres Exp $ (LBL)";
#endif

#include <windows.h>
#include <packet32.h>
#include "pcap-int.h"

#define  MAX_PACKET_LENGTH 1514  // (MAC ethernet/802.3)

static LPPACKET* PacketVect=NULL;
static struct _timeb *TimeVect;
static u_char** buffs;
static int head=0;
static int queue=0;
static int np;
static int dim;
static int persi=0;
#include <winbase.h>
static CRITICAL_SECTION Crit;
HANDLE hCapThread;
static HANDLE hMainThread;
static u_char* bt;
int CapPriorityHigh=0;

int SIZE_BUF=4096;


LPPACKET* AllocPacketVect(int n)
{
	int i;
	if (PacketVect) free(PacketVect);
	PacketVect=(LPPACKET*) malloc(sizeof(LPPACKET)*n);
	if(!PacketVect) return NULL;
	if (buffs) free(buffs);
	buffs=(u_char**) malloc(sizeof(u_char*)*(n));
	if(!buffs) return NULL;
	for(i=0;i<n;i++)
	{
		buffs[i]=(u_char*) malloc(sizeof(u_char)*MAX_PACKET_LENGTH);
		if (!buffs[i]) return NULL;
	}
	bt=(u_char*) malloc(sizeof(u_char)*MAX_PACKET_LENGTH);
	if(!bt) return NULL;
	if (TimeVect) free(TimeVect);
	TimeVect=(struct _timeb*) malloc(sizeof(struct _timeb)*n);
	if(!TimeVect) return NULL;
	dim=n;
	return PacketVect;
}

extern int CapExit;

DWORD WINAPI CapThread(LPVOID param)
{
	register BYTE *bp;
	LPPACKET Packet;
	pcap_t *p;
	int ns;

	p=(pcap_t *)param;
	if (p->adapter == NULL) 
	{
		MessageBox(NULL,"Adapter not opened.","Error",MB_OK);
		ExitProcess(1);
	}
lab:
	if (CapExit) return 0;
	// programmo la cattura del pacchetto
	Packet = PacketAllocatePacket();
	PacketInitPacket(Packet,(BYTE*) bt,MAX_PACKET_LENGTH);
    // catturo il pacchetto
    PacketReceivePacket(p->adapter,Packet,TRUE);     

	EnterCriticalSection(&Crit);
	if (np>=dim)
	{
		persi++;
		LeaveCriticalSection(&Crit);
		if(ResumeThread(hMainThread)>=1)
			MessageBox(NULL,"Thread was suspended while queue was full","Error",MB_OK);
		PacketFreePacket(Packet);
		goto lab;
	}
	else
	{
		bp=bt;
		bt=buffs[head];
		buffs[head]=bp;
		PacketVect[head]=Packet;
		_ftime(TimeVect+head);
		head++;
		if(head==dim) head=0;
		np++;
	    if(np>=1) 
		{
labr:
			ns=ResumeThread(hMainThread);
#ifdef DEBUG
			if(ns==0xFFFFFFFF) 
			{
				MessageBox(NULL,"Resume Failed.","Error",MB_OK);
				goto labr;
			}
#ifdef ERR_REP
			else if(ns>1)
			{
				MessageBox(NULL,"Thread was disabled more than one time","Error",MB_OK);
				goto labr;
			}
#endif
#endif
		}
	}
	LeaveCriticalSection(&Crit);
	goto lab;
	return (0);
}

int BeginCapture(pcap_t *p)
{
	HANDLE t;
	DWORD dwThreadId;
	BOOL b;
	InitializeCriticalSection(&Crit);
	t=GetCurrentThread();
	b=DuplicateHandle(GetCurrentProcess(),t,GetCurrentProcess(),&hMainThread,0,FALSE,DUPLICATE_SAME_ACCESS);
	if (b==0) return 1;
	CloseHandle(t);
	PacketVect=AllocPacketVect(SIZE_BUF);
	if (!PacketVect) return 1;
	t=CreateThread(NULL,0,CapThread,p,0,&dwThreadId);
	if (t==NULL) return 1;
	b=DuplicateHandle(GetCurrentProcess(),t,GetCurrentProcess(),&hCapThread,0,FALSE,DUPLICATE_SAME_ACCESS);
	if(b==0) {TerminateThread(t,0);return 1;}
	CloseHandle(t);
	if (CapPriorityHigh==2)
		SetThreadPriority(hCapThread,THREAD_PRIORITY_HIGHEST);
	else if (CapPriorityHigh==1)
		SetThreadPriority(hCapThread,THREAD_PRIORITY_ABOVE_NORMAL);
	else
		SetThreadPriority(hCapThread,THREAD_PRIORITY_NORMAL);
	SuspendThread(hMainThread);
	return 0;
}

int
pcap_stats(pcap_t *p, struct pcap_stat *ps)
{

	*ps = p->md.stat;
	ps->ps_drop=persi;
	return (0);
}

int progress=0;

int
pcap_read(pcap_t *p, int cnt, pcap_handler callback, u_char *user)
{
	register int cc;
	register int caplen;
	int ns;
	/* Captured length can't exceed our read buffer size */
	cc = caplen = PacketVect[queue]->ulBytesReceived;
	if (caplen > p->bufsize)
		caplen = p->bufsize;

	/* Captured length can't exceed the snapshot length */
	if (caplen > p->snapshot)
		caplen = p->snapshot;

	if (p->fcode.bf_insns == NULL ||
	    bpf_filter(p->fcode.bf_insns, buffs[queue], cc, caplen)) 
	{
		struct pcap_pkthdr h;

		++p->md.stat.ps_recv;

		/* Get timestamp */
		h.ts.tv_usec=TimeVect[queue].millitm*1000;
		h.ts.tv_sec=TimeVect[queue].time;
		h.len = cc;
		h.caplen = caplen;
		(*callback)(user, &h, buffs[queue]);
		if (progress) {putc('|',stderr);fflush(stderr);}
		PacketFreePacket(PacketVect[queue]);
		queue++;
		if(queue==dim) queue=0;
		EnterCriticalSection(&Crit);
		np--;
		if (np<=0) 
		{
			if (np<0) MessageBox(NULL,"Thread not suspended when required","Error",MB_OK);
			LeaveCriticalSection(&Crit);
			ns=SuspendThread(hMainThread);
#ifdef DEBUG
			if (ns!=0) MessageBox(NULL,"Thread already suspended. Or error suspending","Error",MB_OK);
#endif
		}
		else
			LeaveCriticalSection(&Crit);
		return (1);

	}
	PacketFreePacket(PacketVect[queue]);
	queue++;
	if(queue==dim) queue=0;
	EnterCriticalSection(&Crit);
	np--;
	if (np<=0) 
	{
		if (np<0) MessageBox(NULL,"Thread not suspended when required","Error",MB_OK);
		LeaveCriticalSection(&Crit);
		ns=SuspendThread(hMainThread);
#ifdef DEBUG
		if (ns!=0) MessageBox(NULL,"Thread already suspended.","Error",MB_OK);
#endif
	}
	else
		LeaveCriticalSection(&Crit);
	return (0);
}

extern char* AdapterName1;

pcap_t *
pcap_open_live(char *device, int snaplen, int promisc, int to_ms, char *ebuf)
{
	register int broadcast;
	register pcap_t *p;

	p = (pcap_t *)malloc(sizeof(*p));
	if (p == NULL) {
		sprintf(ebuf, "malloc: %s", pcap_strerror(errno));
		return (NULL);
	}
	memset(p, 0, sizeof(*p));
	p->adapter=NULL;
	p->adapter=PacketOpenAdapter(AdapterName1);
	if (p->adapter==NULL) {strcpy(ebuf,"Error opening adapter");return NULL;}

	if (promisc) PacketSetFilter(p->adapter,NDIS_PACKET_TYPE_PROMISCUOUS);

	p->linktype = DLT_EN10MB;
	p->offset = 0;
	++broadcast;

	/* Leave room for link header (which is never large under linux...) */
	p->bufsize = MAX_PACKET_LENGTH;

	p->buffer = (u_char *)malloc(MAX_PACKET_LENGTH);
	if (p->buffer == NULL) {
		sprintf(ebuf, "malloc: %s", pcap_strerror(errno));
		goto bad;
	}

	p->snapshot = snaplen;
	if (BeginCapture(p)) goto bad;

	return (p);
bad:
	if (p->adapter)
	    PacketCloseAdapter(p->adapter);
	if (p->buffer != NULL)
		free(p->buffer);
	free(p);
	return (NULL);
}

int
pcap_setfilter(pcap_t *p, struct bpf_program *fp)
{

	p->fcode = *fp;
	return (0);
}

