// CommandDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Query.h"
#include "CommandDlg.h"
#include "CommandExecutor.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifndef ENGLISH
#define ERR_CMD "Inserire un comando"
#define ERR_ERR "Problemi nell'esecuzione del comando"
#else
#define ERR_CMD "Insert a command"
#define ERR_ERR "Problems executing command"
#endif

/////////////////////////////////////////////////////////////////////////////
// CCommandDlg dialog


CCommandDlg::CCommandDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCommandDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCommandDlg)
	//}}AFX_DATA_INIT
	m_FComando=0;
	m_NComandi=0;
	c= new CommandExecutor(/*FALSE*/);
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}


void CCommandDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCommandDlg)
	DDX_Control(pDX, IDC_COMBO1, m_ComboBox);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCommandDlg, CDialog)
	//{{AFX_MSG_MAP(CCommandDlg)
	ON_BN_CLICKED(IDC_OK, OnOk)
	ON_WM_PAINT()
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCommandDlg message handlers

void CCommandDlg::OnOk() 
{
	CString String;
	m_ComboBox.SetItemHeight(10,100);
	m_ComboBox.GetWindowText(String);
	if(String.Compare("")==0) 
		{AfxMessageBox(ERR_CMD /*Inserire un comando*/);return;}
	int n=m_ComboBox.FindStringExact(0, "");
	if(n!=CB_ERR)
		{m_ComboBox.SetCurSel(n);return;}
	m_ComboBox.InsertString(0,String);
	m_ComboBox.SetCurSel(0);
	int t=m_ComboBox.GetCount();
	if(t>20)m_ComboBox.DeleteString(20);
	if(!c->DoCommand((char*)(LPCTSTR)String)) AfxMessageBox(ERR_ERR /*Problemi nell'esecuzione del comando*/);
}

CCommandDlg::~CCommandDlg()
{
 if(c!=NULL) 
 {
	 delete c;
 }
 if(f) delete f;
}

BOOL CCommandDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	c->log.edit=(CEdit*)GetDlgItem(IDC_EDIT1);
    f=new CFont();
    if (f->CreatePointFont(100,"Analyzer")==0)
     {
       if (!f->CreateStockObject(OEM_FIXED_FONT))
        {delete f;f=NULL;}
     }
	if(f)c->log.edit->SetFont(f);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCommandDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CCommandDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCommandDlg::OnCancel() 
{
	CDialog::OnCancel();
}

void CCommandDlg::OnClose() 
{
	CDialog::OnClose();
}
