// Query.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "Query.h"
#include "QueryDlg.h"
#include "CommandDlg.h"
#include "CommandExecutor.h"
#include "../comuni/cmdline.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern processCmdLine *p;

/////////////////////////////////////////////////////////////////////////////
// CQueryApp

BEGIN_MESSAGE_MAP(CQueryApp, CWinApp)
	//{{AFX_MSG_MAP(CQueryApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CQueryApp construction

CQueryApp::CQueryApp()
{
	c=NULL;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CQueryApp object

CQueryApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CQueryApp initialization

BOOL CQueryApp::InitInstance()
{
	// Initialize OLE libraries
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif
	//AfxMessageBox(m_lpCmdLine);
	BOOL IsAutomated=RunEmbedded() || RunAutomated();
	// Parse the command line to see if launched as OLE server
	if (!IsAutomated)
	{
		// When a server application is launched stand-alone, it is a good idea
		//  to update the system registry in case it has been damaged.
		COleObjectFactory::UpdateRegistryAll();
	}

	CreateArgs();

	p=new processCmdLine(argc,argv);
	for(int i=0;i<argc;i++)
	{
		if (argv[i][0]=='/' && strcmp(argv[i]+1,"Register")==0)
		{
			COleObjectFactory::UpdateRegistryAll();
			exit(0);
		}
	}

	int nResponse;
	if (IsAutomated==FALSE)
	{
     CCommandDlg dlg;
	 m_pCommandWnd = &dlg;
     m_pMainWnd = &dlg;
 	 nResponse = dlg.DoModal();
	} else 
	{
		if(!f.Create(NULL,"Fittizia"))return FALSE;
		f.ActivateFrame(SW_HIDE);
		m_pMainWnd = &f;
		c=new CommandExecutor;
		COleTemplateServer::RegisterAll();
		return TRUE;
    }
	
	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}


void CQueryApp::CreateArgs()
{
	int i,l,n=1;
	l=strlen(m_lpCmdLine);
	for(i=0;i<l;i++)
		if(m_lpCmdLine[i]==' ' || m_lpCmdLine[i]=='\t') n++;
	argv=new char*[n+1];
	if(l==0) {n=1;argc=1;}
	else argc=n+1;
	n=2;
	argv[0]="Query";
	argv[1]=m_lpCmdLine;
	for(i=0;i<l;i++)
		if(m_lpCmdLine[i]==' ' || m_lpCmdLine[i]=='\t') 
		{
		  argv[n]=m_lpCmdLine+i+1;
		  m_lpCmdLine[i]='\0';
		  n++;
		}
}

CQueryApp::~CQueryApp()
{
	if(argv) delete []argv;
	if(p) delete p;
	if(c) delete c;
}

BOOL CQueryApp::PreTranslateMessage(MSG* pMsg) 
{
	if (pMsg->message==WM_CLOSE) exit(0);
	return CWinApp::PreTranslateMessage(pMsg);
}
