// Protocol.cpp: implementation of the Protocol class.
//
//////////////////////////////////////////////////////////////////////

#include "protocol.h"
#include "case.h"
#include <string.h>
#include "asksay.h"

#define ErrorInt() {Error(); return 1;}
#define ErrorInt2() {Error2(); return 1;}

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
#ifndef ENGLISH
#define Error() {Say("Errore di IO dei costrutti Case");}
#define Error2() {Say("Formato del file non valido");}
#define ERR_FLD "Definizione errata dei campi"
#define ERR_TITLE "----- %s -----"
#define ERR_NOFLD "[Nessun campo definito]"
#else
#define Error() {Say("IO Error in Case");}
#define Error2() {Say("Bad file format");}
#define ERR_FLD "Wrong field definition"
#define ERR_TITLE "----- %s -----"
#define ERR_NOFLD "[No field defined]"
#endif

Protocol::Protocol(const char* c)
{
 nome=NULL;
 SetNome(c);
 ps=NULL;
 dataoff=0;
 nc=0;
 ni=0;
 ist=NULL;
 cc=0;
 ccase=NULL;
 np=0;
 size=-1;
 is_virt=0;
 mustinvert=0x1234;
 if (*((TUBYTE*)(&mustinvert))==0x34) 
	mustinvert=1; 
 else
	mustinvert=0;
}

Protocol::~Protocol()
{
 if (nome) delete[]nome;
 if (ist) delete[]ist;
 DeleteCampi();
 RemoveAllCases();
}

int Protocol::RiempiCampi(p_struct * p, int enp)
{
	np=enp;
	if (np<0) np=0;

	DeleteCampi();
	size=0;
	ps=new p_struct[np];
	if (ps)
     for(int i=0;i<np;i++)
	 {
	  strcpy(ps[i].nome,p[i].nome);
	  ps[i].size=p[i].size;
	  size+=p[i].size;
	  ps[i].offset=p[i].offset;
	  ps[i].bs=p[i].bs;
	  ps[i].be=p[i].be;
	  ps[i].ref=p[i].ref;
	 }
	 else return 1;
    return 0;
}

void Protocol::DeleteCampi()
{
 if (ps) delete[]ps;
 ps=NULL;
 size=-1;
}



int Protocol::AddCase(CCase & c)
{
	CCase** tccase;
	int i;
	if (nc==0) 
	{
		ccase=new CCase*[10];
		if (ccase==NULL) return 1;
		for (i=0;i<10;i++) ccase[i]=NULL;
		nc=10;
		cc=0;
	}
	if (cc==nc) 
	{
		tccase=new CCase*[10+nc];
		if (tccase==NULL) return 1;
		for (i=0;i<nc;i++) tccase[i]=ccase[i];
		for (i=nc;i<nc+10;i++) tccase[i]=NULL;
		ccase=tccase;
	}
	ccase[cc]=new CCase;
	if (ccase[cc]) *ccase[cc]=c;
	cc++;
	return 0;
}

int Protocol::RemoveCase()
{
	if (ccase==NULL) return 1;
	if (cc==0) return 0;
	if (ccase[cc-1]!=NULL) delete ccase[cc-1];
	ccase[cc-1]=NULL;
	cc--;
	return 0;
}

int Protocol::RemoveAllCases()
{
	if (ccase)
	{
	 for (int i=cc-1;i>=0;i--) RemoveCase();
	 delete[]ccase;
	 ccase=NULL;
	 nc=0;
	 return 0;
	} return 1;
}

int Protocol::Serialize(int IsReading, FILE * f)
{
	int y;

	if(IsReading)
	{
	 DeleteCampi();
	 RemoveAllCases();
	 if (nome) delete[]nome;
	 // Delimitatore iniziale
	 if (fread(&y,sizeof(int),1,f)!=1) ErrorInt();
	 if (y!=BPROTOCOL) ErrorInt2();
	 if (fread(&is_virt,sizeof(int),1,f)!=1) ErrorInt();
	 if (fread(&y,sizeof(int),1,f)!=1) ErrorInt();
	 nome=new char[y];
	 if (nome==NULL) ErrorInt2();
	 if (fread(nome,sizeof(char),y,f)!=(unsigned)y) ErrorInt();
	 // Campi
	 SerializeCampi(IsReading,f);
	 // Skip
	 if (fread(&ni,sizeof(int),1,f)!=1) ErrorInt();
	 if (ist) delete[] ist;
	 if (ni) 
	 {
		ist=new istruzione[ni+1];
		for(y=0;y<ni;y++)
		{
			if (fread(&(ist[y].ist_number),sizeof(int),1,f)!=1) ErrorInt();
			if (fread(&(ist[y].p1),sizeof(int),1,f)!=1) ErrorInt();
		}
		ist[ni].ist_number=I_END;
		ist[ni].p1=0;
	 } else ist=NULL;
	 // Case
	 if (fread(&y,sizeof(int),1,f)!=1) ErrorInt();
	 CCase c;
	 for (int i=0;i<y;i++) 
	 {
		 c.Serialize(IsReading,f);
		 AddCase(c);
	 }
	 // Delimitatore finale
	 if (fread(&y,sizeof(int),1,f)!=1) ErrorInt();
	 if (y!=ENDPROTOCOL) ErrorInt2();
	}
	 else
	{
	 // Delimitatore iniziale
	 y=BPROTOCOL;
	 if (fwrite(&y,sizeof(int),1,f)!=1) ErrorInt();
	 if (fwrite(&is_virt,sizeof(int),1,f)!=1) ErrorInt();
	 y=strlen(nome)+1;
	 if (fwrite(&y,sizeof(int),1,f)!=1) ErrorInt();
	 if (fwrite(nome,sizeof(char),y,f)!=(unsigned)y) ErrorInt();
	 // Campi
	 SerializeCampi(IsReading,f);
	 // Skip
	 if (fwrite(&ni,sizeof(int),1,f)!=1) ErrorInt();
	 for(y=0;y<ni;y++)
	 {
		if (fwrite(&(ist[y].ist_number),sizeof(int),1,f)!=1) ErrorInt();
		if (fwrite(&(ist[y].p1),sizeof(int),1,f)!=1) ErrorInt();
	 }
	 // Case
	 if (fwrite(&cc,sizeof(int),1,f)!=1) ErrorInt();
	 for (int i=0;i<cc;i++) 
		 ccase[i]->Serialize(IsReading,f);
	 // Delimitatore finale
	 y=ENDPROTOCOL;
	 if (fwrite(&y,sizeof(int),1,f)!=1) ErrorInt();
	}
	return 0;
}

int Protocol::SerializeCampi(int IsReading, FILE * f)
{
 int i,y;
	if(IsReading)
	{
	 DeleteCampi();
	 if (fread(&np,sizeof(int),1,f)!=1) ErrorInt();
	 if (np<0) return 1;
	 ps=new p_struct[np];
	 if (!ps) return 1;
	 size=0;
     for(i=0;i<np;i++)
	 {
	  if (fread(&y,sizeof(int),1,f)!=1) ErrorInt();
	  if (fread(ps[i].nome,sizeof(char),y,f)!=(unsigned)y) ErrorInt();
	  if (fread(&ps[i].size,sizeof(int),1,f)!=1) ErrorInt();
	  size+=ps[i].size;
	  if (fread(&ps[i].offset,sizeof(int),1,f)!=1) ErrorInt();
	  if (fread(&ps[i].bs,sizeof(int),1,f)!=1) ErrorInt();
	  if (fread(&ps[i].be,sizeof(int),1,f)!=1) ErrorInt();
	  if (fread(&ps[i].ref,sizeof(int),1,f)!=1) ErrorInt();
	 }
	}
	 else
	{
	 if (fwrite(&np,sizeof(int),1,f)!=1) ErrorInt();
     for(i=0;i<np;i++)
	 {
	  y=strlen(ps[i].nome)+1;
	  if (fwrite(&y,sizeof(int),1,f)!=1) ErrorInt();
	  if (fwrite(ps[i].nome,sizeof(char),y,f)!=(unsigned)y) ErrorInt();
	  if (fwrite(&ps[i].size,sizeof(int),1,f)!=1) ErrorInt();
	  if (fwrite(&ps[i].offset,sizeof(int),1,f)!=1) ErrorInt();
	  if (fwrite(&ps[i].bs,sizeof(int),1,f)!=1) ErrorInt();
	  if (fwrite(&ps[i].be,sizeof(int),1,f)!=1) ErrorInt();
	  if (fwrite(&ps[i].ref,sizeof(int),1,f)!=1) ErrorInt();
	 }
	}
	return 0;
}

int Protocol::SetNome(const char * c)
{
 if (c==NULL) nome=NULL;
 else
  nome =new char[strlen(c)+1];
 if (nome) strcpy(nome,c);
 return 0;
}

const char* Protocol::GetName()
{
	return nome;
}

int Protocol::GetSize()
{
	return size;
}

CCase * Protocol::GetCase(int i)
{
	if(i<cc && i>=0) return ccase[i];
	return NULL;
}

int Protocol::RiempiSkip(istruzione * v, int nv)
{
 ni=nv;
 if (v==NULL) {ni=0;ist=NULL;}
 if(ni<0) ni=0;
 if(ist) delete[]ist;
 ist =new istruzione[ni+1];
 if (!ist) return 1;
 int i;
 for(i=0;i<nv;i++)
 {
	 ist[i].ist_number=v[i].ist_number;
	 ist[i].p1=v[i].p1;
 }
 ist[nv].ist_number=I_END;
 ist[nv].p1=0;
 return 0;
}

istruzione* Protocol::GetSkipCode()
{
	if(ni) return ist;
	return NULL;
}

int Protocol::GetVisited()
{
	return Visitato;
}

void Protocol::SetVisited(int i)
{
	Visitato=i;
}

int Protocol::CalcolaCampi(const TUBYTE * p)
{
	if(ps==NULL) return 1;
	int i,ref=-1,t,tt,m;
	TUBYTE ch; TWORD sh; TDWORD ih;
	for(i=0;i<np;i++)
	{
		switch (ps[i].size)
		{
		 case 0:
			 m=0;
			 ps[i].val=ps[ref].val;
			 t=ps[i].be-ps[i].bs+1;
			 for(tt=0;tt<t;tt++)
				m+=1<<tt;
			 ps[i].val>>=ps[i].bs;
			 ps[i].val&=m;
			 break;
		 case 1:
			 ch=*((TUBYTE*)(p+ps[i].offset));
			 ps[i].val=ch&0xFF;
			 ref=i;
			 break;
		 case 2:
			 if (mustinvert) sh=INV_WORD((void*)(p+ps[i].offset));
				else sh= (*((TWORD*)(p+ps[i].offset)));
			 ps[i].val=sh&0xFFFF;
			 ref=i;
			 break;
		 case 4:
			 if (mustinvert) ih=INV_DWORD((void*)(p+ps[i].offset));
				else ih= (*((TWORD*)(p+ps[i].offset)));
			 ps[i].val=ih;
			 ref=i;
			 break;
		 default: 
			 Say(ERR_FLD /*Definizione errata dei campi*/);
		}
	}
    return 0;
}

TWORD Protocol::INV_WORD(void* A)
{
	TWORD word; 
	((TUBYTE*)&word)[0]=((TUBYTE*)A)[1];
	((TUBYTE*)&word)[1]=((TUBYTE*)A)[0];
	return word;
}

TDWORD Protocol::INV_DWORD(void* A)
{
	TDWORD word; 
	((TUBYTE*)&word)[0]=((TUBYTE*)A)[3];
	((TUBYTE*)&word)[1]=((TUBYTE*)A)[2];
	((TUBYTE*)&word)[2]=((TUBYTE*)A)[1];
	((TUBYTE*)&word)[3]=((TUBYTE*)A)[0];
	return word;
}


void Protocol::DumpProtocol(LineCollection & lc,const TUBYTE * p)
{
	CalcolaCampi(p);
	lc.insert(ERR_TITLE /*----- %s -----*/, nome);
	int i,j;
	if (np==0) lc.insert1(ERR_NOFLD /*[Nessun campo definito]*/);
	for(i=0;i<np;i++)
	{
		j=i;
		if (ps[i].size==0) j=ps[i].ref;
		if (ps[j].size==1)
			lc.insert("%s: %d (0x%02x)",ps[i].nome,ps[i].val,ps[i].val);
		else if (ps[j].size==2)
			lc.insert("%s: %d (0x%04x)",ps[i].nome,ps[i].val,ps[i].val);
		else
			lc.insert("%s: %d (0x%08x)",ps[i].nome,ps[i].val,ps[i].val);
	}
}

p_struct* Protocol::GetPS(int & n)
{
	n=np;
	if (!ps) {n=0;return NULL;}
	return ps;
}

int Protocol::GetCaseNumber()
{
	return cc;
}

TSDWORD Protocol::GetVar(int i)
{
	if (i<0 || i>np) return 0;
	return ps[i].val;
}

int Protocol::GetVarNumber()
{
	return np;
}

const char* Protocol::GetVarName(int i)
{
	if (i<0 || i>np) return NULL;
	return ps[i].nome;
}

int Protocol::GetVarSize(int i)
{
	if (i<0 || i>np) return 0;
	return ps[i].size;
}

int Protocol::GetOffset(int i, int & s, int & e)
{
	if (i<0 || i>np) return 1;
	if (ps[i].size!=0) {s=-1;e=-1; return 1;}
	 else {s=ps[i].bs;e=ps[i].be;}
	return 0;
}

void Protocol::SetVirt(int v)
{
	is_virt=v;
}

int Protocol::GetVirt()
{
	return is_virt;
}
