// Protocol.h: interface for the Protocol class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PROTOCOL_H__04CEEA94_1A1C_11D2_9416_000000000000__INCLUDED_)
#define AFX_PROTOCOL_H__04CEEA94_1A1C_11D2_9416_000000000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "structs.h"
#include "case.h"
#include "linecol.h"

#define BPROTOCOL 6000
#define ENDPROTOCOL 6001
#define CASES 6002

class Protocol  
{
public:
	int GetVirt();
	void SetVirt(int v);
	int GetOffset(int i, int& s,int& e);
	int GetVarSize(int i);
	const char* GetVarName(int i);
	int GetVarNumber();
	TSDWORD GetVar(int i);
	int GetCaseNumber();
	p_struct* GetPS(int &np);
	void DumpProtocol(LineCollection& lc,const TUBYTE * p);
	int CalcolaCampi(const TUBYTE* p);
	void SetVisited(int i);
	int GetVisited();
	istruzione* GetSkipCode();
	int RiempiSkip(istruzione* ist, int i);
	CCase * GetCase(int i);
	int GetSize();
	const char* GetName();
	int SetNome(const char* c);
	int Serialize(int IsReading, FILE* f);
	int RemoveAllCases();
	int RemoveCase();
	int AddCase(CCase &c);
	void DeleteCampi();
	int RiempiCampi(p_struct *p, int enp);
	Protocol(const char* c=NULL);
	virtual ~Protocol();
	void SetDataOffset(int l) {dataoff=l;}
	int GetDataOffset() {return dataoff;}

private:
	int mustinvert;
	TDWORD INV_DWORD(void*);
	TWORD INV_WORD(void*);
	int Visitato;
	istruzione * ist;
	int size;
	int dataoff;
	int SerializeCampi(int IsReading,FILE* f);
	char* nome;
	p_struct* ps;
	int np;
	CCase ** ccase;
	int cc;
	int nc;
	int ni;
	int is_virt;
};

#endif // !defined(AFX_PROTOCOL_H__04CEEA94_1A1C_11D2_9416_000000000000__INCLUDED_)
