// Case.cpp: implementation of the CCase class.
//
//////////////////////////////////////////////////////////////////////

#include "case.h"
#include <stdio.h>
#include "asksay.h"

#ifndef ENGLISH
#define ERR_READ "Errore di lettura del Case"
#define ERR_BADF "Formato del file non valido"
#define ERR_WRITE "Errore di scrittura del Case"
#define ERR_MEM "Memoria esaurita"
#else
#define ERR_READ "Error reading Case"
#define ERR_BADF "Bad file format"
#define ERR_WRITE "Error writing  Case"
#define ERR_MEM "Out of Memory"
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CCase::CCase()
{
	ist=NULL;
	NextProtocol=NULL;
}

CCase::~CCase()
{
	ClearAll();
}

int CCase::RiempiCase(istruzione* v, int nv, const char * next)
{
 ClearAll();
 if (next==NULL) next="DATA";
 NextProtocol =new char[strlen(next)+1];
 if (NextProtocol) strcpy(NextProtocol,next);
 ni=nv;
 if(ni<0) ni=0;
 if(ist) delete[]ist;
 ist =new istruzione[ni+1];
 if (!ist) return 1;
 int i;
 for(i=0;i<nv;i++)
 {
	 ist[i].ist_number=v[i].ist_number;
	 ist[i].p1=v[i].p1;
 }
 ist[nv].ist_number=I_END;
 ist[nv].p1=0;
 return 0;
}

CCase& CCase::operator =(CCase & c)
{
 RiempiCase(c.ist,c.ni,c.NextProtocol);
 return c;
}

#define ErrorInt(A) {Say(A); return 1;}

int CCase::Serialize(int IsReading, FILE * f)
{
	int y;

	if(IsReading)
	{
	 ClearAll();
	 // Delimitatore iniziale
	 if (fread(&y,sizeof(int),1,f)!=1) ErrorInt(ERR_READ /*Errore di lettura del Case*/);
	 if (y!=BEGCASE) ErrorInt(ERR_BADF /*Formato del file non valido*/);
	 // Prossimo protocollo
	 y=0;
	 if (fread(&y,sizeof(int),1,f)!=1) ErrorInt(ERR_WRITE /*Errore di scrittura del Case*/);
	 NextProtocol=new char[y];
	 if (NextProtocol==NULL) ErrorInt(ERR_MEM /*Memoria esaurita*/);
	 if (fread(NextProtocol,sizeof(char),y,f)!=(unsigned)y) ErrorInt(ERR_READ /*Errore di lettura del Case*/);
	 // Vari Case
	 if (fread(&ni,sizeof(int),1,f)!=1) ErrorInt(ERR_READ /*Errore di lettura del Case*/);
	 ist=new istruzione[ni+1];
	 for(y=0;y<ni;y++)
	 {
		if (fread(&(ist[y].ist_number),sizeof(int),1,f)!=1) ErrorInt(ERR_READ /*Errore di lettura del Case*/);
		if (fread(&(ist[y].p1),sizeof(int),1,f)!=1) ErrorInt(ERR_READ /*Errore di lettura del Case*/);
	 }
	 ist[ni].ist_number=I_END;
	 ist[ni].p1=0;
	 // Delimitatore finale
	 if (fread(&y,sizeof(int),1,f)!=1) ErrorInt(ERR_READ /*Errore di lettura del Case*/);
	 if (y!=ENDCASE) ErrorInt(ERR_BADF /*Formato del file non valido*/);
	}
	 else
	{
	 // Delimitatore iniziale
	 y=BEGCASE;
	 if (fwrite(&y,sizeof(int),1,f)!=1) ErrorInt(ERR_WRITE /*Errore di scrittura del Case*/);
	 // Prossimo protocollo
	 y=0;
	 if (NextProtocol) y=strlen(NextProtocol)+1;
	 if (fwrite(&y,sizeof(int),1,f)!=1) ErrorInt(ERR_WRITE /*Errore di scrittura del Case*/);
	 if (fwrite(NextProtocol,sizeof(char),y,f)!=(unsigned)y)ErrorInt(ERR_WRITE /*Errore di scrittura del Case*/);
	 // Vari Case
	 if (fwrite(&ni,sizeof(int),1,f)!=1) ErrorInt(ERR_WRITE /*Errore di scrittura del Case*/);
	 for(y=0;y<ni;y++)
	 {
		if (fwrite(&(ist[y].ist_number),sizeof(int),1,f)!=1) ErrorInt(ERR_WRITE /*Errore di scrittura del Case*/);
		if (fwrite(&(ist[y].p1),sizeof(int),1,f)!=1) ErrorInt(ERR_WRITE /*Errore di scrittura del Case*/);
	 }
	 // Delimitatore finale
	 y=ENDCASE;
	 if (fwrite(&y,sizeof(int),1,f)!=1) ErrorInt(ERR_WRITE /*Errore di scrittura del Case*/);
	}
	return 0;
}

void CCase::ClearAll()
{
 if (NextProtocol) delete[]NextProtocol;
 NextProtocol=NULL;
 if (ist) delete[]ist;
 ist=NULL;
}

istruzione* CCase::GetCaseCode(int i)
{
	if(i<ni && i>=0) return ist+i;
	return NULL;
}

const char* CCase::GetNextProtocol()
{
	return NextProtocol;
}
