// CodeProcessor.cpp: implementation of the CCodeProcessor class.
//
//////////////////////////////////////////////////////////////////////

#include "codeprocessor.h"
#include "asksay.h"
#include <string.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
#ifndef ENGLISH
#define ErrorInt() {Say("Errore nel caricamento del codice oggetto"); return 1;}
#define ErrorInt2() {Say("Errore nel salvataggio del codice oggetto"); return 1;}
#define ERR_NOMEM "Memoria esaurita"
#else
#define ErrorInt() {Say("Error loading object  file"); return 1;}
#define ErrorInt2() {Say("Error saving object  file"); return 1;}
#define ERR_NOMEM "Out of Memory"
#endif

CCodeProcessor::CCodeProcessor()
{
	stringhe=NULL;
	nomi=NULL;
	pr=NULL;
	np=ns=nn=0;
	n_vect=0;
}

CCodeProcessor::~CCodeProcessor()
{
	DeleteAll();
}

#ifdef LINUX
Protos* alloca_protos(int y) {return new Protos[y];}
#endif

int CCodeProcessor::Read(FILE * f)
{
	int y,i,t;

	 DeleteAll();
	 // Delimitatore iniziale
	 if (fread(&y,sizeof(int),1,f)!=1) ErrorInt();
	 if (y!=INI_FILE) ErrorInt();
	 // Numero di vettori globali
	 if (fread(&n_vect,sizeof(int),1,f)!=1) ErrorInt();
	 // Stringhe
	 if (fread(&y,sizeof(int),1,f)!=1) ErrorInt();
	 if (y!=INI_STR) ErrorInt();
	 if (fread(&y,sizeof(int),1,f)!=1) ErrorInt();
	 stringhe=new char*[y];
	 ns=y;
	 if (stringhe==NULL) ErrorInt();
	 for(i=0;i<y;i++)
		 {
			if (fread(&t,sizeof(int),1,f)!=1) ErrorInt();
			stringhe[i]=new char[t];
			if (stringhe[i]==NULL) ErrorInt();
			if (fread(stringhe[i],sizeof(char),t,f)!=(unsigned)t) ErrorInt();
		 }
	 if (fread(&y,sizeof(int),1,f)!=1) ErrorInt();
	 if (y!=END_STR) ErrorInt();
	 // Nomi di variabili non definite del codice
	 if (fread(&y,sizeof(int),1,f)!=1) ErrorInt();
	 if (y!=INI_NOME) ErrorInt();
	 if (fread(&y,sizeof(int),1,f)!=1) ErrorInt();
	 nomi=new char*[y];
	 nn=y;
	 if (nomi==NULL) ErrorInt();
	 for(i=0;i<y;i++)
		 {
			if (fread(&t,sizeof(int),1,f)!=1) ErrorInt();
			nomi[i]=new char[t];
			if (nomi[i]==NULL) ErrorInt();
			if (fread(nomi[i],sizeof(char),t,f)!=(unsigned)t) ErrorInt();
		 }
	 if (fread(&y,sizeof(int),1,f)!=1) ErrorInt();
	 if (y!=END_NOME) ErrorInt();
	 // Funzioni che si occupano del processamento del codice
	 if (fread(&y,sizeof(int),1,f)!=1) ErrorInt();
	 if (y!=INI_PROTO) ErrorInt();
	 if (fread(&y,sizeof(int),1,f)!=1) ErrorInt();
#ifndef LINUX
	 pr=new Protos[y];
#else
	 pr=alloca_protos(y);
#endif
	 np=y;
	 if (nomi==NULL) ErrorInt();
	 for(i=0;i<y;i++)
		 {
			pr[i].Serialize(1,f);
		 }
	 if (fread(&y,sizeof(int),1,f)!=1) ErrorInt();
	 if (y!=END_PROTO) ErrorInt();
	 // Delimitatore finale
	 if (fread(&y,sizeof(int),1,f)!=1) ErrorInt();
	 if (y!=END_FILE) ErrorInt();
	 return 0;
}

int CCodeProcessor::Write(FILE * f)
{
	int y,i,t;

	 // Delimitatore iniziale
	 y=INI_FILE;
	 if (fwrite(&y,sizeof(int),1,f)!=1) ErrorInt2();
	 // Numero di vettori globali
	 if (fwrite(&n_vect,sizeof(int),1,f)!=1) ErrorInt2();
	 // Stringhe
	 y=INI_STR;
	 if (fwrite(&y,sizeof(int),1,f)!=1) ErrorInt2();
	 y=ns;
	 if (fwrite(&y,sizeof(int),1,f)!=1) ErrorInt2();
	 for(i=0;i<y;i++)
		 {
			t=strlen(stringhe[i])+1;
			if (fwrite(&t,sizeof(int),1,f)!=1) ErrorInt2();
			if (fwrite(stringhe[i],sizeof(char),t,f)!=(unsigned)t) ErrorInt2();
		 }
	 y=END_STR;
	 if (fwrite(&y,sizeof(int),1,f)!=1) ErrorInt2();
	 // Nomi di variabili non definite del codice
	 y=INI_NOME;
	 if (fwrite(&y,sizeof(int),1,f)!=1) ErrorInt2();
	 y=nn;
	 if (fwrite(&y,sizeof(int),1,f)!=1) ErrorInt2();
	 for(i=0;i<y;i++)
		 {
			t=strlen(nomi[i])+1;
			if (fwrite(&t,sizeof(int),1,f)!=1) ErrorInt2();
			if (fwrite(nomi[i],sizeof(char),t,f)!=(unsigned)t) ErrorInt2();
		 }
	 y=END_NOME;
	 if (fwrite(&y,sizeof(int),1,f)!=1) ErrorInt2();
	 // Funzioni che si occupano del processamento del codice
	 y=INI_PROTO;
	 if (fwrite(&y,sizeof(int),1,f)!=1) ErrorInt2();
	 y=np;
	 if (fwrite(&y,sizeof(int),1,f)!=1) ErrorInt2();
	 for(i=0;i<y;i++)
		 {
			pr[i].Serialize(0,f);
		 }
	 y=END_PROTO;
	 if (fwrite(&y,sizeof(int),1,f)!=1) ErrorInt2();
	 // Delimitatore finale
	 y=END_FILE;
	 if (fwrite(&y,sizeof(int),1,f)!=1) ErrorInt2();
	 return 0;
}

int CCodeProcessor::Serialize(int IsReading, FILE * f)
{
	if (IsReading)
	{
	 return Read(f);
	}
	 else
	{
	 return Write(f);
	}
 return 0;
}


void CCodeProcessor::DeleteAll()
{
	if (ns)
	{
		for(int i=0;i<ns;i++) delete[]stringhe[i];
		delete[]stringhe;
		ns=0;
	}
	if (nn)
	{
		for(int i=0;i<nn;i++) delete[]nomi[i];
		delete[]nomi;
		nn=0;
	}
	if (np)
	{
		delete []pr;
		np=0;
	}
}

Nomi& Nomi::operator = (Nomi& nome) 
{
	if (n==NULL || strlen(n)<strlen(nome.n))
	{
		if(n) delete[]n; 
		n=new char[strlen(nome.n)+1];
		if (!n) {Say(ERR_NOMEM /*Memoria esaurita*/);return nome;}
	}
	strcpy(n,nome.n);
	return nome;
}

Nomi& Nomi::operator =(const char * nome)
{
	if (n==NULL || strlen(n)<strlen(nome))
	{
		if(n) delete[]n; 
		n=new char[strlen(nome)+1];
		if (!n) {Say(ERR_NOMEM /*Memoria esaurita*/);return *this;}
	}
	strcpy(n,nome);
	return *this;
}

Protos & Protos::operator = (Protos& p) 
{
	if (np<p.np) 
	{
		if(parametri) delete[]parametri;
		parametri=new int[p.np];
		if (parametri==NULL) {Say(ERR_NOMEM /*Memoria esaurita*/);np=0;return p;}
	}
	for (int i=0;i<p.np;i++){parametri[i]=p.parametri[i];}
	np=p.np; rettype=p.rettype; nome=p.nome;
	if(p.ni)
	{
		if (ni<p.ni)	
		{
			if(ist) delete[]ist;
			ist=new istruzione[p.ni];
			if (ist==NULL) {Say(ERR_NOMEM /*Memoria esaurita*/);ni=0;return p;}
		}
		for (int i=0;i<p.ni;i++){ist[i]=p.ist[i];}
	}
	if(p.nv)
	{
		if (nv<p.nv) 
		{
			if(vars) delete[]vars;
			if(offs) delete[]offs;
			if(nomivars) delete[]nomivars;
			vars=new int[p.nv];
			offs=new int[p.nv];
			nomivars=new char*[p.nv];
			if (vars==NULL || offs==NULL || nomivars==NULL) 
			{Say(ERR_NOMEM /*Memoria esaurita*/);nv=0;return p;}
		}
		for (int i=0;i<p.nv;i++)
		{
			vars[i]=p.vars[i];
			if (p.offs) offs[i]=p.offs[i]; 
			else offs[i]=0;
			nomivars[i]=new char[strlen(p.nomivars[i])+1];
			if (!nomivars) {Say(ERR_NOMEM /*Memoria esaurita*/);nv=0;return p;}
			strcpy(nomivars[i],p.nomivars[i]);
		}
	}
	np=p.np; rettype=p.rettype; nome=p.nome; ni=p.ni; nv=p.nv;
	rettype=p.rettype;
	return p;
}


int Protos::Serialize(int IsReading, FILE * f)
{
	int i,y;

	if (IsReading)
	{
	 DeleteAll();
	 if (fread(&y,sizeof(int),1,f)!=1) ErrorInt2();
	 if (nome.n) delete[]nome.n;
	 nome.n= new char[y];
	 if (!nome.n) ErrorInt2();
	 nome.size=y-1;
	 if (fread(nome.n,sizeof(char),y,f)!=(unsigned)y) ErrorInt2();
	 if (fread(&rettype,sizeof(int),1,f)!=1) ErrorInt2();
	 if (fread(&np,sizeof(int),1,f)!=1) ErrorInt2();
	 parametri=new int[np];
	 if (!parametri) ErrorInt2();
	 for (i=0;i<np;i++)
		 if (fread(parametri+i,sizeof(int),1,f)!=1) ErrorInt2();
	 if (fread(&ni,sizeof(int),1,f)!=1) ErrorInt2();
	 ist=new istruzione[ni+1];
	 if (!ist) {Say(ERR_NOMEM /*Memoria esaurita*/);return 1;}
	 for (i=0;i<ni;i++)
	 {
		 if (fread(&(ist[i].ist_number),sizeof(int),1,f)!=1) ErrorInt2();
		 if (fread(&(ist[i].p1),sizeof(int),1,f)!=1) ErrorInt2();
	 }
	 ist[ni].ist_number=I_END;
	 ist[ni].p1=0;
	 if (fread(&nv,sizeof(int),1,f)!=1) ErrorInt2();
	 vars=new int[nv];
	 if (!vars) {Say(ERR_NOMEM /*Memoria esaurita*/);return 1;}
	 nomivars=new char*[nv];
	 if (!nomivars) {Say(ERR_NOMEM /*Memoria esaurita*/);return 1;}
	 for (i=0;i<nv;i++)
	 {
		 if (fread(vars+i,sizeof(int),1,f)!=1) ErrorInt2();
		 if (fread(&y,sizeof(int),1,f)!=1) ErrorInt2();
		 nomivars[i]=new char[y];
		 if (!nomivars[i]) {Say(ERR_NOMEM /*Memoria esaurita*/);return 1;}
		 if (fread(nomivars[i],sizeof(char),y,f)!=(unsigned)y) ErrorInt2();
	 }
	}
	else
	{
	 y=strlen(nome.n)+1;
	 if (fwrite(&y,sizeof(int),1,f)!=1) ErrorInt2();
	 if (fwrite(nome.n,sizeof(char),y,f)!=(unsigned)y) ErrorInt2();
	 if (fwrite(&rettype,sizeof(int),1,f)!=1) ErrorInt2();
	 if (fwrite(&np,sizeof(int),1,f)!=1) ErrorInt2();
	 for (i=0;i<np;i++)
		 if (fwrite(parametri+i,sizeof(int),1,f)!=1) ErrorInt2();
	 if (fwrite(&ni,sizeof(int),1,f)!=1) ErrorInt2();
	 for (i=0;i<ni;i++)
	 {
		 if (fwrite(&(ist[i].ist_number),sizeof(int),1,f)!=1) ErrorInt2();
		 if (fwrite(&(ist[i].p1),sizeof(int),1,f)!=1) ErrorInt2();
	 }
	 if (fwrite(&nv,sizeof(int),1,f)!=1) ErrorInt2();
	 for (i=0;i<nv;i++)
	 {
		 if (fwrite(vars+i,sizeof(int),1,f)!=1) ErrorInt2();
		 y=strlen(nomivars[i])+1;
		 if (fwrite(&y,sizeof(int),1,f)!=1) ErrorInt2();
		 if (fwrite(nomivars[i],sizeof(char),y,f)!=(unsigned)y) ErrorInt2();
	 }
	}
	return 0;
}

int Protos::AddIst(istruzione * is, int ni)
{
	if (ist) delete[] ist;
	ist=new istruzione[ni+1];
	if (!ist) {Say(ERR_NOMEM /*Memoria esaurita*/);return 1;}
	 for (int i=0;i<ni;i++)
	 {
		 ist[i].ist_number=is[i].ist_number;
		 ist[i].p1=is[i].p1;
	 }
	 ist[ni].ist_number=I_END;
	 ist[ni].p1=0;
	 Protos::ni=ni;
	 return 0;
}

void CCodeProcessor::SetPr(Protos * p, int n)
{
	pr=p;
	np=n;
}

Protos* CCodeProcessor::FindProto(const char * c)
{
	if (np==0) return NULL;
	for(int i=0;i<np;i++)
	{
		if (strcmp(pr[i].nome.n,c)==0) return pr+i;
	}
	return NULL;
}

Protos* CCodeProcessor::FindProto(int i)
{
	if (np==0) return NULL;
	if (i<np) return pr+i;
	return NULL;
}

const char** CCodeProcessor::GetStrings(int & n)
{
	n=ns;
	return (const char**) stringhe;
}


int CCodeProcessor::AddString(const char * c)
{
  ns++;
  char** str=new char*[ns+1];
  if (!str) {Say(ERR_NOMEM /*Memoria esaurita*/); return -1;}
  if(stringhe) 
  {
	  for(int i=0;i<ns;i++) str[i]=stringhe[i];
	  delete [] stringhe;
  }
  stringhe=str;
  stringhe[ns-1]=new char[strlen(c)+1];
  if (!stringhe[ns-1]) {Say(ERR_NOMEM /*Memoria esaurita*/); return -1;}
  strcpy(stringhe[ns-1],c);
  return 0;
}


void CCodeProcessor::SetVectNumber(int i)
{
	n_vect=i;
}

int CCodeProcessor::GetVectNumber()
{
	return n_vect;
}

const char* Cost::operator =(const char* c)
{
	if (c==NULL) {c=NULL;n=0;return NULL;} 
	if (s) delete[]s; 
	n=strlen(c)+1;
	s=new char[n];
	strcpy(s,c);
	return c;
};

Cost& Cost::operator =(Cost& c)
{
	if (s) delete[]s; 
	n=strlen(c.s)+1;
	s=new char[n];
	strcpy(s,c.s);
	return c;
};


int CCodeProcessor::GetProtoNumber(const char * c)
{
	if (np==0) return -1;
	for(int i=0;i<np;i++)
	{
		if (strcmp(pr[i].nome.n,c)==0) return i;
	}
	return -1;
}
