// CodeProcessor.h: interface for the CCodeProcessor class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CODEPROCESSOR_H__E399A673_1CAB_11D2_941D_000000000000__INCLUDED_)
#define AFX_CODEPROCESSOR_H__E399A673_1CAB_11D2_941D_000000000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "structs.h"
#include <stdio.h>
#include <string.h>

#define INI_FILE	5000
#define END_FILE	5001
#define INI_STR	5002
#define END_STR	5003
#define INI_PROTO	5004
#define END_PROTO	5005
#define INI_NOME	5006
#define END_NOME	5007

#define MAXSTRING 256
#define MAXPARS 10

class Nomi
{
public:
	char* n;
	int offset;
	int size;
	Nomi(int n=MAXSTRING) {Nomi::n=new char[n];};
	~Nomi() {if (n) delete[] n;};
	Nomi& operator = (Nomi& nome);
	Nomi& operator =(const char*);
};

class Cost;

class Protos
{
public:
	int AddIst(istruzione* i, int y);
	int Serialize(int IsReading, FILE * f);
	int *parametri;
	int np;
	Nomi nome;
	int rettype; 
	istruzione * ist;
	int ni;
	Protos(int n=MAXPARS) {parametri=new int[n];np=n;ist=NULL;nv=0;vars=NULL;offs=NULL;nomivars=NULL;};
	~Protos(){DeleteAll();};
	inline DeleteAll();
	Protos & operator = (Protos& p);
	int nv;
	int *vars;
	char** nomivars;
	int *offs;
};

inline Protos::DeleteAll()
{
	if (parametri) delete[] parametri;
	if (ist) delete[] ist;
	if (vars) delete[]vars;
	vars=NULL;
	if (offs) delete[]offs;
	offs=NULL;
	if (nomivars)
	{
		for(int i=0;i<nv;i++)
			if (nomivars[i]!=NULL) delete[]nomivars[i];
		delete nomivars;
		nomivars=NULL;
	}
	nv=0;
	parametri=NULL;
	np=0;
	ist=NULL;
	ni=0;
	return 0;
};


class Cost
{
public:
	char*s;
	int n;
	Cost(const char* c) {if (c==NULL) {s=NULL;n=0;return;} n=strlen(c)+1;s=new char[n];strcpy(s,c);};
	Cost() {s=NULL;n=0;return;};
	~Cost() {if (s) delete[] s;};
	const char* operator =(const char* c);
	Cost& operator =(Cost& c);
	char operator [](int i) {if (i<n &&i>=0)return s[i]; else return 0;}
	const char *operator ()(int i=0) {if (i<n &&i>=0)return s+i; else return NULL;}
};

class CCodeProcessor
{
public:
	int GetProtoNumber(const char* c);
	int GetVectNumber();
	void SetVectNumber(int i);
	Protos* FindProto(int i);
	int AddString(const char* c);
	const char** GetStrings(int& ns);
	Protos* FindProto(const char* c);
	void SetPr(Protos* p, int n);
	int Serialize(int IsReading, FILE * f);
	CCodeProcessor();
	virtual ~CCodeProcessor();

private:
	int Read(FILE * f);
	int Write(FILE * f);
	void DeleteAll();
	char** stringhe;
	int ns;
	Protos *pr;
	int np;
	char** nomi;
	int nn;
	int n_vect;
};

#endif // !defined(AFX_CODEPROCESSOR_H__E399A673_1CAB_11D2_941D_000000000000__INCLUDED_)
