//				LINECOL.CPP
// defining a line collection

#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include "linecol.h"

//constructor for a LineCollection
LineCollection::LineCollection(int maxLineNumber,unsigned int maxMemory)
{
    storage=new char[maxMemory];
    lines=new char*[maxLineNumber];
    lineNr=0;
    maxLineNr=maxLineNumber;
    storageSize=maxMemory;
    bytesUsed=0;
    compact=1;

}

LineCollection::~LineCollection()

{
    delete []storage;
    delete []lines;
}

//moves the lines so they are compact
void LineCollection::makeCompact()
{
    bytesUsed=0;
    for(int i=0;i<lineNr;i++)
	{
	int lineLen=strlen(lines[i])+1;	//the '\0'
	char* newAddress=storage+bytesUsed;

	if(lines[i]>newAddress)
	    //move the line
	    {
	    if(newAddress+lineLen<lines[i])
		//the zones don't overlap
		memcpy(newAddress,lines[i],lineLen);
	    else
		{
		char buffer[MaxLineLength+1];
		memcpy(buffer,lines[i],lineLen);
		memcpy(newAddress,buffer,lineLen);
		}
	    lines[i]=newAddress;
	    }
	bytesUsed+=lineLen;
	}
    //now the storage is fully compacted
    compact=1;
}

//inserting a line at the end of the collection
void LineCollection::insert (char *format,...)

{
    if(lineNr==maxLineNr)
	return;

    va_list argptr;
    static char line[2*MaxLineLength+1];
	//I want to be sure I have enough space

    //translating arguments into a string

    va_start(argptr,format);
    vsprintf(line,format,argptr);
    va_end(argptr);

    int newLineLen;
    newLineLen=strlen(line);
    if(newLineLen>MaxLineLength)
	//don't need all of it
	{
	line[MaxLineLength]='\0';
	newLineLen=MaxLineLength;
	}
    newLineLen++;	//the '\0'
    if((int)newLineLen>(int)(storageSize-bytesUsed))
	//we don't have enough free space right now
	{
	if(compact)
	    return;
	//compacting the storage
	makeCompact();
	if((int)newLineLen>(int)(storageSize-bytesUsed))
	    return;
	}
    lines[lineNr]=storage+bytesUsed;
    lineNr++;
    memcpy(storage+bytesUsed,line,newLineLen);
    bytesUsed+=newLineLen;

}

void LineCollection::insert1 (const char *l)

{
	char* line=(char*)l;
    if(lineNr==maxLineNr)
	return;


    int newLineLen;
    newLineLen=strlen(line);
    if(newLineLen>MaxLineLength)
	//don't need all of it
	{
	line[MaxLineLength]='\0';
	newLineLen=MaxLineLength;
	}
    newLineLen++;	//the '\0'
    if((int)newLineLen>(int)(storageSize-bytesUsed))
	//we don't have enough free space right now
	{
	if(compact)
	    return;
	//compacting the storage
	makeCompact();
	if((int)newLineLen>(int)(storageSize-bytesUsed))
	    return;
	}
    lines[lineNr]=storage+bytesUsed;
    lineNr++;
    memcpy(storage+bytesUsed,line,newLineLen);
    bytesUsed+=newLineLen;

}

//removing a line from somewhwre in the collection
void LineCollection::removeLine(int line)
{
    if(line<lineNr)
	//the line exists so has to be eliminated
	{
	lineNr--;
	while(line<lineNr)
	    {
	    lines[line]=lines[line+1];
	    line++;
	    }
	compact=0;
	}
}

//returns the length of the longest line
int LineCollection::getLongestLine()
{
    int retVal,n;
    for (retVal=n=0;n<lineNr;n++)
	if((int)strlen(lines[n])>(int)retVal)
	    retVal=strlen(lines[n]);
    return retVal;
}

void LineCollection::shrink()
{
    if(lowMem()) return;
    if(maxLineNr!=lineNr)
	{
	char** newLines;
	newLines=new char*[lineNr];
	if(lowMem()) delete []newLines;
	else
	    {
	    memcpy(newLines,lines,lineNr*sizeof(char*));
	    delete []lines;
	    lines=newLines;
	    maxLineNr=lineNr;
	    }
	}
    if(bytesUsed!=storageSize)
	{
	char* newStorage;
	newStorage=new char[bytesUsed];
	if(lowMem()) delete [] newStorage;
	else
	    {
	    memcpy(newStorage,storage,bytesUsed);
	    //reactualising all the pointers
	    for(int i=0;i<lineNr;i++)
		lines[i]=newStorage+(lines[i]-storage);
	    delete []storage;
	    storage=newStorage;
	    storageSize=bytesUsed;
	    }
	}
}

void LineCollection::print()
{
    int n;
    for(n=0;n<getLineCount();n++)
	{
		printf("%s\n",line(n));
	}
}
