//				LINECOL.H
//Header file for linecol.cpp

#if !defined( __LINECOL_H )
#define __LINECOL_H

//maximal length for lines from a collection
#define MaxLineLength 250
#include <string.h>
//a line collection will contain lines of text to be displayed in windows
class LineCollection
{
protected:
    char* storage;	//here we hold the lines
    char** lines;	//here an array of pointers to the lines (in storage)
    unsigned int storageSize;	//the size of the allocated storage
    unsigned int bytesUsed;	//index in storage that points to the end of
				//last allocated block
    int lineNr;		//the current number of lines
    int maxLineNr;	//the maximal number of lines
    int compact;	//indicates if lines are in contiguous memory zones
    void makeCompact();	//moves the lines so they are compact

public:
	void print();

    LineCollection(int maxLineNumber=1000,unsigned int maxMemory=79000);
	//by default the maximal number of lines is 100 and all the lines must
	//fit in 7900 bytes (ScreenWidth=78+'\0')*100
    //inserts a printf-type line in 'lines' (\n is not allowed inside the
    //format argument) and updates scroller limits
    void insert (char *format,...);
    void insert1 (const char *line);
    //removing a line from somewhwre in the collection
    void removeLine(int line);
    //reading a line from the collection
    inline const char* line(int line);
    //clearing all the lines
    void clear(){lineNr=bytesUsed=0;}
    int getLineCount(){return lineNr;}
    int getLongestLine();	//returns the length of the longest line
    //reducing the memory used by the collection to what is absolutelly
    //necessary to hold the present data
    void shrink();
    ~LineCollection();

};

extern int lowMem();

inline const char* LineCollection::line(int line)
{
	int i=0;
	if (line==0)
		for(i=0;i<(int)strlen(lines[0]);i++)
			if((lines[0])[i]!=' ')break;
	return ((const char*)(lines[line]))+i;
}

#endif