// ProtocolVect.cpp: implementation of the ProtocolVect class.
//
//////////////////////////////////////////////////////////////////////

#include "protocolvect.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ProtocolVect::ProtocolVect()
{
	size=0;
	max_el=-1;
	p=NULL;
	p=CreateVect();
}

ProtocolVect::~ProtocolVect()
{
	if (p)
		{
		 for(int i=0;i<=max_el;i++) 
			 if (p[i]) 
				 delete p[i];
		 delete p;
		}
	p=NULL;
}

Protocol** ProtocolVect::CreateVect()
{
    Protocol** t;
	t= new Protocol*[20+size];
	int i;
	if (t) 
	{
		for(i=0;i<size;i++)
			t[i]=p[i];
		for(i=size;i<20+size;i++)
			t[i]=NULL;
		size+=20;
		if (p) delete[] p;
		p=t;
	}
	return t;
}

Protocol& ProtocolVect::operator [ ](int &n)
{
	if (n<=0) n=0;
	if (max_el<0) Insert();
	if (n>max_el) {Insert();n=max_el;}
	return *p[n];
}

void ProtocolVect::Insert()
{
	if (p==NULL) CreateVect();
	max_el++;
	if(max_el>=size) CreateVect();
	p[max_el]=new Protocol;
}

void ProtocolVect::ClearVisited()
{
	for(int i=0;i<max_el;i++) p[i]->SetVisited(0);
}

int ProtocolVect::FindProto(const char * c)
{
	int i;
	for(i=0;i<=max_el;i++)
	{
		if (strcmp((*p[i]).GetName(),c)==0)
			return i;
	}
	return -1;
}

int ProtocolVect::GetSize()
{
	return max_el+1;
}
