#ifndef __STACK_CL
#define __STACK_CL
#include <stdio.h>
#include "vec_cl.h"
#include "except.h"

template<class T> class stack
{
    private:
     int sp;
     vector<T> v;
    public:
     stack(){sp=0;};
     void push(T t){v[sp]=t;sp++;};
     T& pop() {if(sp==0) throw stack_underflow();--sp;return v[sp];};
     T& get_top() {return v[sp-1];};
     inline T& get_el(int i) {if (!((i>=0)&&(i<sp)))
           throw out_of_index();return v[i]; };
     int n_el() {return sp;};
     int n_max_el() {return sp-1;};
};

#endif
