#ifdef _CONSOLE
#ifndef CONSOLE
#define CONSOLE
#endif
#endif

#include <stdio.h>
#include "linecol.h"
#include "string_l.h"
#include "cmdline.h"
#ifdef WIN32
#include <conio.h>
#endif

#ifndef ENGLISH
#define ERR_PAUSE "Premere un tasto per continuare"
#else
#define ERR_PAUSE "Press a key to continue"
#endif

int progress=0;

int lowMem()
{
	int* c=new int[1];
	if (c==NULL) return 1;
	delete []c;
	return 0;
}

#include "asksay.h"

#if defined WIN32 && !defined CONSOLE
CQueryDlg* cdlg;
int oldp;
int silent;

void reportProgress(int dir)
{
    if(oldp==dir) return;
	oldp=dir;
	if(cdlg) cdlg->SendMessage(WM_PAINT,0,0);
	if(!silent) cdlg->Step(dir);
}

#else

void reportProgress(int dir)
{
}

#endif

// writes the line collection to stdout
#if (defined WIN32 && defined CONSOLE) || !defined WIN32
int rows=25,cols=80,likemore=1;
#endif

void pr(LineCollection* lc)
{
    int n;
#if (defined WIN32 && defined CONSOLE) || !defined WIN32
	int l, r=0,t;
#endif
	const char* tmp;
    for(n=0;n<lc->getLineCount();n++)
	{
		tmp=lc->line(n);
#if (defined WIN32 && defined CONSOLE) || !defined WIN32
		if(likemore)
		{
		 l=strlen(tmp)+1;
		 r += l/cols;
		 if (l%cols) r++;
		 if (r>=rows-1)
		 {
			r=0;
			printf(ERR_PAUSE /*Premere un tasto per continuare*/);
#ifdef WIN32
			t=_getch();
#else
			fflush(stdin);
			t=getchar();
			fflush(stdin);
#endif
			if(t!='\n') puts("\n");
		 }
		}
#endif
#ifndef WIN32
		Say(tmp);
#else
		printf("%s\n",(char*)tmp);
#endif
	}
}

#ifdef WIN32
#ifndef CONSOLE
string output;
#define pr(A)
#endif
#endif
extern processCmdLine *p;

string *Lc2String(LineCollection &lc,string &c,BOOL asterisk,BOOL cronly)
   {
    int n;
    c.Empty();
    string t;
	if (cronly) t="\n";
	 else t=CRLF;
    for(n=0;n<lc.getLineCount();n++)
	{
     if (asterisk)c+="*";
     c+=lc.line(n);
     c+=t;
	}
	return &c;
   }
