#ifndef __VEC_CL
#define __VEC_CL
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "except.h"

#define max_int(y,z) ((y)<(z))?(y):(z)

template<class T> class vector
{
  protected:
    T *t;
    int dim,distr;
    int max_el;
    int step;
    void expand(int i);
    T* alloca_vect(int d){return new T[d];}
  public:
    inline ~vector () 
	{
		if((distr)&&(t!=NULL))
			delete[] t;
	}
#ifdef LINUX	
    crea_vector (int d,int st,int dist);
    vector (int d=20,int st=10,int dist=1){crea_vector(d,st,dist);}
#else
    vector (int d=20,int st=10,int dist=1);
#endif
    inline void* to_void_p(int& n_el) 
     {void* q;n_el=max_el+1; q=(void*)t;t=NULL;max_el=0;return q;}
    int get_dim() {return dim;}
    virtual void empty();
    virtual int get_n_el() {return max_el+1;}
    virtual operator T* () {return t;}
    virtual T& operator[](int i)
        {
         if ((i<0)||(t==NULL)) 
	 {
	  throw out_of_index();
	 }
            else
             if (i>=dim) //espande il vettore
               {expand(i); }
         if (i>max_el) max_el = i;
         return t[i];
        }
};

template<class T> void vector<T>::expand(int i)
              {
	          T* q;
                  q=new T[(i+this->step)];
                    if (q==NULL)
                        {
                          i=0;
                          throw no_mem();
                        }
                      else
                        {
                  	  memset((char*)q,0,(i+step)*sizeof(T));
                          max_el=i;
                          for (int y=0;y<dim;y++) q[y]=this->t[y];
                          dim=i+step;
                          delete[] this->t;
                          this->t=q;
                        }
		 return;
               }
       
#ifndef LINUX
#define crea_vector vector
#endif

template<class T> vector<T>:: crea_vector (int d,int st,int dist)
     {
      t=alloca_vect(d);
      memset((char*)t,0,d*sizeof(T));
      dim=d;
      if (st>0) step=st; 
       else step=1;
      max_el=-1;
      distr=dist;
     }

template<class T> void vector<T>::empty() 
{
	max_el=-1;
	if (dim>step) delete[]t;
	t=new T[step];
	if(t)dim=step; else dim=0;
} 

#endif
