#include <string.h>
#include <stdio.h>
#include <stdlib.h>

char* TrimStr(char* t); 

#ifndef ENGLISH
#define ERR_CFG "Configurazione dei tipi in corso.\n"
#define ERR_DST "Impossibile aprire il file destinazione.\n"
#define ERR_1 "Impossibile determinare automaticamente un tipo la cui dimensione sia un byte.\n"
#define ERR_2 "Tale tipo deve essere senza segno.\n"
#define ERR_3 "Prego inserire un tipo C appropriato: "
#define ERR_4 "Impossibile determinare automaticamente un tipo la cui dimensione sia di due byte.\n"
#define ERR_5 "Impossibile determinare automaticamente un tipo la cui dimensione sia di quattro byte.\n"
#define ERR_6 "Impossibile determinare automaticamente un tipo la cui dimensione sia di quattro byte.\n"
#define ERR_7 "Tale tipo deve essere con segno.\n"
#else
#define ERR_CFG "Type configuration in progress...\n"
#define ERR_DST "Unable to open destination file.\n"
#define ERR_1 "Unable to determine a type whoose dimension is 1 byte.\n"
#define ERR_2 "This type must be unsigned.\n"
#define ERR_3 "Please insert a C Type: "
#define ERR_4 "Unable to determine a type whoose dimension is 2 byte.\n"
#define ERR_5 "Unable to determine a type whoose dimension is 4 byte.\n"
#define ERR_6 "Unable to determine a type whoose dimension is 4 byte.\n"
#define ERR_7 "This type must be signed.\n"
#endif

int main(int argc, char**argv)
{
	FILE* out;
	char t[100];
	char *q;
	printf(ERR_CFG /*Configurazione dei tipi in corso.\n*/);
	if (argc>=2) q=argv[1]; else q="config.h";
	out=fopen (q,"w");
	if (!out) {fprintf(stderr,ERR_DST /*Impossibile aprire il file destinazione.\n*/);exit(1);}
	if (sizeof(unsigned char)==1) fprintf(out,"#define TUBYTE unsigned char\n");
	else if (sizeof(unsigned short)==1) fprintf(out,"#define TUBYTE unsigned short\n");
	else 
	{
	 do 
	 {
	  fprintf(stderr,ERR_1 /*Impossibile determinare automaticamente un tipo la cui dimensione sia un byte.\n*/);
	  fprintf(stderr,ERR_2 /*Tale tipo deve essere senza segno.\n*/);
	  fprintf(stderr,ERR_3 /*Prego inserire un tipo C appropriato: */);
	  fgets(t,98,stdin);
	  q=TrimStr(t);
	 } while (strlen(q)==0);
	 fprintf(out,"#define TUBYTE %s\n",q);
	}
	if (sizeof(unsigned short)==2) fprintf(out,"#define TWORD unsigned short\n");
	else if (sizeof(unsigned int)==2) fprintf(out,"#define TWORD unsigned int\n");
	else 
	{
	 do 
	 {
	  fprintf(stderr,ERR_4 /*Impossibile determinare automaticamente un tipo la cui dimensione sia di due byte.\n*/);
	  fprintf(stderr,ERR_2 /*Tale tipo deve essere senza segno.\n*/);
	  fprintf(stderr,ERR_3 /*Prego inserire un tipo C appropriato: */);
	  fgets(t,98,stdin);
	  q=TrimStr(t);
	 } while (strlen(q)==0);
	 fprintf(out,"#define TWORD %s\n",q);
	}
	if (sizeof(unsigned int)==4) fprintf(out,"#define TDWORD unsigned int\n");
	else if (sizeof(unsigned long)==4) fprintf(out,"#define TDWORD unsigned long\n");
	else 
	{
	 do 
	 {
	  fprintf(stderr,ERR_5 /*Impossibile determinare automaticamente un tipo la cui dimensione sia di quattro byte.\n*/);
	  fprintf(stderr,ERR_2 /*Tale tipo deve essere senza segno.\n*/);
	  fprintf(stderr,ERR_3 /*Prego inserire un tipo C appropriato: */);
	  fgets(t,98,stdin);
	  q=TrimStr(t);
	 } while (strlen(q)==0);
	 fprintf(out,"#define TDWORD %s\n",q);
	}
	if (sizeof(signed int)==4) fprintf(out,"#define TSDWORD int\n");
	else if (sizeof(signed long)==4) fprintf(out,"#define TSDWORD long\n");
	else 
	{
	 do 
	 {
	  fprintf(stderr,ERR_6 /*Impossibile determinare automaticamente un tipo la cui dimensione sia di quattro byte.\n*/);
	  fprintf(stderr,ERR_7 /*Tale tipo deve essere con segno.\n*/);
	  fprintf(stderr,ERR_3 /*Prego inserire un tipo C appropriato: */);
	  fgets(t,98,stdin);
	  q=TrimStr(t);
	 } while (strlen(q)==0);
	 fprintf(out,"#define TSDWORD %s\n",q);
	}
	fclose (out);
	return 0;
}

char* TrimStr(char* t)
{
 char* q;
 unsigned int i;
 for(i=0; i<strlen(t);i++)
	 {
	  q=t+i;
	  if (t[i]!=' ' && t[i]!='\t' && t[i]!='\r' && t[i]!='\n') break;
	 }
 for(i=strlen(q)-1; i>=0;i=strlen(q)-1)
	 {
	  if (q[i]!=' ' && q[i]!='\t' && q[i]!='\r' && q[i]!='\n') break;
		else q[i]='\0';
	 }
 return q;
}
