// HTST.cpp 
//
#if defined WINDOWS
#include "stdafx.h"
#endif

#include <stdlib.h>
#include <string.h>
#include "hashtable.h"

ini_hashtable::~ini_hashtable() 
{ 
  int i;
  ht_entry *t,*ot;
  for(i=0; i<dp.size; ++i)
   {
    t=dp.buckets[i];
    while (t != NULL) 
      {
       delete [] t->key;
	   if (recursive && t->info) delete t->info;
	   ot=t->next;
       delete t;
       t=ot;
      }
   }
  delete []dp.buckets; 
}

long ini_hashtable::hashpjw(const char* p)
{
  unsigned long h=0,g;
  for( ; *p; ++p )
  {
    h = (h << 4) + *p;
    if( (g = (h & 0xf0000000)) )
	{
      h = h ^ (g >> 24);
      h = h ^ g;
    }
  }
  return h % dp.size;
}

ini_hashtable::ht_entry** ini_hashtable::h_lookup(const char* key, long &kp)
{
  ini_hashtable::ht_entry** epp;

  kp=hashpjw(key);
  if(dp.buckets[kp] == NULL) return NULL;

  epp = &(dp.buckets[kp]);

  while(*epp)
  {
    if(strcmp((*epp)->key,key) == 0)
	{
      return epp;
    }
    epp = &((*epp)->next);
  }
  return NULL;
}

char* ini_hashtable::insert(const char* key, ini_hashtable* info,char* t)
{
  long k;
  ini_hashtable::ht_entry** epp;
  ini_hashtable::ht_entry* ep;

  epp = h_lookup(key,k);

  if(epp==NULL)
  {
    ep=new ht_entry;
    memset((char*)ep,0,sizeof(ht_entry));
    if (ep==NULL) return NULL;
    ep->next=dp.buckets[k];
    char* t1=new char[strlen(key)+1];
    strcpy(t1,key);
    ep->key=t1;
    ep->info=info;
	if (t==NULL) ep->type=NULL;
	else { ep->type=new char[strlen(t)+1]; strcpy(ep->type,t);}
	ep->nuse=1;
    dp.buckets[k]=ep;
    return ep->key;
  }
  ep=*epp;
  ep->nuse++;
  return ep->key;
}

ini_hashtable* ini_hashtable::lookup(const char* key,char*& t)
{
  long k;
  ini_hashtable::ht_entry** epp;

  epp = h_lookup(key,k);

  if(epp!=NULL)
  {
    t=(*epp)->type;
    return (*epp)->info;
  }
  t=0;
  return NULL;
}

ini_hashtable* ini_hashtable::sost_type(char* key,char*& t)
{
  long k;
  ini_hashtable::ht_entry** epp;

  epp = h_lookup(key,k);

  if(epp!=NULL)
  {
    if ((*epp)->type) delete (*epp)->type;
	if (t==NULL) (*epp)->type=NULL;
	else { (*epp)->type=new char[strlen(t)+1]; strcpy((*epp)->type,t);}
    return (*epp)->info;
  }
  return NULL;
}

ini_hashtable* ini_hashtable::del(const char* key)
{
  long k;
  ini_hashtable::ht_entry** epp,*t;

  epp = h_lookup(key,k);

  if(epp!=NULL)
  {
    ((*epp)->nuse)--;
	if ((*epp)->nuse) return (*epp)->info;
    if ((*epp)->key) delete [] (*epp)->key;
    if ((*epp)->type) delete [] (*epp)->type;
    ini_hashtable* info=(*epp)->info;
	t=*epp;
    *epp = (*epp)->next;
    delete t;
    return info;
  }
  return NULL;
}

ini_hashtable* ini_hashtable::first(char* &key,char*& t)
{
  int i;
  for(i=0; i<dp.size; ++i)
  {
    dp.current=dp.buckets[i];
    if(dp.current != NULL)
	{
      dp.base=i;
      t=dp.current->type;
      key=dp.current->key;
      return dp.current->info;
    }
  }
  t=0;
  return NULL;
}

ini_hashtable* ini_hashtable::next(char* &key,char*& t)
{
  if(dp.current == NULL) return NULL;
  dp.current=(dp.current)->next;
  if(dp.current!=NULL)
  {
    t=dp.current->type;
    key=dp.current->key;
    return dp.current->info;
  }
  dp.base++;
  while(dp.base < dp.size)
  {
    dp.current=dp.buckets[dp.base];
    if(dp.current != NULL)
	{
      t=dp.current->type;
      key=dp.current->key;
      return dp.current->info;
    }
    dp.base++;
  }
  t=0;
  return NULL;
}

