#ifndef __HTST_H
#define __HTST_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

class ini_hashtable
 {
  protected:
   struct ht_entry
   {
    char* key;
    ini_hashtable* info;
    char* type;
    struct ht_entry* next;
	int nuse;
   };

   struct ht_descriptor
   {
    long size;
    ht_entry* current;
    long base;
    ht_entry** buckets;
   } dp;

   int recursive;
   long hashpjw(const char* p);
   ht_entry** h_lookup(const char* key, long &kp);
  public:
    // Create a hash table and returns a handle
   inline ini_hashtable(int size=211,int rec=0);
    // Destroy a hash table given its handle
   ~ini_hashtable();
    // Insert an element into an hash table given its handle
    // returns: 1 when OK, -1 on error and 0 when already present
   char* insert(const char* key, ini_hashtable* info,char* t=NULL);
    // Search and element in a hash table given the table's handle
    // and the key of the element
   ini_hashtable* lookup(const char* key,char*& t);
    // Change the type
   ini_hashtable* sost_type(char* key,char*& t);
    // Delete an element from the hash table
   ini_hashtable* del(const char* key);
    // Get first element for a table scan
   ini_hashtable* first(char*&key,char*& t);
    // Get next element for a table scan
   ini_hashtable* next(char*&key,char*& t);
 };

inline ini_hashtable::ini_hashtable(int size,int rec)
{
    recursive=rec;
    dp.size = size;
    dp.current=NULL;
    dp.buckets = new ht_entry*[size];
    memset ((char*)dp.buckets,0,sizeof(ht_entry*)*size);
}

#endif