// IniProcesser.cpp: implementation of the CIniProcesser class.
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include "iniprocesser.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CIniProcesser::CIniProcesser(const char* FileName, int NoHash)
{
	h=NULL;
	fn=NULL;
	if(FileName) OpenIni(FileName);
	Modified=0;
	cur=NULL;
	if (!f) return;
	if (!NoHash) 
	  {
		h=new ini_hashtable(211,1);
		CreateHash();
	  }
}

CIniProcesser::~CIniProcesser()
{
	if (Modified) SaveHash();
	if (fn) delete [] fn;
	if (f) fclose (f);
}


int CIniProcesser::OpenIni(const char* FileName)
{
	if (FileName)
	{
	 f=fopen(FileName,"r+");
	 if (f!=NULL) 
		{
			if (fn) delete[] fn;
			fn=new char[strlen(FileName)+1];
			strcpy(fn,FileName);
			return 1;
		}
		else fn=NULL;
	}
	return 0;
}

const char* CIniProcesser::SearchFromFile(const char * group, const char * voce)
{
	static char t[1000];
	char *h,*y;
	if (group==NULL || voce==NULL) return NULL;

	if (f==NULL) return NULL;
	fseek(f,0,SEEK_SET);
	while (h=fgets(t,998,f))
		{
		TrimStr(h);
		if (h[0]!='[' && h[strlen(h)-1]!=']') continue;
			h[strlen(h)-1]='\0';
			h++;
			if (strcmp(h,group)) continue;
			/* group found */
			while (h=fgets(t,998,f))
			{
				TrimStr(h);
				if (h[0]=='[') break;
				y=NULL;
				for (int i=0;i<(signed)strlen(h);i++)
					if (h[i]=='=') {h[i]='\0'; y=h+i+1; TrimStr(h); TrimStr(y);break;}
				if(y!=NULL && strcmp(h,voce)==0) return y;
			}
		}
	return NULL;
}

void CIniProcesser::TrimStr(char * h)
{
	while(h[0]=='\t' || h[0]==' '|| h[0]=='\r' || h[0]=='\n') h++;
	while(h[strlen(h)-1]=='\t' || h[strlen(h)-1]==' '|| 
		  h[strlen(h)-1]=='\r' || h[strlen(h)-1]=='\n') 
		h[strlen(h)-1]='\0';
}

int CIniProcesser::CreateHash()
{
	static char t[1000];
	char *hh,*y;
	char def[1000];
	char * val;
	ini_hashtable* ih;

	if (f==NULL) return -1;
	strcpy(def,"DEFAULT");
	if (CIniProcesser::h) delete (h);
	CIniProcesser::h = new ini_hashtable;
	if (CIniProcesser::h==NULL) return -1;
	fseek(f,0,SEEK_SET);
	while (hh=fgets(t,998,f))
		{
			TrimStr(hh);
			if (hh[0]!='[' && hh[strlen(hh)-1]!=']') 
			{
			 ih=CIniProcesser::h->lookup(def,val);
				if (ih==NULL)
				{
					ih=new ini_hashtable();
					CIniProcesser::h->insert(def,ih,NULL);
				}
			 for (int i=0;i<(signed)strlen(hh);i++)
				if (hh[i]=='=') {hh[i]='\0'; y=hh+i+1; TrimStr(hh); TrimStr(y);break;}
				if(y!=NULL)
				{
					ih->lookup(hh,val);
					if(val==NULL) ih->insert(hh,NULL,y);
					 else ih->sost_type(hh,y);
				}
			}
			else
			{
				hh[strlen(hh)-1]='\0';
				hh++;
				strcpy(def,hh);
			}
		}
	return 1;
}

int CIniProcesser::SaveHash()
{
	if (f==NULL|| h==NULL) return -1;
	fclose (f);
	f=fopen (fn,"w");
	fseek(f,0,SEEK_SET);
	ini_hashtable *ih;
	char* k,*g;
	ih=h->first(k,g);
	for(;;)
	{
		if (ih)
		{
			fprintf(f,"[%s]\n",k);
			ih->first(k,g);
			while(g!=NULL)
			{
				fprintf(f,"%s=%s\n",k,g);
				ih->next(k,g);
			}
		} else break;
		ih=h->next(k,g);
	}
	fclose (f);
	f=fopen (fn,"r");
	Modified=0;
	return 1;
}

const char* CIniProcesser::Search(const char * gruppo, const char * voce)
{
	if (f==NULL) return NULL;
	if (h==NULL) return SearchFromFile(gruppo,voce);
	ini_hashtable *ih;
	char *g=NULL;
	ih=h->lookup(gruppo,g);
	if (ih)
		{
			ih->lookup(voce,g);
			return g;
		} 
	return NULL;
}

int CIniProcesser::Insert(const char * gruppo, const char * voce, const char * valore)
{
	char* val;
	if (f==NULL|| h==NULL) return -1;
	ini_hashtable *ih;
	ih=CIniProcesser::h->lookup(gruppo,val);
		if (ih==NULL)
				{
					ih=new ini_hashtable();
					CIniProcesser::h->insert(gruppo,ih,NULL);
				}
	if(ih==NULL) return 0;
	ih->lookup(voce,val);
	if(val==NULL) ih->insert((char*)voce,NULL,(char*)valore);
		else ih->sost_type((char*)voce,(char*&)valore);
	Modified=1;
	return 1;
}

int CIniProcesser::SaveHashAs(const char * fname)
{
	if(fname==NULL) return -1;
	FILE* nf;
	nf=fopen(fname,"w");
	if (nf==NULL ) return -1;
	fclose (nf);
	if (fn) delete[] fn;
	fn=new char[strlen(fname)+1];
	strcpy(fn,fname);
	return SaveHash();
}

int CIniProcesser::GetIniOpened()
{
	if (f==NULL) return 0;
	return 1;
}


const char* CIniProcesser::GetFirst(const char * gruppo,char *& voce)
{
	if (f==NULL) return NULL;
	if (!h) CreateHash();
	if (!h) return NULL;
	char *g;
	cur=h->lookup(gruppo,g);
	if (cur)
		{
			char* tmp=(char*)voce;
			cur->first(tmp,g);
			voce=tmp;
			return g;
		} 
	return NULL;
}

const char* CIniProcesser::GetNext(char *& voce)
{
	if (f==NULL) return NULL;
	if (!h) CreateHash();
	if (!h) return NULL;
	char *g;
	if (cur)
		{
			cur->next(voce,g);
			return g;
		} 
	return NULL;
}
