// IniProcesser.h: interface for the CIniProcesser class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_INIPROCESSER_H__A9CA4165_10DC_11D2_93FD_000000000000__INCLUDED_)
#define AFX_INIPROCESSER_H__A9CA4165_10DC_11D2_93FD_000000000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "hashtable.h"

class CIniProcesser  
{
public:
	const char* GetFirst(const char * g,char *& voce);
	const char* GetNext(char *& voce);
	int GetIniOpened();
	int SaveHashAs(const char* fname);
	const char* Search(const char* gruppo,const char* voce);
	int SaveHash();
	int Insert(const char * gruppo, const char * voce, const char * valore);
	int CreateHash();
	void TrimStr(char * s);
	const char* SearchFromFile (const char* group, const char* voce);
	int OpenIni(const char* FileName);
	CIniProcesser(const char* FileName=NULL, int NoHash=0);
	virtual ~CIniProcesser();

private:
	int Modified;
	ini_hashtable *h;
	ini_hashtable *cur;
	FILE* f;
	char* fn;
};

#endif // !defined(AFX_INIPROCESSER_H__A9CA4165_10DC_11D2_93FD_000000000000__INCLUDED_)
