#include <stdio.h>
#include <stdlib.h>

extern FILE* yyin;
extern int yyparse();
FILE* out;
extern int errorflag;
extern int macrocomp;

#ifdef YYDEBUG
extern int yydebug;
#endif

int OpenPDesc(const char* c);

#ifndef ENGLISH
#define ERR_PARS "Erano attesi 3 parametri"
#define ERR_IN "Impossibile aprire il file di Input %s\n"
#define ERR_OUT "Impossibile aprire il file di Output %s\n"
#define ERR_PDF "Impossibile aprire il file di descrizione dei protocolli %s\n"
#define ERR_CMP "Compilazione del file \"%s\" in corso...\n"
#else
#define ERR_PARS "3 parameters required"
#define ERR_IN "Unable to open Input file %s\n"
#define ERR_OUT "Unable to open Output file %s\n"
#define ERR_PDF "Unable to open PDO file %s\n"
#define ERR_CMP "Compilation: \"%s\". Please wait...\n"
#endif

int main (int argc,char**argv)
{
	if (argc!=4 && argc!=3) 
		{printf(ERR_PARS /*Erano attesi 3 parametri*/);exit(-1);}
	yyin=fopen(argv[1],"r");
	if(yyin==NULL) {printf(ERR_IN /*Impossibile aprire il file di Input %s\n*/,argv[1]);return 1;}
	out=fopen(argv[2],"wb");
	if(out==NULL) {printf(ERR_OUT /*Impossibile aprire il file di Output %s\n*/,argv[2]);return 1;}
	if (argc==4)
	{
	 if(OpenPDesc(argv[3]))
		{printf(ERR_PDF /*Impossibile aprire il file di descrizione dei protocolli %s\n*/,argv[3]);return 1;}
	 macrocomp=0;
	} else macrocomp=1;
	printf(ERR_CMP /*Compilazione del file \"%s\" in corso...\n*/,argv[1]);
#ifdef YYDEBUG
	yydebug=1;
#endif
	yyparse();
	if(out) fclose(out);
	if(yyin) fclose(yyin);
	if (errorflag) return 1; else return 0;
}
