#ifndef lint
static char yysccsid[] = "@(#)yaccpar	1.8 (Berkeley) 01/20/90";
#endif
#define YYBYACC 1
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <time.h>

#include "tipi.h"
#include "../../comuni/vec_cl.h"
#include "../../comuni/stack_cl.h"
#include "../../comuni/protocol.h"
#include "../../comuni/protocolvect.h"

#ifdef Say
#undef Say
#define Say(A) printf("%s\n",A)
#endif

#ifndef ENGLISH
#define ERR_FILEN "Nome di file errato"
#define ERR_SRC "Impossibile aprire il file sorgente"
#define ERR_FILE "File errato"
#define ERR_DIM "Errore di dimensione non nota"
#define ERR_VAR "Impossibile accedere ad una variabile non definita"
#define ERR_ARRAY "Array non definito"
#define ERR_ISTNMAC "Istruzione non valida in una macro"
#define ERR_ISTMAC "Istruzione valida solo in una macro"
#define ERR_FUNZ "Chiamata di funzione non definita"
#define ERR_PARS "Numero di parametri incompatibile"
#define ERR_TOOPARS "Troppi parametri per la funzione"
#define ERR_SAVEMAC "Impossibile salvare la macro compilata"
#define ERR_SAVE "Impossibile salvare il file compilato"
#define ERR_NOOBJ "Codice oggetto non generato a causa degli errori riscontrati."
#define ERR_RIDF "Ridefinizione di funzione"
#define ERR_NOPROT "Manca un tipo nel prototipo. Si assumer DWORD."
#define ERR_VARRID "Ridefinizione di variabile"
#define ERR_CAST "I tipi vengono automaticamente convertiti a DWORD"
#define ERR_DO "Errore nel do"
#define ERR_WHILE "Errore nel while"
#define ERR_IF "Errore nell'if"
#define ERR_FOR "Errore nel for"
#define ERR_FUNCP "errore nella funzione o nel prototipo"
#define ERR_TITLE "L'istruzione 'title' non vuole parametri"
#define ERR_GRAF "Possibile mancanza di una graffa chiusa"
#define ERR_LINE "Errore di analisi del sorgente alla linea %d\n%s\n"
#define ERR_WARNLINE "Warning alla linea %d.\n%s\n"
#define ERR_RIDEFVAR "Ridefinizione di variabile"
#else
#define ERR_FILEN "Wrong file name"
#define ERR_SRC "Unable to open source file"
#define ERR_FILE "Bad file"
#define ERR_DIM "Unknown dimension"
#define ERR_VAR "Unable to access undefined variable"
#define ERR_ARRAY "Undefined Array"
#define ERR_ISTNMAC "Invalid Instruction in macro"
#define ERR_ISTMAC "Instruction valid only in macros"
#define ERR_FUNZ "Function not defined"
#define ERR_PARS "Wrong parameter number"
#define ERR_TOOPARS "Too many parameters for function"
#define ERR_SAVEMAC "Unable to save compiled macro"
#define ERR_SAVE "Unable to save compiled file"
#define ERR_NOOBJ "Errors detected. Object code not generated."
#define ERR_RIDF "Function ridefinition"
#define ERR_NOPROT "Type absenbt in prototype. Assuming DWORD."
#define ERR_VARRID "Variable ridefinition"
#define ERR_CAST "Types are automatically converted to DWORD"
#define ERR_DO "Error in do"
#define ERR_WHILE "Error in while"
#define ERR_IF "Error in if"
#define ERR_FOR "Error in for"
#define ERR_FUNCP "Error in function or prototype"
#define ERR_TITLE "Title instruction don't need any parameter"
#define ERR_GRAF "Expected '}'"
#define ERR_LINE "Error analyzing source in line %d\n%s\n"
#define ERR_WARNLINE "Warning in line %d.\n%s\n"
#define ERR_RIDEFVAR "Variable ridefinition"
#endif

extern void EndParsing();
extern int yylex();
extern char* yytext;
extern FILE* out;
extern FILE* yyin;

int errorflag=0;
vector <Cost> costanti;
int nc=0;
vector <Nomi> scope;
int nv=0;
vector <Protos> prototipi;
int np=0;
int cp;
vector <istruzione> ist;
int i_ind;
vector <char*> vect;
int v_ind=0;

int macrocomp=0;

stack <int> labi;
stack <int> labf;
stack <int> labt;
vector <int> lab;
int nl=0;
int l_ind=0;
Protos prot_temp;
static int i;
Nomi ext_nome;
ProtocolVect proto;
int num_pr;
int num_var_pr;
time_t Pdo_time;
int Pdo_Id;

int OpenPDesc(const char* c)
{
	FILE* yyin;

	if (c==NULL) {Say(ERR_FILEN /*Nome di file errato*/);return -1;}
	yyin=fopen(c,"rb");
	if (yyin==NULL) {Say(ERR_SRC /*Impossibile aprire il file sorgente*/);return -1;}
	int i;
	fread(&i,sizeof(int),1,yyin);
	if(i!=MAGIC_PDF) {Say(ERR_FILE /*File errato*/);return -1;}
	fread(&Pdo_time,sizeof(time_t),1,yyin);
	fread(&Pdo_Id,sizeof(int),1,yyin);
	fread(&num_pr,sizeof(int),1,yyin);
	if (num_pr<0) {Say(ERR_FILE /*File errato*/);return -1;}
	for(i=0;i<num_pr;i++)
	{
	  proto[i].Serialize(1,yyin);
	}
	if (yyin)fclose (yyin);
	return 0;
}

int FindProto(const char* nome)
{
	int i;
	for(i=0;i<num_pr;i++)
		if (strcmp(nome,proto[i].GetName())==0) return i;
	return -1;
}

void ParseString(char* text)
{
	int l=strlen(text);
	char* n=new char[strlen(text)+1];
	int i,j,k;
	for(i=0,j=0;i<=l;i++)
	 if (text[i]!='\\') {n[j]=text[i];j++;}
	 else
	 {
	   i++;
	   if (text[i]!='a') {n[j]='\a';j++;}
	   else if (text[i]!='b') {n[j]='\b';j++;}
	   else if (text[i]!='f') {n[j]='\f';j++;}
	   else if (text[i]!='n') {n[j]='\n';j++;}
	   else if (text[i]!='r') {n[j]='\r';j++;}
	   else if (text[i]!='t') {n[j]='\t';j++;}
	   else if (text[i]!='v') {n[j]='\v';j++;}
	   else if (text[i]!='\\') {n[j]='\\';j++;}
	   else if (text[i]!='\?') {n[j]='\?';j++;}
	   else if (text[i]!='\'') {n[j]='\\';j++;}
	   else if (text[i]!='\"') {n[j]='\"';j++;}
	   else if (text[i]!='x') 
	   {
	    n[j]=0;
		for(k=0;k<2;k++)
		if (text[i+1]>='0' && text[i+1]<='9') {i++;n[j]=(n[j]<<k*4)+text[i]-'0';}
		else if (text[i+1]>='a' && text[i+1]<='f') {i++;n[j]=(n[j]<<k*4)+text[i]-'a'+10;}
		else if (text[i+1]>='A' && text[i+1]<='F') {i++;n[j]=(n[j]<<k*4)+text[i]-'A'+10;}
		else break;
		j++;
	   }
	   else
	   {
	    n[j]=0;
		for(k=0;k<3;k++)
		if (text[i+1]>='0' && text[i+1]<='7') {i++;n[j]=(n[j]<<k*3)+text[i]-'0';}
		else break;
		j++;
	   }
	 }
	for(i=0;i<j;i++)
	 text[i]=n[i];
	delete[]n;
}

p_struct * FindPrVar(const char* p, const char* v, int& pr)
{
	if(!p||!v) return NULL;
	pr=FindProto(p);
	if(pr<0) return NULL;
	p_struct * ps= proto[pr].GetPS(num_var_pr);
	for(pr=0;pr<num_var_pr;pr++)
	 if(strcmp(ps[pr].nome,v)==0)
	 {
	  return ps;
	 }
    return NULL;
}
typedef union {
	 nome n;
	 intero i;
	 prots p;
	} YYSTYPE;
#define NOME 257
#define IF 258
#define DO 259
#define ELSE 260
#define WHILE 261
#define FOR 262
#define RETURN 263
#define BREAK 264
#define CONTINUE 265
#define COMMAND 266
#define STRING 267
#define LIT_CH 268
#define BYTE 269
#define WORD 270
#define DWORD 271
#define SIZEOF 272
#define OFFSETOF 273
#define GETVMVAR 274
#define NUMERO 275
#define COST_STRINGA 276
#define C_H_NUM 277
#define C_O_NUM 278
#define TITLE 279
#define PRINT 280
#define APRINT 281
#define CHECK 282
#define CONV 283
#define CONV16 284
#define CONV24 285
#define CONV32 286
#define ARRAY 287
#define CLEAR 288
#define LEN 289
#define STRLEN 290
#define RESETLOG 291
#define OR 292
#define AND 293
#define EQ 294
#define NOT_EQ 295
#define MIU 296
#define MAU 297
#define LSHIFT 298
#define RSHIFT 299
#define NOT 300
#define MENO_UNARIO 301
#define CH_FUNZ 302
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    2,    2,    2,   14,    3,    3,    3,    3,    4,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,   13,   13,    5,    5,   15,   15,    0,
    0,   17,   17,   17,   17,   18,   20,   20,   20,   16,
   16,   16,   16,   21,    6,    6,    6,   22,   22,   22,
   10,   10,   10,   10,   10,   24,   24,   24,   24,    9,
    8,    7,   11,   12,   29,   25,   25,   30,   26,   26,
   31,   27,   32,   27,   27,   33,   34,   35,   28,   28,
   36,   19,   37,   19,   19,   23,   23,   23,   23,   23,
   23,   23,   23,   23,   23,   23,   23,   23,   23,
};
short yylen[] = {                                         2,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    4,    1,    1,    4,    4,    4,    4,    4,    3,    3,
    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
    3,    3,    3,    3,    2,    2,    1,    4,    4,    4,
    4,    4,    4,    3,    6,    4,    3,    1,    3,    1,
    0,    1,    1,    2,    2,    1,    5,    6,    3,    2,
    1,    4,    3,    2,    2,    3,    2,    2,    1,    1,
    2,    1,    1,    3,    2,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    0,    8,    4,    0,    6,    2,
    0,    6,    0,    9,    2,    0,    0,    0,   12,    2,
    0,    8,    0,    9,    4,    1,    1,    1,    4,    6,
    6,    4,    6,    4,    2,    3,    6,    8,    1,
};
short yydefred[] = {                                      0,
    1,    2,    3,    0,    0,    0,    0,   52,   53,   56,
    4,    0,    0,   54,   55,   59,    0,  105,    0,    0,
   61,    0,   57,    0,   60,    0,    0,    0,   58,    0,
    0,   63,   70,   83,   80,   81,   82,    0,  107,  106,
    0,    8,    0,    0,    0,    5,    6,    7,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   13,   12,    0,    0,
    0,    0,   69,    0,   37,    0,  119,   73,    0,    0,
   72,   76,   77,   78,   79,    0,   62,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   75,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   67,    0,    0,   64,  100,    0,
   90,    0,    0,   95,    0,    0,    0,    0,  102,   68,
   71,    0,    9,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  116,    0,
   19,   74,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   32,   33,   34,    0,   66,    0,
    0,    0,    0,    0,    0,   47,    0,    0,  104,   41,
   38,   39,   40,  109,    0,  112,    0,    0,   14,   15,
   16,   17,   18,  114,   42,   43,    0,    0,    0,   96,
   88,   87,    0,   91,    0,   46,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  110,  111,
  113,  117,    0,    0,   89,    0,    0,    0,    0,   97,
    0,   84,   93,  118,    0,   86,    0,    0,   94,   98,
    0,   99,
};
short yydgoto[] = {                                       5,
   65,   66,   67,  144,   68,   69,   70,   71,   72,   73,
   74,  243,   75,   76,  188,   22,    7,    8,    9,   77,
   78,   79,   80,   81,   82,   83,   84,   85,  213,  224,
  226,  247,  223,  245,  251,   24,   30,
};
short yysindex[] = {                                   -152,
    0,    0,    0, -256,    0, -256, -152,    0,    0,    0,
    0,  -38,   -4,    0,    0,    0,   18,    0,    3, -256,
    0,   20,    0,  -55,    0,   19, -105,  372,    0,  -24,
 -256,    0,    0,    0,    0,    0,    0,  985,    0,    0,
   44,    0,   64,   73,   75,    0,    0,    0,   85,   99,
  106,  108,  110,  116,  123,  128,  129,  140,  144,  149,
  985,  985,  985,  300,  465, -148,    0,    0,  -41,  -29,
  -20,  859,    0,  -16,    0,  -14,    0,    0,  552,   27,
    0,    0,    0,    0,    0,  372,    0,  465, -136, -256,
 -256, -136, -136, -136, -136,  985,  985,  985,  985,  985,
 -256, -256, -256,  905,   -9,    0,    7,    0,  649,  985,
  985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
  985,  985,  985,  985,    0,  151, -256,    0,    0,  985,
    0,  985,  -76,    0,  985,  985,  985,  935,    0,    0,
    0,  733,    0,  152,  154,  156,  160,   80,   86,  162,
   29,   38,   60,   69,   91,  173,  175,  180,    0,  100,
    0,    0,  472,  486,   45,   45,   45,   45,   45,   45,
  204,  204,   -9,   -9,    0,    0,    0,  -39,    0,  112,
  136,  -34,  145,  465,  157,    0,  465,  126,    0,    0,
    0,    0,    0,    0,  985,    0,  985, -256,    0,    0,
    0,    0,    0,    0,    0,    0,  985,    3,  171,    0,
    0,    0,  203,    0,  183,    0,  985,  201,  232,  207,
   -2,   19,  985,  859,  985,  859,  985,  465,    0,    0,
    0,    0,  985,  166,    0,  192,   -7,  465,  432,    0,
  220,    0,    0,    0,  985,    0,  859,  456,    0,    0,
  859,    0,
};
short yyrindex[] = {                                    263,
    0,    0,    0,    0,    0,    0,  282,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  161,    0,
    0,    0,    0,    0,    0,  163,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  224,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  -37,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  226,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1002,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  -32,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  179,   82, 1263, 1270, 1280, 1287, 1293, 1300,
 1140, 1220, 1185, 1243,    0,    0,    0,    0,    0,    0,
    0,  258,    0,  117,    0,    0,  236,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  -28,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  237,    0,    0,
    0,    0,    0,    0,    0,    0,  819,  377,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,
};
short yygindex[] = {                                      0,
 1507,   46,    0,    1,    0,    0,    0,    0,    0,  637,
    0,    0,    0, 1400, -140,  130,    0,  302,  303,   30,
    0,  -35,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,
};
#define YYTABLESIZE 1752
short yytable[] = {                                      10,
   11,  208,  127,   10,   10,   10,   10,   10,   11,   10,
  130,   65,   11,   11,   11,   11,   11,  128,   11,  132,
   16,   10,   10,  135,   10,  138,   65,  124,  109,   10,
   11,   11,  122,   11,  124,   17,   10,  123,  232,  122,
  120,  233,  121,  124,  123,    6,  136,  161,  122,  120,
  142,  121,    6,  123,  218,   10,  219,  114,   19,  115,
   26,   23,   20,   27,   11,  124,  114,   28,  115,  199,
  122,  120,   31,  121,  124,  123,  137,   29,  200,  122,
  120,  124,  121,   89,  123,  141,  122,  120,  114,  121,
  115,  123,  147,  148,  149,  150,  124,  114,   86,  115,
  201,  122,  120,   90,  121,  124,  123,  125,   11,  202,
  122,  120,   91,  121,   92,  123,    1,    2,    3,  114,
  194,  115,   29,  195,   93,   29,  196,  124,  114,  197,
  115,  203,  122,  120,    4,  121,  124,  123,   94,  143,
   29,  122,  120,  207,  121,   95,  123,   96,  124,   97,
  114,   11,  115,  122,  120,   98,  121,   44,  123,  114,
   44,  115,   99,    1,    2,    3,  216,  100,  101,  217,
  210,  114,  124,  115,   29,   44,  211,  122,  120,  102,
  121,  124,  123,  103,  182,  214,  122,  120,  104,  121,
  178,  123,  190,  124,  191,  114,  192,  115,  122,  120,
  193,  121,  124,  123,  114,  198,  115,  122,  120,   44,
  121,  222,  123,  204,   27,  205,  114,   11,  115,   30,
  206,  212,   30,   20,  240,  114,  129,  115,  124,    1,
    2,    3,  241,  122,  120,  131,  121,   30,  123,  134,
  124,  229,  225,  227,  217,  122,  120,  231,  121,  215,
  123,  114,  242,  115,   10,   10,   10,   10,   10,   10,
   10,   10,   51,   11,   11,   11,   11,   11,   11,   11,
   11,   30,  230,   18,   11,  217,   48,   49,  246,   48,
   49,   50,  108,  101,  115,  103,    1,    2,    3,  110,
  111,  112,  113,  116,  117,  118,  119,   85,  110,  111,
  112,  113,  116,  117,  118,  119,    0,  209,   14,   15,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  110,  111,  112,  113,  116,  117,  118,  119,    0,  110,
  111,  112,  113,  116,  117,  118,  119,    0,    0,   63,
    0,    0,  118,  119,   61,    0,    0,    0,    0,    0,
    0,  110,  111,  112,  113,  116,  117,  118,  119,    0,
  110,  111,  112,  113,  116,  117,  118,  119,    0,    0,
    0,    0,    0,   29,   29,    0,    0,    0,    0,    0,
    0,    0,  110,  111,  112,  113,  116,  117,  118,  119,
    0,  110,  111,  112,  113,  116,  117,  118,  119,    0,
    0,    0,    0,  110,  111,  112,  113,  116,  117,  118,
  119,   63,    0,    0,    0,    0,   61,   45,    0,    0,
   45,    0,   64,    0,  108,    0,    0,  110,  111,  112,
  113,  116,  117,  118,  119,   45,  110,  111,  112,  113,
  116,  117,  118,  119,    0,    0,    0,    0,  110,  111,
  112,  113,  116,  117,  118,  119,    0,  110,  111,  112,
  113,  116,  117,  118,  119,    0,    0,    0,  124,   45,
   30,    0,  244,  122,  120,    0,  121,    0,  123,    0,
    0,    0,    0,  110,  111,  112,  113,  116,  117,  118,
  119,  114,  124,  115,   64,    0,  250,  122,  120,    0,
  121,  124,  123,    0,    0,    0,  122,  120,  124,  121,
    0,  123,    0,  122,  120,  114,  121,  115,  123,    0,
    0,    0,  124,    0,  114,    0,  115,  122,  120,    0,
  121,  114,  123,  115,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  114,    0,  115,    0,    0,
    0,    0,    0,    0,    0,   33,   11,   34,   35,    0,
   36,   37,   38,   39,   40,   41,    0,   42,    1,    2,
    3,   43,   44,   45,   46,    0,   47,   48,   49,   50,
   51,   52,   53,   54,   55,   56,    4,   57,   58,   59,
   60,   63,    0,    0,    0,    0,   61,    0,    0,   62,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   33,   11,   34,
   35,    0,   36,   37,   38,   39,   40,   41,    0,   42,
    1,    2,    3,   43,   44,   45,   46,    0,   47,   48,
   49,   50,   51,   52,   53,   54,   55,   56,    4,   57,
   58,   59,   60,    0,    0,    0,    0,    0,    0,    0,
    0,   62,    0,    0,   64,    0,  139,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   63,    0,
    0,    0,    0,   61,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  133,    0,
    0,    0,    0,    0,    0,  140,    0,    0,    0,    0,
    0,    0,    0,  110,  111,  112,  113,  116,  117,  118,
  119,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  140,    0,  110,  111,  112,
  113,  116,  117,  118,  119,    0,  110,  111,  112,  113,
  116,  117,  118,  119,  111,  112,  113,  116,  117,  118,
  119,   64,   63,  162,    0,    0,    0,   61,  140,  112,
  113,  116,  117,  118,  119,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   11,   34,
   35,    0,   36,   37,   38,   39,   40,   41,    0,   42,
    1,    2,    3,   43,   44,   45,   46,    0,   47,   48,
   49,   50,   51,   52,   53,   54,   55,   56,    4,   57,
   58,   59,   60,    0,    0,    0,    0,    0,    0,    0,
    0,   62,    0,    0,    0,   64,    0,  189,   92,    0,
  235,    0,  237,   92,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  249,    0,    0,    0,  252,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   63,    0,
    0,    0,    0,   61,    0,   11,   34,   35,    0,   36,
   37,   38,   39,   40,   41,    0,   42,    1,    2,    3,
   43,   44,   45,   46,    0,   47,   48,   49,   50,   51,
   52,   53,   54,   55,   56,    4,   57,   58,   59,   60,
    0,   92,    0,   92,   63,  159,    0,    0,   62,   61,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   63,  186,    0,    0,    0,   61,
    0,   64,    0,    0,    0,    0,    0,    0,    0,   11,
   34,   35,    0,   36,   37,   38,   39,   40,   41,    0,
   42,    1,    2,    3,   43,   44,   45,   46,    0,   47,
   48,   49,   50,   51,   52,   53,   54,   55,   56,    4,
   57,   58,   59,   60,   63,    0,    0,    0,    0,   61,
    0,    0,   62,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   35,    0,   35,   35,   35,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   35,   35,    0,   35,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   92,   92,   92,    0,   92,
   92,   92,   92,   92,   92,    0,   92,   92,   92,   92,
   92,   92,   92,   92,   35,   92,   92,   92,   92,   92,
   92,   92,   92,   92,   92,   92,   92,   92,   92,   92,
    0,    0,    0,    0,    0,   11,   34,   35,   92,   36,
   37,   38,   39,   40,   41,    0,   42,    1,    2,    3,
   43,   44,   45,   46,    0,   47,   48,   49,   50,   51,
   52,   53,   54,   55,   56,    4,   57,   58,   59,   60,
    0,    0,    0,    0,    0,    0,    0,    0,   62,    0,
    0,   11,    0,    0,    0,    0,    0,    0,    0,    0,
   41,    0,   42,    0,    0,    0,   43,   44,   45,   46,
   21,   47,   48,   21,    0,    0,   52,   53,   54,   55,
   56,   11,    0,   58,   59,    0,    0,    0,   21,   21,
   41,   21,   42,    0,   62,    0,   43,   44,   45,   46,
    0,   47,   48,    0,    0,    0,   52,   53,   54,   55,
   56,    0,    0,   58,   59,   20,    0,   20,   20,   20,
    0,    0,   21,    0,   62,    0,    0,    0,    0,    0,
    0,   11,    0,   20,   20,    0,   20,    0,    0,    0,
   41,    0,   42,    0,    0,    0,   43,   44,   45,   46,
   22,   47,   48,   22,    0,    0,   52,   53,   54,   55,
   56,    0,    0,   58,   59,    0,    0,   20,   22,   22,
    0,   22,    0,   31,   62,   31,   31,   31,    0,    0,
    0,    0,    0,   35,   35,   35,   35,   35,   35,   35,
   35,   31,   31,   28,   31,    0,   28,    0,    0,    0,
   23,    0,   22,   23,    0,    0,    0,    0,    0,    0,
   26,   28,   28,   26,   28,    0,    0,   27,   23,   23,
   27,   23,    0,   24,    0,   31,   24,    0,   26,   26,
   25,   26,    0,   25,    0,   27,   27,    0,   27,    0,
    0,   24,   24,    0,   24,   28,    0,    0,   25,   25,
    0,   25,   23,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   26,    0,    0,    0,    0,    0,    0,   27,
    0,    0,    0,    0,    0,   24,    0,    0,    0,    0,
    0,    0,   25,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   12,    0,   13,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   21,    0,    0,   25,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
   87,   21,   21,   21,   21,   21,   21,   21,   21,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  126,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   20,   20,   20,   20,
   20,   20,   20,   20,    0,    0,    0,    0,    0,  145,
  146,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  156,  157,  158,    0,    0,    0,    0,    0,    0,    0,
    0,   22,   22,   22,   22,   22,   22,   22,   22,    0,
    0,    0,    0,    0,    0,    0,  179,    0,    0,    0,
    0,    0,    0,    0,   31,   31,   31,   31,   31,   31,
   31,   31,    0,    0,   88,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   28,   28,   28,   28,   28,   28,
    0,   23,   23,   23,   23,   23,   23,  105,  106,  107,
    0,   26,   26,   26,   26,   26,   26,   21,   27,   27,
   27,   27,   27,   27,   24,   24,   24,   24,   24,   24,
    0,   25,   25,   25,   25,   25,   25,  220,    0,    0,
    0,    0,  151,  152,  153,  154,  155,    0,    0,    0,
  160,    0,    0,    0,    0,    0,  163,  164,  165,  166,
  167,  168,  169,  170,  171,  172,  173,  174,  175,  176,
  177,    0,    0,    0,    0,    0,  180,    0,  181,    0,
    0,  183,  184,  185,  187,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  187,    0,  187,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  221,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  228,    0,    0,    0,    0,    0,  234,
    0,  236,    0,  238,    0,    0,    0,    0,    0,  239,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  248,
};
short yycheck[] = {                                      37,
  257,   41,   44,   41,   42,   43,   44,   45,   37,   47,
   40,   44,   41,   42,   43,   44,   45,   59,   47,   40,
   59,   59,   60,   40,   62,   40,   59,   37,   64,    0,
   59,   60,   42,   62,   37,   40,    7,   47,   41,   42,
   43,   44,   45,   37,   47,    0,   61,   41,   42,   43,
   86,   45,    7,   47,  195,   93,  197,   60,   41,   62,
   41,   59,   17,   44,   93,   37,   60,  123,   62,   41,
   42,   43,   27,   45,   37,   47,   91,   59,   41,   42,
   43,   37,   45,   40,   47,   59,   42,   43,   60,   45,
   62,   47,   92,   93,   94,   95,   37,   60,  123,   62,
   41,   42,   43,   40,   45,   37,   47,  256,  257,   41,
   42,   43,   40,   45,   40,   47,  269,  270,  271,   60,
   41,   62,   41,   44,   40,   44,   41,   37,   60,   44,
   62,   41,   42,   43,  287,   45,   37,   47,   40,  276,
   59,   42,   43,   44,   45,   40,   47,   40,   37,   40,
   60,  257,   62,   42,   43,   40,   45,   41,   47,   60,
   44,   62,   40,  269,  270,  271,   41,   40,   40,   44,
   59,   60,   37,   62,   93,   59,   41,   42,   43,   40,
   45,   37,   47,   40,  261,   41,   42,   43,   40,   45,
   40,   47,   41,   37,   41,   60,   41,   62,   42,   43,
   41,   45,   37,   47,   60,   44,   62,   42,   43,   93,
   45,   41,   47,   41,   44,   41,   60,  257,   62,   41,
   41,  256,   44,  178,   59,   60,  256,   62,   37,  269,
  270,  271,   41,   42,   43,  256,   45,   59,   47,  256,
   37,   41,   40,   61,   44,   42,   43,   41,   45,   93,
   47,   60,  260,   62,  292,  293,  294,  295,  296,  297,
  298,  299,    0,  292,  293,  294,  295,  296,  297,  298,
  299,   93,   41,  256,  257,   44,   41,   41,   59,   44,
   44,    0,   59,  123,   59,  123,  269,  270,  271,  292,
  293,  294,  295,  296,  297,  298,  299,   40,  292,  293,
  294,  295,  296,  297,  298,  299,   -1,  178,    7,    7,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  292,  293,  294,  295,  296,  297,  298,  299,   -1,  292,
  293,  294,  295,  296,  297,  298,  299,   -1,   -1,   40,
   -1,   -1,  298,  299,   45,   -1,   -1,   -1,   -1,   -1,
   -1,  292,  293,  294,  295,  296,  297,  298,  299,   -1,
  292,  293,  294,  295,  296,  297,  298,  299,   -1,   -1,
   -1,   -1,   -1,  292,  293,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  292,  293,  294,  295,  296,  297,  298,  299,
   -1,  292,  293,  294,  295,  296,  297,  298,  299,   -1,
   -1,   -1,   -1,  292,  293,  294,  295,  296,  297,  298,
  299,   40,   -1,   -1,   -1,   -1,   45,   41,   -1,   -1,
   44,   -1,  123,   -1,  125,   -1,   -1,  292,  293,  294,
  295,  296,  297,  298,  299,   59,  292,  293,  294,  295,
  296,  297,  298,  299,   -1,   -1,   -1,   -1,  292,  293,
  294,  295,  296,  297,  298,  299,   -1,  292,  293,  294,
  295,  296,  297,  298,  299,   -1,   -1,   -1,   37,   93,
  292,   -1,   41,   42,   43,   -1,   45,   -1,   47,   -1,
   -1,   -1,   -1,  292,  293,  294,  295,  296,  297,  298,
  299,   60,   37,   62,  123,   -1,   41,   42,   43,   -1,
   45,   37,   47,   -1,   -1,   -1,   42,   43,   37,   45,
   -1,   47,   -1,   42,   43,   60,   45,   62,   47,   -1,
   -1,   -1,   37,   -1,   60,   -1,   62,   42,   43,   -1,
   45,   60,   47,   62,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   60,   -1,   62,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259,   -1,
  261,  262,  263,  264,  265,  266,   -1,  268,  269,  270,
  271,  272,  273,  274,  275,   -1,  277,  278,  279,  280,
  281,  282,  283,  284,  285,  286,  287,  288,  289,  290,
  291,   40,   -1,   -1,   -1,   -1,   45,   -1,   -1,  300,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258,
  259,   -1,  261,  262,  263,  264,  265,  266,   -1,  268,
  269,  270,  271,  272,  273,  274,  275,   -1,  277,  278,
  279,  280,  281,  282,  283,  284,  285,  286,  287,  288,
  289,  290,  291,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  300,   -1,   -1,  123,   -1,  125,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   40,   -1,
   -1,   -1,   -1,   45,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   72,   -1,
   -1,   -1,   -1,   -1,   -1,   79,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  292,  293,  294,  295,  296,  297,  298,
  299,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  109,   -1,  292,  293,  294,
  295,  296,  297,  298,  299,   -1,  292,  293,  294,  295,
  296,  297,  298,  299,  293,  294,  295,  296,  297,  298,
  299,  123,   40,  125,   -1,   -1,   -1,   45,  142,  294,
  295,  296,  297,  298,  299,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,
  259,   -1,  261,  262,  263,  264,  265,  266,   -1,  268,
  269,  270,  271,  272,  273,  274,  275,   -1,  277,  278,
  279,  280,  281,  282,  283,  284,  285,  286,  287,  288,
  289,  290,  291,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  300,   -1,   -1,   -1,  123,   -1,  125,   40,   -1,
  224,   -1,  226,   45,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  247,   -1,   -1,   -1,  251,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   40,   -1,
   -1,   -1,   -1,   45,   -1,  257,  258,  259,   -1,  261,
  262,  263,  264,  265,  266,   -1,  268,  269,  270,  271,
  272,  273,  274,  275,   -1,  277,  278,  279,  280,  281,
  282,  283,  284,  285,  286,  287,  288,  289,  290,  291,
   -1,  123,   -1,  125,   40,   41,   -1,   -1,  300,   45,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   40,   41,   -1,   -1,   -1,   45,
   -1,  123,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,
  258,  259,   -1,  261,  262,  263,  264,  265,  266,   -1,
  268,  269,  270,  271,  272,  273,  274,  275,   -1,  277,
  278,  279,  280,  281,  282,  283,  284,  285,  286,  287,
  288,  289,  290,  291,   40,   -1,   -1,   -1,   -1,   45,
   -1,   -1,  300,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   41,   -1,   43,   44,   45,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   59,   60,   -1,   62,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,
  262,  263,  264,  265,  266,   -1,  268,  269,  270,  271,
  272,  273,  274,  275,   93,  277,  278,  279,  280,  281,
  282,  283,  284,  285,  286,  287,  288,  289,  290,  291,
   -1,   -1,   -1,   -1,   -1,  257,  258,  259,  300,  261,
  262,  263,  264,  265,  266,   -1,  268,  269,  270,  271,
  272,  273,  274,  275,   -1,  277,  278,  279,  280,  281,
  282,  283,  284,  285,  286,  287,  288,  289,  290,  291,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  300,   -1,
   -1,  257,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  266,   -1,  268,   -1,   -1,   -1,  272,  273,  274,  275,
   41,  277,  278,   44,   -1,   -1,  282,  283,  284,  285,
  286,  257,   -1,  289,  290,   -1,   -1,   -1,   59,   60,
  266,   62,  268,   -1,  300,   -1,  272,  273,  274,  275,
   -1,  277,  278,   -1,   -1,   -1,  282,  283,  284,  285,
  286,   -1,   -1,  289,  290,   41,   -1,   43,   44,   45,
   -1,   -1,   93,   -1,  300,   -1,   -1,   -1,   -1,   -1,
   -1,  257,   -1,   59,   60,   -1,   62,   -1,   -1,   -1,
  266,   -1,  268,   -1,   -1,   -1,  272,  273,  274,  275,
   41,  277,  278,   44,   -1,   -1,  282,  283,  284,  285,
  286,   -1,   -1,  289,  290,   -1,   -1,   93,   59,   60,
   -1,   62,   -1,   41,  300,   43,   44,   45,   -1,   -1,
   -1,   -1,   -1,  292,  293,  294,  295,  296,  297,  298,
  299,   59,   60,   41,   62,   -1,   44,   -1,   -1,   -1,
   41,   -1,   93,   44,   -1,   -1,   -1,   -1,   -1,   -1,
   41,   59,   60,   44,   62,   -1,   -1,   41,   59,   60,
   44,   62,   -1,   41,   -1,   93,   44,   -1,   59,   60,
   41,   62,   -1,   44,   -1,   59,   60,   -1,   62,   -1,
   -1,   59,   60,   -1,   62,   93,   -1,   -1,   59,   60,
   -1,   62,   93,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,   93,
   -1,   -1,   -1,   -1,   -1,   93,   -1,   -1,   -1,   -1,
   -1,   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,    4,   -1,    6,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   17,   -1,   -1,   20,
   -1,   -1,   -1,   -1,   -1,   -1,   27,   -1,   -1,   -1,
   31,  292,  293,  294,  295,  296,  297,  298,  299,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   66,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  292,  293,  294,  295,
  296,  297,  298,  299,   -1,   -1,   -1,   -1,   -1,   90,
   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  101,  102,  103,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  292,  293,  294,  295,  296,  297,  298,  299,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  127,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  292,  293,  294,  295,  296,  297,
  298,  299,   -1,   -1,   38,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  292,  293,  294,  295,  296,  297,
   -1,  292,  293,  294,  295,  296,  297,   61,   62,   63,
   -1,  292,  293,  294,  295,  296,  297,  178,  292,  293,
  294,  295,  296,  297,  292,  293,  294,  295,  296,  297,
   -1,  292,  293,  294,  295,  296,  297,  198,   -1,   -1,
   -1,   -1,   96,   97,   98,   99,  100,   -1,   -1,   -1,
  104,   -1,   -1,   -1,   -1,   -1,  110,  111,  112,  113,
  114,  115,  116,  117,  118,  119,  120,  121,  122,  123,
  124,   -1,   -1,   -1,   -1,   -1,  130,   -1,  132,   -1,
   -1,  135,  136,  137,  138,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  195,   -1,  197,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  207,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  217,   -1,   -1,   -1,   -1,   -1,  223,
   -1,  225,   -1,  227,   -1,   -1,   -1,   -1,   -1,  233,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  245,
};
#define YYFINAL 5
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 302
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,"'%'",0,0,"'('","')'","'*'","'+'","','","'-'",0,"'/'",0,0,0,0,0,0,0,0,0,0,
0,"';'","'<'","'='","'>'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,"'['",0,"']'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'{'",
0,"'}'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"NOME","IF","DO","ELSE","WHILE","FOR","RETURN",
"BREAK","CONTINUE","COMMAND","STRING","LIT_CH","BYTE","WORD","DWORD","SIZEOF",
"OFFSETOF","GETVMVAR","NUMERO","COST_STRINGA","C_H_NUM","C_O_NUM","TITLE",
"PRINT","APRINT","CHECK","CONV","CONV16","CONV24","CONV32","ARRAY","CLEAR",
"LEN","STRLEN","RESETLOG","OR","AND","EQ","NOT_EQ","MIU","MAU","LSHIFT",
"RSHIFT","NOT","MENO_UNARIO","CH_FUNZ",
};
char *yyrule[] = {
"$accept : programma",
"tipo : BYTE",
"tipo : WORD",
"tipo : DWORD",
"nome : NOME",
"numero : NUMERO",
"numero : C_H_NUM",
"numero : C_O_NUM",
"numero : LIT_CH",
"cost_str : COST_STRINGA",
"espressione : nome",
"espressione : nome '[' espressione ']'",
"espressione : ch_funz",
"espressione : numero",
"espressione : CHECK '(' espressione ')'",
"espressione : CONV '(' espressione ')'",
"espressione : CONV16 '(' espressione ')'",
"espressione : CONV24 '(' espressione ')'",
"espressione : CONV32 '(' espressione ')'",
"espressione : '(' espressione ')'",
"espressione : espressione '+' espressione",
"espressione : espressione LSHIFT espressione",
"espressione : espressione RSHIFT espressione",
"espressione : espressione NOT_EQ espressione",
"espressione : espressione MIU espressione",
"espressione : espressione MAU espressione",
"espressione : espressione '<' espressione",
"espressione : espressione '>' espressione",
"espressione : espressione EQ espressione",
"espressione : espressione AND espressione",
"espressione : espressione OR espressione",
"espressione : espressione '-' espressione",
"espressione : espressione '*' espressione",
"espressione : espressione '/' espressione",
"espressione : espressione '%' espressione",
"espressione : '-' espressione",
"espressione : NOT espressione",
"espressione : assegnamento",
"espressione : SIZEOF '(' nome ')'",
"espressione : OFFSETOF '(' nome ')'",
"espressione : GETVMVAR '(' cost_str ')'",
"espressione : COMMAND '(' cost_str ')'",
"espressione : LEN '(' nome ')'",
"espressione : STRLEN '(' nome ')'",
"assegnamento : nome '=' espressione",
"assegnamento : nome '[' espressione ']' '=' espressione",
"ch_funz : nome '(' l_espress ')'",
"ch_funz : nome '(' ')'",
"l_espress : espressione",
"l_espress : l_espress ',' espressione",
"programma : llinee",
"programma :",
"llinee : dichiarazioni",
"llinee : c_function",
"llinee : llinee dichiarazioni",
"llinee : llinee c_function",
"dichiarazioni : prototipo",
"prototipo : tipo nome '(' ')' ';'",
"prototipo : tipo nome '(' l_variabili ')' ';'",
"prototipo : ARRAY nome ';'",
"l_variabili : tipo nome",
"l_variabili : nome",
"l_variabili : l_variabili ',' tipo nome",
"l_variabili : l_variabili ',' nome",
"def_var : def_v ';'",
"def_v : tipo nome",
"def_v : def_v ',' nome",
"def_v : tipo error",
"listruzioni : listruzioni istruzione",
"listruzioni : istruzione",
"listruzioni : error",
"istruzione : istruz ';'",
"istruzione : costrutto",
"istruzione : def_var",
"istruzione : '{' listruzioni '}'",
"istruzione : '{' '}'",
"costrutto : c_do",
"costrutto : c_while",
"costrutto : c_if",
"costrutto : c_for",
"do : DO",
"while : WHILE",
"for : FOR",
"if : IF",
"else : ELSE",
"$$1 :",
"c_do : do istruzione WHILE $$1 '(' espressione ')' ';'",
"c_do : do istruzione WHILE error",
"$$2 :",
"c_while : while '(' espressione ')' $$2 istruzione",
"c_while : while error",
"t_if :",
"c_if : if '(' espressione ')' t_if istruzione",
"$$3 :",
"c_if : if '(' espressione ')' t_if istruzione else $$3 istruzione",
"c_if : if error",
"$$4 :",
"$$5 :",
"$$6 :",
"c_for : for '(' espressione ';' $$4 espressione ';' $$5 espressione ')' $$6 istruzione",
"c_for : for error",
"$$7 :",
"c_function : tipo nome '(' ')' $$7 '{' listruzioni '}'",
"$$8 :",
"c_function : tipo nome '(' l_variabili ')' $$8 '{' listruzioni '}'",
"c_function : tipo nome '(' error",
"istruz : CONTINUE",
"istruz : BREAK",
"istruz : espressione",
"istruz : TITLE '(' cost_str ')'",
"istruz : TITLE '(' cost_str ',' l_espress ')'",
"istruz : PRINT '(' cost_str ',' l_espress ')'",
"istruz : PRINT '(' cost_str ')'",
"istruz : APRINT '(' cost_str ',' nome ')'",
"istruz : CLEAR '(' nome ')'",
"istruz : RETURN espressione",
"istruz : RESETLOG '(' ')'",
"istruz : RESETLOG '(' espressione ',' espressione ')'",
"istruz : RESETLOG '(' espressione ',' espressione ',' espressione ')'",
"istruz : prototipo",
};
#endif
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#ifdef YYSTACKSIZE
#ifndef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#endif
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];
#define yystacksize YYSTACKSIZE

extern int yylineno;

int yyerror(char* s)
{
 char t[1000];
 sprintf(t,ERR_LINE /*Errore di analisi del sorgente alla linea %d\n%s\n*/,yylineno,s);
 Say(t);
 if(strcmp(s,"syntax error")==0) EndParsing();
 errorflag=1;
 return 1;
}

int yywarn(char* s)
{
 char t[1000];
 if (s==NULL) s="";
 sprintf(t,ERR_WARNLINE /*Warning alla linea %d.\n%s\n*/,yylineno,s);
 Say(t);
 return 1;
}
#define YYABORT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv(const char*);

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, reading %d (%s)\n", yystate,
                    yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: state %d, shifting to state %d\n",
                    yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: state %d, error recovery shifting\
 to state %d\n", *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: error recovery discarding state %d\n",
                            *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, error recovery discards token %d (%s)\n",
                    yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("yydebug: state %d, reducing by rule %d (%s)\n",
                yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 1:
{yyval.i.i = 1;yyval.i.s = 1;}
break;
case 2:
{yyval.i.i = 2;yyval.i.s = 2;}
break;
case 3:
{yyval.i.i = 4;yyval.i.s = 4;}
break;
case 4:
{
			   strcpy(yyval.n.nome,agg_nome(yytext));
			  }
break;
case 5:
{
			   int num;
			   sscanf(yytext,"%d",&num);
			   yyval.i.i=num;
			   if (num<=0xFF) yyval.i.s=1;
			   else if (num<=0xFFFF) yyval.i.s=2;
			   else yyval.i.s=4;
			  }
break;
case 6:
{
			   int num;
			   sscanf(yytext+2,"%x",&num);
			   yyval.i.i=num;
			   if (num<=0xFF) yyval.i.s=1;
			   else if (num<=0xFFFF) yyval.i.s=2;
			   else yyval.i.s=4;
			  }
break;
case 7:
{
			   int num;
			   sscanf(yytext+1,"%o",&num);
			   yyval.i.i=num;
			   if (num<=0xFF) yyval.i.s=1;
			   else if (num<=0xFFFF) yyval.i.s=2;
			   else yyval.i.s=4;
			  }
break;
case 8:
{
			   yyval.i.i = yytext[1]; 
			   if (yytext[1]=='\\' && yytext[2]!='\\') 
			    sscanf(yytext+2,"%d",&(yyval.i.i));
			   yyval.i.s=1;
			  }
break;
case 9:
{ParseString(yytext);yytext[strlen(yytext)-1]='\0';costanti[nc]=yytext+1;yyval.i.i=nc;nc++;}
break;
case 10:
{
			   int indice;
			   const char* ct=yyvsp[0].n.nome;i=0;
			   for(indice=0;indice<nv;indice++)
			    if (strcmp(yyvsp[0].n.nome,scope[indice].n)==0) {ct=NULL;break;}
			   if (ct!=NULL) 
			    {
				  p_struct* p_str;
				  p_str=FindPrVar(prototipi[cp].nome.n,yyvsp[0].n.nome,indice);
				  if (p_str!=NULL)
				  {
					switch (p_str[indice].size)
					{
					 case 0:
				 		i=p_str[indice].ref;
						if(p_str[i].size==1){ist[i_ind].ist_number=I_P_PUSH_BYTE;yyval.i.s=1;}
							else if(p_str[i].size==2){ist[i_ind].ist_number=I_P_PUSH_WORD;yyval.i.s=2;}
							else if(p_str[i].size==4){ist[i_ind].ist_number=I_P_PUSH_DWORD;yyval.i.s=4;}
						ist[i_ind].p1=p_str[indice].offset;
						i_ind++;
						ist[i_ind].ist_number=I_P_PUSH_BITS;
						ist[i_ind].p1=((p_str[indice].bs)&0xFF)+(((p_str[indice].be)<<8)&0xFF00);
						break;
					 case 1:
						yyval.i.s=1;
						ist[i_ind].ist_number=I_P_PUSH_BYTE;
						ist[i_ind].p1=p_str[indice].offset;
						break;
					 case 2:
						yyval.i.s=2;
						ist[i_ind].ist_number=I_P_PUSH_WORD;
						ist[i_ind].p1=p_str[indice].offset;
						break;
					 case 4:
						yyval.i.s=4;
						ist[i_ind].ist_number=I_P_PUSH_DWORD;
						ist[i_ind].p1=p_str[indice].offset;
						break;
					 default:
						yyerror(ERR_DIM /*Errore di dimensione non nota*/);
						yyval.i.s=1;
						ist[i_ind].ist_number=I_P_PUSH_BYTE;
						ist[i_ind].p1=p_str[indice].offset;
						break;
					}
				   yyval.i.i=indice;
				   i_ind++;
				   ct=NULL;
				   i=-1;
				  }
				}
			   if (ct!=NULL) 
			   yyerror(ERR_VAR /*Impossibile accedere ad una variabile non definita*/);
			   else 
			   {
			    if(i==0)
				{
			     switch (scope[indice].size)
				 {
				  case 1:
			       ist[i_ind].ist_number=I_PUSH_BYTE;
			       ist[i_ind].p1=scope[indice].offset;
				   break;
				  case 2:
			       ist[i_ind].ist_number=I_PUSH_WORD;
			       ist[i_ind].p1=scope[indice].offset;
				   break;
				  case 4:
			       ist[i_ind].ist_number=I_PUSH_DWORD;
			       ist[i_ind].p1=scope[indice].offset;
				   break;
				  default:
				   yyerror(ERR_DIM /*Errore di dimensione non nota*/);
			       ist[i_ind].ist_number=I_PUSH_BYTE;
			       ist[i_ind].p1=scope[indice].offset;
				   break;
				 }
				 yyval.i.s=scope[indice].size;
				 yyval.i.i=indice;
				 i_ind++;
				}
			   }
			  }
break;
case 11:
{
			    int indice=-1;
				for(i=0;i<v_ind;i++)
				 if(strcmp(yyvsp[-3].n.nome,vect[i])==0) {indice=i;break;}
				if (indice<0) yyerror(ERR_ARRAY /*Array non definito*/);
				else
				 {
				     ist[i_ind].ist_number=I_VECTOR;
				     ist[i_ind].p1=indice; 
				     i_ind++;
				 }
			  }
break;
case 12:
{yyval.i.i=-1;yyval.i.s=yyvsp[0].i.s;}
break;
case 13:
{
			   int num=yyvsp[0].i.i;
			   ist[i_ind].ist_number=I_PUSH;
			   ist[i_ind].p1=num;
			   i_ind++;
			   yyval.i.s=yyvsp[0].i.s;
			   yyval.i.i=-1;
			  }
break;
case 14:
{
			   if (macrocomp) yyerror(ERR_ISTNMAC /*Istruzione non valida in una macro*/);
			   ist[i_ind].ist_number=I_P_CHECK;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 15:
{
			   if (macrocomp) yyerror(ERR_ISTNMAC /*Istruzione non valida in una macro*/);
			   ist[i_ind].ist_number=I_CONV;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 16:
{
			   if (macrocomp) yyerror(ERR_ISTNMAC /*Istruzione non valida in una macro*/);
			   ist[i_ind].ist_number=I_CONV16;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 17:
{
			   if (macrocomp) yyerror(ERR_ISTNMAC /*Istruzione non valida in una macro*/);
			   ist[i_ind].ist_number=I_CONV24;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 18:
{
			   if (macrocomp) yyerror(ERR_ISTNMAC /*Istruzione non valida in una macro*/);
			   ist[i_ind].ist_number=I_CONV32;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 19:
{
			   yyval.i.s=yyvsp[-1].i.s;
			   yyval.i.i=-1;
			  }
break;
case 20:
{
			   ist[i_ind].ist_number=I_PLUS;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=max(yyvsp[-2].i.s,yyvsp[0].i.s);
			   yyval.i.i=-1;
			  }
break;
case 21:
{
			   ist[i_ind].ist_number=I_LSHIFT;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=(yyvsp[-2].i.s);
			   yyval.i.i=-1;
			  }
break;
case 22:
{
			   ist[i_ind].ist_number=I_RSHIFT;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=(yyvsp[-2].i.s);
			   yyval.i.i=-1;
			  }
break;
case 23:
{
			   ist[i_ind].ist_number=I_NOT_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 24:
{
			   ist[i_ind].ist_number=I_MIN_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 25:
{
			   ist[i_ind].ist_number=I_MAG_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 26:
{
			   ist[i_ind].ist_number=I_MIN;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 27:
{
			   ist[i_ind].ist_number=I_MAG;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 28:
{
			   ist[i_ind].ist_number=I_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 29:
{
			   ist[i_ind].ist_number=I_AND;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 30:
{
			   ist[i_ind].ist_number=I_OR;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 31:
{
			   ist[i_ind].ist_number=I_MINUS;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=max(yyvsp[-2].i.s,yyvsp[0].i.s);
			   yyval.i.i=-1;
			  }
break;
case 32:
{
			   ist[i_ind].ist_number=I_MUL;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=max(yyvsp[-2].i.s,yyvsp[0].i.s);
			   yyval.i.i=-1;
			  }
break;
case 33:
{
			   ist[i_ind].ist_number=I_DIV;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=max(yyvsp[-2].i.s,yyvsp[0].i.s);
			   yyval.i.i=-1;
			  }
break;
case 34:
{
			   ist[i_ind].ist_number=I_MOD;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=max(yyvsp[-2].i.s,yyvsp[0].i.s);
			   yyval.i.i=-1;
			  }
break;
case 35:
{
			   ist[i_ind].ist_number=I_UN_MINUS;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=yyvsp[0].i.s;
			   yyval.i.i=-1;
			  }
break;
case 36:
{
			   ist[i_ind].ist_number=I_NOT;
			   ist[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 37:
{
			   yyval.i.s=yyvsp[0].i.s;
			   yyval.i.i=yyvsp[0].i.i;
			  }
break;
case 38:
{
			   int indice;
			   const char* ct=yyvsp[-1].n.nome;i=0;
			   for(indice=0;indice<nv;indice++)
			    if (strcmp(yyvsp[-1].n.nome,scope[indice].n)==0) {ct=NULL;break;}
			   if (ct!=NULL) 
			    {
				  p_struct* p_str;
				  p_str=FindPrVar(prototipi[cp].nome.n,yyvsp[-1].n.nome,indice);
				  if (p_str!=NULL)
				    {
					ist[i_ind].ist_number=I_PUSH;
					ist[i_ind].p1=p_str->size;
					i_ind++;
					}
				   i=-1;
				}
			   if (ct!=NULL) 
			   yyerror(ERR_VAR /*Impossibile accedere ad una variabile non definita*/);
			   else 
			   {
			    if(i==0)
				{
					ist[i_ind].ist_number=I_PUSH;
					ist[i_ind].p1=scope[indice].size;
					i_ind++;
				}
			   }
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 39:
{
			   int indice;
			   const char* ct=yyvsp[-1].n.nome;i=0;
			   for(indice=0;indice<nv;indice++)
			    if (strcmp(yyvsp[-1].n.nome,scope[indice].n)==0) 
				{
				 ct=NULL;
				 ist[i_ind].ist_number=I_OFFSET_S;
				 ist[i_ind].p1=scope[indice].offset;
				 i_ind++;
				 break;
				}
			   if (ct!=NULL) 
			    {
				  p_struct* p_str;
				  p_str=FindPrVar(prototipi[cp].nome.n,yyvsp[-1].n.nome,indice);
				  if (p_str!=NULL)
				    {
					ist[i_ind].ist_number=I_OFFSET_P;
					ist[i_ind].p1=p_str[indice].offset;
					i_ind++;
					ct=NULL;
					}
				   i=-1;
				}
			   if (ct!=NULL) 
			    yyerror(ERR_VAR /*Impossibile accedere ad una variabile non definita*/);
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 40:
{
			   if (macrocomp) yyerror(ERR_ISTNMAC /*Istruzione non valida in una macro*/);
			   ist[i_ind].ist_number=I_GETVMVAR;
			   ist[i_ind].p1=yyvsp[-1].i.i;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 41:
{
			   if (!macrocomp) yyerror(ERR_ISTMAC /*Istruzione valida solo in una macro*/);
			   ist[i_ind].ist_number=I_COMMAND;
			   ist[i_ind].p1=yyvsp[-1].i.i;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 42:
{
			   int indice=-1;
			   for(i=0;i<v_ind;i++)
				 if(strcmp(yyvsp[-1].n.nome,vect[i])==0) {indice=i;break;}
			   if (indice<0) yyerror(ERR_ARRAY /*Array non definito*/);
				else
				 {
				     ist[i_ind].ist_number=I_VLEN;
				     ist[i_ind].p1=indice; 
				     i_ind++;
				 }
			   yyval.i.s=4;
			   yyval.i.i=-1;
			}
break;
case 43:
{
			   int indice=-1;
			   for(i=0;i<v_ind;i++)
				 if(strcmp(yyvsp[-1].n.nome,vect[i])==0) {indice=i;break;}
			   if (indice<0) yyerror(ERR_ARRAY /*Array non definito*/);
				else
				 {
				     ist[i_ind].ist_number=I_STRLEN;
				     ist[i_ind].p1=indice; 
				     i_ind++;
				 }
			   yyval.i.s=4;
			   yyval.i.i=-1;
			}
break;
case 44:
{
			   int indice;
			   const char* ct=yyvsp[-2].n.nome;
			   for(indice=0;indice<nv;indice++)
			    if (strcmp(yyvsp[-2].n.nome,scope[indice].n)==0) 
				 {
				  ct=NULL;
			      ist[i_ind].ist_number=I_ASSEGN;
			      ist[i_ind].p1=indice; /*$1.i;*/
			      i_ind++;
				  break;
				 }
			   if (ct!=NULL) 
			   {
			    p_struct* pstr;
			    pstr=FindPrVar(prototipi[cp].nome.n,yyvsp[-2].n.nome,i);
				if(i>=0)
				{
				 ct=NULL;
				 indice=i;
				 if (pstr[indice].size==0)
					{
						int itmp=i;
				 		i=pstr[indice].ref;
						if(pstr[i].size==1){ist[i_ind].ist_number=I_P_PUSH_BYTE;yyval.i.s=1;}
							else if(pstr[i].size==2){ist[i_ind].ist_number=I_P_PUSH_WORD;yyval.i.s=2;}
							else if(pstr[i].size==4){ist[i_ind].ist_number=I_P_PUSH_DWORD;yyval.i.s=4;}
						ist[i_ind].p1=pstr[indice].offset;
						i_ind++;
						ist[i_ind].ist_number=I_P_ASSEGN_BITS;
					    ist[i_ind].p1=itmp; 
						i_ind++;
					}
				 else
				 {
					ist[i_ind].ist_number=I_P_ASSEGN;
					ist[i_ind].p1=i; 
					i_ind++;
				 }
				}
			   }
			   if (ct!=NULL) yyerror(ERR_VAR /*Impossibile accedere ad una variabile non definita*/);
			   yyval.i.s=yyvsp[0].i.s;
			  }
break;
case 45:
{
			    int indice=-1;
				for(i=0;i<v_ind;i++)
				 if(strcmp(yyvsp[-5].n.nome,vect[i])==0) {indice=i;break;}
				if (indice<0) yyerror(ERR_ARRAY /*Array non definito*/);
				else
				 {
				     ist[i_ind].ist_number=I_V_ASSEGN;
				     ist[i_ind].p1=indice; 
				     i_ind++;
				 }
			  }
break;
case 46:
{
				 i=cerca_prototipo(yyvsp[-3].n.nome);
				 if(i<0) {yyerror(ERR_FUNZ /*Chiamata di funzione non definita*/);yyval.i.s=0;}
				 else 
				 {
				  yyval.i.s=prototipi[i].rettype;
				  if (yyvsp[-1].p.n!=prototipi[i].np)
					{yyerror(ERR_PARS /*Numero di parametri incompatibile*/);}
				 }
				 ist[i_ind].ist_number=I_CH_FUNZ;
				 ist[i_ind].p1=i;
				 i_ind++;
				}
break;
case 47:
{
				 i=cerca_prototipo(yyvsp[-2].n.nome);
				 if(i<0) {yyerror(ERR_FUNZ /*Chiamata di funzione non definita*/);yyval.i.s=0;}
				 else 
				 {
				  yyval.i.s=prototipi[i].rettype;
				  if (0!=prototipi[i].np)
					{yyerror(ERR_PARS /*Numero di parametri incompatibile*/);}
				 }
				 ist[i_ind].ist_number=I_CH_FUNZ;
				 ist[i_ind].p1=i;
				 i_ind++;
				}
break;
case 48:
{yyval.p.n=1; yyval.p.pars[0]=yyvsp[0].i.s;}
break;
case 49:
{
				if(yyval.p.n>=MAXPARS) yyerror(ERR_TOOPARS /*Troppi parametri per la funzione*/);
				else 
				{
			     yyval.p.pars[yyval.p.n]=yyvsp[0].i.s;
				 (yyval.p.n)++;
			    }
			   }
break;
case 50:
{
					if(!errorflag)
					 {
					  if (macrocomp) 
					  {
						i=MAGIC_MACRO;
						if(fwrite(&i,sizeof(int),1,out)!=1)
							yyerror(ERR_SAVEMAC /*Impossibile salvare la macro compilata*/);
					  }
					  else 
					  {
						i=MAGIC_XFF;
						if(fwrite(&i,sizeof(int),1,out)!=1)
							yyerror(ERR_SAVE /*Impossibile salvare il file compilato*/);
						if(fwrite(&Pdo_time,sizeof(time_t),1,out)!=1)
							yyerror(ERR_SAVE /*Impossibile salvare il file compilato*/);
						if(fwrite(&Pdo_Id,sizeof(int),1,out)!=1)
							yyerror(ERR_SAVE /*Impossibile salvare il file compilato*/);
					  }

					  CCodeProcessor p;
					  p.SetVectNumber(v_ind);
					  for(i=0;i<nc;i++)
					  {
					   p.AddString(costanti[i].s);
					  }
					  p.SetPr(prototipi,np);
					  p.Serialize(0,out);
					  p.SetPr(NULL,0);
					 }
					else Say(ERR_NOOBJ /*Codice oggetto non generato a causa degli errori riscontrati.*/);
				}
break;
case 57:
{
				 if(cerca_prototipo(yyvsp[-3].n.nome)>=0) yyerror(ERR_RIDF /*Ridefinizione di funzione*/);
				 prototipi[np].nome=yyvsp[-3].n.nome;
				 prototipi[np].np=0;
				 prototipi[np].rettype=yyvsp[-4].i.i;
				 np++;
				}
break;
case 58:
{
				 if(cerca_prototipo(yyvsp[-4].n.nome)>=0) yyerror(ERR_RIDF /*Ridefinizione di funzione*/);
				 prototipi[np].nome=yyvsp[-4].n.nome;
				 prototipi[np].np=yyvsp[-2].p.n;
				 if (prototipi[np].parametri==NULL) prototipi[np].parametri=new int[yyvsp[-2].p.n];
				 for(i=0;i<yyvsp[-2].p.n;i++) prototipi[np].parametri[i]=yyvsp[-2].p.pars[i];
				 prototipi[np].rettype=yyvsp[-5].i.i;
				 np++;
				}
break;
case 59:
{
					vect[v_ind]=new char[strlen(yyvsp[-1].n.nome)+1];
					strcpy(vect[v_ind],yyvsp[-1].n.nome);
					v_ind++;
				}
break;
case 60:
{
			    nv=0;
			    yyval.p.n=1; yyval.p.pars[0]=yyvsp[-1].i.s;
				scope[nv].size=yyvsp[-1].i.i;
				scope[nv].offset=0; 
				scope[nv]=yyvsp[0].n.nome;
				nv++;
			   }
break;
case 61:
{
			    yywarn(ERR_NOPROT /*Manca un tipo nel prototipo. Si assumer DWORD.*/);
			    nv=0;
			    yyval.p.n=1; yyval.p.pars[0]=4;
				scope[nv].size=4;
				scope[nv].offset=0; 
				scope[nv]=yyvsp[0].n.nome;
				nv++;
			   }
break;
case 62:
{
			    yyval.p.n=yyvsp[-3].p.n;
				if(yyval.p.n>=MAXPARS) yyerror(ERR_TOOPARS /*Troppi parametri per la funzione*/);
				else 
				{
			     yyval.p.pars[yyval.p.n]=yyvsp[-1].i.s;
				 (yyval.p.n)++;
			    }
				scope[nv].size=yyvsp[-1].i.i;
				scope[nv].offset=scope[nv-1].offset+scope[nv-1].size;
				scope[nv]=yyvsp[0].n.nome;
				for(i=0;i<nv;i++) 
				if (strcmp(scope[i].n,yyvsp[0].n.nome)==0)
				   yyerror(ERR_RIDEFVAR /*Ridefinizione di variabile*/);
				nv++;
			   }
break;
case 63:
{
			    yywarn(ERR_NOPROT /*Manca un tipo nel prototipo. Si assumer DWORD.*/);
			    yyval.p.n=yyvsp[-2].p.n;
				if(yyval.p.n>=MAXPARS) yyerror(ERR_TOOPARS /*Troppi parametri per la funzione*/);
				else 
				{
			     yyval.p.pars[yyval.p.n]=4;
				 (yyval.p.n)++;
			    }
				scope[nv].size=4;
				scope[nv].offset=scope[nv-1].offset+scope[nv-1].size;
				scope[nv]=yyvsp[0].n.nome;
				for(i=0;i<nv;i++) 
				if (strcmp(scope[i].n,yyvsp[0].n.nome)==0)
				   yyerror(ERR_VARRID /*Ridefinizione di variabile*/);
				nv++;
			   }
break;
case 64:
{}
break;
case 65:
{
				 yyval.i.i = yyvsp[-1].i.i; scope[nv].size=yyvsp[-1].i.i;
				 if (yyval.i.i!=4) yywarn(ERR_CAST /*I tipi vengono automaticamente convertiti a DWORD*/);
				 if (nv==0) scope[nv].offset=0; 
				  else 
				   scope[nv].offset=scope[nv-1].offset+scope[nv-1].size;
				 scope[nv]=yyvsp[0].n.nome;
				 for(i=0;i<nv;i++) 
				  if (strcmp(scope[i].n,yyvsp[0].n.nome)==0)
				   yyerror(ERR_VARRID /*Ridefinizione di variabile*/);
				 nv++;
				}
break;
case 66:
{
				 yyval.i.i=yyvsp[-2].i.i; scope[nv].size=yyvsp[-2].i.i;
				 if (nv==0) scope[nv].offset=0; 
				  else 
				   scope[nv].offset=scope[nv-1].offset+yyvsp[-2].i.i;
				 scope[nv]=yyvsp[0].n.nome;
				 for(i=0;i<nv;i++) 
				  if (strcmp(scope[i].n,yyvsp[0].n.nome)==0)
				   yyerror(ERR_VARRID /*Ridefinizione di variabile*/);
				 nv++;
				}
break;
case 67:
{yyval.i.i=0;}
break;
case 68:
{}
break;
case 69:
{}
break;
case 70:
{}
break;
case 71:
{
			   /*ist[i_ind].ist_number=I_LAB;*/
			   /*ist[i_ind].p1=yylineno;*/
			   yyval.i.i=i_ind;
			   /*i_ind++;*/
		  }
break;
case 72:
{
			   /*ist[i_ind].ist_number=I_LAB;*/
			   /*ist[i_ind].p1=yylineno;*/
			   yyval.i.i=i_ind;
			   /*i_ind++;*/
		  }
break;
case 73:
{
			   /*ist[i_ind].ist_number=I_LAB;*/
			   /*ist[i_ind].p1=yylineno;*/
			   yyval.i.i=i_ind;
			   /*i_ind++;*/
		  }
break;
case 74:
{
			   /*ist[i_ind].ist_number=I_LAB;*/
			   /*ist[i_ind].p1=yylineno;*/
			   yyval.i.i=i_ind;
			   /*i_ind++;*/
		  }
break;
case 75:
{
			   /*ist[i_ind].ist_number=I_LAB;*/
			   /*ist[i_ind].p1=yylineno;*/
			   yyval.i.i=i_ind;
			   /*i_ind++;*/
		  }
break;
case 80:
{
			   yyval.i.i=i_ind;
			   lab[nl]=i_ind;
			   labt.push(nl);
			   nl++;
			   lab[nl]=-1;
			   labi.push(nl);
			   nl++;
			   lab[nl]=-1;
			   labf.push(nl);
			   nl++;
		  }
break;
case 81:
{
			   yyval.i.i=i_ind;
			   lab[nl]=i_ind;
			   labi.push(nl);
			   nl++;
			   lab[nl]=-1;
			   labf.push(nl);
			   nl++;
		  }
break;
case 82:
{
			   /* Crea le label non inizializzate per continue e break */
			   yyval.i.i=i_ind;
			   lab[nl]=-1;
			   labi.push(nl);
			   nl++;
			   lab[nl]=-1;
			   labf.push(nl);
			   nl++;
		  }
break;
case 83:
{
			   yyval.i.i=i_ind;
			   lab[nl]=-1;
			   labt.push(nl);
			   nl++;
		  }
break;
case 84:
{
			   yyval.i.i=i_ind;
			   /*lab[nl]=-1;
			   labt.push(nl);
			   nl++;*/
		  }
break;
case 85:
{lab[labi.get_top()]=i_ind;}
break;
case 86:
{
		   ist[i_ind].ist_number=I_NOT;
		   ist[i_ind].p1=0;
		   i_ind++;
		   ist[i_ind].ist_number=I_IF;
		   ist[i_ind].p1=labt.pop();
		   i_ind++;
		   lab[labf.pop()]=i_ind;
		   labi.pop();
		  }
break;
case 87:
{yyerror (ERR_DO /*Errore nel do*/);}
break;
case 88:
{
		   ist[i_ind].ist_number=I_IF;
		   ist[i_ind].p1=labf.get_top();
		   i_ind++;
		  }
break;
case 89:
{
		   ist[i_ind].ist_number=I_CONTINUE;
		   ist[i_ind].p1=labi.pop();
		   i_ind++;
		   lab[labf.pop()]=i_ind;
		  }
break;
case 90:
{yyerror (ERR_WHILE /*Errore nel while*/);lab[nl-1]=i_ind;}
break;
case 91:
{
		   ist[i_ind].ist_number=I_IF;
		   ist[i_ind].p1=labt.get_top();
		   i_ind++;
		  }
break;
case 92:
{lab[labt.pop()]=i_ind;}
break;
case 93:
{
		   /* Imposta la label per l'else*/
		   i=labt.get_top();
		   /* Crea una label non inizializzata per il break dell'istruzione*/
		   lab[nl]=-1;
		   labt.push(nl);
		   nl++;
		   /* Inserisce l'istruzione di break;*/
		   ist[i_ind].ist_number=I_BREAK;
		   ist[i_ind].p1=labt.get_top();
		   i_ind++;
		   lab[i]=i_ind;
		  }
break;
case 94:
{lab[labt.pop()]=i_ind;labt.pop();}
break;
case 95:
{yyerror (ERR_IF /*Errore nell'if*/);}
break;
case 96:
{
		   /* Label Check*/
		   lab[nl]=i_ind;
		   labt.push(nl);
		   nl++;
		  }
break;
case 97:
{
			   /* Label fine istruzione (da riempire)*/
			   lab[nl]=-1;
			   labt.push(nl);
			   nl++;
			   /* If*/
			   ist[i_ind].ist_number=I_IF;
			   ist[i_ind].p1=labt.get_top();
			   i_ind++;
			   /* Label istruzione (da riempire)*/
			   lab[nl]=-1;
			   labt.push(nl);
			   nl++;
			   /* Istruzione di salto all'istruzione*/
			   ist[i_ind].ist_number=I_GOTO;
			   ist[i_ind].p1=labt.get_top();
			   i_ind++;
			   /* Label 3 Espressione*/
			   lab[nl]=i_ind;
			   labt.push(nl);
			   nl++;
			   /* Label per continue;*/
			   lab[labi.get_top()]=i_ind;
		  }
break;
case 98:
{
			   int a,b,c,d;
			   a=labt.pop();
			   b=labt.pop();
			   c=labt.pop();
			   d=labt.pop();
			   labt.push(d);
			   labt.push(c);
			   labt.push(b);
			   labt.push(a);
			   /* Salta al check*/
			   ist[i_ind].ist_number=I_GOTO;
			   ist[i_ind].p1=d;
			   i_ind++;
			   /* Label per l'istruzione*/
			   lab[b]=i_ind;
		  }
break;
case 99:
{
		   /* Salta alla 3 espressione*/
		   ist[i_ind].ist_number=I_GOTO;
		   ist[i_ind].p1=labt.pop();
		   i_ind++;
		   lab[labf.pop()]=i_ind;
		   labt.pop();
		   lab[labt.pop()]=i_ind;
		   labt.pop();
		   labi.pop();
		  }
break;
case 100:
{yyerror (ERR_FOR /*Errore nel for*/);}
break;
case 101:
{
				 nv=0;
				 nl=0;
				 l_ind=0;
				 i_ind=0;
				 cp=i=cerca_prototipo(yyvsp[-2].n.nome);
				 if(i>=0 && !conf_prototipi(i,NULL)) yyerror(ERR_RIDF /*Ridefinizione di funzione*/);
				 if(i<0)
				 {
				  prototipi[np].nome=yyvsp[-2].n.nome;
				  prototipi[np].np=0;
				  prototipi[np].rettype=yyvsp[-3].i.s;
				  cp=np;
				  np++;
				 }
				}
break;
case 102:
{
				 for (i=0;i<i_ind;i++)
					if(ist[i].ist_number==I_GOTO ||ist[i].ist_number==I_IF )
					 ist[i].p1=lab[ist[i].p1];
				 cp=i=cerca_prototipo(yyvsp[-6].n.nome);
				 if (i>=0)
				 {
				  prototipi[i].AddIst(ist,i_ind);
				  prototipi[i].nv=nv;
				  prototipi[i].vars=new int[nv];
				  prototipi[i].nomivars=new char*[nv];
				  for(int h=0;h<nv;h++) 
				  {
				    prototipi[i].vars[h]=scope[h].size;
				    prototipi[i].nomivars[h]=new char[strlen(scope[h].n)+1];
					if (prototipi[i].nomivars[h]) strcpy(prototipi[i].nomivars[h],scope[h].n);
				  }
				 }
				 i_ind=0;
				 l_ind=0;
				 nl=0;
				}
break;
case 103:
{
				 nl=0;
				 l_ind=0;
				 i_ind=0;
				 i=cerca_prototipo(yyvsp[-3].n.nome);
				 if(i>=0 && !conf_prototipi(i,&(yyvsp[-1].p))) yyerror(ERR_RIDF /*Ridefinizione di funzione*/);
				 if(i<0)
				 {
				  prototipi[np].nome=yyvsp[-3].n.nome;
				  prototipi[np].np=yyvsp[-1].p.n;
				  prototipi[np].rettype=yyvsp[-4].i.s;
				  if (prototipi[np].parametri==NULL) prototipi[np].parametri=new int[yyvsp[-1].p.n];
				  for (i=0;i<yyvsp[-1].p.n;i++) prototipi[np].parametri[i]=yyvsp[-1].p.pars[i];
				  cp=np;
				  np++;
				 }
				}
break;
case 104:
{
				 for (i=0;i<i_ind;i++)
					if(ist[i].ist_number==I_GOTO ||ist[i].ist_number==I_IF )
					 ist[i].p1=lab[ist[i].p1];
				 i=cerca_prototipo(yyvsp[-7].n.nome);
				 if (i>=0)
				 {
				  prototipi[i].AddIst(ist,i_ind);
				  prototipi[i].nv=nv;
				  prototipi[i].vars=new int[nv];
				  prototipi[i].nomivars=new char*[nv];
				  for(int h=0;h<nv;h++) 
				  {
				    prototipi[i].vars[h]=scope[h].size;
				    prototipi[i].nomivars[h]=new char[strlen(scope[h].n)+1];
					if (prototipi[i].nomivars[h]) strcpy(prototipi[i].nomivars[h],scope[h].n);
				  }
				 }
				 i_ind=0;
				 l_ind=0;
				 nl=0;
				}
break;
case 105:
{yyerror(ERR_FUNCP /*errore nella funzione o nel prototipo*/);}
break;
case 106:
{
			   ist[i_ind].ist_number=I_CONTINUE;
			   ist[i_ind].p1=labi.get_top();
			   i_ind++;
			}
break;
case 107:
{
			   ist[i_ind].ist_number=I_BREAK;
			   ist[i_ind].p1=labf.get_top();
			   i_ind++;
			}
break;
case 108:
{
			   ist[i_ind].ist_number=I_POP;
			   ist[i_ind].p1=0;
			   i_ind++;
			}
break;
case 109:
{
			   ist[i_ind].ist_number=I_TITLE;
			   ist[i_ind].p1=yyvsp[-1].i.i;
			   i_ind++;
			}
break;
case 110:
{
				yyerror(ERR_TITLE /*L'istruzione 'title' non vuole parametri*/);
			}
break;
case 111:
{
			   ist[i_ind].ist_number=I_PUSH;
			   ist[i_ind].p1=yyvsp[-1].p.n;
			   i_ind++;
			   ist[i_ind].ist_number=I_PRINT;
			   ist[i_ind].p1=yyvsp[-3].i.i;
			   i_ind++;
			}
break;
case 112:
{
			   ist[i_ind].ist_number=I_PUSH;
			   ist[i_ind].p1=0;
			   i_ind++;
			   ist[i_ind].ist_number=I_PRINT;
			   ist[i_ind].p1=yyvsp[-1].i.i;
			   i_ind++;
			}
break;
case 113:
{
			   ist[i_ind].ist_number=I_PUSH;
			   ist[i_ind].p1=yyvsp[-3].i.i;
			   i_ind++;
			   int indice=-1;
			   for(i=0;i<v_ind;i++)
				 if(strcmp(yyvsp[-1].n.nome,vect[i])==0) {indice=i;break;}
			   if (indice<0) yyerror(ERR_ARRAY /*Array non definito*/);
				else
				 {
				     ist[i_ind].ist_number=I_APRINT;
				     ist[i_ind].p1=indice; 
				     i_ind++;
				 }
			}
break;
case 114:
{
			   int indice=-1;
			   for(i=0;i<v_ind;i++)
				 if(strcmp(yyvsp[-1].n.nome,vect[i])==0) {indice=i;break;}
			   if (indice<0) yyerror(ERR_ARRAY /*Array non definito*/);
				else
				 {
				     ist[i_ind].ist_number=I_CLEAR;
				     ist[i_ind].p1=indice; 
				     i_ind++;
				 }
			}
break;
case 115:
{
			   ist[i_ind].ist_number=I_END;
			   ist[i_ind].p1=0;
			   i_ind++;
			}
break;
case 116:
{
			   ist[i_ind].ist_number=I_RESET_LOG_VARS;
			   ist[i_ind].p1=0;
			   i_ind++;
			}
break;
case 117:
{
			   ist[i_ind].ist_number=I_RESET_LOG_VARS;
			   ist[i_ind].p1=1;
			   i_ind++;
			}
break;
case 118:
{
			   ist[i_ind].ist_number=I_RESET_LOG_VARS;
			   ist[i_ind].p1=2;
			   i_ind++;
			}
break;
case 119:
{
			   yyerror(ERR_GRAF /*Possibile mancanza di una graffa chiusa*/);
			   return -1;
			}
break;
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: after reduction, shifting from state 0 to\
 state %d\n", YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("yydebug: state %d, reading %d (%s)\n",
                        YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("yydebug: after reduction, shifting from state %d \
to state %d\n", *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
