/****************************************************************************
			      PACKET PARSER - PARSER
				  (C) 1998 by VIANO PIERO
 ****************************************************************************/

%{
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <time.h>

#include "tipi.h"
#include "../../comuni/vec_cl.h"
#include "../../comuni/stack_cl.h"
#include "../../comuni/protocol.h"
#include "../../comuni/protocolvect.h"

#ifdef Say
#undef Say
#define Say(A) printf("%s\n",A)
#endif

#ifndef ENGLISH
#define ERR_FILEN "Nome di file errato"
#define ERR_SRC "Impossibile aprire il file sorgente"
#define ERR_FILE "File errato"
#define ERR_DIM "Errore di dimensione non nota"
#define ERR_VAR "Impossibile accedere ad una variabile non definita"
#define ERR_ARRAY "Array non definito"
#define ERR_ISTNMAC "Istruzione non valida in una macro"
#define ERR_ISTMAC "Istruzione valida solo in una macro"
#define ERR_FUNZ "Chiamata di funzione non definita"
#define ERR_PARS "Numero di parametri incompatibile"
#define ERR_TOOPARS "Troppi parametri per la funzione"
#define ERR_SAVEMAC "Impossibile salvare la macro compilata"
#define ERR_SAVE "Impossibile salvare il file compilato"
#define ERR_NOOBJ "Codice oggetto non generato a causa degli errori riscontrati."
#define ERR_RIDF "Ridefinizione di funzione"
#define ERR_NOPROT "Manca un tipo nel prototipo. Si assumer DWORD."
#define ERR_VARRID "Ridefinizione di variabile"
#define ERR_CAST "I tipi vengono automaticamente convertiti a DWORD"
#define ERR_DO "Errore nel do"
#define ERR_WHILE "Errore nel while"
#define ERR_IF "Errore nell'if"
#define ERR_FOR "Errore nel for"
#define ERR_FUNCP "errore nella funzione o nel prototipo"
#define ERR_TITLE "L'istruzione 'title' non vuole parametri"
#define ERR_GRAF "Possibile mancanza di una graffa chiusa"
#define ERR_LINE "Errore di analisi del sorgente alla linea %d\n%s\n"
#define ERR_WARNLINE "Warning alla linea %d.\n%s\n"
#define ERR_RIDEFVAR "Ridefinizione di variabile"
#else
#define ERR_FILEN "Wrong file name"
#define ERR_SRC "Unable to open source file"
#define ERR_FILE "Bad file"
#define ERR_DIM "Unknown dimension"
#define ERR_VAR "Unable to access undefined variable"
#define ERR_ARRAY "Undefined Array"
#define ERR_ISTNMAC "Invalid Instruction in macro"
#define ERR_ISTMAC "Instruction valid only in macros"
#define ERR_FUNZ "Function not defined"
#define ERR_PARS "Wrong parameter number"
#define ERR_TOOPARS "Too many parameters for function"
#define ERR_SAVEMAC "Unable to save compiled macro"
#define ERR_SAVE "Unable to save compiled file"
#define ERR_NOOBJ "Errors detected. Object code not generated."
#define ERR_RIDF "Function ridefinition"
#define ERR_NOPROT "Type absenbt in prototype. Assuming DWORD."
#define ERR_VARRID "Variable ridefinition"
#define ERR_CAST "Types are automatically converted to DWORD"
#define ERR_DO "Error in do"
#define ERR_WHILE "Error in while"
#define ERR_IF "Error in if"
#define ERR_FOR "Error in for"
#define ERR_FUNCP "Error in function or prototype"
#define ERR_TITLE "Title instruction don't need any parameter"
#define ERR_GRAF "Expected '}'"
#define ERR_LINE "Error analyzing source in line %d\n%s\n"
#define ERR_WARNLINE "Warning in line %d.\n%s\n"
#define ERR_RIDEFVAR "Variable ridefinition"
#endif

extern void EndParsing();
extern int yylex();
extern char* yytext;
extern FILE* out;
extern FILE* yyin;

int errorflag=0;
vector <Cost> costanti;
int nc=0;
vector <Nomi> scope;
int nv=0;
vector <Protos> prototipi;
int np=0;
int cp;
vector <istruzione> ist;
int i_ind;
vector <char*> vect;
int v_ind=0;

int macrocomp=0;

stack <int> labi;
stack <int> labf;
stack <int> labt;
vector <int> lab;
int nl=0;
int l_ind=0;
Protos prot_temp;
static int i;
Nomi ext_nome;
ProtocolVect proto;
int num_pr;
int num_var_pr;
time_t Pdo_time;
int Pdo_Id;

int OpenPDesc(const char* c)
{
	FILE* yyin;

	if (c==NULL) {Say(ERR_FILEN /*Nome di file errato*/);return -1;}
	yyin=fopen(c,"rb");
	if (yyin==NULL) {Say(ERR_SRC /*Impossibile aprire il file sorgente*/);return -1;}
	int i;
	fread(&i,sizeof(int),1,yyin);
	if(i!=MAGIC_PDF) {Say(ERR_FILE /*File errato*/);return -1;}
	fread(&Pdo_time,sizeof(time_t),1,yyin);
	fread(&Pdo_Id,sizeof(int),1,yyin);
	fread(&num_pr,sizeof(int),1,yyin);
	if (num_pr<0) {Say(ERR_FILE /*File errato*/);return -1;}
	for(i=0;i<num_pr;i++)
	{
	  proto[i].Serialize(1,yyin);
	}
	if (yyin)fclose (yyin);
	return 0;
}

int FindProto(const char* nome)
{
	int i;
	for(i=0;i<num_pr;i++)
		if (strcmp(nome,proto[i].GetName())==0) return i;
	return -1;
}

void ParseString(char* text)
{
	int l=strlen(text);
	char* n=new char[strlen(text)+1];
	int i,j,k;
	for(i=0,j=0;i<=l;i++)
	 if (text[i]!='\\') {n[j]=text[i];j++;}
	 else
	 {
	   i++;
	   if (text[i]!='a') {n[j]='\a';j++;}
	   else if (text[i]!='b') {n[j]='\b';j++;}
	   else if (text[i]!='f') {n[j]='\f';j++;}
	   else if (text[i]!='n') {n[j]='\n';j++;}
	   else if (text[i]!='r') {n[j]='\r';j++;}
	   else if (text[i]!='t') {n[j]='\t';j++;}
	   else if (text[i]!='v') {n[j]='\v';j++;}
	   else if (text[i]!='\\') {n[j]='\\';j++;}
	   else if (text[i]!='\?') {n[j]='\?';j++;}
	   else if (text[i]!='\'') {n[j]='\\';j++;}
	   else if (text[i]!='\"') {n[j]='\"';j++;}
	   else if (text[i]!='x') 
	   {
	    n[j]=0;
		for(k=0;k<2;k++)
		if (text[i+1]>='0' && text[i+1]<='9') {i++;n[j]=(n[j]<<k*4)+text[i]-'0';}
		else if (text[i+1]>='a' && text[i+1]<='f') {i++;n[j]=(n[j]<<k*4)+text[i]-'a'+10;}
		else if (text[i+1]>='A' && text[i+1]<='F') {i++;n[j]=(n[j]<<k*4)+text[i]-'A'+10;}
		else break;
		j++;
	   }
	   else
	   {
	    n[j]=0;
		for(k=0;k<3;k++)
		if (text[i+1]>='0' && text[i+1]<='7') {i++;n[j]=(n[j]<<k*3)+text[i]-'0';}
		else break;
		j++;
	   }
	 }
	for(i=0;i<j;i++)
	 text[i]=n[i];
	delete[]n;
}

p_struct * FindPrVar(const char* p, const char* v, int& pr)
{
	if(!p||!v) return NULL;
	pr=FindProto(p);
	if(pr<0) return NULL;
	p_struct * ps= proto[pr].GetPS(num_var_pr);
	for(pr=0;pr<num_var_pr;pr++)
	 if(strcmp(ps[pr].nome,v)==0)
	 {
	  return ps;
	 }
    return NULL;
}
%}

%token NOME
%token IF
%token DO
%token ELSE
%token WHILE
%token FOR
%token RETURN
%token BREAK
%token CONTINUE
%token COMMAND
%token STRING
%token LIT_CH
%token BYTE
%token WORD
%token DWORD
%token SIZEOF
%token OFFSETOF
%token GETVMVAR
%token NUMERO
%token COST_STRINGA
%token C_H_NUM
%token C_O_NUM
%token TITLE
%token PRINT
%token APRINT
%token CHECK
%token CONV
%token CONV16
%token CONV24
%token CONV32
%token ARRAY
%token CLEAR
%token LEN
%token STRLEN
%token RESETLOG

%start programma

%right '='
%left OR
%left AND
%left EQ,NOT_EQ,'<','>',MIU,MAU
%left LSHIFT,RSHIFT
%left '+','-'
%left '*','/','%'
%right NOT,MENO_UNARIO
%left CH_FUNZ

%union {
	 nome n;
	 intero i;
	 prots p;
	}

%type <i> espressione, tipo, numero, cost_str, ch_funz, def_v, for, while, do, istruzione, if
%type <i> if, else, assegnamento
%type <n> nome
%type <p> l_espress, l_variabili

%%
	/* DEFINIZIONI GENERALI */

tipo	: BYTE	{$$.i = 1;$$.s = 1;}
		| WORD {$$.i = 2;$$.s = 2;}
		| DWORD {$$.i = 4;$$.s = 4;}
		;
nome		: NOME
			  {
			   strcpy($$.nome,agg_nome(yytext));
			  }
			  ;
numero		: NUMERO 
			  {
			   int num;
			   sscanf(yytext,"%d",&num);
			   $$.i=num;
			   if (num<=0xFF) $$.s=1;
			   else if (num<=0xFFFF) $$.s=2;
			   else $$.s=4;
			  }
			| C_H_NUM 
			  {
			   int num;
			   sscanf(yytext+2,"%x",&num);
			   $$.i=num;
			   if (num<=0xFF) $$.s=1;
			   else if (num<=0xFFFF) $$.s=2;
			   else $$.s=4;
			  }
			| C_O_NUM 
			  {
			   int num;
			   sscanf(yytext+1,"%o",&num);
			   $$.i=num;
			   if (num<=0xFF) $$.s=1;
			   else if (num<=0xFFFF) $$.s=2;
			   else $$.s=4;
			  }
			| LIT_CH
			  {
			   $$.i = yytext[1]; 
			   if (yytext[1]=='\\' && yytext[2]!='\\') 
			    sscanf(yytext+2,"%d",&($$.i));
			   $$.s=1;
			  }
			;
cost_str	: COST_STRINGA 
				{ParseString(yytext);yytext[strlen(yytext)-1]='\0';costanti[nc]=yytext+1;$$.i=nc;nc++;}
				;
espressione : nome
			  {
			   int indice;
			   const char* ct=$1.nome;i=0;
			   for(indice=0;indice<nv;indice++)
			    if (strcmp($1.nome,scope[indice].n)==0) {ct=NULL;break;}
			   if (ct!=NULL) 
			    {
				  p_struct* p_str;
				  p_str=FindPrVar(prototipi[cp].nome.n,$1.nome,indice);
				  if (p_str!=NULL)
				  {
					switch (p_str[indice].size)
					{
					 case 0:
				 		i=p_str[indice].ref;
						if(p_str[i].size==1){ist[i_ind].ist_number=I_P_PUSH_BYTE;$$.s=1;}
							else if(p_str[i].size==2){ist[i_ind].ist_number=I_P_PUSH_WORD;$$.s=2;}
							else if(p_str[i].size==4){ist[i_ind].ist_number=I_P_PUSH_DWORD;$$.s=4;}
						ist[i_ind].p1=p_str[indice].offset;
						i_ind++;
						ist[i_ind].ist_number=I_P_PUSH_BITS;
						ist[i_ind].p1=((p_str[indice].bs)&0xFF)+(((p_str[indice].be)<<8)&0xFF00);
						break;
					 case 1:
						$$.s=1;
						ist[i_ind].ist_number=I_P_PUSH_BYTE;
						ist[i_ind].p1=p_str[indice].offset;
						break;
					 case 2:
						$$.s=2;
						ist[i_ind].ist_number=I_P_PUSH_WORD;
						ist[i_ind].p1=p_str[indice].offset;
						break;
					 case 4:
						$$.s=4;
						ist[i_ind].ist_number=I_P_PUSH_DWORD;
						ist[i_ind].p1=p_str[indice].offset;
						break;
					 default:
						yyerror(ERR_DIM /*Errore di dimensione non nota*/);
						$$.s=1;
						ist[i_ind].ist_number=I_P_PUSH_BYTE;
						ist[i_ind].p1=p_str[indice].offset;
						break;
					}
				   $$.i=indice;
				   i_ind++;
				   ct=NULL;
				   i=-1;
				  }
				}
			   if (ct!=NULL) 
			   yyerror(ERR_VAR /*Impossibile accedere ad una variabile non definita*/);
			   else 
			   {
			    if(i==0)
				{
			     switch (scope[indice].size)
				 {
				  case 1:
			       ist[i_ind].ist_number=I_PUSH_BYTE;
			       ist[i_ind].p1=scope[indice].offset;
				   break;
				  case 2:
			       ist[i_ind].ist_number=I_PUSH_WORD;
			       ist[i_ind].p1=scope[indice].offset;
				   break;
				  case 4:
			       ist[i_ind].ist_number=I_PUSH_DWORD;
			       ist[i_ind].p1=scope[indice].offset;
				   break;
				  default:
				   yyerror(ERR_DIM /*Errore di dimensione non nota*/);
			       ist[i_ind].ist_number=I_PUSH_BYTE;
			       ist[i_ind].p1=scope[indice].offset;
				   break;
				 }
				 $$.s=scope[indice].size;
				 $$.i=indice;
				 i_ind++;
				}
			   }
			  }
			| nome '[' espressione ']'
			  {
			    int indice=-1;
				for(i=0;i<v_ind;i++)
				 if(strcmp($1.nome,vect[i])==0) {indice=i;break;}
				if (indice<0) yyerror(ERR_ARRAY /*Array non definito*/);
				else
				 {
				     ist[i_ind].ist_number=I_VECTOR;
				     ist[i_ind].p1=indice; 
				     i_ind++;
				 }
			  }
			| ch_funz {$$.i=-1;$$.s=$1.s;}
			| numero
			  {
			   int num=$1.i;
			   ist[i_ind].ist_number=I_PUSH;
			   ist[i_ind].p1=num;
			   i_ind++;
			   $$.s=$1.s;
			   $$.i=-1;
			  }
			| CHECK '(' espressione ')'
			  {
			   if (macrocomp) yyerror(ERR_ISTNMAC /*Istruzione non valida in una macro*/);
			   ist[i_ind].ist_number=I_P_CHECK;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| CONV '(' espressione ')'
			  {
			   if (macrocomp) yyerror(ERR_ISTNMAC /*Istruzione non valida in una macro*/);
			   ist[i_ind].ist_number=I_CONV;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| CONV16 '(' espressione ')'
			  {
			   if (macrocomp) yyerror(ERR_ISTNMAC /*Istruzione non valida in una macro*/);
			   ist[i_ind].ist_number=I_CONV16;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| CONV24 '(' espressione ')'
			  {
			   if (macrocomp) yyerror(ERR_ISTNMAC /*Istruzione non valida in una macro*/);
			   ist[i_ind].ist_number=I_CONV24;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| CONV32 '(' espressione ')'
			  {
			   if (macrocomp) yyerror(ERR_ISTNMAC /*Istruzione non valida in una macro*/);
			   ist[i_ind].ist_number=I_CONV32;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| '(' espressione ')' 
			  {
			   $$.s=$2.s;
			   $$.i=-1;
			  }
			| espressione '+' espressione 
			  {
			   ist[i_ind].ist_number=I_PLUS;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=max($1.s,$3.s);
			   $$.i=-1;
			  }
			| espressione LSHIFT espressione 
			  {
			   ist[i_ind].ist_number=I_LSHIFT;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=($1.s);
			   $$.i=-1;
			  }
			| espressione RSHIFT espressione 
			  {
			   ist[i_ind].ist_number=I_RSHIFT;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=($1.s);
			   $$.i=-1;
			  }
			| espressione NOT_EQ espressione 
			  {
			   ist[i_ind].ist_number=I_NOT_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| espressione MIU espressione 
			  {
			   ist[i_ind].ist_number=I_MIN_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| espressione MAU espressione 
			  {
			   ist[i_ind].ist_number=I_MAG_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| espressione '<' espressione 
			  {
			   ist[i_ind].ist_number=I_MIN;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| espressione '>' espressione 
			  {
			   ist[i_ind].ist_number=I_MAG;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| espressione EQ espressione 
			  {
			   ist[i_ind].ist_number=I_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| espressione AND espressione 
			  {
			   ist[i_ind].ist_number=I_AND;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| espressione OR espressione 
			  {
			   ist[i_ind].ist_number=I_OR;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| espressione '-' espressione 
			  {
			   ist[i_ind].ist_number=I_MINUS;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=max($1.s,$3.s);
			   $$.i=-1;
			  }
			| espressione '*' espressione 
			  {
			   ist[i_ind].ist_number=I_MUL;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=max($1.s,$3.s);
			   $$.i=-1;
			  }
			| espressione '/' espressione 
			  {
			   ist[i_ind].ist_number=I_DIV;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=max($1.s,$3.s);
			   $$.i=-1;
			  }
			| espressione '%' espressione 
			  {
			   ist[i_ind].ist_number=I_MOD;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=max($1.s,$3.s);
			   $$.i=-1;
			  }
			| '-' espressione 
			  {
			   ist[i_ind].ist_number=I_UN_MINUS;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=$2.s;
			   $$.i=-1;
			  }
			| NOT espressione
			  {
			   ist[i_ind].ist_number=I_NOT;
			   ist[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| assegnamento %prec '='
			  {
			   $$.s=$1.s;
			   $$.i=$1.i;
			  }
			| SIZEOF '(' nome ')'
			  {
			   int indice;
			   const char* ct=$3.nome;i=0;
			   for(indice=0;indice<nv;indice++)
			    if (strcmp($3.nome,scope[indice].n)==0) {ct=NULL;break;}
			   if (ct!=NULL) 
			    {
				  p_struct* p_str;
				  p_str=FindPrVar(prototipi[cp].nome.n,$3.nome,indice);
				  if (p_str!=NULL)
				    {
					ist[i_ind].ist_number=I_PUSH;
					ist[i_ind].p1=p_str->size;
					i_ind++;
					}
				   i=-1;
				}
			   if (ct!=NULL) 
			   yyerror(ERR_VAR /*Impossibile accedere ad una variabile non definita*/);
			   else 
			   {
			    if(i==0)
				{
					ist[i_ind].ist_number=I_PUSH;
					ist[i_ind].p1=scope[indice].size;
					i_ind++;
				}
			   }
			   $$.s=4;
			   $$.i=-1;
			  }
			| OFFSETOF '(' nome ')'
			  {
			   int indice;
			   const char* ct=$3.nome;i=0;
			   for(indice=0;indice<nv;indice++)
			    if (strcmp($3.nome,scope[indice].n)==0) 
				{
				 ct=NULL;
				 ist[i_ind].ist_number=I_OFFSET_S;
				 ist[i_ind].p1=scope[indice].offset;
				 i_ind++;
				 break;
				}
			   if (ct!=NULL) 
			    {
				  p_struct* p_str;
				  p_str=FindPrVar(prototipi[cp].nome.n,$3.nome,indice);
				  if (p_str!=NULL)
				    {
					ist[i_ind].ist_number=I_OFFSET_P;
					ist[i_ind].p1=p_str[indice].offset;
					i_ind++;
					ct=NULL;
					}
				   i=-1;
				}
			   if (ct!=NULL) 
			    yyerror(ERR_VAR /*Impossibile accedere ad una variabile non definita*/);
			   $$.s=4;
			   $$.i=-1;
			  }
			| GETVMVAR '(' cost_str ')'
			  {
			   if (macrocomp) yyerror(ERR_ISTNMAC /*Istruzione non valida in una macro*/);
			   ist[i_ind].ist_number=I_GETVMVAR;
			   ist[i_ind].p1=$3.i;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| COMMAND '(' cost_str ')'
			  {
			   if (!macrocomp) yyerror(ERR_ISTMAC /*Istruzione valida solo in una macro*/);
			   ist[i_ind].ist_number=I_COMMAND;
			   ist[i_ind].p1=$3.i;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
		| LEN '(' nome ')'
			{
			   int indice=-1;
			   for(i=0;i<v_ind;i++)
				 if(strcmp($3.nome,vect[i])==0) {indice=i;break;}
			   if (indice<0) yyerror(ERR_ARRAY /*Array non definito*/);
				else
				 {
				     ist[i_ind].ist_number=I_VLEN;
				     ist[i_ind].p1=indice; 
				     i_ind++;
				 }
			   $$.s=4;
			   $$.i=-1;
			}
		| STRLEN '(' nome ')'
			{
			   int indice=-1;
			   for(i=0;i<v_ind;i++)
				 if(strcmp($3.nome,vect[i])==0) {indice=i;break;}
			   if (indice<0) yyerror(ERR_ARRAY /*Array non definito*/);
				else
				 {
				     ist[i_ind].ist_number=I_STRLEN;
				     ist[i_ind].p1=indice; 
				     i_ind++;
				 }
			   $$.s=4;
			   $$.i=-1;
			}
			;
assegnamento:
			  nome '=' espressione
			  {
			   int indice;
			   const char* ct=$1.nome;
			   for(indice=0;indice<nv;indice++)
			    if (strcmp($1.nome,scope[indice].n)==0) 
				 {
				  ct=NULL;
			      ist[i_ind].ist_number=I_ASSEGN;
			      ist[i_ind].p1=indice; //$1.i;
			      i_ind++;
				  break;
				 }
			   if (ct!=NULL) 
			   {
			    p_struct* pstr;
			    pstr=FindPrVar(prototipi[cp].nome.n,$1.nome,i);
				if(i>=0)
				{
				 ct=NULL;
				 indice=i;
				 if (pstr[indice].size==0)
					{
						int itmp=i;
				 		i=pstr[indice].ref;
						if(pstr[i].size==1){ist[i_ind].ist_number=I_P_PUSH_BYTE;$$.s=1;}
							else if(pstr[i].size==2){ist[i_ind].ist_number=I_P_PUSH_WORD;$$.s=2;}
							else if(pstr[i].size==4){ist[i_ind].ist_number=I_P_PUSH_DWORD;$$.s=4;}
						ist[i_ind].p1=pstr[indice].offset;
						i_ind++;
						ist[i_ind].ist_number=I_P_ASSEGN_BITS;
					    ist[i_ind].p1=itmp; 
						i_ind++;
					}
				 else
				 {
					ist[i_ind].ist_number=I_P_ASSEGN;
					ist[i_ind].p1=i; 
					i_ind++;
				 }
				}
			   }
			   if (ct!=NULL) yyerror(ERR_VAR /*Impossibile accedere ad una variabile non definita*/);
			   $$.s=$3.s;
			  }
			| nome '[' espressione ']' '=' espressione 
			  {
			    int indice=-1;
				for(i=0;i<v_ind;i++)
				 if(strcmp($1.nome,vect[i])==0) {indice=i;break;}
				if (indice<0) yyerror(ERR_ARRAY /*Array non definito*/);
				else
				 {
				     ist[i_ind].ist_number=I_V_ASSEGN;
				     ist[i_ind].p1=indice; 
				     i_ind++;
				 }
			  }
			  ;
ch_funz
		: nome '(' l_espress ')' %prec CH_FUNZ
				{
				 i=cerca_prototipo($1.nome);
				 if(i<0) {yyerror(ERR_FUNZ /*Chiamata di funzione non definita*/);$$.s=0;}
				 else 
				 {
				  $$.s=prototipi[i].rettype;
				  if ($3.n!=prototipi[i].np)
					{yyerror(ERR_PARS /*Numero di parametri incompatibile*/);}
				 }
				 ist[i_ind].ist_number=I_CH_FUNZ;
				 ist[i_ind].p1=i;
				 i_ind++;
				}
		| nome '(' ')' %prec CH_FUNZ
				{
				 i=cerca_prototipo($1.nome);
				 if(i<0) {yyerror(ERR_FUNZ /*Chiamata di funzione non definita*/);$$.s=0;}
				 else 
				 {
				  $$.s=prototipi[i].rettype;
				  if (0!=prototipi[i].np)
					{yyerror(ERR_PARS /*Numero di parametri incompatibile*/);}
				 }
				 ist[i_ind].ist_number=I_CH_FUNZ;
				 ist[i_ind].p1=i;
				 i_ind++;
				};
l_espress	: espressione {$$.n=1; $$.pars[0]=$1.s;}
			| l_espress ',' espressione
			   {
				if($$.n>=MAXPARS) yyerror(ERR_TOOPARS /*Troppi parametri per la funzione*/);
				else 
				{
			     $$.pars[$$.n]=$3.s;
				 ($$.n)++;
			    }
			   };
programma	: llinee 
				{
					if(!errorflag)
					 {
					  if (macrocomp) 
					  {
						i=MAGIC_MACRO;
						if(fwrite(&i,sizeof(int),1,out)!=1)
							yyerror(ERR_SAVEMAC /*Impossibile salvare la macro compilata*/);
					  }
					  else 
					  {
						i=MAGIC_XFF;
						if(fwrite(&i,sizeof(int),1,out)!=1)
							yyerror(ERR_SAVE /*Impossibile salvare il file compilato*/);
						if(fwrite(&Pdo_time,sizeof(time_t),1,out)!=1)
							yyerror(ERR_SAVE /*Impossibile salvare il file compilato*/);
						if(fwrite(&Pdo_Id,sizeof(int),1,out)!=1)
							yyerror(ERR_SAVE /*Impossibile salvare il file compilato*/);
					  }

					  CCodeProcessor p;
					  p.SetVectNumber(v_ind);
					  for(i=0;i<nc;i++)
					  {
					   p.AddString(costanti[i].s);
					  }
					  p.SetPr(prototipi,np);
					  p.Serialize(0,out);
					  p.SetPr(NULL,0);
					 }
					else Say(ERR_NOOBJ /*Codice oggetto non generato a causa degli errori riscontrati.*/);
				}
			| ;
llinee		: dichiarazioni
			| c_function
			| llinee dichiarazioni
			| llinee c_function ;
dichiarazioni 
			: prototipo ;
prototipo	: tipo nome '(' ')' ';' 
				{
				 if(cerca_prototipo($2.nome)>=0) yyerror(ERR_RIDF /*Ridefinizione di funzione*/);
				 prototipi[np].nome=$2.nome;
				 prototipi[np].np=0;
				 prototipi[np].rettype=$1.i;
				 np++;
				}
			| tipo nome '(' l_variabili ')' ';'
				{
				 if(cerca_prototipo($2.nome)>=0) yyerror(ERR_RIDF /*Ridefinizione di funzione*/);
				 prototipi[np].nome=$2.nome;
				 prototipi[np].np=$4.n;
				 if (prototipi[np].parametri==NULL) prototipi[np].parametri=new int[$4.n];
				 for(i=0;i<$4.n;i++) prototipi[np].parametri[i]=$4.pars[i];
				 prototipi[np].rettype=$1.i;
				 np++;
				}
			| ARRAY nome ';'
				{
					vect[v_ind]=new char[strlen($2.nome)+1];
					strcpy(vect[v_ind],$2.nome);
					v_ind++;
				}
				;
l_variabili : tipo nome 
			   {
			    nv=0;
			    $$.n=1; $$.pars[0]=$1.s;
				scope[nv].size=$1.i;
				scope[nv].offset=0; 
				scope[nv]=$2.nome;
				nv++;
			   }
			| nome 
			   {
			    yywarn(ERR_NOPROT /*Manca un tipo nel prototipo. Si assumer DWORD.*/);
			    nv=0;
			    $$.n=1; $$.pars[0]=4;
				scope[nv].size=4;
				scope[nv].offset=0; 
				scope[nv]=$1.nome;
				nv++;
			   }
			| l_variabili ',' tipo nome 
			   {
			    $$.n=$1.n;
				if($$.n>=MAXPARS) yyerror(ERR_TOOPARS /*Troppi parametri per la funzione*/);
				else 
				{
			     $$.pars[$$.n]=$3.s;
				 ($$.n)++;
			    }
				scope[nv].size=$3.i;
				scope[nv].offset=scope[nv-1].offset+scope[nv-1].size;
				scope[nv]=$4.nome;
				for(i=0;i<nv;i++) 
				if (strcmp(scope[i].n,$4.nome)==0)
				   yyerror(ERR_RIDEFVAR /*Ridefinizione di variabile*/);
				nv++;
			   }
			| l_variabili ',' nome 
			   {
			    yywarn(ERR_NOPROT /*Manca un tipo nel prototipo. Si assumer DWORD.*/);
			    $$.n=$1.n;
				if($$.n>=MAXPARS) yyerror(ERR_TOOPARS /*Troppi parametri per la funzione*/);
				else 
				{
			     $$.pars[$$.n]=4;
				 ($$.n)++;
			    }
				scope[nv].size=4;
				scope[nv].offset=scope[nv-1].offset+scope[nv-1].size;
				scope[nv]=$3.nome;
				for(i=0;i<nv;i++) 
				if (strcmp(scope[i].n,$3.nome)==0)
				   yyerror(ERR_VARRID /*Ridefinizione di variabile*/);
				nv++;
			   }
			   ;
def_var		: def_v ';' {};
def_v		: tipo nome 
				{
				 $$.i = $1.i; scope[nv].size=$1.i;
				 if ($$.i!=4) yywarn(ERR_CAST /*I tipi vengono automaticamente convertiti a DWORD*/);
				 if (nv==0) scope[nv].offset=0; 
				  else 
				   scope[nv].offset=scope[nv-1].offset+scope[nv-1].size;
				 scope[nv]=$2.nome;
				 for(i=0;i<nv;i++) 
				  if (strcmp(scope[i].n,$2.nome)==0)
				   yyerror(ERR_VARRID /*Ridefinizione di variabile*/);
				 nv++;
				}
			| def_v ',' nome 
				{
				 $$.i=$1.i; scope[nv].size=$1.i;
				 if (nv==0) scope[nv].offset=0; 
				  else 
				   scope[nv].offset=scope[nv-1].offset+$1.i;
				 scope[nv]=$3.nome;
				 for(i=0;i<nv;i++) 
				  if (strcmp(scope[i].n,$3.nome)==0)
				   yyerror(ERR_VARRID /*Ridefinizione di variabile*/);
				 nv++;
				}
			| tipo error {$$.i=0;};
	/* LISTA DI ISTRUZIONI */
listruzioni	
		: listruzioni istruzione {}
		| istruzione {}
		| error {}
		;
istruzione 	
		: istruz ';'
		  {
			   //ist[i_ind].ist_number=I_LAB;
			   //ist[i_ind].p1=yylineno;
			   $$.i=i_ind;
			   //i_ind++;
		  }
		| costrutto
		  {
			   //ist[i_ind].ist_number=I_LAB;
			   //ist[i_ind].p1=yylineno;
			   $$.i=i_ind;
			   //i_ind++;
		  }
		| def_var 
		  {
			   //ist[i_ind].ist_number=I_LAB;
			   //ist[i_ind].p1=yylineno;
			   $$.i=i_ind;
			   //i_ind++;
		  }
		| '{' listruzioni '}'
		  {
			   //ist[i_ind].ist_number=I_LAB;
			   //ist[i_ind].p1=yylineno;
			   $$.i=i_ind;
			   //i_ind++;
		  }
		| '{' '}'
		  {
			   //ist[i_ind].ist_number=I_LAB;
			   //ist[i_ind].p1=yylineno;
			   $$.i=i_ind;
			   //i_ind++;
		  }
		;
	/* DEFINIZIONE DEI PRINCIPALI COSTRUTTI STRUTTURATI */
costrutto	
		: c_do 
		| c_while 
		| c_if 
		| c_for ;
do		: DO 
		  {
			   $$.i=i_ind;
			   lab[nl]=i_ind;
			   labt.push(nl);
			   nl++;
			   lab[nl]=-1;
			   labi.push(nl);
			   nl++;
			   lab[nl]=-1;
			   labf.push(nl);
			   nl++;
		  };
while	: WHILE 
		  {
			   $$.i=i_ind;
			   lab[nl]=i_ind;
			   labi.push(nl);
			   nl++;
			   lab[nl]=-1;
			   labf.push(nl);
			   nl++;
		  };
for		: FOR
		  {
			   /* Crea le label non inizializzate per continue e break */
			   $$.i=i_ind;
			   lab[nl]=-1;
			   labi.push(nl);
			   nl++;
			   lab[nl]=-1;
			   labf.push(nl);
			   nl++;
		  };
if		: IF
		  {
			   $$.i=i_ind;
			   lab[nl]=-1;
			   labt.push(nl);
			   nl++;
		  };
else	: ELSE
		  {
			   $$.i=i_ind;
			   /*lab[nl]=-1;
			   labt.push(nl);
			   nl++;*/
		  };
c_do	
		: do istruzione WHILE {lab[labi.get_top()]=i_ind;} '(' espressione ')' ';' 
		  {
		   ist[i_ind].ist_number=I_NOT;
		   ist[i_ind].p1=0;
		   i_ind++;
		   ist[i_ind].ist_number=I_IF;
		   ist[i_ind].p1=labt.pop();
		   i_ind++;
		   lab[labf.pop()]=i_ind;
		   labi.pop();
		  }
		| do istruzione WHILE error 
		  {yyerror (ERR_DO /*Errore nel do*/);};
c_while	
		: while '(' espressione ')' 
		  {
		   ist[i_ind].ist_number=I_IF;
		   ist[i_ind].p1=labf.get_top();
		   i_ind++;
		  }
		  istruzione 
		  {
		   ist[i_ind].ist_number=I_CONTINUE;
		   ist[i_ind].p1=labi.pop();
		   i_ind++;
		   lab[labf.pop()]=i_ind;
		  }
		| while error 
		  {yyerror (ERR_WHILE /*Errore nel while*/);lab[nl-1]=i_ind;};
t_if	: {
		   ist[i_ind].ist_number=I_IF;
		   ist[i_ind].p1=labt.get_top();
		   i_ind++;
		  };
c_if	
		: if '(' espressione ')' t_if
			istruzione {lab[labt.pop()]=i_ind;}
		| if '(' espressione ')' t_if
		    istruzione else 
		  {
		   // Imposta la label per l'else
		   i=labt.get_top();
		   // Crea una label non inizializzata per il break dell'istruzione
		   lab[nl]=-1;
		   labt.push(nl);
		   nl++;
		   // Inserisce l'istruzione di break;
		   ist[i_ind].ist_number=I_BREAK;
		   ist[i_ind].p1=labt.get_top();
		   i_ind++;
		   lab[i]=i_ind;
		  }
			istruzione {lab[labt.pop()]=i_ind;labt.pop();}
		| if error {yyerror (ERR_IF /*Errore nell'if*/);};
/*
	Il costrutto for:
		for(esp1;esp2;esp3) ist;
	viene tradotto;
			esp1;
		lab1:
			if(esp2) goto lab2 
			else goto lab3;
		lab4:
			esp3;
			goto lab1;
		lab2:
			ist;
			goto lab4;
		lab3:
	continue salta a lab4
	break salta a lab3
*/

c_for	
		: for '(' espressione ';' 
		  {
		   // Label Check
		   lab[nl]=i_ind;
		   labt.push(nl);
		   nl++;
		  }
			espressione ';'
		  {
			   // Label fine istruzione (da riempire)
			   lab[nl]=-1;
			   labt.push(nl);
			   nl++;
			   // If
			   ist[i_ind].ist_number=I_IF;
			   ist[i_ind].p1=labt.get_top();
			   i_ind++;
			   // Label istruzione (da riempire)
			   lab[nl]=-1;
			   labt.push(nl);
			   nl++;
			   // Istruzione di salto all'istruzione
			   ist[i_ind].ist_number=I_GOTO;
			   ist[i_ind].p1=labt.get_top();
			   i_ind++;
			   // Label 3 Espressione
			   lab[nl]=i_ind;
			   labt.push(nl);
			   nl++;
			   // Label per continue;
			   lab[labi.get_top()]=i_ind;
		  }
			espressione ')' 
		  {
			   int a,b,c,d;
			   a=labt.pop();
			   b=labt.pop();
			   c=labt.pop();
			   d=labt.pop();
			   labt.push(d);
			   labt.push(c);
			   labt.push(b);
			   labt.push(a);
			   // Salta al check
			   ist[i_ind].ist_number=I_GOTO;
			   ist[i_ind].p1=d;
			   i_ind++;
			   // Label per l'istruzione
			   lab[b]=i_ind;
		  }
			istruzione 
		  {
		   // Salta alla 3 espressione
		   ist[i_ind].ist_number=I_GOTO;
		   ist[i_ind].p1=labt.pop();
		   i_ind++;
		   lab[labf.pop()]=i_ind;
		   labt.pop();
		   lab[labt.pop()]=i_ind;
		   labt.pop();
		   labi.pop();
		  }
		| for error {yyerror (ERR_FOR /*Errore nel for*/);}
		;
c_function	
		: tipo nome '(' ')'
				{
				 nv=0;
				 nl=0;
				 l_ind=0;
				 i_ind=0;
				 cp=i=cerca_prototipo($2.nome);
				 if(i>=0 && !conf_prototipi(i,NULL)) yyerror(ERR_RIDF /*Ridefinizione di funzione*/);
				 if(i<0)
				 {
				  prototipi[np].nome=$2.nome;
				  prototipi[np].np=0;
				  prototipi[np].rettype=$1.s;
				  cp=np;
				  np++;
				 }
				}
		  '{' listruzioni '}'
				{
				 for (i=0;i<i_ind;i++)
					if(ist[i].ist_number==I_GOTO ||ist[i].ist_number==I_IF )
					 ist[i].p1=lab[ist[i].p1];
				 cp=i=cerca_prototipo($2.nome);
				 if (i>=0)
				 {
				  prototipi[i].AddIst(ist,i_ind);
				  prototipi[i].nv=nv;
				  prototipi[i].vars=new int[nv];
				  prototipi[i].nomivars=new char*[nv];
				  for(int h=0;h<nv;h++) 
				  {
				    prototipi[i].vars[h]=scope[h].size;
				    prototipi[i].nomivars[h]=new char[strlen(scope[h].n)+1];
					if (prototipi[i].nomivars[h]) strcpy(prototipi[i].nomivars[h],scope[h].n);
				  }
				 }
				 i_ind=0;
				 l_ind=0;
				 nl=0;
				}
		| tipo nome '(' l_variabili ')' 
				{
				 nl=0;
				 l_ind=0;
				 i_ind=0;
				 i=cerca_prototipo($2.nome);
				 if(i>=0 && !conf_prototipi(i,&($4))) yyerror(ERR_RIDF /*Ridefinizione di funzione*/);
				 if(i<0)
				 {
				  prototipi[np].nome=$2.nome;
				  prototipi[np].np=$4.n;
				  prototipi[np].rettype=$1.s;
				  if (prototipi[np].parametri==NULL) prototipi[np].parametri=new int[$4.n];
				  for (i=0;i<$4.n;i++) prototipi[np].parametri[i]=$4.pars[i];
				  cp=np;
				  np++;
				 }
				}
		  '{' listruzioni '}'
				{
				 for (i=0;i<i_ind;i++)
					if(ist[i].ist_number==I_GOTO ||ist[i].ist_number==I_IF )
					 ist[i].p1=lab[ist[i].p1];
				 i=cerca_prototipo($2.nome);
				 if (i>=0)
				 {
				  prototipi[i].AddIst(ist,i_ind);
				  prototipi[i].nv=nv;
				  prototipi[i].vars=new int[nv];
				  prototipi[i].nomivars=new char*[nv];
				  for(int h=0;h<nv;h++) 
				  {
				    prototipi[i].vars[h]=scope[h].size;
				    prototipi[i].nomivars[h]=new char[strlen(scope[h].n)+1];
					if (prototipi[i].nomivars[h]) strcpy(prototipi[i].nomivars[h],scope[h].n);
				  }
				 }
				 i_ind=0;
				 l_ind=0;
				 nl=0;
				}
		| tipo nome '(' error {yyerror(ERR_FUNCP /*errore nella funzione o nel prototipo*/);};
istruz	
		: CONTINUE 
			{
			   ist[i_ind].ist_number=I_CONTINUE;
			   ist[i_ind].p1=labi.get_top();
			   i_ind++;
			}
		| BREAK 
			{
			   ist[i_ind].ist_number=I_BREAK;
			   ist[i_ind].p1=labf.get_top();
			   i_ind++;
			}
		| espressione 
			{
			   ist[i_ind].ist_number=I_POP;
			   ist[i_ind].p1=0;
			   i_ind++;
			}
		| TITLE '(' cost_str ')'
			{
			   ist[i_ind].ist_number=I_TITLE;
			   ist[i_ind].p1=$3.i;
			   i_ind++;
			}
		| TITLE '(' cost_str ',' l_espress ')'
			{
				yyerror(ERR_TITLE /*L'istruzione 'title' non vuole parametri*/);
			}
		| PRINT '(' cost_str ',' l_espress ')'
			{
			   ist[i_ind].ist_number=I_PUSH;
			   ist[i_ind].p1=$5.n;
			   i_ind++;
			   ist[i_ind].ist_number=I_PRINT;
			   ist[i_ind].p1=$3.i;
			   i_ind++;
			}
		| PRINT '(' cost_str ')'
			{
			   ist[i_ind].ist_number=I_PUSH;
			   ist[i_ind].p1=0;
			   i_ind++;
			   ist[i_ind].ist_number=I_PRINT;
			   ist[i_ind].p1=$3.i;
			   i_ind++;
			}
		| APRINT '(' cost_str ',' nome ')'
			{
			   ist[i_ind].ist_number=I_PUSH;
			   ist[i_ind].p1=$3.i;
			   i_ind++;
			   int indice=-1;
			   for(i=0;i<v_ind;i++)
				 if(strcmp($5.nome,vect[i])==0) {indice=i;break;}
			   if (indice<0) yyerror(ERR_ARRAY /*Array non definito*/);
				else
				 {
				     ist[i_ind].ist_number=I_APRINT;
				     ist[i_ind].p1=indice; 
				     i_ind++;
				 }
			}
		| CLEAR '(' nome ')'
			{
			   int indice=-1;
			   for(i=0;i<v_ind;i++)
				 if(strcmp($3.nome,vect[i])==0) {indice=i;break;}
			   if (indice<0) yyerror(ERR_ARRAY /*Array non definito*/);
				else
				 {
				     ist[i_ind].ist_number=I_CLEAR;
				     ist[i_ind].p1=indice; 
				     i_ind++;
				 }
			}
		| RETURN espressione 
			{
			   ist[i_ind].ist_number=I_END;
			   ist[i_ind].p1=0;
			   i_ind++;
			}
		| RESETLOG '(' ')'
			{
			   ist[i_ind].ist_number=I_RESET_LOG_VARS;
			   ist[i_ind].p1=0;
			   i_ind++;
			}
		| RESETLOG '(' espressione ',' espressione ')'
			{
			   ist[i_ind].ist_number=I_RESET_LOG_VARS;
			   ist[i_ind].p1=1;
			   i_ind++;
			}
		| RESETLOG '(' espressione ',' espressione ',' espressione ')'
			{
			   ist[i_ind].ist_number=I_RESET_LOG_VARS;
			   ist[i_ind].p1=2;
			   i_ind++;
			}
		| prototipo 
			{
			   yyerror(ERR_GRAF /*Possibile mancanza di una graffa chiusa*/);
			   return -1;
			}
		;

%%

extern int yylineno;

int yyerror(char* s)
{
 char t[1000];
 sprintf(t,ERR_LINE /*Errore di analisi del sorgente alla linea %d\n%s\n*/,yylineno,s);
 Say(t);
 if(strcmp(s,"syntax error")==0) EndParsing();
 errorflag=1;
 return 1;
}

int yywarn(char* s)
{
 char t[1000];
 if (s==NULL) s="";
 sprintf(t,ERR_WARNLINE /*Warning alla linea %d.\n%s\n*/,yylineno,s);
 Say(t);
 return 1;
}
