%{
/**********************************************************************
		SCANNER PER IL LINGUAGGIO DEL PARSER
		    (C) 1998 - VIANO PIERO
 **********************************************************************/

#include <stdio.h>
#include <string.h>
#include "tipi.h"
#include "parser.h"

#ifdef CHECK_L
#ifdef CHECK_L_C
#define CHSAY(A) printf("%s\n",A);
#else
#define CHSAY(A) Say(A)
#endif
#else 
#define CHSAY(A) 
#endif

#define SC_ERROR -1

extern int macrocomp;
static int oldline=0;
%}

%option yylineno
%option caseless

SPAZIO ([\t\r\n ])
SPAZI ({SPAZIO}*)
LETTER ([a-zA-Z])
DIGIT ([0-9])
F_DIGIT ([1-9])
DECIMALE ({DIGIT}*{F_DIGIT}|0)
FINO_FINE ([^\n]*)
R_REM (\/\/)

HEX ((("0x")|("0X"))([a-fA-F]|{DIGIT})+)
OCT (("0")([0-7])+)
INTERO ({F_DIGIT}{DIGIT}*)
VAR_NAME ((("_")|{LETTER})({LETTER}|{DIGIT}|("_"))*)

COST_STRINGA (\"[^\"\n]*\")
COST_INT_CORTO ({INTERO}|[0])

QUOTE	\'([^\\']|\\[^'\\]+|\\\\)\'
OP	([-+=*/<>{}();,:%])|("\[")|("\]")

VAR ({VAR_NAME})

COMMENTO ("/*"([^*]*|"*"+[^*/])"*"+\/)
COMMENTO_L ("//".*)

%%
\xd	/* Scarta LF*/
{COMMENTO}	{ CHSAY("Commenti");/* Scarta commenti */ }
{COMMENTO_L}	{ CHSAY("Commenti_L");/* Scarta commenti */ }

do	{CHSAY("DO"); return DO; }
if	{CHSAY("IF"); return IF; }
else	{CHSAY("ELSE");return ELSE; }
while	{CHSAY("WHILE");return WHILE; }
for	{CHSAY("FOR");return FOR; }
return	{CHSAY("RETURN");return RETURN; }
break	{CHSAY("BREAK");return BREAK; }
continue	{CHSAY("CONTINUE");return CONTINUE; }
array	{CHSAY("ARRAY");return ARRAY; }
byte	{CHSAY("BYTE");return BYTE; }
word	{CHSAY("WORD");return WORD; }
dword	{CHSAY("DWORD");return DWORD; }
sizeof	{CHSAY("SIZEOF");return SIZEOF; }
offsetof	{CHSAY("OFFSETOF");return OFFSETOF; }
getvmvar	{CHSAY("GETVMVAR");return GETVMVAR; }
printf	{CHSAY("PRINTF");return PRINT; }
aprintf	{CHSAY("APRINTF");return APRINT; }
clear	{CHSAY("CLEAR");return CLEAR; }
resetlog	{CHSAY("RESETLOG");return RESETLOG; }
arrlen	{CHSAY("LEN");return LEN; }
strlen	{CHSAY("STRLEN");return STRLEN; }
title	{CHSAY("TITLE");return TITLE; }
check	{CHSAY("CHECK");if (macrocomp) return NOME; else return CHECK; }
conv	{CHSAY("CONV");if (macrocomp) return NOME; else return CONV; }
conv16	{CHSAY("CONV16");if (macrocomp) return NOME; else return CONV16; }
conv24	{CHSAY("CONV24");if (macrocomp) return NOME; else return CONV24; }
conv32	{CHSAY("CONV32");if (macrocomp) return NOME; else return CONV32; }
command {CHSAY("COMMAND");if (macrocomp) return COMMAND; else return NOME;}
{COST_STRINGA} 	{CHSAY("STRINGA"); return COST_STRINGA; }
{COST_INT_CORTO}	{CHSAY("N_IC"); return NUMERO; }
{HEX}	{CHSAY("N_HEX"); return C_H_NUM; }
{OCT}	{CHSAY("N_OCT"); return C_O_NUM; }
{QUOTE}	{CHSAY("CHARACT"); return LIT_CH; }
AND {CHSAY("AND");return AND;}
"&" {CHSAY("AND");return AND;}
"&&" {CHSAY("AND");return AND;}
OR {CHSAY("OR");return OR;}
"|" {CHSAY("OR");return OR;}
"||" {CHSAY("OR");return OR;}
NOT {CHSAY("NOT");return NOT;}
"!" {CHSAY("NOT");return NOT;}
"~" {CHSAY("NOT");return NOT;}
{OP}	{CHSAY(yytext); return *yytext; }
"=="	{CHSAY("=="); return EQ; }
"!="	{CHSAY("!="); return NOT_EQ; }
">="	{CHSAY(">="); return MAU; }
"<="	{CHSAY("<="); return MIU; }
"<<"	{CHSAY("<<"); return LSHIFT; }
">>"	{CHSAY(">>"); return RSHIFT; }
{VAR}	{CHSAY("NOME");return NOME;}


{SPAZIO}+ {/*ignora gli spazi*/if (yytext[0]=='\n' && oldline!=yylineno)
			{oldline=yylineno;ist[i_ind].ist_number=I_LAB;
			 ist[i_ind].p1=yylineno;
			 i_ind++;}}

. {char t[200];sprintf(t,"Scanner error at line %d\n",yylineno);Say(t);return (SC_ERROR);}
%%

int yywrap()
{
 oldline=0;
 return 1;
}

void EndParsing()
{
	if (yyin) fseek (yyin,0,SEEK_END);
	YY_FLUSH_BUFFER;
}

