/****************************************************************************
			      PACKET PARSER - PARSER
				  (C) 1998 by VIANO PIERO
 ****************************************************************************/

%{
#include <stdio.h>
#include <stdlib.h>
#include "../../comuni/asksay.h"
#include "../../comuni/vec_cl.h"
#include "../../comuni/mystring.h"
#include "l_structs.h"

#ifndef ENGLISH
#define ERR_WRITE "Errore di scrittura del file di output"
#define ERR_NAMEDEF "Nome gi definito in questa struttura"
#define ERR_NAMEPLONG "Nome del primo protocollo troppo lungo. Verr troncato."
#define ERR_FIELD "Impossibile accedere ad un campo non definito"
#define ERR_DIM "Errore di dimensione non nota"
#define ERR_LINE "Errore alla linea :%d\n%s\n"
#define ERR_PAUSE "Premere invio per continuare"
#else
#define ERR_WRITE "Error writing output file"
#define ERR_NAMEDEF "Name already defined in this structure"
#define ERR_NAMEPLONG "First protocol name too long. It will be truncated."
#define ERR_FIELD "Unable to access an undefined filed"
#define ERR_DIM "Unknown dimension error"
#define ERR_LINE "Error in line :%d\n%s\n"
#define ERR_PAUSE "Press a key to continue"
#endif

header log_header;
vector <packet> p;
vector <p_struct> p_str;
vector <istruzione> ist;
int p_ind;
int i_ind;
int np;
int l,t;

extern FILE* out;
extern char* yytext;
extern int yylex();
int yyerror (const char* c);

char FirstProtocol[MAX_NAME+3];

const char* agg_nome(char* t)
{
	int l,i;
	l=strlen(yytext);
	for (i=0;i<l;i++)
	 if (yytext[i]>='a' && yytext[i]<='z')
	  { yytext[i]= yytext[i]+ 'A'-'a';}
	if (strlen(t)>50) t[49]='\0';
	return t;
}

static int i;

inline void OUTPUT(int k) 
{
 if(fwrite(&k,sizeof(int),1,out)==0) 
 {
  yyerror(ERR_WRITE /*Errore di scrittura del file di output*/);
  return;
 }
}

inline void SEEK(int k) 
{
	fseek(out,k,SEEK_SET);
}

int checkexisting(const char* c)
{
	int i;
	for(i=0;i<p_ind;i++)
	 if(strcmp(c,p_str[i].nome)==0) 
		 {
		  yyerror(ERR_NAMEDEF /*Nome gi definito in questa struttura*/);
		  return 1;
		 }
	return 0;
}

%}

%token HEADER
%token ENDHH
%token TRAILER
%token ENDHT
%token PHEADER
%token ENDPH
%token PTRAILER
%token ENDPT
%token SIZE
%token CHECK
%token TYPE
%token MUSTINVERT
%token LINKTYPE
%token NOME
%token STRINGA
%token NOT_EQ
%token NUMERO
%token NUMERO_H
%token BYTET
%token WORDT
%token DWORDT
%token PLEN
%token LEN
%token FIRSTPROTOCOL
%token SECS
%token USECS
%token WRITTEN
%token DISCARDED


%start file

%left OR
%left AND
%left '=',NOT_EQ,'<','>',MIU,MAU
%left '+','-'
%left '*','/','%'
%right NOT,MENO_UNARIO

%%
	/* DEFINIZIONI GENERALI */

file		: header packet_formats trailer {SEEK(sizeof(int));OUTPUT(np);};
hdr_init	: HEADER {p_ind=0;i_ind=0;OUTPUT(O_HDRH);np=0;OUTPUT(np);};
header		: hdr_init structs ENDHH hdefs 
			  {
			   OUTPUT($2);
			   OUTPUT(i_ind);
			   for (i=0;i<i_ind;i++)
			    {
				 OUTPUT(ist[i].ist_number);
				 OUTPUT(ist[i].p1);
				}
			   OUTPUT(O_HDRH_E);
			   i_ind=0;
			   p_ind=0;
			  };
trailer		: TRAILER structs ENDHT 
			  {
			   OUTPUT(O_HDRT);
			   OUTPUT($2);
			   OUTPUT(O_HDRT_E);
			   i_ind=0;
			   p_ind=0;
			  };
packet_formats
			: pheader pdefs psdefs pudefs pwdefs pddefs
			  {
			   OUTPUT(O_PKTH);
			   OUTPUT($1);
			   OUTPUT(i_ind);
			   for (i=0;i<i_ind;i++)
			    {
				 OUTPUT(ist[i].ist_number);
				 OUTPUT(ist[i].p1);
				}
			   OUTPUT(O_PKTH_E);
			   i_ind=0;
			   p_ind=0;
			  }
			  ptrailer
			  {
			   OUTPUT(O_PKTT);
			   OUTPUT($8);
			   OUTPUT(O_PKTT_E);
			   i_ind=0;
			   p_ind=0;
			  };
			| packet_formats pheader pdefs psdefs pudefs pwdefs pddefs 
			  {
			   OUTPUT(O_PKTH);
			   OUTPUT($2);
			   OUTPUT(i_ind);
			   for (i=0;i<i_ind;i++)
			    {
				 OUTPUT(ist[i].ist_number);
				 OUTPUT(ist[i].p1);
				}
			   OUTPUT(O_PKTH_E);
			   i_ind=0;
			   p_ind=0;
			  } 		
			  ptrailer
  			  {
			   OUTPUT(O_PKTT);
			   OUTPUT($9);
			   OUTPUT(O_PKTT_E);
			   i_ind=0;
			   p_ind=0;
			  };
pheader		: PHEADER structs ENDPH {$$=$2;np++;};
ptrailer	: PTRAILER structs ENDPT {$$=$2;};
str			: str def {$$=$1+$2;}
			| def {$$=$1;};
structs		: str {$$=$1;}
			| {$$=0;};
def			: BYTET NOME 
				{
				 $$=1;p_str[p_ind].size=1;
				 if (p_ind==0) p_str[p_ind].offset=0; 
				  else p_str[p_ind].offset=p_str[p_ind-1].offset+p_str[p_ind-1].size;
				 strcpy(p_str[p_ind].nome, agg_nome(yytext));
				 checkexisting(yytext);
				 p_ind++;
				}
			| WORDT NOME
				{
				 $$=2;p_str[p_ind].size=2;
				 if (p_ind==0) p_str[p_ind].offset=0; 
				  else p_str[p_ind].offset=p_str[p_ind-1].offset+p_str[p_ind-1].size;
				 strcpy(p_str[p_ind].nome, agg_nome(yytext));
				 checkexisting(yytext);
				 p_ind++;
				}
			| DWORDT NOME
				{
				 $$=4;p_str[p_ind].size=4;
				 if (p_ind==0) p_str[p_ind].offset=0; 
				  else p_str[p_ind].offset=p_str[p_ind-1].offset+p_str[p_ind-1].size;
				 strcpy(p_str[p_ind].nome, agg_nome(yytext));
				 checkexisting(yytext);
				 p_ind++;
				};
hdefs		: hdefs1 hdefs2;
hdefs1		: MUSTINVERT ':' espressione 
				{
			     ist[i_ind].ist_number=I_INVERTBYTES;
			     ist[i_ind].p1=0;
			     i_ind++;
				};
hdefs2		: LINKTYPE ':' espressione
				{
			     ist[i_ind].ist_number=I_LINKTYPE;
			     ist[i_ind].p1=0;
			     i_ind++;
				};
stringa		: STRINGA
				{
					strmai(yytext);
					l=strlen(yytext)-1;
					yytext[l]='\0';
					l--;
					if (l-1>MAX_NAME) 
					 {
					  Say(ERR_NAMEPLONG /*Nome del primo protocollo troppo lungo. Verr troncato.*/);
					  yytext[MAX_NAME]='\0';
					 }
					strcpy(FirstProtocol,yytext+1);
				}
pdefs		: PLEN ':' espressione 
			  LEN ':' espressione 
			  TYPE ':' espressione
			  CHECK ':' espressione 
			  FIRSTPROTOCOL ':' stringa
				{
			     ist[i_ind].ist_number=I_CHECK;
			     ist[i_ind].p1=0;
			     i_ind++;
			     ist[i_ind].ist_number=I_TYPE;
			     ist[i_ind].p1=0;
			     i_ind++;
			     ist[i_ind].ist_number=I_LEN;
			     ist[i_ind].p1=0;
			     i_ind++;
			     ist[i_ind].ist_number=I_PLEN;
			     ist[i_ind].p1=0;
			     i_ind++;
				 l=strlen(FirstProtocol);
				 for(t=l-1;t>=0;t--)
				 {
					ist[i_ind].ist_number=I_PUSH;
					ist[i_ind].p1=FirstProtocol[t];
					i_ind++;
				 }
				 ist[i_ind].ist_number=I_FIRSTP;
				 ist[i_ind].p1=l;
				 i_ind++;
				 $$=i_ind;
				};
psdefs		: SECS ':' espressione 
				{
			     ist[i_ind].ist_number=I_SECS;
			     ist[i_ind].p1=0;
			     i_ind++;
				 $$=i_ind;
				}
			 | {$$=i_ind;};
pudefs		: USECS ':' espressione 
				{
			     ist[i_ind].ist_number=I_USECS;
			     ist[i_ind].p1=0;
			     i_ind++;
				 $$=i_ind;
				}
			 | {$$=i_ind;};
pwdefs		: WRITTEN ':' espressione 
				{
			     ist[i_ind].ist_number=I_WRITTEN;
			     ist[i_ind].p1=0;
			     i_ind++;
				 $$=i_ind;
				}
			 | {$$=i_ind;};
pddefs		: DISCARDED ':' espressione 
				{
			     ist[i_ind].ist_number=I_DISCARDED;
			     ist[i_ind].p1=0;
			     i_ind++;
				 $$=i_ind;
				}
			 | {$$=i_ind;};
espressione : NOME
			  {
			   int indice;
			   const char* ct=agg_nome(yytext);
			   for(indice=0;indice<p_ind;indice++)
			    if (strcmp(yytext,p_str[indice].nome)==0) {ct=NULL;break;}
			   if (ct!=NULL) yyerror(ERR_FIELD /*Impossibile accedere ad un campo non definito*/);
			   else 
			   {
			    switch (p_str[indice].size)
				{
				 case 1:
			      ist[i_ind].ist_number=I_PUSH_BYTE;
			      ist[i_ind].p1=p_str[indice].offset;
				  break;
				 case 2:
			      ist[i_ind].ist_number=I_PUSH_WORD;
			      ist[i_ind].p1=p_str[indice].offset;
				  break;
				 case 4:
			      ist[i_ind].ist_number=I_PUSH_DWORD;
			      ist[i_ind].p1=p_str[indice].offset;
				  break;
				 default:
				  yyerror(ERR_DIM /*Errore di dimensione non nota*/);
			      ist[i_ind].ist_number=I_PUSH_BYTE;
			      ist[i_ind].p1=p_str[indice].offset;
				  break;
				}
				i_ind++;
			   }
			  }
			| NUMERO 
			  {
			   int num;
			   sscanf(yytext,"%d",&num);
			   ist[i_ind].ist_number=I_PUSH;
			   ist[i_ind].p1=num;
			   i_ind++;
			  }
			| NUMERO_H
			  {
			   int num;
			   sscanf(yytext+2,"%x",&num);
			   ist[i_ind].ist_number=I_PUSH;
			   ist[i_ind].p1=num;
			   i_ind++;
			  }
			| '(' espressione ')'
			| espressione '+' espressione 
			  {
			   ist[i_ind].ist_number=I_PLUS;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione MIU espressione 
			  {
			   ist[i_ind].ist_number=I_MIN_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione MAU espressione 
			  {
			   ist[i_ind].ist_number=I_MAG_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione '<' espressione 
			  {
			   ist[i_ind].ist_number=I_MIN;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione '>' espressione 
			  {
			   ist[i_ind].ist_number=I_MAG;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione NOT_EQ espressione 
			  {
			   ist[i_ind].ist_number=I_NOT_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione '=' espressione 
			  {
			   ist[i_ind].ist_number=I_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione AND espressione 
			  {
			   ist[i_ind].ist_number=I_AND;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione OR espressione 
			  {
			   ist[i_ind].ist_number=I_OR;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione '-' espressione 
			  {
			   ist[i_ind].ist_number=I_MINUS;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione '*' espressione 
			  {
			   ist[i_ind].ist_number=I_MUL;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione '/' espressione 
			  {
			   ist[i_ind].ist_number=I_DIV;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione '%' espressione 
			  {
			   ist[i_ind].ist_number=I_MOD;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| '-' espressione 
			  {
			   ist[i_ind].ist_number=I_UN_MINUS;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| NOT espressione
			  {
			   ist[i_ind].ist_number=I_NOT;
			   ist[i_ind].p1=0;
			   i_ind++;
			  };
%%

extern int yylineno;
int errorflag=0;

int yyerror (const char* c)
{
 printf(ERR_LINE /*Errore alla linea :%d\n%s\n*/,yylineno,c);
 errorflag=1;
#ifdef DEBUG
 Ask(ERR_PAUSE /*Premere invio per continuare*/);
#endif
 return 0;
}