%{
/**********************************************************************
		SCANNER PER IL LINGUAGGIO DEL PARSER
		    (C) 1998 - VIANO PIERO
 **********************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "parser.h"
#ifdef WIN32
#undef WIN32
#include "../../comuni/asksay.h"
#define WIN32
#else
#include "../../comuni/asksay.h"
#endif

#define SC_ERROR -1

#ifdef DEBUG_SCANNER
#define SC_SAY(A) Say(A)
#else
#define SC_SAY(A)
#endif 

extern int yyerror(char*c);
%}

%option caseless
%option yylineno

SPAZIO ([\t\r\n ])
SPAZI ({SPAZIO}*)
LETTER ([a-zA-Z])
DIGIT ([0-9])
F_DIGIT ([1-9])
DECIMALE ({DIGIT}*{F_DIGIT}|0)

HEX ((("0x")|("0X"))([a-fA-F]|{DIGIT})+)
INTERO ({F_DIGIT}{DIGIT}*)
VAR_NAME ((("_")|{LETTER})({LETTER}|{DIGIT}|("_"))*)

COST_INT_CORTO ({INTERO}|[0])

OP	([-+=*/%()<>:])

VAR ({VAR_NAME})

COMMENTO ("/*"([^*]*|"*"+[^*/])"*"+\/)
COST_STRINGA (\"[^\"\n]*\")

%%
BYTE {SC_SAY("BYTE");return BYTET;}
WORD {SC_SAY("WORD");return WORDT;}
DWORD {SC_SAY("DWORD");return DWORDT;}
{OP} {SC_SAY(yytext);return yytext[0];}
AND {SC_SAY("AND");return AND;}
"&" {SC_SAY("AND");return AND;}
"&&" {SC_SAY("AND");return AND;}
OR {SC_SAY("OR");return OR;}
"|" {SC_SAY("OR");return OR;}
"||" {SC_SAY("OR");return OR;}
NOT {SC_SAY("NOT");return NOT;}
"!" {SC_SAY("NOT");return NOT;}
"~" {SC_SAY("NOT");return NOT;}
TYPE {SC_SAY("TYPE");return TYPE;}
CHECK {SC_SAY("CHECK");return CHECK;}
PLEN {SC_SAY("PLEN");return PLEN;}
LEN {SC_SAY("LEN");return LEN;}
SECS {SC_SAY("SECS");return SECS;}
USECS {SC_SAY("USECS");return USECS;}
WRITTEN {SC_SAY("WRITTEN");return WRITTEN;}
DISCARDED {SC_SAY("DISCARDED");return DISCARDED;}
FIRSTPROTOCOL {SC_SAY("FIRSTPROTOCOL");return FIRSTPROTOCOL;}
LINKTYPE {SC_SAY("LINKTYPE");return LINKTYPE;}
HEADER {SC_SAY("HEADER");return HEADER;}
TRAILER {SC_SAY("TRAILER");return TRAILER;}
PHEADER {SC_SAY("PHEADER");return PHEADER;}
PTRAILER {SC_SAY("PTRAILER");return PTRAILER;}
ENDHH {SC_SAY("ENDHH");return ENDHH;}
ENDPH {SC_SAY("ENDPH");return ENDPH;}
ENDHT {SC_SAY("ENDHT");return ENDHT;}
ENDPT {SC_SAY("ENDPT");return ENDPT;}
NOT {SC_SAY("NOT");return NOT;}
"!=" {SC_SAY("NOT_EQ");return NOT_EQ;}
"<=" {SC_SAY("NOT_EQ");return MIU;}
">=" {SC_SAY("NOT_EQ");return MAU;}
MUSTINVERT {SC_SAY("MUSTINVERT");return MUSTINVERT;}
{HEX} {SC_SAY("NUMERO_H");return NUMERO_H;}
{COST_INT_CORTO} {SC_SAY("NUMERO");return NUMERO;}
{COMMENTO}	{/* Scarta commenti */ }
{VAR}	{SC_SAY("NOME");return NOME;}
{COST_STRINGA}	{SC_SAY("STRINGA");return STRINGA;}


{SPAZIO}+ {SC_SAY("SPAZIO");/*ignora gli spazi*/}

. {char t[200];printf(t,"Scanner error at line %d\n",yylineno);return (-1);}
%%

int yywrap()
{
  return 1;
}

