#ifndef lint
static char yysccsid[] = "@(#)yaccpar	1.8 (Berkeley) 01/20/90";
#endif
#define YYBYACC 1
#include <stdio.h>
#include <stdlib.h>
#include "../../comuni/asksay.h"
#include "../../comuni/vec_cl.h"
#include "../../comuni/mystring.h"
#include "l_structs.h"

#ifndef ENGLISH
#define ERR_WRITE "Errore di scrittura del file di output"
#define ERR_NAMEDEF "Nome gi definito in questa struttura"
#define ERR_NAMEPLONG "Nome del primo protocollo troppo lungo. Verr troncato."
#define ERR_FIELD "Impossibile accedere ad un campo non definito"
#define ERR_DIM "Errore di dimensione non nota"
#define ERR_LINE "Errore alla linea :%d\n%s\n"
#define ERR_PAUSE "Premere invio per continuare"
#else
#define ERR_WRITE "Error writing output file"
#define ERR_NAMEDEF "Name already defined in this structure"
#define ERR_NAMEPLONG "First protocol name too long. It will be truncated."
#define ERR_FIELD "Unable to access an undefined filed"
#define ERR_DIM "Unknown dimension error"
#define ERR_LINE "Error in line :%d\n%s\n"
#define ERR_PAUSE "Press a key to continue"
#endif

header log_header;
vector <packet> p;
vector <p_struct> p_str;
vector <istruzione> ist;
int p_ind;
int i_ind;
int np;
int l,t;

extern FILE* out;
extern char* yytext;
extern int yylex();
int yyerror (const char* c);

char FirstProtocol[MAX_NAME+3];

const char* agg_nome(char* t)
{
	int l,i;
	l=strlen(yytext);
	for (i=0;i<l;i++)
	 if (yytext[i]>='a' && yytext[i]<='z')
	  { yytext[i]= yytext[i]+ 'A'-'a';}
	if (strlen(t)>50) t[49]='\0';
	return t;
}

static int i;

inline void OUTPUT(int k) 
{
 if(fwrite(&k,sizeof(int),1,out)==0) 
 {
  yyerror(ERR_WRITE /*Errore di scrittura del file di output*/);
  return;
 }
}

inline void SEEK(int k) 
{
	fseek(out,k,SEEK_SET);
}

int checkexisting(const char* c)
{
	int i;
	for(i=0;i<p_ind;i++)
	 if(strcmp(c,p_str[i].nome)==0) 
		 {
		  yyerror(ERR_NAMEDEF /*Nome gi definito in questa struttura*/);
		  return 1;
		 }
	return 0;
}

#define HEADER 257
#define ENDHH 258
#define TRAILER 259
#define ENDHT 260
#define PHEADER 261
#define ENDPH 262
#define PTRAILER 263
#define ENDPT 264
#define SIZE 265
#define CHECK 266
#define TYPE 267
#define MUSTINVERT 268
#define LINKTYPE 269
#define NOME 270
#define STRINGA 271
#define NOT_EQ 272
#define NUMERO 273
#define NUMERO_H 274
#define BYTET 275
#define WORDT 276
#define DWORDT 277
#define PLEN 278
#define LEN 279
#define FIRSTPROTOCOL 280
#define SECS 281
#define USECS 282
#define WRITTEN 283
#define DISCARDED 284
#define OR 285
#define AND 286
#define MIU 287
#define MAU 288
#define NOT 289
#define MENO_UNARIO 290
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    0,    4,    1,    3,   14,    2,   15,    2,    7,   13,
   16,   16,    5,    5,   17,   17,   17,    6,   18,   19,
   21,    8,    9,    9,   10,   10,   11,   11,   12,   12,
   20,   20,   20,   20,   20,   20,   20,   20,   20,   20,
   20,   20,   20,   20,   20,   20,   20,   20,   20,
};
short yylen[] = {                                         2,
    3,    1,    4,    3,    0,    8,    0,    9,    3,    3,
    2,    1,    1,    0,    2,    2,    2,    2,    3,    3,
    1,   15,    3,    0,    3,    0,    3,    0,    3,    0,
    1,    1,    1,    3,    3,    3,    3,    3,    3,    3,
    3,    3,    3,    3,    3,    3,    3,    2,    2,
};
short yydefred[] = {                                      0,
    2,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   12,    0,    0,    1,    0,    0,    0,   15,
   16,   17,    0,   11,    9,    0,    0,    0,    0,    0,
    0,    3,    0,    4,    0,   31,   32,   33,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   18,    0,    0,
   49,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   45,   46,   47,    0,    0,
    0,    5,    0,    7,    0,    0,    0,    0,    0,    0,
    0,    0,    6,    8,    0,    0,    0,   10,    0,    0,
    0,    0,    0,   21,   22,
};
short yydgoto[] = {                                       2,
    3,    6,   16,    4,   11,   32,    7,   19,   30,   45,
   70,   92,  103,   98,   99,   12,   13,   33,   48,   42,
  115,
};
short yysindex[] = {                                   -235,
    0,    0, -241, -273, -273, -243, -251, -218, -217, -213,
 -230, -273,    0, -194, -273,    0, -251,  -29, -211,    0,
    0,    0, -195,    0,    0, -185, -211,  -33,   28, -186,
   30,    0, -168,    0, -186,    0,    0,    0,  -33,  -33,
  -33,  -37,  -33,   45, -176,  -33,   51,    0, -176,   -2,
    0,  -28,  -33,   55,  -33,  -33,  -33,  -33,  -33,  -33,
  -33,  -33,  -33,  -33,  -33,  -33,   29,  -33,   56, -169,
   29,  -33, -169,    0,   85,  -33,   50,   57,   85,   85,
   85,   85,   85,   -2,   -2,    0,    0,    0,   29,  -33,
   58,    0,   29,    0,   -6,   29,  -33, -155, -155,   62,
   29, -273,    0,    0,  -33, -140,    1,    0,   68,  -33,
   22,   76, -135,    0,    0,
};
short yyrindex[] = {                                      0,
    0,    0,    0, -121, -124,    0,    0,    0,    0,    0,
    0, -129,    0,    0, -117,    0,    0,    0, -233,    0,
    0,    0,    0,    0,    0,    0, -233,    0,    0, -203,
    0,    0,    0,    0, -203,    0,    0,    0,    0,    0,
    0,    0,    0,    0, -242,    0,    0,    0, -242,   80,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -205,    0,    0, -119,
 -130,    0, -119,    0,  164,    0,  329,  284,  192,  223,
  251,  293,  421,  108,  136,    0,    0,    0, -178,    0,
    0,    0, -116,    0,    0, -237,    0,    0,    0,    0,
 -115, -118,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,
};
short yygindex[] = {                                      0,
    0,    0,    0,    0,   -4,    0,  141,  133,  125,  119,
  106,   83,   59,    0,    0,    0,  145,    0,    0,  564,
    0,
};
#define YYTABLESIZE 709
short yytable[] = {                                      66,
   14,    8,    9,   10,   64,   62,   41,   63,   66,   65,
   26,   39,   74,   64,   62,   15,   63,    5,   65,    5,
   28,    1,   58,   57,   59,   27,   18,   23,   28,   24,
   66,   58,   57,   59,   66,   64,   62,   66,   63,   64,
   65,   28,   64,   62,   65,   63,   27,   65,   24,   24,
   24,   20,   21,   58,   57,   59,   22,   23,   66,   26,
   58,   57,   59,   64,   62,   66,   63,   25,   65,   29,
   64,   62,   31,   63,   34,   65,   23,   23,   23,   26,
   26,   58,   57,   59,   25,   43,   66,   46,   58,   57,
   59,   64,   62,   66,   63,   44,   65,  106,   64,   62,
   47,   63,   68,   65,   25,   25,   69,  102,   72,   58,
   57,   59,   76,   90,   91,   97,   58,   57,   59,  105,
   48,   66,   48,  108,   48,  110,   64,   62,   13,   63,
   13,   65,   13,  113,   13,  114,   14,   14,   19,   48,
   48,   48,   14,   30,   20,   14,   17,   29,   35,   27,
   35,   35,   35,   49,   73,   94,   24,  104,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   35,   35,   35,
    0,    0,    0,    0,    0,    0,   44,    0,   44,    0,
   44,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   44,   44,   44,    0,    0,
    0,    0,    0,    0,   40,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   40,   40,   40,    0,    0,    0,    0,
    0,    0,   41,    0,   53,    0,   36,    0,    0,   37,
   38,   54,    0,   53,    0,    0,    0,   55,   56,   60,
   61,   41,   41,   41,    0,   40,   55,   56,   60,   61,
  100,    0,    0,   38,    0,   53,  109,    0,    0,    0,
    0,    0,   53,    0,    0,    0,    0,    0,   55,   56,
   60,   61,   38,   38,   38,   55,   56,   60,   61,    0,
    0,   39,    0,   53,    0,    0,    0,    0,    0,    0,
   53,  112,    0,    0,    0,    0,   55,   56,   60,   61,
   39,   39,   39,   55,   56,   60,   61,    0,    0,    0,
    0,   53,    0,    0,   42,    0,    0,    0,   53,    0,
    0,    0,    0,   36,    0,   56,   60,   61,    0,    0,
   48,    0,   48,   60,   61,   48,   48,    0,   48,    0,
    0,   48,   36,   36,   36,    0,    0,    0,   48,   48,
    0,   48,   48,   48,   48,   48,   48,   48,   35,   43,
   35,    0,    0,   35,   35,    0,   35,    0,    0,   35,
    0,    0,    0,    0,    0,    0,   35,   35,    0,   35,
   35,   35,   35,   35,   35,   35,   44,    0,   44,    0,
    0,   44,   44,    0,   44,    0,    0,   44,    0,    0,
    0,    0,    0,    0,   44,   44,    0,   44,   44,   44,
   44,   44,   44,   44,   40,    0,   40,    0,    0,   40,
   40,    0,   40,    0,    0,   40,    0,    0,    0,    0,
    0,    0,   40,   40,    0,   40,   40,   40,   40,   40,
   40,   40,   41,    0,   41,    0,    0,   41,   41,    0,
   41,   37,    0,   41,    0,    0,    0,    0,    0,    0,
   41,   41,    0,   41,   41,   41,   41,   41,   41,   41,
   37,   37,   37,   38,    0,   38,    0,    0,   38,   38,
    0,   38,    0,    0,   38,    0,    0,    0,    0,    0,
    0,   38,   38,    0,   38,   38,   38,   38,   38,   38,
   38,   39,    0,   39,    0,    0,   39,   39,    0,   39,
    0,    0,   39,    0,    0,    0,    0,    0,    0,   39,
   39,    0,   39,   39,   39,   39,   39,   39,   39,    0,
    0,    0,    0,    0,   42,    0,   42,    0,    0,   42,
   42,    0,   42,   36,    0,   36,    0,    0,   36,   36,
    0,   36,   42,   42,   36,   42,   42,   42,   42,   42,
    0,   36,   36,    0,   36,   36,   36,   36,   36,   36,
   36,    0,    0,    0,    0,    0,    0,    0,    0,   43,
    0,   43,    0,    0,   43,   43,    0,   43,    0,    0,
    0,    0,   50,   51,   52,    0,   67,   43,   43,   71,
   43,   43,   43,   43,    0,    0,   75,    0,   77,   78,
   79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
    0,   89,    0,    0,    0,   93,    0,    0,    0,   95,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   96,    0,    0,    0,    0,    0,    0,
  101,    0,    0,    0,    0,    0,    0,    0,  107,    0,
    0,    0,    0,  111,    0,    0,    0,    0,    0,    0,
    0,   37,    0,   37,    0,    0,   37,   37,    0,   37,
    0,    0,   37,    0,    0,    0,    0,    0,    0,   37,
   37,    0,   37,   37,   37,   37,   37,   37,   37,
};
short yycheck[] = {                                      37,
    5,  275,  276,  277,   42,   43,   40,   45,   37,   47,
   15,   45,   41,   42,   43,  259,   45,  261,   47,  261,
  263,  257,   60,   61,   62,  263,  278,  258,   58,  263,
   37,   60,   61,   62,   37,   42,   43,   37,   45,   42,
   47,  284,   42,   43,   47,   45,  284,   47,  282,  283,
  284,  270,  270,   60,   61,   62,  270,  263,   37,  263,
   60,   61,   62,   42,   43,   37,   45,  262,   47,  281,
   42,   43,  268,   45,  260,   47,  282,  283,  284,  283,
  284,   60,   61,   62,  263,   58,   37,   58,   60,   61,
   62,   42,   43,   37,   45,  282,   47,  102,   42,   43,
  269,   45,   58,   47,  283,  284,  283,  263,   58,   60,
   61,   62,   58,   58,  284,   58,   60,   61,   62,   58,
   41,   37,   43,  264,   45,   58,   42,   43,  258,   45,
  260,   47,  262,   58,  264,  271,  258,  262,  269,   60,
   61,   62,  260,  263,  261,  264,    6,  263,   41,   17,
   43,   27,   45,   35,   49,   73,   12,   99,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   60,   61,   62,
   -1,   -1,   -1,   -1,   -1,   -1,   41,   -1,   43,   -1,
   45,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   60,   61,   62,   -1,   -1,
   -1,   -1,   -1,   -1,   41,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   60,   61,   62,   -1,   -1,   -1,   -1,
   -1,   -1,   41,   -1,  272,   -1,  270,   -1,   -1,  273,
  274,  279,   -1,  272,   -1,   -1,   -1,  285,  286,  287,
  288,   60,   61,   62,   -1,  289,  285,  286,  287,  288,
  267,   -1,   -1,   41,   -1,  272,  266,   -1,   -1,   -1,
   -1,   -1,  272,   -1,   -1,   -1,   -1,   -1,  285,  286,
  287,  288,   60,   61,   62,  285,  286,  287,  288,   -1,
   -1,   41,   -1,  272,   -1,   -1,   -1,   -1,   -1,   -1,
  272,  280,   -1,   -1,   -1,   -1,  285,  286,  287,  288,
   60,   61,   62,  285,  286,  287,  288,   -1,   -1,   -1,
   -1,  272,   -1,   -1,   41,   -1,   -1,   -1,  272,   -1,
   -1,   -1,   -1,   41,   -1,  286,  287,  288,   -1,   -1,
  261,   -1,  263,  287,  288,  266,  267,   -1,  269,   -1,
   -1,  272,   60,   61,   62,   -1,   -1,   -1,  279,  280,
   -1,  282,  283,  284,  285,  286,  287,  288,  261,   41,
  263,   -1,   -1,  266,  267,   -1,  269,   -1,   -1,  272,
   -1,   -1,   -1,   -1,   -1,   -1,  279,  280,   -1,  282,
  283,  284,  285,  286,  287,  288,  261,   -1,  263,   -1,
   -1,  266,  267,   -1,  269,   -1,   -1,  272,   -1,   -1,
   -1,   -1,   -1,   -1,  279,  280,   -1,  282,  283,  284,
  285,  286,  287,  288,  261,   -1,  263,   -1,   -1,  266,
  267,   -1,  269,   -1,   -1,  272,   -1,   -1,   -1,   -1,
   -1,   -1,  279,  280,   -1,  282,  283,  284,  285,  286,
  287,  288,  261,   -1,  263,   -1,   -1,  266,  267,   -1,
  269,   41,   -1,  272,   -1,   -1,   -1,   -1,   -1,   -1,
  279,  280,   -1,  282,  283,  284,  285,  286,  287,  288,
   60,   61,   62,  261,   -1,  263,   -1,   -1,  266,  267,
   -1,  269,   -1,   -1,  272,   -1,   -1,   -1,   -1,   -1,
   -1,  279,  280,   -1,  282,  283,  284,  285,  286,  287,
  288,  261,   -1,  263,   -1,   -1,  266,  267,   -1,  269,
   -1,   -1,  272,   -1,   -1,   -1,   -1,   -1,   -1,  279,
  280,   -1,  282,  283,  284,  285,  286,  287,  288,   -1,
   -1,   -1,   -1,   -1,  261,   -1,  263,   -1,   -1,  266,
  267,   -1,  269,  261,   -1,  263,   -1,   -1,  266,  267,
   -1,  269,  279,  280,  272,  282,  283,  284,  285,  286,
   -1,  279,  280,   -1,  282,  283,  284,  285,  286,  287,
  288,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  261,
   -1,  263,   -1,   -1,  266,  267,   -1,  269,   -1,   -1,
   -1,   -1,   39,   40,   41,   -1,   43,  279,  280,   46,
  282,  283,  284,  285,   -1,   -1,   53,   -1,   55,   56,
   57,   58,   59,   60,   61,   62,   63,   64,   65,   66,
   -1,   68,   -1,   -1,   -1,   72,   -1,   -1,   -1,   76,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   90,   -1,   -1,   -1,   -1,   -1,   -1,
   97,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  105,   -1,
   -1,   -1,   -1,  110,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  261,   -1,  263,   -1,   -1,  266,  267,   -1,  269,
   -1,   -1,  272,   -1,   -1,   -1,   -1,   -1,   -1,  279,
  280,   -1,  282,  283,  284,  285,  286,  287,  288,
};
#define YYFINAL 2
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 290
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,"'%'",0,0,"'('","')'","'*'","'+'",0,"'-'",0,"'/'",0,0,0,0,0,0,0,0,0,0,
"':'",0,"'<'","'='","'>'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,"HEADER","ENDHH","TRAILER","ENDHT","PHEADER","ENDPH","PTRAILER",
"ENDPT","SIZE","CHECK","TYPE","MUSTINVERT","LINKTYPE","NOME","STRINGA","NOT_EQ",
"NUMERO","NUMERO_H","BYTET","WORDT","DWORDT","PLEN","LEN","FIRSTPROTOCOL",
"SECS","USECS","WRITTEN","DISCARDED","OR","AND","MIU","MAU","NOT","MENO_UNARIO",
};
char *yyrule[] = {
"$accept : file",
"file : header packet_formats trailer",
"hdr_init : HEADER",
"header : hdr_init structs ENDHH hdefs",
"trailer : TRAILER structs ENDHT",
"$$1 :",
"packet_formats : pheader pdefs psdefs pudefs pwdefs pddefs $$1 ptrailer",
"$$2 :",
"packet_formats : packet_formats pheader pdefs psdefs pudefs pwdefs pddefs $$2 ptrailer",
"pheader : PHEADER structs ENDPH",
"ptrailer : PTRAILER structs ENDPT",
"str : str def",
"str : def",
"structs : str",
"structs :",
"def : BYTET NOME",
"def : WORDT NOME",
"def : DWORDT NOME",
"hdefs : hdefs1 hdefs2",
"hdefs1 : MUSTINVERT ':' espressione",
"hdefs2 : LINKTYPE ':' espressione",
"stringa : STRINGA",
"pdefs : PLEN ':' espressione LEN ':' espressione TYPE ':' espressione CHECK ':' espressione FIRSTPROTOCOL ':' stringa",
"psdefs : SECS ':' espressione",
"psdefs :",
"pudefs : USECS ':' espressione",
"pudefs :",
"pwdefs : WRITTEN ':' espressione",
"pwdefs :",
"pddefs : DISCARDED ':' espressione",
"pddefs :",
"espressione : NOME",
"espressione : NUMERO",
"espressione : NUMERO_H",
"espressione : '(' espressione ')'",
"espressione : espressione '+' espressione",
"espressione : espressione MIU espressione",
"espressione : espressione MAU espressione",
"espressione : espressione '<' espressione",
"espressione : espressione '>' espressione",
"espressione : espressione NOT_EQ espressione",
"espressione : espressione '=' espressione",
"espressione : espressione AND espressione",
"espressione : espressione OR espressione",
"espressione : espressione '-' espressione",
"espressione : espressione '*' espressione",
"espressione : espressione '/' espressione",
"espressione : espressione '%' espressione",
"espressione : '-' espressione",
"espressione : NOT espressione",
};
#endif
#ifndef YYSTYPE
typedef int YYSTYPE;
#endif
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#ifdef YYSTACKSIZE
#ifndef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#endif
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];
#define yystacksize YYSTACKSIZE

extern int yylineno;
int errorflag=0;

int yyerror (const char* c)
{
 printf(ERR_LINE /*Errore alla linea :%d\n%s\n*/,yylineno,c);
 errorflag=1;
#ifdef DEBUG
 Ask(ERR_PAUSE /*Premere invio per continuare*/);
#endif
 return 0;
}
#define YYABORT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv(const char*);

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, reading %d (%s)\n", yystate,
                    yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: state %d, shifting to state %d\n",
                    yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: state %d, error recovery shifting\
 to state %d\n", *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: error recovery discarding state %d\n",
                            *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, error recovery discards token %d (%s)\n",
                    yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("yydebug: state %d, reducing by rule %d (%s)\n",
                yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 1:
{SEEK(sizeof(int));OUTPUT(np);}
break;
case 2:
{p_ind=0;i_ind=0;OUTPUT(O_HDRH);np=0;OUTPUT(np);}
break;
case 3:
{
			   OUTPUT(yyvsp[-2]);
			   OUTPUT(i_ind);
			   for (i=0;i<i_ind;i++)
			    {
				 OUTPUT(ist[i].ist_number);
				 OUTPUT(ist[i].p1);
				}
			   OUTPUT(O_HDRH_E);
			   i_ind=0;
			   p_ind=0;
			  }
break;
case 4:
{
			   OUTPUT(O_HDRT);
			   OUTPUT(yyvsp[-1]);
			   OUTPUT(O_HDRT_E);
			   i_ind=0;
			   p_ind=0;
			  }
break;
case 5:
{
			   OUTPUT(O_PKTH);
			   OUTPUT(yyvsp[-5]);
			   OUTPUT(i_ind);
			   for (i=0;i<i_ind;i++)
			    {
				 OUTPUT(ist[i].ist_number);
				 OUTPUT(ist[i].p1);
				}
			   OUTPUT(O_PKTH_E);
			   i_ind=0;
			   p_ind=0;
			  }
break;
case 6:
{
			   OUTPUT(O_PKTT);
			   OUTPUT(yyvsp[0]);
			   OUTPUT(O_PKTT_E);
			   i_ind=0;
			   p_ind=0;
			  }
break;
case 7:
{
			   OUTPUT(O_PKTH);
			   OUTPUT(yyvsp[-5]);
			   OUTPUT(i_ind);
			   for (i=0;i<i_ind;i++)
			    {
				 OUTPUT(ist[i].ist_number);
				 OUTPUT(ist[i].p1);
				}
			   OUTPUT(O_PKTH_E);
			   i_ind=0;
			   p_ind=0;
			  }
break;
case 8:
{
			   OUTPUT(O_PKTT);
			   OUTPUT(yyvsp[0]);
			   OUTPUT(O_PKTT_E);
			   i_ind=0;
			   p_ind=0;
			  }
break;
case 9:
{yyval=yyvsp[-1];np++;}
break;
case 10:
{yyval=yyvsp[-1];}
break;
case 11:
{yyval=yyvsp[-1]+yyvsp[0];}
break;
case 12:
{yyval=yyvsp[0];}
break;
case 13:
{yyval=yyvsp[0];}
break;
case 14:
{yyval=0;}
break;
case 15:
{
				 yyval=1;p_str[p_ind].size=1;
				 if (p_ind==0) p_str[p_ind].offset=0; 
				  else p_str[p_ind].offset=p_str[p_ind-1].offset+p_str[p_ind-1].size;
				 strcpy(p_str[p_ind].nome, agg_nome(yytext));
				 checkexisting(yytext);
				 p_ind++;
				}
break;
case 16:
{
				 yyval=2;p_str[p_ind].size=2;
				 if (p_ind==0) p_str[p_ind].offset=0; 
				  else p_str[p_ind].offset=p_str[p_ind-1].offset+p_str[p_ind-1].size;
				 strcpy(p_str[p_ind].nome, agg_nome(yytext));
				 checkexisting(yytext);
				 p_ind++;
				}
break;
case 17:
{
				 yyval=4;p_str[p_ind].size=4;
				 if (p_ind==0) p_str[p_ind].offset=0; 
				  else p_str[p_ind].offset=p_str[p_ind-1].offset+p_str[p_ind-1].size;
				 strcpy(p_str[p_ind].nome, agg_nome(yytext));
				 checkexisting(yytext);
				 p_ind++;
				}
break;
case 19:
{
			     ist[i_ind].ist_number=I_INVERTBYTES;
			     ist[i_ind].p1=0;
			     i_ind++;
				}
break;
case 20:
{
			     ist[i_ind].ist_number=I_LINKTYPE;
			     ist[i_ind].p1=0;
			     i_ind++;
				}
break;
case 21:
{
					strmai(yytext);
					l=strlen(yytext)-1;
					yytext[l]='\0';
					l--;
					if (l-1>MAX_NAME) 
					 {
					  Say(ERR_NAMEPLONG /*Nome del primo protocollo troppo lungo. Verr troncato.*/);
					  yytext[MAX_NAME]='\0';
					 }
					strcpy(FirstProtocol,yytext+1);
				}
break;
case 22:
{
			     ist[i_ind].ist_number=I_CHECK;
			     ist[i_ind].p1=0;
			     i_ind++;
			     ist[i_ind].ist_number=I_TYPE;
			     ist[i_ind].p1=0;
			     i_ind++;
			     ist[i_ind].ist_number=I_LEN;
			     ist[i_ind].p1=0;
			     i_ind++;
			     ist[i_ind].ist_number=I_PLEN;
			     ist[i_ind].p1=0;
			     i_ind++;
				 l=strlen(FirstProtocol);
				 for(t=l-1;t>=0;t--)
				 {
					ist[i_ind].ist_number=I_PUSH;
					ist[i_ind].p1=FirstProtocol[t];
					i_ind++;
				 }
				 ist[i_ind].ist_number=I_FIRSTP;
				 ist[i_ind].p1=l;
				 i_ind++;
				 yyval=i_ind;
				}
break;
case 23:
{
			     ist[i_ind].ist_number=I_SECS;
			     ist[i_ind].p1=0;
			     i_ind++;
				 yyval=i_ind;
				}
break;
case 24:
{yyval=i_ind;}
break;
case 25:
{
			     ist[i_ind].ist_number=I_USECS;
			     ist[i_ind].p1=0;
			     i_ind++;
				 yyval=i_ind;
				}
break;
case 26:
{yyval=i_ind;}
break;
case 27:
{
			     ist[i_ind].ist_number=I_WRITTEN;
			     ist[i_ind].p1=0;
			     i_ind++;
				 yyval=i_ind;
				}
break;
case 28:
{yyval=i_ind;}
break;
case 29:
{
			     ist[i_ind].ist_number=I_DISCARDED;
			     ist[i_ind].p1=0;
			     i_ind++;
				 yyval=i_ind;
				}
break;
case 30:
{yyval=i_ind;}
break;
case 31:
{
			   int indice;
			   const char* ct=agg_nome(yytext);
			   for(indice=0;indice<p_ind;indice++)
			    if (strcmp(yytext,p_str[indice].nome)==0) {ct=NULL;break;}
			   if (ct!=NULL) yyerror(ERR_FIELD /*Impossibile accedere ad un campo non definito*/);
			   else 
			   {
			    switch (p_str[indice].size)
				{
				 case 1:
			      ist[i_ind].ist_number=I_PUSH_BYTE;
			      ist[i_ind].p1=p_str[indice].offset;
				  break;
				 case 2:
			      ist[i_ind].ist_number=I_PUSH_WORD;
			      ist[i_ind].p1=p_str[indice].offset;
				  break;
				 case 4:
			      ist[i_ind].ist_number=I_PUSH_DWORD;
			      ist[i_ind].p1=p_str[indice].offset;
				  break;
				 default:
				  yyerror(ERR_DIM /*Errore di dimensione non nota*/);
			      ist[i_ind].ist_number=I_PUSH_BYTE;
			      ist[i_ind].p1=p_str[indice].offset;
				  break;
				}
				i_ind++;
			   }
			  }
break;
case 32:
{
			   int num;
			   sscanf(yytext,"%d",&num);
			   ist[i_ind].ist_number=I_PUSH;
			   ist[i_ind].p1=num;
			   i_ind++;
			  }
break;
case 33:
{
			   int num;
			   sscanf(yytext+2,"%x",&num);
			   ist[i_ind].ist_number=I_PUSH;
			   ist[i_ind].p1=num;
			   i_ind++;
			  }
break;
case 35:
{
			   ist[i_ind].ist_number=I_PLUS;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 36:
{
			   ist[i_ind].ist_number=I_MIN_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 37:
{
			   ist[i_ind].ist_number=I_MAG_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 38:
{
			   ist[i_ind].ist_number=I_MIN;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 39:
{
			   ist[i_ind].ist_number=I_MAG;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 40:
{
			   ist[i_ind].ist_number=I_NOT_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 41:
{
			   ist[i_ind].ist_number=I_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 42:
{
			   ist[i_ind].ist_number=I_AND;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 43:
{
			   ist[i_ind].ist_number=I_OR;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 44:
{
			   ist[i_ind].ist_number=I_MINUS;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 45:
{
			   ist[i_ind].ist_number=I_MUL;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 46:
{
			   ist[i_ind].ist_number=I_DIV;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 47:
{
			   ist[i_ind].ist_number=I_MOD;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 48:
{
			   ist[i_ind].ist_number=I_UN_MINUS;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 49:
{
			   ist[i_ind].ist_number=I_NOT;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: after reduction, shifting from state 0 to\
 state %d\n", YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("yydebug: state %d, reading %d (%s)\n",
                        YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("yydebug: after reduction, shifting from state %d \
to state %d\n", *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
