#include <stdio.h>
#include <stdlib.h>
#include "../../comuni/protocol.h"

extern int yyparse();
extern FILE* yyin;
FILE* out;
extern int np,hasErrors;


#ifndef ENGLISH
#define ERR_PARS "Erano attesi 2 parametri"
#define ERR_IN "Impossibile aprire il file di Input %s\n"
#define ERR_OUT "Impossibile aprire il file di Output %s\n"
#else
#define ERR_PARS "Two parameters required"
#define ERR_IN "Unable to open Input file %s\n"
#define ERR_OUT "Unable to open Output file %s\n"
#endif

int main (int argc, char** argv)
{
	Protocol proto;

	if (argc!=3) {printf(ERR_PARS /*Sono attesi due parametri*/);exit(-1);}
	out=fopen(argv[2],"wb");
	if (out==NULL) {printf(ERR_OUT /*Impossibile aprire il file destinazione %s\n*/,argv[2]);exit(-1);}
	yyin=fopen(argv[1],"r");
	if (yyin==NULL) {printf(ERR_IN /*Impossibile aprire il file sorgente %s\n*/,argv[1]);exit(-1);}
	yyparse();
	if (out)fclose (out);
	if (yyin)fclose (yyin);
	if (hasErrors) return 1; else return 0;
}
