/****************************************************************************
			      PACKET PARSER - PARSER
				  (C) 1998 by VIANO PIERO
 ****************************************************************************/

%{
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "../../comuni/asksay.h"
#include "../../comuni/vec_cl.h"
#include "../../comuni/structs.h"
#include "../../comuni/protocolvect.h"
#include "../../comuni/protocol.h"
#include "../../comuni/case.h"

#ifdef Say
#undef Say
#define Say(A) printf("%s\n",A)
#endif

#ifndef ENGLISH
#define ERR_WRITE "Errore di scrittura del file di output"
#define ERR_NAMEEX "Nome gi definito in questa struttura"
#define ERR_DESTPR "Protocollo di destinazione non definito"
#define ERR_PRID "Ridefinizione di protocollo"
#define ERR_BITS "Nella definizione dei bits il primo numero deve essere minore o uguale al secondo"
#define ERR_BITS1 "Errore nell'assegnazione dei campi dei bits. Valori errati."
#define ERR_FIELD "Impossibile accedere ad un campo non definito"
#define ERR_UNKDIM "Errore di dimensione non nota"
#define ERR_LINE "Errore alla linea :%d\n%s\n"
#define ERR_PAUSE "Premere invio per continuare"
#define ERR_VMVAR "Variabile della macchina virtuale non definita"
#else
#define ERR_WRITE "Error writing output file"
#define ERR_NAMEEX "Nome gi definito in questa struttura"
#define ERR_DESTPR "Destination protocol not defined"
#define ERR_PRID "Protocol ridefinition"
#define ERR_BITS "In bits definition, first number must be minor or equal to second"
#define ERR_BITS1 "Error assigning bit fields. Wrong values."
#define ERR_FIELD "Unable to access undefined field"
#define ERR_UNKDIM "Unknown dimension"
#define ERR_LINE "Error in line :%d\n%s\n"
#define ERR_PAUSE "Press a key to continue"
#define ERR_VMVAR "Virtual machine variable not defined"
#endif

vector <p_struct> p_str;
vector <istruzione> ist;
ProtocolVect prot;
vector <nome> name;
CCase cc;

int p_ind;
int i_ind;
int n_ind;
int np=0;
int hasErrors;

extern FILE* out;
extern char* yytext;
extern int yylex();
int yyerror (const char* c);

const char* agg_nome(char* t)
{
	int l,i;
	l=strlen(yytext);
	for (i=0;i<l;i++)
	 if (yytext[i]>='a' && yytext[i]<='z')
	  { yytext[i]= yytext[i]+ 'A'-'a';}
	if (strlen(t)>50) t[49]='\0';
	return t;
}

static int i;

inline void OUTPUT(int k) 
{
 if(fwrite(&k,sizeof(int),1,out)==0) 
 {
  yyerror(ERR_WRITE /*Errore di scrittura del file di output*/);
  return;
 }
}

inline void SEEK(int k) 
{
	fseek(out,k,SEEK_SET);
}

int checkexisting(const char* c)
{
	int i;
	for(i=0;i<p_ind;i++)
	 if(strcmp(c,p_str[i].nome)==0) 
		 {
		  yyerror(ERR_NAMEEX /*Nome gi definito in questa struttura*/);
		  return 1;
		 }
	return 0;
}

%}

%token PROTOCOL
%token VIRTUAL
%token ENDPR
%token BYTE
%token WORD
%token DWORD
%token BIT
%token MUSTINVERT
%token NOME
%token NUMERO
%token NUMERO_H
%token CASE
%token ELSE
%token SKIP
%token GETVMVAR
%token COST_STRINGA

%start file

%left OR
%left AND
%left '=',NOT_EQ, MIU, MAU, '<', '>'
%left '+','-'
%left '*','/','%'
%right NOT,MENO_UNARIO

%union {
	 nome n;
	 intero i;
	}

%type <n> nome
%type <i> pheader, structs ,bit_defs, b_defs ,def, numero, espressione, stringa

%%
	/* DEFINIZIONI GENERALI */

file		: protocol_list 
			   {
			    int j,found;
				const char *a,*b;
				for(j=0;j<n_ind;j++)
				{
				 found=0;
			     for(i=0;i<np;i++)
				  {
				     a=prot[i].GetName();
					 b=name[j].nome;
					 if (a==NULL) break;
					 if (strcmp(a,b)==0) {found=1;break;}
				  }
				 if(!found && strcmp(b,"DATA")==0 ) found=1;
				 if(!found) yyerror(ERR_DESTPR /*Protocollo di destinazione non definito*/);
				}
				if(!hasErrors) 
				{
				i=MAGIC_PDF;
				fwrite(&i,sizeof(int),1,out);
				time_t current_time;
				time(&current_time);
				fwrite(&current_time,sizeof(time_t),1,out);
				srand((unsigned int)current_time);
				i=rand();
				fwrite(&i,sizeof(int),1,out);
				fwrite(&np,sizeof(int),1,out);
				 for(i=0;i<np;i++)
				 {
				    prot[i].Serialize(0,out);
				 }
				}
			   };
protocol_list
			: pheader ptrailer {}
			| protocol_list pheader ptrailer {};
pheader		: PROTOCOL nome structs ENDPR 
				{
				 $$.i=$3.i;
				 for(i=0;i<np;i++) 
					if (strcmp($2.nome,prot[i].GetName())==0)
					   {
						yyerror(ERR_PRID /*Ridefinizione di protocollo*/);
						strcpy($2.nome,"!!!");
						break;
					   }
				 prot[np].SetNome($2.nome);
				 prot[np].RiempiCampi(p_str,p_ind);
				 cc.ClearAll();
				}
			| PROTOCOL nome ENDPR 
				{
				 $$.i=0;
				 for(i=0;i<np;i++) 
					if (strcmp($2.nome,prot[i].GetName())==0)
					   {
						yyerror(ERR_PRID /*Ridefinizione di protocollo*/);
						strcpy($2.nome,"!!!");
						break;
					   }
				 prot[np].SetNome($2.nome);
				 prot[np].RiempiCampi(p_str,p_ind);
				 cc.ClearAll();
				};
			| VIRTUAL PROTOCOL nome structs ENDPR 
				{
				 $$.i=$4.i;
				 for(i=0;i<np;i++) 
					if (strcmp($3.nome,prot[i].GetName())==0)
					   {
						yyerror(ERR_PRID /*Ridefinizione di protocollo*/);
						strcpy($3.nome,"!!!");
						break;
					   }
				 prot[np].SetNome($3.nome);
				 prot[np].SetVirt(1);
				 prot[np].RiempiCampi(p_str,p_ind);
				 cc.ClearAll();
				}
			| VIRTUAL PROTOCOL nome ENDPR 
				{
				 $$.i=0;
				 for(i=0;i<np;i++) 
					if (strcmp($3.nome,prot[i].GetName())==0)
					   {
						yyerror(ERR_PRID /*Ridefinizione di protocollo*/);
						strcpy($3.nome,"!!!");
						break;
					   }
				 prot[np].SetNome($3.nome);
				 prot[np].SetVirt(1);
				 prot[np].RiempiCampi(p_str,p_ind);
				 cc.ClearAll();
				}
skip		: SKIP ':' espressione
			   {
				prot[np].RiempiSkip(ist,i_ind);
				i_ind=0;
			   }
ptrailer	: skip next_protocol 
			   {
				p_ind=0;
			    np++;
			   }
			| next_protocol 
			   {
				prot[np].RiempiSkip(NULL,0);
				i_ind=0;
				p_ind=0;
			    np++;
			   };
next_protocol
			: ELSE nome
				{
			     ist[0].ist_number=I_PUSH;
			     ist[0].p1=1;
				 cc.RiempiCase(ist,1,$2.nome);
				 prot[np].AddCase(cc);
				 cc.ClearAll();
				 i_ind=0;
				 strcpy (name[n_ind].nome,$2.nome);
				 n_ind++;
				}
			| n_protocol ELSE nome
				{
			     ist[0].ist_number=I_PUSH;
			     ist[0].p1=1;
				 cc.RiempiCase(ist,1,$3.nome);
				 prot[np].AddCase(cc);
				 cc.ClearAll();
				 i_ind=0;
				 strcpy (name[n_ind].nome,$3.nome);
				 n_ind++;
				}
n_protocol
			: CASE espressione ':' nome
				{
				 cc.RiempiCase(ist,i_ind,$4.nome);
				 prot[np].AddCase(cc);
				 cc.ClearAll();
				 i_ind=0;
				 strcpy (name[n_ind].nome,$4.nome);
				 n_ind++;
				}
			| n_protocol CASE espressione ':' nome
				{
				 cc.RiempiCase(ist,i_ind,$5.nome);
				 prot[np].AddCase(cc);
				 cc.ClearAll();
				 i_ind=0;
				 strcpy (name[n_ind].nome,$5.nome);
				 n_ind++;
				}
structs		: structs def bit_defs {$$.i=$1.i+$2.i;}
			| def bit_defs {$$.i=$1.i;}
			;
bit_defs	: '{' b_defs '}' {$$.i=$2.i;}
			| {$$.i=0;} ;
b_defs		: BIT nome '(' numero ',' numero ')'
				{
				 $$.i=0;p_str[p_ind].size=0;
				 p_str[p_ind].offset=p_str[p_ind-1].offset;
				 p_str[p_ind].bs=$4.i;
				 p_str[p_ind].be=$6.i;
				 p_str[p_ind].ref=p_ind-1;
				 if ($4.i>$6.i) 
				  yyerror(ERR_BITS /*Nella definizione dei bits il primo numero deve essere minore o uguale al secondo*/);
				 if (($4.i>>3)>p_str[p_ind-1].size || 
					 ($6.i>>3)>p_str[p_ind-1].size || 
					 $4.i<0 || $6.i<0)
				  yyerror(ERR_BITS1 /*Errore nell'assegnazione dei campi dei bits. Valori errati.*/);
				 strcpy(p_str[p_ind].nome, agg_nome($2.nome));
				 checkexisting($2.nome);
				 p_ind++;
				}
			| b_defs BIT nome '(' numero ',' numero ')'
				{
				 $$.i=0;p_str[p_ind].size=0;
				 p_str[p_ind].offset=p_str[p_ind-1].offset;
				 p_str[p_ind].bs=$5.i;
				 p_str[p_ind].be=$7.i;
				 p_str[p_ind].ref=p_str[p_ind-1].ref;
				 if ($5.i>$7.i) 
				  yyerror(ERR_BITS /*Nella definizione dei bits il primo numero deve essere minore o uguale al secondo*/);
				 if (($5.i>>3)>p_str[p_str[p_ind-1].ref].size || 
					 ($7.i>>3)>p_str[p_str[p_ind-1].ref].size || 
					 $5.i<0 || $7.i<0)
				  yyerror(ERR_BITS1 /*Errore nell'assegnazione dei campi dei bits. Valori errati.*/);
				 strcpy(p_str[p_ind].nome, agg_nome($3.nome));
				 checkexisting($3.nome);
				 p_ind++;
				}
def			: BYTE nome 
				{
				 $$.i=1;p_str[p_ind].size=1;
				 if (p_ind==0) p_str[p_ind].offset=0; 
				  else 
				  {
				   i=p_str[p_ind-1].size;
				   if (i==0) i=p_str[p_str[p_ind-1].ref].size;
				   p_str[p_ind].offset=p_str[p_ind-1].offset+i;
				  }
				 strcpy(p_str[p_ind].nome, agg_nome(yytext));
				 checkexisting(yytext);
				 p_ind++;
				}
			| WORD nome
				{
				 $$.i=2;p_str[p_ind].size=2;
				 if (p_ind==0) p_str[p_ind].offset=0; 
				  else 
				  {
				   i=p_str[p_ind-1].size;
				   if (i==0) i=p_str[p_str[p_ind-1].ref].size;
				   p_str[p_ind].offset=p_str[p_ind-1].offset+i;
				  }
				 strcpy(p_str[p_ind].nome, agg_nome(yytext));
				 checkexisting(yytext);
				 p_ind++;
				}
			| DWORD nome
				{
				 $$.i=4;p_str[p_ind].size=4;
				 if (p_ind==0) p_str[p_ind].offset=0; 
				  else 
				  {
				   i=p_str[p_ind-1].size;
				   if (i==0) i=p_str[p_str[p_ind-1].ref].size;
				   p_str[p_ind].offset=p_str[p_ind-1].offset+i;
				  }
				 strcpy(p_str[p_ind].nome, agg_nome(yytext));
				 checkexisting(yytext);
				 p_ind++;
				};
nome		: NOME
			  {
			   strcpy($$.nome,agg_nome(yytext));
			  }
numero		: NUMERO 
			  {
			   int num;
			   sscanf(yytext,"%d",&num);
			   $$.i=num;
			  }
			| NUMERO_H
			  {
			   int num;
			   sscanf(yytext+2,"%x",&num);
			   $$.i=num;
			  };
stringa		: COST_STRINGA
			  {
				 yytext[strlen(yytext)-1]='\0';
				 if (strcmp(yytext+1,"FrameAvail")==0) $$.i=0;
				 else if (strcmp(yytext+1,"FrameSize")==0) $$.i=1;
				 else if (strcmp(yytext+1,"ItemNumber")==0) $$.i=2;
				 else if (strcmp(yytext+1,"FrameSecs")==0) $$.i=3;
				 else if (strcmp(yytext+1,"FrameUSecs")==0) $$.i=4;
				 else if (strcmp(yytext+1,"Written")==0) $$.i=5;
				 else if (strcmp(yytext+1,"Discarded")==0) $$.i=6;
				 else if (strcmp(yytext+1,"FrameType")==0) $$.i=7;
				 else if (strcmp(yytext+1,"SizeNotInt")==0) $$.i=8;
				 else if (strcmp(yytext+1,"SizeInt")==0) $$.i=9;
				 else if (strcmp(yytext+1,"Position")==0) $$.i=10;
				 else {yyerror(ERR_VMVAR /*Variabile della macchina virtuale non definita*/);}
			  }
espressione : nome
			  {
			   int indice;
			   const char* ct=agg_nome(yytext);
			   for(indice=0;indice<p_ind;indice++)
			    if (strcmp(yytext,p_str[indice].nome)==0) {ct=NULL;break;}
			   if (ct!=NULL) yyerror(ERR_FIELD /*Impossibile accedere ad un campo non definito*/);
			   else 
			   {
			    switch (p_str[indice].size)
				{
				 case 0:
				  i=p_str[indice].ref;
					if(p_str[i].size==1)ist[i_ind].ist_number=I_PUSH_BYTE;
					else if(p_str[i].size==2)ist[i_ind].ist_number=I_PUSH_WORD;
					else if(p_str[i].size==4)ist[i_ind].ist_number=I_PUSH_DWORD;
			      ist[i_ind].p1=p_str[indice].offset;
				  i_ind++;
			      ist[i_ind].ist_number=I_PUSH_BITS;
			      ist[i_ind].p1=((p_str[indice].bs)&0xFF)+(((p_str[indice].be)<<8)&0xFF00);
				  break;
				 case 1:
			      ist[i_ind].ist_number=I_PUSH_BYTE;
			      ist[i_ind].p1=p_str[indice].offset;
				  break;
				 case 2:
			      ist[i_ind].ist_number=I_PUSH_WORD;
			      ist[i_ind].p1=p_str[indice].offset;
				  break;
				 case 4:
			      ist[i_ind].ist_number=I_PUSH_DWORD;
			      ist[i_ind].p1=p_str[indice].offset;
				  break;
				 default:
				  yyerror(ERR_UNKDIM /*Errore di dimensione non nota*/);
			      ist[i_ind].ist_number=I_PUSH_BYTE;
			      ist[i_ind].p1=p_str[indice].offset;
				  break;
				}
				i_ind++;
			   }
			  }
			| numero
			  {
			   int num=$1.i;
			   ist[i_ind].ist_number=I_PUSH;
			   ist[i_ind].p1=num;
			   i_ind++;
			  }
			| '(' espressione ')' { }
			| GETVMVAR '(' stringa ')'
				{
				 ist[i_ind].ist_number=I_GETVMVAR;
			     ist[i_ind].p1=$3.i;
				 i_ind++;
				}
			| espressione '+' espressione 
			  {
			   ist[i_ind].ist_number=I_PLUS;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione NOT_EQ espressione 
			  {
			   ist[i_ind].ist_number=I_NOT_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione MIU espressione 
			  {
			   ist[i_ind].ist_number=I_MIN_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione MAU espressione 
			  {
			   ist[i_ind].ist_number=I_MAG_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione '<' espressione 
			  {
			   ist[i_ind].ist_number=I_MIN;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione '>' espressione 
			  {
			   ist[i_ind].ist_number=I_MAG;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione '=' espressione 
			  {
			   ist[i_ind].ist_number=I_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione AND espressione 
			  {
			   ist[i_ind].ist_number=I_AND;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione OR espressione 
			  {
			   ist[i_ind].ist_number=I_OR;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione '-' espressione 
			  {
			   ist[i_ind].ist_number=I_MINUS;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione '*' espressione 
			  {
			   ist[i_ind].ist_number=I_MUL;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione '/' espressione 
			  {
			   ist[i_ind].ist_number=I_DIV;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| espressione '%' espressione 
			  {
			   ist[i_ind].ist_number=I_MOD;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| '-' espressione 
			  {
			   ist[i_ind].ist_number=I_UN_MINUS;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
			| NOT espressione
			  {
			   ist[i_ind].ist_number=I_NOT;
			   ist[i_ind].p1=0;
			   i_ind++;
			  };
%%

extern int yylineno;

int yyerror (const char* c)
{
 hasErrors=1;
 printf(ERR_LINE /*Errore alla linea :%d\n%s\n*/,yylineno,c);
#ifdef DEBUG
 Ask(ERR_PAUSE /*Premere invio per continuare*/);
#endif
 return 0;
}